/***************************************************************************
 *   Copyright (C) 2006 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TLABEL_H_
#define _STDGUI_TLABEL_H_ _

#include <wx/control.h>
#include <wx/string.h>

#include "lib/commons.h"
#include "components/framework/translation.h"

/**
 * Un libelle
 * @author Thierry CHARLES
 */
class TLabel : public wxControl, virtual public TranslatableCmp
{
    TRANSLATABLE;
    public:
        DECLARE_DYNAMIC_CLASS(TLabel);

        enum TextAlignment { Left, Center, Right };

        TLabel(wxWindow * parent = NULL, long iStyle = 0);
        virtual ~TLabel();

        /** defini le texte du bouton */
        void setText(const wxString & s);
        /** renvoie le texte du bouton */
        wxString getText() const { return this->sText; }
        /** renvoie le texte du bouton */
        const wxString & getText() { return this->sText; }

        /** defini l'alignement du texte */
        void setAlignment(TextAlignment align);
        TextAlignment getAlignment() const { return this->align; }

        /** calcule la taille optimale du bouton */
        virtual wxSize DoGetBestSize() const;

        void onPaint(wxPaintEvent& event);
        void onResize(wxSizeEvent & event);

        virtual bool HasTransparentBackground() const { return true; }

        virtual bool SetBackgroundColour(const wxColour& colour);

        DECLARE_EVENT_TABLE();
    protected:

    private:
        wxString sText;
        TextAlignment align;
};

#endif

