/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TIMAGEVIEWER_H_
#define _STDGUI_TIMAGEVIEWER_H_ _

#include <wx/control.h>
#include <wx/string.h>
#include <set>

#include "lib/commons.h"
#include "components/framework/translation.h"

class TBitmap;

/**
 * Composant d'affichage d'une image
 * @author Thierry CHARLES
 */
class TImageViewer : public wxControl
{
    public:
        DECLARE_DYNAMIC_CLASS(TImageViewer);
        virtual ~TImageViewer();

        TImageViewer(wxWindow * parent = NULL);

        /** defini l'image a afficher (NULL si aucune) */
        void setBitmap(const TBitmap * bmp);
        /** renvoie l'image affichee sur le bouton (NULL si aucune) */
        const TBitmap * getBitmap() const { return this->bitmap; }

        /** dfini le niveau de zoom a utiliser pour afficher l'image. 0.0 = ajustement automatique */
        void setZoom(float fZoom);
        /** renvoie le niveau de zoom utilis pour afficher l'image */
        float getZoom() const { return this->fZoom; }


        /** calcule la taille optimale du composant */
        virtual wxSize DoGetBestSize() const;

        void onPaint(wxPaintEvent& event);
        void onResize(wxSizeEvent & event);

        DECLARE_EVENT_TABLE();

    protected:

        void updateCachedImage();

    private:
        const TBitmap * bitmap;
        TBitmap * cachedImage;
        float fZoom; // 0.0 = automatique
};

#endif //_STDGUI_TIMAGEVIEWER_H_

