/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "thuesaturationmap.h"


#include <wx/dcclient.h>
#include <wx/dcmemory.h>

#include "lib/tcolor.h"


BEGIN_EVENT_TABLE( THueSaturationMap, wxControl )
        EVT_PAINT(THueSaturationMap::onPaint)
END_EVENT_TABLE()

THueSaturationMap::THueSaturationMap(wxWindow* parent, wxWindowID id)
    :wxControl(parent, id, wxDefaultPosition, wxSize(256,256), wxSUNKEN_BORDER),
    map(NULL)
{
}

THueSaturationMap::~THueSaturationMap()
{
    delete this->map;
    this->map = NULL;
}

/** calcule la taille optimale de la zone de saisie */
wxSize THueSaturationMap::DoGetBestSize() const
{
    return wxSize(256,256);
}

/**
* redessine le contenu du composant
*/
void THueSaturationMap::onPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    if(this->map == NULL)
    {
        TBitmap * bmp = new TBitmap(256, 256, 24);
        wxMemoryDC bmpDC;
        bmpDC.SelectObject(*bmp);

        wxBrush brush(this->GetBackgroundColour());
        bmpDC.SetBackground(brush);
        bmpDC.Clear();

        wxPen pen;

        TColor col;
        for(uint iHue = 0 ; iHue < 256 ; iHue++)
        {
            int h = 360*iHue/255;
            for(uint iSat = 0 ; iSat  < 256 ; iSat++)
            {
                int s = 1000*iSat/255;
                col.setValue(255);
                col.setSaturation(s);
                col.setHue(h);

                pen.SetColour(col.toWxColour());

                bmpDC.SetPen(pen);
                bmpDC.DrawPoint(iHue, 255-iSat);
            }
        }

        this->map = bmp;
    }
    dc.DrawBitmap(*this->map,0,0,true);
}
