/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TBITMAP_H_
#define _STDGUI_TBITMAP_H_

#include <wx/bitmap.h>
#include <wx/image.h>
#include "lib/commons.h"
#include "lib/lib_string.h"

/**
 * @short Une image
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TBitmap : public wxBitmap
{
    public :
        explicit TBitmap() : wxBitmap() {}
        explicit TBitmap(const wxBitmap& image) : wxBitmap(image) {}
        explicit TBitmap(const wxImage& image) : wxBitmap(image) {}
        explicit TBitmap(int width, int height, int depth=-1) : wxBitmap(width, height, depth) {}
        explicit TBitmap(const wxString & sFilename, wxBitmapType type = wxBITMAP_TYPE_ANY) : wxBitmap() { this->LoadFile(sFilename, type); }
        explicit TBitmap(const char** xpm_data) : wxBitmap(xpm_data) {}

        virtual ~TBitmap(){}

        /** cree une copie en niveaux de gris de l'image (penser a liberer la memoire) */
        TBitmap * getGreyedCopy() const;

        /** cree une copie redimensionnee de l'image (penser a liberer la memoire) */
        TBitmap * getResampledCopy(int width, int height) const;

        wxImage ResampleBicubic(int width, int height) const;
        wxImage ResampleBox(int width, int height) const;

    private :
        wxImage BlurHorizontal(const wxImage & src, int blurRadius) const;
        wxImage BlurVertical(const wxImage & src, int blurRadius) const;
};

#endif // _STDGUI_TBITMAP_H_
