/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _XMLCFGCMP_H_
#define _XMLCFGCMP_H_

#include "lib/commons.h"
#include "lib/tinyxml/tinyxml.h"

/**
 * d�fini une classe g�rant ses parametres sous forme de XML
 */
class XmlConfiguredComponent
{
    public:
        virtual ~ XmlConfiguredComponent() {}
        /** charge les parametres du composant a partir des informations contenues dans le noeud pass� en param�tre */
        virtual bool loadParameters(TiXmlElement * parametersNode) { return true; }
        /** charge les parametres par d�faut */
        virtual void loadDefaultParameters() {}
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters() { return NULL; }
        /** indique si le composant doit etre sauvegard� */
        virtual bool mightBeSaved() const { return true; }
};

#define XMLCC_NODE_APPLICATION "Application"
#define XMLCC_NODE_APP_PARAMS "Parameters"
#define XMLCC_NODE_APP_WIN_ROOT "Windows"
#define XMLCC_NODE_WINDOW "Window"
#define XMLCC_ATTR_WINDOW_ID "id"
#define XMLCC_ATTR_WINDOW_TYPE "type"
#define XMLCC_NODE_WINDOW_PARAMS "Parameters"
#define XMLCC_NODE_WINDOW_PANELS "Panels"
#define XMLCC_NODE_PANEL "Panel"
#define XMLCC_ATTR_PANEL_ID "id"
#define XMLCC_ATTR_PANEL_SIZE "size"
#define XMLCC_NODE_PANEL_PARAMS "Parameters"
#define XMLCC_NODE_PANEL_SIZE "Size"
#define XMLCC_NODE_PANEL_ELTS "Elements"
#define XMLCC_NODE_ELEMENT "Element"
#define XMLCC_NODE_ELEMENT_PARAMS "Parameters"
#define XMLCC_ATTR_ELEMENT_ID "id"
#define XMLCC_ATTR_ELEMENT_VIS "visible"
#define XMLCC_ATTR_ELEMENT_ORD "displayOrder"
#define XMLCC_ATTR_ELEMENT_TYPE "type"
#define XMLCC_ATTR_ELEMENT_NAME "name"

#endif
