/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TCONFIG_DLG_H_
#define _TCONFIG_DLG_H_

#define CONFIG_DLG_MAINPANEL_ID -6

#include <wx/dialog.h>

#include "lib/commons.h"
#include "components/framework/tapplwindow.h"
#include "components/framework/tpanelelement.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"

/**
 * decris un element utilisable dans une fenetre de configuration
 */
class TConfigPanelElement : public TPanelElement
{
    public:
        TConfigPanelElement(TApplicationPanel * _owner, int _iID, const wxString & _sName = wxT(""), wxString _sTooltip = wxT("")) : TPanelElement(_owner,_iID, _sName, _sTooltip) {}
        virtual ~TConfigPanelElement() {}

        /** initialise le panneau avec les parametres actuels de l'application */
        virtual void init() = 0;

        /** valide les modifications */
        virtual void commit() = 0;

        /** indique si le panneau est dans un etat valide */
        virtual bool canCommit() = 0;
};

/**
 * decris une fenetre de configuration
 */
class TConfigDlg : public wxDialog, public TApplicationWindow, public TGenButtonListener
{
    TRANSLATABLE;
    public:
        TConfigDlg();
        virtual ~TConfigDlg(){}

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return false; }

        /** initialise tous les panneaux contenus avec les parametres actuels de l'application */
        void init();

        /** valide les modifications sur tous les panneaux contenus */
        void commit();

        /** indique si tous les panneaux sont dans un �tat valide */
        bool canCommit();

        /** ajoute un element a la liste des panneaux de configuration */
        void addConfigElement(TConfigPanelElement * elt);

        /** enleve un element de la liste des panneaux de configuration et libere la m�moire */
        void removeConfigElement(int iEltID);

        /** affiche le dialogue de gestion des preferences */
        virtual int ShowModal();

        /** renvoie le panneau principal du dialogue */
        TApplicationPanel * getMainPanel() { return this->panel; }
        
        virtual void buttonActivated(TGenButton * btn);

    private:
        TApplicationPanel * panel;
        TGenButton * btnOk;
        TGenButton * btnCancel;
        TConfigPanelElement * lastRefused;
};



#endif
