/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TAPPLWINDOW_H_
#define _TAPPLWINDOW_H_

#include <wx/string.h>

#include <map>

#include "lib/commons.h"
#include "components/framework/xmlcfgcmp.h"
#include "components/framework/translation.h"

class TApplicationPanel;

/**
 * d�fini une classe repr�sentant une fenetre
 */
class TApplicationWindow : public XmlConfiguredComponent, virtual public TranslatableCmp
{
    public:
        TApplicationWindow(const wxString & _sId) : sId(_sId) {}
        virtual ~TApplicationWindow();

        /** renvoie une r�f�rence constante a l'id du composant */
        const wxString & getId() { return this->sId; }
        /** renvoie l'id du composant */
        wxString getId() const { return this->sId; }
        /** d�fini l'id du composant */
        void setId(const wxString & sId) { this->sId = sId; }

        /** charge les panneaux d'une fenetre a partir des informations stock�s sous forme XML */
        virtual bool loadPanels(TiXmlElement * panelsNode);

        /** sauvegarde les panneaux d'une fenetre en XML */
        virtual TiXmlElement * getPanelsNode();

        /** retrouve un panel a partir de son ID */
        virtual TApplicationPanel * getPanel(int iPanelId) const;

        /** reconstruit les splitters avec les panneaux */
        virtual void updatePanels();

        /**
         * enregistre un panneau dans la fenetre
         * @return false si un panneau avec le meme ID existe deja
         */
        virtual bool registerPanel(TApplicationPanel * panel);

        /** supprime une reference a un panneau */
        virtual bool unregisterPanel(int iPanelId);

        /** charge les parametres du composant a partir des informations contenues dans le noeud pass� en param�tre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();
        /** indique si le composant doit etre sauvegard� */
        virtual bool mightBeSaved() const { return true; }

        /** supprime tout le contenu de la fenetre. Devrait tre appel avant le destructeur, tant que toute la structure de l'application est encore accessible */
        virtual void destroyWindowContent();

    private:
        wxString sId;

        typedef std::map<int, TApplicationPanel *> TPanelsMap;
        TPanelsMap panelsMap;
};


#endif
