/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TSTYLE_H_
#define _TSTYLE_H_

#include "lib/commons.h"
#include "lib/tcolor.h"
#include <map>
#include <wx/dc.h>

#define DEFAULT_STYLE 0
#define SELECTED_STYLE -1


class TStyle
{
    public :
        TStyle() : bHasBgColor(false), bIsBold(false), bIsItalic(false), bIsUnderlined(false) {}

        /** enleve la couleur de fond */
        void removeBgColor() { this->bHasBgColor = false; }
        /** defini la couleur de fond */
        void setBgColor(const TColor & color);
        /** renvoie la couleur de fond */
        TColor getBgColor() const { return this->bgColor; }
        /** renvoie la couleur de fond */
        const TColor & getBgColor() { return this->bgColor; }
        /** indique si une couleur de fond a �t� d�finie */
        bool hasBgColor() const { return this->bHasBgColor; }

        /** defini la couleur de la police */
        void setFgColor(const TColor & color) { this->fgColor = color; }
        /** renvoie la couleur de la police */
        TColor getFgColor() const { return this->fgColor; }
        /** renvoie la couleur de la police */
        const TColor & getFgColor() { return this->fgColor; }

        /** renvoie si la police est en gras */
        bool isBold() const { return this->bIsBold; }
        /** defini si la police est en gras */
        void setBold(bool b) { this->bIsBold = b; }

        /** renvoie si la police est en italique */
        bool isItalic() const { return this->bIsItalic; }
        /** defini si la police est en italique */
        void setItalic(bool b) { this->bIsItalic = b; }

        /** renvoie si la police est soulign�e */
        bool isUnderlined() const { return this->bIsUnderlined; }
        /** defini si la police est soulign�e */
        void setUnderlined(bool b) { this->bIsUnderlined = b; }

        /** initialise le style pour les valeurs pr�d�finies */
        void setPredefined(int iStyleID);

        /** prepare le context de p�riph�rique avec le style de police */
        void prepareDC(wxDC & dc, const wxColour & defaultBgColour) const;

    private :
        bool bHasBgColor;
        TColor bgColor;

        TColor fgColor;

        bool bIsBold;
        bool bIsItalic;
        bool bIsUnderlined;
};

typedef std::map<sbyte,TStyle> TStylesMap;

#endif
