/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tstyle.h"
#include <wx/settings.h>
#include <wx/font.h>

/** defini la couleur de fond */
void TStyle::setBgColor(const TColor & color)
{
    this->bHasBgColor = true;
    this->bgColor = color;
}

/** initialise le style pour les valeurs prdfinies */
void TStyle::setPredefined(int iStyleID)
{
    if(iStyleID == DEFAULT_STYLE)
    {
        this->removeBgColor();
        this->setBold(false);
        this->setItalic(false);
        this->setUnderlined(false);
        this->fgColor.initFrom(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWTEXT));
    }
    else if(iStyleID == SELECTED_STYLE)
    {
        this->setBold(false);
        this->setItalic(false);
        this->setUnderlined(false);
        this->fgColor.initFrom(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW));
        this->bHasBgColor = true;
        this->bgColor.initFrom(wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHT));
    }
}

#include "lib/lib_logging.h"
/** prepare le context de priphrique avec le style de police */
void TStyle::prepareDC(wxDC & dc, const wxColour & defaultBgColour) const
{
    if(this->bHasBgColor)
        dc.SetBrush(wxBrush(this->bgColor.toWxColour()));
    else
        dc.SetBrush(wxBrush(defaultBgColour));
    dc.SetTextBackground(dc.GetBrush().GetColour());
    dc.SetTextForeground(this->fgColor.toWxColour());
    wxFont font = dc.GetFont();
    font.SetStyle(this->bIsItalic ? wxFONTSTYLE_ITALIC : wxFONTSTYLE_NORMAL);
    font.SetUnderlined(this->bIsUnderlined);
    font.SetWeight(this->bIsBold ? wxFONTWEIGHT_BOLD : wxFONTWEIGHT_NORMAL);
    dc.SetFont(font);
}
