/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TDOCACTION_H_
#define _TDOCACTION_H_

#include <deque>
#include <wx/string.h>

#include "lib/commons.h"
#include "components/codeeditor/tpoint.h"

class TDocument;

/**
 * @short Une action sur un document
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TDocAction
{
    public :
        TDocAction(TDocument * doc) : document(doc) {}
        virtual ~TDocAction(){}

        virtual bool executeAction() = 0;

        virtual TDocument * getDocument() { return this->document; }

    private :
        TDocument * document;
};

typedef std::deque<TDocAction *> TDocActionsList;

/**
 * @short Une simple action sur un document
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TSimpleDocAction : public TDocAction
{
    public :
        enum ActionType{Insert,Delete};
        TSimpleDocAction(TDocument * doc, ActionType _type, const TPoint & _begin, const TPoint & _end, const wxString & _sData) : TDocAction(doc), type(_type), begin(_begin), end(_end), sData(_sData) {}
        virtual ~TSimpleDocAction(){}

        virtual bool executeAction();

    private:
        ActionType type;
        TPoint begin;
        TPoint end;
        wxString sData;
};

/**
 * @short Une serie d'actions sur un document
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TComposedDocAction : public TDocAction
{
    public :
        TComposedDocAction(TDocument * doc) : TDocAction(doc) {}
        virtual ~TComposedDocAction();

        virtual bool executeAction();
        virtual void addAction(TDocAction * action);

    private :
        TDocActionsList actions;
};


#endif
