/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tdocaction.h"
#include "tdocument.h"
#include "lib/lib_logging.h"


bool TSimpleDocAction::executeAction()
{
    bool bSucces = true;
    try
    {
        if(this->type == Insert)
        {
            if(this->begin.isValid()
              && uint(this->begin.y) < this->getDocument()->getLinesCount()
              && uint(this->begin.x) <= this->getDocument()->getLineLength(this->begin.y))
            {
                this->getDocument()->insertAt(this->sData.c_str(),this->begin.y, this->begin.x);
            }
            else
            {
                bSucces = false;
            }
        }
        else
        {
            if(this->begin.isValid()
              && this->end.isValid()
              && uint(this->begin.y) < this->getDocument()->getLinesCount()
              && uint(this->begin.x) <= this->getDocument()->getLineLength(this->begin.y)
              && uint(this->end.y) < this->getDocument()->getLinesCount()
              && uint(this->end.x) <= this->getDocument()->getLineLength(this->end.y))
            {
                this->getDocument()->removeRange(this->begin, this->end);
            }
            else
            {
                bSucces = false;
            }
        }
    }
    catch(...)
    {
        bSucces = false;
    }
    return bSucces;
}

bool TComposedDocAction::executeAction()
{
    TDocActionsList::iterator itB = this->actions.begin();
    TDocActionsList::iterator itE = this->actions.end();

    this->getDocument()->startComposedAction();
    bool bSucces = true;
    while(bSucces && itB != itE)
    {
        itE--;
        bSucces = (*itE)->executeAction();
    }
    this->getDocument()->stopComposedAction();
    return bSucces;
}

void TComposedDocAction::addAction(TDocAction * action)
{
    this->actions.push_back(action);
}

TComposedDocAction::~TComposedDocAction()
{
    TDocActionsList::iterator itB = this->actions.begin();
    TDocActionsList::iterator itE = this->actions.end();

    while(itB != itE)
    {
        delete (*itB);
        itB++;
    }
    this->actions.clear();
}

