/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TCURSOR_H_
#define _TCURSOR_H_

#include <wx/window.h>
#include <wx/bitmap.h> // to make wxCaret complete
#include <wx/caret.h>
#include <wx/timer.h>

#include <set>

#include "lib/commons.h"
#include "components/codeeditor/tpoint.h"
class TCodeEditor;

class TCursorListener;

#define _STDGUI_TCURSOR_CARET_TIMER_ 2

/**
 * @short Curseur dans un editeur de texte
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TCursor : public wxEvtHandler
{
    public:
        TCursor(TCodeEditor * ed);
        virtual ~TCursor();

        // gestionnaires de position du curseur
        /** defini la ligne du curseur */
        void setLine(int iLine);
        /** renvoie la ligne du curseur */
        int getLine() { return this->position.y; }
        /** defini la colone du curseur */
        void setColumn(int iColumn);
        /** renvoie la colone du curseur */
        int getColumn() { return this->position.x; }
        /** defini la position du curseur */
        void setPosition(const TPoint & pt);
        /** renvoie la position du curseur */
        TPoint getPosition() const { return this->position; }
        /** renvoie la position du curseur */
        const TPoint & getPosition() { return this->position; }

        /** renvoie la position graphique du curseur sur l'axe horizontal */
        int getCursorPosX();
        /** renvoie la position graphique du curseur sur l'axe vertical */
        int getCursorPosY();

        /** Rafraichissement de la position du curseur graphique */
        void updateCaret();

        /** Affiche/cache le curseur */
        void setVisible(bool bVisible);
        /** indique si le curseur est actuellement visible ou pas */
        bool isVisible();

        /** ajoute un ecouteur */
        virtual bool addCursorListener(TCursorListener * l);
        /** enleve un ecouteur */
        virtual bool removeCursorListener(TCursorListener * l);
        /** envoie un evenement indiquant que la position du curseur a change */
        virtual void fireCursorMoved();

        /** traite les evenements du timer de variation du blink */
        void onCaretBlinkTimer(wxTimerEvent& event);

        DECLARE_EVENT_TABLE();

    private:
        TPoint position;
        wxCaret * caret;
        TCodeEditor * editor;
        int iRequestedXPos;
        int iRequestedYPos;

        wxTimer     caretBlinkTimer;

        typedef std::set<TCursorListener *> TCursorListenersList;
        /** liste des ecouteurs */
        TCursorListenersList listeners;
};

/** Directions de deplacement du curseur */
enum TDirection{Left,Right,Up,Down};


/**
 * @short Definition d'un ecouteur de modifications de curseur
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TCursorListener
{
    public :
        virtual ~TCursorListener(){}
        /** indique le curseur s'est deplace */
        virtual void cursorMoved(TCursor * cursor) = 0;
};


#endif // _TCURSOR_H_
