/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "calculator_pe.h"

#include <math.h>

#include <wx/font.h>

#include "tcalculator.h"
#include "components/framework/tapplicationpanel.h"
#include "components/framework/tapplication.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"

#include "calculator.xpm"

TBitmap * CalculatorPanelElement::defaultIcon = NULL;
const TBitmap * CalculatorPanelElement::getDefaultIcon()
{
    if(!defaultIcon)
    {
        defaultIcon = new TBitmap((const char **)calculator_xpm);
    }
    return defaultIcon;
}


CalculatorPanelElement::CalculatorPanelElement(TApplicationPanel * _owner, int iID)
    : TPanelElement(_owner, iID, wxT(""), wxT("")),
        calculator(NULL)
{
    this->setTooltip(wxTr("A calculator"));
    this->setExtensivity(0);
    this->setBitmap(getDefaultIcon());
}

CalculatorPanelElement::~CalculatorPanelElement()
{
}

/** construit le panneau conteneur et son contenu (appell�automatiquement par getContentPanel et d�ruit automatiquement par le destructeur) */
TPanel * CalculatorPanelElement::buildContentPanel()
{
    TPanel * contentPanel = new TPanel(this->getOwner()->getContentPanel());
    wxBoxSizer * sizer = new wxBoxSizer( wxVERTICAL);
    contentPanel->SetSizer(sizer);

    this->calculator = new TCalculator(contentPanel);

    sizer->Add(this->calculator,0,wxEXPAND);
    sizer->Show(this->calculator,true);

    return contentPanel;
}


