#!/bin/bash
clear

Id=1

for f in `ls -w 1 *.xpm | sort`
do
    fid=`echo "BMP_${f}_ID" | sed "s/\\.xpm_/_/g" | tr "[a-z]" "[A-Z]"`
    printf "#define %-24s %d\n" "${fid}" ${Id}
    let "Id = Id + 1"
done

printf "\n\n\n\n\n\n\n\n"

for f in `ls -w 1 *.xpm | sort`
do
    printf "#include \"bitmaps/%s\"\n" "${f}"
done


printf "\n\n/** initialise les bitmaps de l'appli */\n"
echo "void XPE::initBmps()"
echo "{"
for f in `ls -w 1 *.xpm | sort`
do
    fid=`echo "BMP_${f}_ID" | sed "s/\\.xpm_/_/g" | tr "[a-z]" "[A-Z]"`
    fv=`echo "${f}" | sed "s/\\.xpm$/_xpm/g"`
    printf "this->addBitmap( %s , new TBitmap((const char **) %s ) );\n" "${fid}" ${fv}
done
echo "}"

