/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_ILLUM_MODEL_ILLUMOBSERVER_HPP
#define INDII_ILLUM_MODEL_ILLUMOBSERVER_HPP

#include "IllumObservable.hpp"

namespace indii {
/**
 * Observer of Illum.
 */
class IllumObserver {
public:
  /**
   * Constructor.
   */
  IllumObserver();

  /**
   * Destructor.
   */
  virtual ~IllumObserver();

  /**
   * Observe an object.
   */
  void watch(IllumObservable* o);

  /**
   * Stop observing the object.
   */
  void ignore();

  /**
   * Notify of settings changes.
   */
  virtual void notifyLength();
  virtual void notifyEdge();
  virtual void notifyOutputStd();
  virtual void notifyBlacks();
  virtual void notifyWhites();
  virtual void notifyBrightness();

  /**
   * Notify of destruction.
   */
  void notifyDestroy();

private:
  /**
   * Observed object.
   */
  IllumObservable* o;

  /**
   * Are we currently observing an object?
   */
  bool watching;
};
}

inline void indii::IllumObserver::notifyLength() {
  //
}

inline void indii::IllumObserver::notifyEdge() {
  //
}

inline void indii::IllumObserver::notifyOutputStd() {
  //
}

inline void indii::IllumObserver::notifyBlacks() {
  //
}

inline void indii::IllumObserver::notifyWhites() {
  //
}

inline void indii::IllumObserver::notifyBrightness() {
  //
}

inline void indii::IllumObserver::notifyDestroy() {
  this->watching = false;
}

#endif
