/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_ILLUM_MODEL_ILLUMOBSERVABLE_HPP
#define INDII_ILLUM_MODEL_ILLUMOBSERVABLE_HPP

#include <set>

namespace indii {
  class IllumObserver;

/**
 * Observable object.
 */
class IllumObservable {
public:
  /**
   * Destructor.
   */
  virtual ~IllumObservable();

  /**
   * Registry type.
   */
  typedef std::set<IllumObserver*> registry_t;

  /**
   * Register observer.
   */
  void subscribe(IllumObserver* o);

  /**
   * Deregister observer.
   */
  void unsubscribe(IllumObserver* o);

  /*
   * Notify of settings changs.
   */
  virtual void notifyLength();
  virtual void notifyOutputStd();
  virtual void notifyBlacks();
  virtual void notifyWhites();
  virtual void notifyBrightness();
  virtual void notifyEdge();

  /**
   * Notify of destruction.
   */
  virtual void notifyDestroy();

protected:
  /**
   * Registry of observers.
   */
  registry_t os;
};
}

#endif
