/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "IllumObservable.hpp"

#include "IllumObserver.hpp"

using namespace indii;

IllumObservable::~IllumObservable() {
  notifyDestroy();
}

void IllumObservable::subscribe(IllumObserver* o) {
  os.insert(o);
}

void IllumObservable::unsubscribe(IllumObserver* o) {
  os.erase(o);
}

void IllumObservable::notifyLength() {
  registry_t::iterator iter;
  IllumObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyLength();
    }
  }
}

void IllumObservable::notifyOutputStd() {
  registry_t::iterator iter;
  IllumObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyOutputStd();
    }
  }
}

void IllumObservable::notifyBlacks() {
  registry_t::iterator iter;
  IllumObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyBlacks();
    }
  }
}

void IllumObservable::notifyWhites() {
  registry_t::iterator iter;
  IllumObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyWhites();
    }
  }
}

void IllumObservable::notifyBrightness() {
  registry_t::iterator iter;
  IllumObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyBrightness();
    }
  }
}

void IllumObservable::notifyEdge() {
  registry_t::iterator iter;
  IllumObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyEdge();
    }
  }
}

void IllumObservable::notifyDestroy() {
  registry_t::iterator iter;
  IllumObserver* ptr;
  for (iter = os.begin(); iter != os.end(); iter++) {
    ptr = *iter;
    if (ptr != NULL) {
      ptr->notifyDestroy();
    }
  }
}
