/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_ILLUM_MODEL_ILLUMCONTROLLER_HPP
#define INDII_ILLUM_MODEL_ILLUMCONTROLLER_HPP

#include "IllumModel.hpp"
#include "../../model/Controller.hpp"

namespace indii {
/**
 * Controller for handling mouse events from PreviewImage for IllumModel.
 */
class IllumController : public Controller {
public:
  /**
   * Constructor.
   *
   * @param model Associated model.
   */
  IllumController(IllumModel* model);

  virtual void up(const int x0, const int y0, const int x, const int y,
      wxMouseEvent& evt);
  virtual void down(const int x0, const int y0, const int x, const int y,
      wxMouseEvent& evt);
  virtual void doubleDown(const int x0, const int y0, const int x,
      const int y, wxMouseEvent& evt);
  virtual void drag(const int x0, const int y0, const int x, const int y,
      const int dx0, const int dy0, const int dx, const int dy,
      wxMouseEvent& evt);

private:
  /**
   * Associated model.
   */
  IllumModel* model;

  /**
   * Currently active control point for adjustments.
   */
  int control;

  /**
   * Was last click a double click?
   */
  bool lastDouble;
};
}

#endif
