/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_ILLUM_GUI_ILLUMGLOBALPANE_HPP
#define INDII_ILLUM_GUI_ILLUMGLOBALPANE_HPP

#include "../model/IllumModel.hpp"
#include "../model/IllumObserver.hpp"
#include "../../gui/Pane.hpp"

#include "wx/slider.h"
#include "wx/checkbox.h"

namespace indii {
/**
 * Global settings pane.
 */
class IllumGlobalPane : public Pane, public IllumObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  IllumGlobalPane(wxWindow* parent);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(IllumModel* model);

  /*
   * Handle model changes.
   */
  virtual void notifyLength();
  virtual void notifyEdge();
  virtual void notifyOutputStd();
  virtual void notifyBlacks();
  virtual void notifyWhites();
  virtual void notifyBrightness();

  /*
   * Control events.
   */
  void OnSlideLength(wxScrollEvent& evt);
  void OnSlideEdge(wxScrollEvent& evt);
  void OnSlideOutputStd(wxScrollEvent& evt);
  void OnSlideBlacks(wxScrollEvent& evt);
  void OnSlideWhites(wxScrollEvent& evt);
  void OnSlideBrightness(wxScrollEvent& evt);
  
  /**
   * Context sensitive help.
   */
  void OnHelp(wxHelpEvent& evt);

private:
  /**
   * Model.
   */
  IllumModel* model;

  /*
   * Controls.
   */
  wxSlider *slideLength;
  wxSlider *slideEdge;
  wxSlider *slideOutputStd;
  wxSlider *slideBlacks;
  wxSlider *slideWhites;
  wxSlider *slideBrightness;

  /*
   * Control ids.
   */
  enum ID {
    ID_SLIDE_LENGTH,
    ID_SLIDE_EDGE,
    ID_SLIDE_OUTPUT_STD,
    ID_SLIDE_BLACKS,
    ID_SLIDE_WHITES,
    ID_SLIDE_BRIGHTNESS
  };

  DECLARE_EVENT_TABLE()
};
}

#endif
