/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_ILLUM_GUI_ILLUMDOCUMENT_HPP
#define INDII_ILLUM_GUI_ILLUMDOCUMENT_HPP

#include "../model/IllumModel.hpp"
#include "../model/IllumController.hpp"
#include "../../gui/Document.hpp"

#include "wx/aui/aui.h"

namespace indii {
/**
 * Image document.
 */
class IllumDocument : public Document {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param res Image resource.
   * @param model Cluster model.
   */
  IllumDocument(wxWindow* parent, ImageResource* res, IllumModel* model);
  
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param path Path of image to open.
   */
  IllumDocument(wxWindow* parent, const wxString& path);
  
  /**
   * Destructor.
   */
  virtual ~IllumDocument();

protected:
  /**
   * Image resource.
   */
  ImageResource* res;

  /**
   * Model.
   */
  IllumModel* model;

  /**
   * Controller.
   */
  IllumController* control;

private:
  /**
   * Do we own the model and image resource?
   */
  bool own;

  DECLARE_EVENT_TABLE()
};
}

#endif
