/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "IllumDocument.hpp"

#include "../../image/FileImageResource.hpp"

using namespace indii;

IllumDocument::IllumDocument(wxWindow* parent, ImageResource* res,
    IllumModel* model) : Document(parent), res(res),
    model(model), own(false) {
  control = new IllumController(model);
  Document::set(res, model, control);
  model->setForDialog();
}

IllumDocument::IllumDocument(wxWindow* parent, const wxString& path) :
    Document(parent), own(true) {
  res = new FileImageResource(path);
  model = new IllumModel(res);
  control = new IllumController(model);

  watch(model);
  set(res, model, control);
}

IllumDocument::~IllumDocument() {
  delete control;
  if (own) {
    delete model;
    delete res;
  }
}

BEGIN_EVENT_TABLE(IllumDocument, Document)
END_EVENT_TABLE()
