AC_PREREQ([2.59])
AC_LANG([C++])
AM_INIT_AUTOMAKE([1.10 no-define foreign])
#AC_CONFIG_HEADERS([config.h])

# Save flags (need to be modified during configure, restored after)
SAVE_CPPFLAGS=$CPPFLAGS
SAVE_CXXFLAGS=$CXXFLAGS

# Checks for programs.
AC_PROG_CXX
AC_PROG_INSTALL

# Compiler characteristics
AC_OPENMP

# Checks of programs
AC_CHECK_PROG(have_wxconfig, [wx-config], [yes], [no])
if test "$have_wxconfig" != "yes"; then
  AC_MSG_ERROR([wx-config required])
fi
AC_SUBST(DEPS_CPPFLAGS, [`wx-config --cppflags`])
AC_SUBST(DEPS_CXXFLAGS, [`wx-config --cxxflags`])
AC_SUBST(DEPS_LIBS, [`wx-config --libs std,aui`])

CPPFLAGS=$DEPS_CPPFLAGS # overwrite for wx header checks
CXXFLAGS=$DEPS_CXXFLAGS

# Checks for libraries
wxrelease=`wx-config --release`
AC_MSG_CHECKING([for wxWidgets 2.8])
if test "$wxrelease" = "2.8"; then
   AC_DEFINE(WX_28)
   AC_MSG_RESULT([yes])
else
   AC_MSG_RESULT([no])
   AC_MSG_CHECKING([for wxWidgets 2.9 or later])
   if test `echo "$wxrelease >= 2.9" | bc`; then
     AC_MSG_RESULT([yes])
   else
     AC_MSG_RESULT([no])
     AC_MSG_ERROR([wxWidgets 2.8 or later required])
   fi
fi

# Checks for header files
AC_HEADER_ASSERT

m4_foreach_w([header_file], [\
    boost/numeric/ublas/matrix.hpp \
    boost/numeric/ublas/matrix_sparse.hpp \
    boost/numeric/ublas/vector.hpp \
    boost/random.hpp \
    ], [AC_CHECK_HEADER(header_file, [], \
    AC_MSG_ERROR([required boost header not found]), [-])])

m4_foreach_w([header_file], [\
    wx/aboutdlg.h \
    wx/app.h \
    wx/aui/aui.h \
    wx/bitmap.h \
    wx/bmpbuttn.h \
    wx/busyinfo.h \
    wx/button.h \
    wx/cmdline.h \
    wx/colour.h \
    wx/config.h \
    wx/control.h \
    wx/cshelp.h \
    wx/datetime.h \
    wx/dcbuffer.h \
    wx/dcclient.h \
    wx/dcmemory.h \
    wx/dialog.h \
    wx/filedlg.h \
    wx/filename.h \
    wx/filesys.h \
    wx/frame.h \
    wx/fs_arc.h \
    wx/fs_zip.h \
    wx/gbsizer.h \
    wx/html/helpctrl.h \
    wx/image.h \
    wx/init.h \
    wx/msgdlg.h \
    wx/mstream.h \
    wx/panel.h \
    wx/scrolwin.h \
    wx/sizer.h \
    wx/slider.h \
    wx/spinctrl.h \
    wx/splash.h \
    wx/statbmp.h \
    wx/stattext.h \
    wx/stdpaths.h \
    wx/string.h \
    wx/textctrl.h \
    wx/textdlg.h \
    wx/utils.h \
    wx/valtext.h \
    wx/window.h \
    wx/wx.h \
    wx/wxprec.h \
    ], [AC_CHECK_HEADER(header_file, [], \
    AC_MSG_ERROR([required wxWidgets header not found]), [-])])

# Checks for typedefs, structures, and compiler characteristics
AC_HEADER_STDBOOL
AC_C_INLINE

# Checks for library functions
m4_foreach_w([func], [pow sqrt], [AC_CHECK_FUNC(func, [], \
    AC_MSG_ERROR([required math function not found]))])

# Restore original flags
CPPFLAGS=$SAVE_CPPFLAGS
CXXFLAGS=$SAVE_CXXFLAGS

AC_CONFIG_FILES([Makefile])
AC_OUTPUT
