// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include <libintl.h>
#include "oyranos_config_fltk.h"

static void* myAllocFunc(size_t size) {
  return new char [size];
}

void selectDefaultProfile_callback( Fl_Widget* w, void* ) {
  Option *op = dynamic_cast<Option*> (w->parent());
    if(op) {
      Fl_Choice *c = dynamic_cast<Fl_Choice*> (w);
      if(c) {
        std::cout << c->value() << c->text() << std::endl;
        int error = 0;
        if(strcmp(c->text(),_("[none]")) == 0)
          error = oySetDefaultProfile( (oyPROFILE_e)op->option,0);
        else
          error = oySetDefaultProfile( (oyPROFILE_e)op->option, c->text());
        if(error) {
          fl_alert( "%s %s", _("setting"), _("failed!") );
        } else
          updateUI();
  
      } else fl_alert( "no Fl_Choice" );
    } else fl_alert( "%s", _("Select Profile") );
}

void showDefaultProfile_callback( Fl_Widget* w, void* ) {
  Option *op = dynamic_cast<Option*> (w->parent());
    if(op) {
      {
        char *pn = oyGetDefaultProfileName( (oyPROFILE_e)op->option, myAllocFunc);
        if(!pn) {
          fl_alert( "%s %s", _("showing"), _("failed!") );
        } else {
          char command[1024];
          oyProfile_s * prof = oyProfile_FromFile( pn, 0,0 );
          snprintf( command, 1024, "export PATH=$PATH:" OY_BINDIR "; iccexamin \"%s\"&",
                    oyProfile_GetFileName( prof, -1 ) );
          oyProfile_Release( &prof );
  #      ifdef DEBUG_
            fprintf(stderr, "%s\n", command);
  #      endif
          int r = system( command );
          if(r >= 0x200) {
            fl_alert( "%s", _("Show Profile failed. iccexamin not found") );
            fprintf(stderr, "%s:%d command \"%s\" failed with error: %d.\n",
                    __FILE__,__LINE__, command, r);
          }
        }
      }
    } else fl_alert( "%s", _("Show Profile failed") );
}

void selectBehaviourCallback( Fl_Widget* w, void* x ) {
  Option *op = dynamic_cast<Option*> (w->parent());
    if(op) {
      Fl_Choice *c = dynamic_cast<Fl_Choice*> (w);
      if(c) {
        std::cout << (intptr_t)x << c->user_data() << c->value() << c->text() << std::endl;
        int error = 0;
  
        if(op->option == oyWIDGET_POLICY)
        {
          error = oyPolicySet( c->text(), NULL );
        } else
          error = oySetBehaviour( (oyBEHAVIOUR_e)op->option, c->value());
  
        if(error) {
          fl_alert( "%s %s %s", _("setting"), _("failed!"), c->text() );
        }
  
        updateUI();
      } else fl_alert( "no Fl_Choice" );
    } else fl_alert( "%s", _("Select Behaviour") );
}

void debug_me( ) {
  int nonsense = 0;
    ++nonsense;
}

OyFl_Pack::OyFl_Pack(int x, int y, int w, int h , const char *t ) : Fl_Pack(x,y,w,h,t) {
}

void OyFl_Pack::draw() {
  int nw = 0, nh = 0;
    Fl_Scroll * scroll = dynamic_cast <Fl_Scroll*> (parent());
    if( scroll )
    {
      nw = parent()->w() - Fl::box_dw( parent()->box() ) - scroll->scrollbar.w() - spacing();
    } else {
      nw = parent()->w() - Fl::box_dw( parent()->box() );
    }
    w( nw );
  
  
    nh = parent()->h() - Fl::box_dh( parent()->box() );
    if( horizontal() )
      Fl_Pack::size( nw, Fl_Pack::h() );
    else
      Fl_Pack::size( Fl_Pack::w(), nh );
  
    // prearrange if one widget is resizeable
    Fl_Widget *re = resizable();
    if( re )
    {
      int n = children();
      int pos_x = Fl::box_dx(box()) + spacing(),
          pos_y = Fl::box_dy(box()) + spacing(),
          pos_x2 = pos_x + w() - Fl::box_dw(box()) - spacing(),
          pos_y2 = pos_y + h() - Fl::box_dh(box()) - spacing();
      int re_i = 0;
      
      for( int i = 0; i < n; ++i )
      {
        Fl_Widget *o = child( i );
        if( o == re )
        {
          re_i = i;
          break;
        }
        
        if( horizontal() )
        {
          o->position( pos_x, o->y() );
          pos_x += o->w() + spacing();
        } else {
          o->position( o->x(), pos_y );
          pos_y += o->h() + spacing();
        }
      }
      
      for( int i = n - 1; i > re_i; --i )
      {
        Fl_Widget *o = child( i );
        if( horizontal() )
        {
          o->position( pos_x2 - o->w(), o->y() );
          pos_x2 -= o->w() + spacing();
        } else {
          o->position( o->x(), pos_y2 - o->h());
          pos_y2 -= o->h() + spacing();
        }
      }
      
      if(horizontal())
        re->resize( pos_x, re->y(), pos_x2-pos_x, re->h() );
      else
        re->resize( re->x(), pos_y, re->w(), pos_y2-pos_y );
  
    }
  
  
    Fl_Pack::draw();
}

OyFl_Box::OyFl_Box(int x, int y, int w, int h , const char *t ) : Fl_Box(x,y,w,h,t) {
  if(t)
    {
      label_orig = (char*)malloc (strlen(t)+1);
      printf("%s %d\n",t, (int)strlen(t));
      sprintf(label_orig, "%s", t);
    } else
      label_orig = 0;
}

void OyFl_Box::draw() {
  int wl=0, hl=0, // have to be zeroed
         ws; // ws - label widgets start width
    char *txt = 0;
    int len = 0;
    int last_utf8_len = 0;
    if(label_orig)
    {
      ws = w();
      Fl_Box::label( label_orig );
      measure_label(wl,hl);
      if(wl < ws)
      {
        if(strlen(label_orig))
          Fl_Box::copy_label(label_orig);
      } else {
  
        txt = (char*)malloc (strlen(label_orig)+1);
        strcpy(txt, label_orig);
        Fl_Box::label(txt);
        do {
          //txt = (char*)Fl_Box::label();
          len = strlen(txt);
          if(len > 3)
          {
  /*
   * Index into the table below with the first byte of a UTF-8 sequence to
   * get the number of trailing bytes that are supposed to follow it.
   * Note that *legal* UTF-8 values can't have 4 or 5-bytes. The table is
   * left as-is for anyone who may want to do such conversion, which was
   * allowed in earlier algorithms.
   */
  static const char trailingBytesForUTF8[256] = {
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5
  };
            // now we have to get the last character length
            int ilen = 0;
            last_utf8_len = 0;
            do {
              last_utf8_len = 1 + trailingBytesForUTF8[ (unsigned char)txt[ilen] ];
              ilen += last_utf8_len;
            } while (len-3 > ilen);
            sprintf( &txt[ilen - last_utf8_len], "..." );
            Fl_Box::label(txt);
          } else
            break;
          measure_label(wl,hl);
        } while(wl > ws);
  
        //Fl_Box::label(txt);
      }
    }
  #ifdef DEBUG
    if(label_orig)
      if(strlen(label_orig))
        printf("%d %s %d %d/%d %d\n",__LINE__,Fl_Box::label(), (int)strlen(Fl_Box::label()), wl, ws, last_utf8_len);
  #endif
    Fl_Box::draw();
}

const char * OyFl_Box::label() {
  return label_orig;
}

void OyFl_Box::label(const char * l) {
  label_orig = new char (strlen(l)+1);
    strcpy(label_orig, l);
    Fl_Box::label( l );
}

void OyFl_Box::copy_label(const char* l) {
  label_orig = new char (strlen(l)+1);
    strcpy(label_orig, l);
    Fl_Box::copy_label(l);
}

Option::Option( int x, int y, int w, int h, const char *name,
  oyWIDGET_e option_,
  oyWIDGET_TYPE_e type_,
  int choices_n,
  const char **choices,
  int current,
  const char *tooltip,
  int flags) : OyFl_Pack(x, y, w, h) {
  Fl_Pack::type( FL_HORIZONTAL );
    Fl_Pack::spacing(H_SPACING);
  
    option = option_;
    type = type_;
  
    debug_me();
  
    /*int weigth = BOX_WIDTH + SELECT_WIDTH + 4 * H_SPACING + BUTTON_HEIGHT;
    if(w < weigth)
      Fl_Pack::size( weigth, Fl_Pack::h() );
    w = Fl_Pack::w();*/
  
    switch((unsigned int)type)
    {
    // == Profiles ==
    case oyWIDGETTYPE_DEFAULT_PROFILE:
    case oyWIDGETTYPE_PROFILE:
    {
      // Profile name box
      box = new OyFl_Box( x, y,
                        OyFl_Pack::w() - SELECT_WIDTH - BUTTON_HEIGHT - 4*H_SPACING, BUTTON_HEIGHT,
                        name );
      box->tooltip( tooltip );
      box->align(FL_ALIGN_LEFT | FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
  
      if( flags & OY_LAYOUT_NO_CHOICES )
      {
        const char* default_p = NULL;
        if(current >= 0)
          default_p = choices[current];
        if(default_p) {
          DBG_PROG_S( (default_p) )
        } else
          default_p = "";
        if(default_p) {
          box = new OyFl_Box( w - BOX_WIDTH - SELECT_WIDTH - BUTTON_HEIGHT - 3*H_SPACING, y,
                            190, BUTTON_HEIGHT, default_p );
          box->align( FL_ALIGN_LEFT | FL_ALIGN_CLIP | FL_ALIGN_INSIDE );
  
          // identify
          box->user_data( (void*)(intptr_t)option );
  
          Fl_Group::end();
          Fl_Group::resizable( box );
          return;
        }
      }
  
      // Choice
      choice = new Fl_Choice( box->x()+box->w(), OyFl_Pack::y(),
                              SELECT_WIDTH, h );
      choice->callback( selectDefaultProfile_callback );
      choice->tooltip( tooltip );
      DBG_PROG_V((choice->size()))
  
      // Profile viewer
      Fl_Button *button = new Fl_Button( w - BUTTON_HEIGHT - H_SPACING, y,
                                         BUTTON_HEIGHT, BUTTON_HEIGHT, "@-3DnArrow" );
      button->callback( showDefaultProfile_callback );
      button->tooltip(_("Show in external Viewer"));
  
      // identify
      choice->user_data( (void*)(intptr_t)option );
    }
    break;
  
    // == Behaviour ==
    case oyWIDGETTYPE_BEHAVIOUR:
    case oyWIDGETTYPE_CHOICE:
    {
      // name box
      box = new OyFl_Box( x, y,
                        w - SELECT_WIDTH - BUTTON_HEIGHT - 4*H_SPACING, BUTTON_HEIGHT,
                        name );
      box->tooltip( tooltip );
      box->align(FL_ALIGN_LEFT | FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
  
      if( flags & OY_LAYOUT_NO_CHOICES )
      {
        const char* default_p = NULL;
        if(current >= 0)
          default_p = choices[current];
        if(default_p) {
          DBG_PROG_S( (default_p) )
        } else
          default_p = "";
        if(default_p) {
          box = new OyFl_Box( w - BOX_WIDTH - SELECT_WIDTH - BUTTON_HEIGHT - 3*H_SPACING, y,
                            190, BUTTON_HEIGHT, default_p );
          box->align( FL_ALIGN_LEFT | FL_ALIGN_CLIP | FL_ALIGN_INSIDE );
  
          // identify
          box->user_data( (void*)(intptr_t)option );
  
          Fl_Group::end();
          Fl_Group::resizable( box );
          return;
        }
      }
  
      // Choice
      choice = new Fl_Choice( w - SELECT_WIDTH - H_SPACING, y,
                              SELECT_WIDTH + BUTTON_HEIGHT + H_SPACING, h );
      choice->callback( selectBehaviourCallback );
      choice->tooltip( tooltip );
  
      // identify
      choice->user_data( (void*)(intptr_t)option );
    }
    break;
  
    // == List ==
    case oyWIDGETTYPE_LIST:
    {
      int count = choices_n;
  
      box = NULL;
  
      Fl_Pack::type( FL_VERTICAL );
      Fl_Pack::spacing(3);
      Fl_Pack::user_data( (void*)(intptr_t)option );
  
      Fl_Pack::size( w, parent()->h() );
  
      ListEntry *pp = 0;
      int width = 0;
      new Fl_Box(0,0,10, H_SPACING);
  
      //parent()->box(FL_ENGRAVED_FRAME);
  
      for (int i = 0 ; i < count ; ++i) {
        int scrollb_w = 0;
        Fl_Scroll * scroll = dynamic_cast <Fl_Scroll*> (Fl_Group::current()->parent()->parent());
        if( scroll )
        {
          scrollb_w = scroll->scrollbar.w();
        }
        pp = new ListEntry( Fl_Group::current()->x(), Fl_Group::current()->y(),
                            w - scrollb_w - spacing(), BUTTON_HEIGHT,
                            choices[i], flags );
        if( width < pp->w() )
          width = pp->w();
        pp->end();
      }
  
    }
    } /* switch */
  
    
    end();
    resizable( box );
}

ListEntry::ListEntry( int x, int y, int w, int h, const char * name, int flags )
    : OyFl_Pack(x, y, w, h) {
  Fl_Pack::type( FL_HORIZONTAL );
      Fl_Pack::spacing(H_SPACING);
      Fl_Group::resizable(0);
  
      box = new Fl_Box( 0, 0, w-BUTTON_HEIGHT-spacing(), BUTTON_HEIGHT, name );
      box->align(FL_ALIGN_LEFT | FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
  
      new Fl_Box( 0, 0, BUTTON_HEIGHT, BUTTON_HEIGHT );
  
      int width=0, height=0;
  
      box->measure_label(width, height);
  
      /*int scroll_w = 50; //default_profiles_pack->w() - 3*H_SPACING - BUTTON_HEIGHT;
      int b_w = scroll_w;
      if(width > scroll_w)
        b_w = width;
  
      box->size( b_w + H_SPACING, 25 ); */
  
      Fl_Pack::resizable(box);
      //Fl_Pack::size( parent()->w(), Fl_Pack::h() );
      //if(name) delete [] name; // dont delete as it belongs now to the widget
}

static Fl_Group* addTab( Flmm_Tabs* tabs, const oyGROUP_e *groups ) {
  Fl_Group *parent = /*dynamic_cast <Fl_Group>*/ tabs; // parent tab
    Fl_Group *tab = NULL; // actual tab
  
    if( !parent )
      WARNc_S( "wrong widget" );
  
    for( int k = 1; k <= groups[0]; ++k )
    {
      int i = 0;
      int wcount = parent->children();
      tab = NULL;
      const char *g_name = NULL;
      oyWidgetTitleGet( (oyWIDGET_e)groups[k], NULL, &g_name, NULL, NULL );
  
      for( i = 0; i < wcount; ++i )
      {
        const char *c_name = parent->child( i )->label(); // current name
  
        if( c_name && g_name )
        if( strcmp( c_name, g_name ) == 0 )
        {
          // a widget with the searched label was found => tab exists allready
          tab = (Flmm_Tabs*) parent->child( i );
          tab->box( FL_THIN_UP_BOX );
          break;
        }
      }
  
      if( !tab )
      {
        const char *tooltip = NULL;
        const char *title = NULL;
        oyWidgetTitleGet( (oyWIDGET_e)groups[k], NULL, &title, &tooltip, NULL );
  
        parent->begin();
          Fl_Widget *wid = (Fl_Widget*)parent->user_data();
          if( !wid ) wid = parent;
  
          int x = parent->x() + Fl::box_dx( wid->box() ) + V_SPACING,
              y = parent->y() + Fl::box_dy( wid->box() ) + BUTTON_HEIGHT,// + V_SPACING,
              w = parent->w() - Fl::box_dw( wid->box() ) - 2*V_SPACING,
              h = parent->h() - Fl::box_dh( wid->box() ) - BUTTON_HEIGHT - 2*V_SPACING;
          printf("%d+%d,%dx%d\n", x,y,w,h);
          if( k < groups[0] )
          {
            tab = new Flmm_Tabs(   x,y,w,h, title);
            tab->tooltip( tooltip );
            tab->user_data( tab );
            tab->box( FL_THIN_UP_BOX );
            tab->end();
          } else {
            tab = new Fl_Scroll( x,y,w,h, title );
            tab->tooltip( tooltip );
            tab->box( FL_NO_BOX ); //FL_THIN_UP_BOX );
            { OyFl_Pack* o = new OyFl_Pack( x + Fl::box_dx( tab->box() ) + V_SPACING,
                                        y + Fl::box_dy( tab->box() ) + V_SPACING,// + BUTTON_HEIGHT,
                                        w - Fl::box_dw(parent->box()) - 2*V_SPACING,
                                        h - Fl::box_dh( parent->box() ) - BUTTON_HEIGHT );
              o->box( FL_NO_BOX );
              o->spacing( V_SPACING );
              o->end();
              tab->user_data( o );
              tab->resizable( o );
            }
            tab->end();
          }
        parent->end();
        parent->resizable( tab );
      }
      parent = const_cast <Fl_Group*> (dynamic_cast<Fl_Group*>(tab));
    }
  
    if( tab )
      return (Fl_Group*)tab->user_data();
    else
      return NULL;
}

static Fl_Widget* getWidget( Fl_Group* group, oyWIDGET_e oywid ) {
  Fl_Widget *wid = NULL;
  
    if( !group )
      WARNc_S( "wrong widget" );
  
      int wcount = group->children();
  
      for( int i = 0; i < wcount; ++i )
      {
        if( dynamic_cast <Fl_Widget*>( group->child( i ) ) )
        {
          oyWIDGET_e w_id = (oyWIDGET_e)(intptr_t)group->child( i )->user_data(); // widget id
          if( w_id && oywid )
            if( w_id == oywid )
              return dynamic_cast <Fl_Widget*>( group->child( i ) );
        }
  
        if( dynamic_cast <Fl_Group*>( group->child( i ) ) )
        {
          wid = getWidget( dynamic_cast <Fl_Group*>( group->child( i ) ),
                              oywid );
          if(wid)
            return wid;
        }
      }
  
    return wid;
}

static Fl_Group* getTab( Flmm_Tabs* tabs, oyGROUP_e group, Fl_Group **container ) {
  Fl_Group *parent = /*dynamic_cast <Fl_Group>*/ tabs; // parent tab
    Fl_Group *tab = NULL; // actual tab
  
    if( container )
      *container = NULL;
  
    if( !parent )
      WARNc_S( "wrong widget" );
  
      int wcount = parent->children();
      tab = NULL;
      const char *g_name = NULL;
      oyWidgetTitleGet( (oyWIDGET_e)group, NULL, &g_name, NULL, NULL );
  
      for( int i = 0; i < wcount; ++i )
      {
        const char *c_name = parent->child( i )->label(); // current name
  
        if( c_name && g_name )
        if( strcmp( c_name, g_name ) == 0 )
        {
          tab = (Flmm_Tabs*) parent->child( i );
          wcount = tab->children();
          for( i = 0; i < wcount; ++i )
            if( dynamic_cast <Fl_Pack*>( tab->child( i ) ) )
            {
              Fl_Pack *p = dynamic_cast <Fl_Pack*>( tab->child( i ) );
              if( p && p == tab->user_data() )
                *container = p;
              return tab;
            }
          return tab;
        }
      }
  
    return tab;
}

static void refreshOptions() {
  top_tabs->damage( FL_DAMAGE_ALL );
    top_tabs->redraw();
  
  
    Option *op = 0;
  
    int n = 0;
    oyWIDGET_e *wl = oyWidgetListGet( oyGROUP_ALL, &n, myAllocFunc );
  
    // fill in all the options
    for( int i = 0 ; i < n ; ++i )
        {
          const oyGROUP_e * groups;
          int             count = 0,
                          current = 0,
                          flags = 0;
          const char    * tooltip = NULL;
          const char   ** names = NULL;
          const char    * name = NULL;
          oyWIDGET_e        oywid = wl[i];
          oyWIDGET_TYPE_e   type = oyWidgetTitleGet(  oywid,
                                                    &groups, &name, &tooltip,
                                                    &flags );
          if(type == oyWIDGETTYPE_CHOICE ||
             type == oyWIDGETTYPE_BEHAVIOUR ||
             type == oyWIDGETTYPE_DEFAULT_PROFILE ||
             type == oyWIDGETTYPE_PROFILE ||
             type == oyWIDGETTYPE_LIST)
          {
            Fl_Group *w = addTab( top_tabs, groups );
  
            oyOptionChoicesGet( oywid, &count, &names, &current );
            /*for(int en = 0; en < count; ++en)
              printf("%s\n", names[en]);*/
  
            if(oywid == oyWIDGET_POLICY)
            {
              if(current >= 0)
                policy_box->label( names[current] );
              else
                policy_box->label( _("----") );
            }
  
            if(w)
            {
              int bh = BUTTON_HEIGHT;
              int by = w->y();
  
              Fl_Widget *wid = getWidget( top_tabs, oywid );
              Fl_Choice * choice = dynamic_cast <Fl_Choice*>( wid );
              Fl_Box * box = dynamic_cast <Fl_Box*>( wid );
              Fl_Pack * pack = dynamic_cast <Fl_Pack*>( wid );
              if(!box && !choice)
              {
                if(pack)
                {
                  op = dynamic_cast <Option*>( pack );
                  w->remove( pack );
                  delete op;
                  w->damage( FL_DAMAGE_ALL );
                  w->redraw();
                }
  
                w->begin();
                  if( flags & OY_LAYOUT_MIDDLE )
                  {
                    const char *nn[2] = { "","" };
                    op = new Option( w->x(), by, w->w() - Fl::box_dw(w->box()),
                           2*bh, "",
                           oyWIDGET_BEHAVIOUR_START,
                           type, 1,nn,1,"", OY_LAYOUT_NO_CHOICES | flags );
                  }
  
                  op = new Option( w->x(), by, Fl_Group::current()->w()
                                         - Fl::box_dw(Fl_Group::current()->box()),
                           bh, name,
                           oywid, type, count, names, current, tooltip, flags );
                w->end();
              }
  
              // fill in the data
              if(!pack)
              {
                wid = getWidget( top_tabs, oywid );
                choice = dynamic_cast <Fl_Choice*>( wid );
                box = dynamic_cast <Fl_Box*>( wid );
                if(box || choice)
                {
                  if(choice)
                  {
                    int j;
                    choice->clear();
                    for(j = 0; j < count; ++j)
                      choice->add( names[j] );
  
                    if(current >= 0 && names[current])
                      choice->value( choice->find_item( names[current] ) );
                    else
                      choice->value( -1 );
                  }
                  if(box)
                  {
                    if( current >= 0 )
                      box->label( names[current] );
                    else
                      box->label( "" );
                  }
                }
              }
            }
          }
        }
    delete [] wl;
  
    // resize the top group
    if( op )
    {
      int tw = top_group->w(),
          ow = op->w();
      if( tw < ow )
        top_group->size( ow, top_group->h() );
    }
}

void createUI() {
  top_tabs->clear();
    refreshOptions();
}

void updateUI() {
  //! internal@todo start refreshing when the UI has finished
  
    Fl::add_idle(updateUIIdle);
}

void updateUIIdle(void*) {
  Fl::remove_idle(updateUIIdle);
    //! internal refreshing when the UI has finished
    refreshOptions();
}

Fl_Double_Window *top_group=(Fl_Double_Window *)0;

#include <FL/Fl_Image.H>
static unsigned char idata_oyranos_logo64[] =
{255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,62,0,0,0,32,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,0,0,0,4,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,158,0,0,
0,125,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,10,
0,0,0,243,0,0,0,219,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,0,0,0,93,0,0,0,255,0,0,0,255,0,0,0,58,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,0,0,0,188,0,0,0,255,0,0,0,255,0,0,0,153,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,0,0,0,29,0,0,0,253,0,0,0,255,0,0,0,255,0,0,0,239,0,0,0,8,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,0,0,0,122,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,86,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,0,0,0,217,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,181,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,56,
0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,252,0,0,0,23,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,152,0,0,0,
255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,114,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,7,0,0,0,239,0,0,0,255,0,0,0,255,
0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,208,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,0,0,0,86,0,0,0,255,0,0,0,255,0,0,0,237,0,0,0,233,0,
0,0,230,0,0,0,242,0,0,0,255,0,0,0,255,0,0,0,47,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,0,0,0,169,0,0,0,136,0,0,0,25,255,255,255,0,0,0,0,152,0,0,0,128,
255,255,255,0,0,0,0,35,0,0,0,153,0,0,0,136,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,0,0,0,16,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,152,0,0,0,128,
255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,16,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,152,
0,0,0,128,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,0,0,0,152,0,0,0,128,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,0,0,0,152,0,0,0,128,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,0,0,0,152,0,0,0,128,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,152,0,0,0,128,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,149,149,
149,56,161,161,161,157,159,159,159,161,158,158,158,160,157,157,157,161,158,158,
158,160,157,157,157,160,156,156,156,160,154,154,154,159,154,154,154,159,154,154,
154,159,61,61,61,216,72,72,72,208,154,154,154,160,154,154,154,160,153,153,153,
159,152,152,152,159,152,152,152,159,152,152,152,159,152,152,152,159,152,152,152,
159,152,152,152,159,152,152,152,159,152,152,152,159,152,152,152,159,151,151,151,
160,151,151,151,160,151,151,151,160,151,151,151,161,151,151,151,161,149,149,149,
161,149,149,149,161,148,148,148,162,149,149,149,162,149,149,149,162,150,150,150,
162,149,149,149,162,148,148,148,162,149,149,149,163,149,149,149,163,147,147,147,
164,147,147,147,164,147,147,147,164,147,147,147,164,146,146,146,98,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,167,167,167,248,170,170,170,255,170,170,170,255,169,169,169,
255,168,168,168,255,167,167,167,255,165,165,165,255,164,164,164,255,163,163,163,
255,162,162,162,255,163,163,163,255,100,100,100,255,109,109,109,255,161,161,161,
255,161,161,161,255,160,160,160,255,160,160,160,255,160,160,160,255,159,159,159,
255,158,158,158,255,158,158,158,255,158,158,158,255,158,158,158,255,157,157,157,
255,157,157,157,255,156,156,156,255,156,156,156,255,156,156,156,255,155,155,155,
255,156,156,156,255,156,156,156,255,155,155,155,255,155,155,155,255,155,155,155,
255,155,155,155,255,154,154,154,255,155,155,155,255,154,154,154,255,155,155,155,
255,155,155,155,255,155,155,155,255,155,155,155,255,155,155,155,255,155,155,155,
255,151,151,151,255,147,147,147,135,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,167,167,167,254,182,182,182,
255,184,184,184,255,183,183,183,255,182,182,182,255,181,181,181,255,180,180,180,
255,179,179,179,255,177,177,177,255,178,178,178,255,177,177,177,255,103,103,103,
255,115,115,115,255,176,176,176,255,175,175,175,255,115,213,115,255,113,212,113,
255,174,174,174,255,173,173,173,255,173,173,173,255,173,173,173,255,173,173,173,
255,172,172,172,255,172,172,172,255,172,172,172,255,171,171,171,255,171,171,171,
255,170,170,170,255,170,170,170,255,170,170,170,255,170,170,170,255,169,169,169,
255,170,170,170,255,169,169,169,255,168,168,168,255,169,169,169,255,169,169,169,
255,168,168,168,255,168,168,168,255,167,167,167,255,168,168,168,255,167,167,167,
255,167,167,167,255,168,168,168,255,158,158,158,255,137,137,137,207,0,0,0,48,0,
0,0,26,0,0,0,11,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,165,165,
165,254,182,182,182,255,183,183,183,255,182,182,182,255,181,181,181,255,181,181,
181,255,179,179,179,255,177,177,177,255,176,176,176,255,177,177,177,255,176,176,
176,255,101,101,101,255,113,113,113,255,175,175,175,255,50,253,61,255,50,253,50,
255,49,252,49,255,49,252,49,255,110,212,110,255,172,172,172,255,171,171,171,255,
171,171,171,255,170,170,170,255,170,170,170,255,171,171,171,255,170,170,170,255,
170,170,170,255,169,169,169,255,169,169,169,255,169,169,169,255,169,169,169,255,
168,168,168,255,169,169,169,255,168,168,168,255,167,167,167,255,168,168,168,255,
167,167,167,255,167,167,167,255,167,167,167,255,166,166,166,255,167,167,167,255,
167,167,167,255,166,166,166,255,166,166,166,255,156,156,156,255,124,124,124,214,
0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
165,165,165,254,180,180,180,255,182,182,182,255,182,182,182,255,181,181,181,255,
180,180,180,255,178,178,178,255,178,178,178,255,176,176,176,255,175,175,175,255,
175,175,175,255,99,99,99,255,110,110,110,255,111,213,138,255,46,252,90,255,47,
252,65,255,46,252,46,255,45,252,45,255,45,251,45,255,45,251,45,255,139,190,139,
255,170,170,170,255,169,169,169,255,169,169,169,255,169,169,169,255,169,169,169,
255,169,169,169,255,168,168,168,255,167,167,167,255,168,168,168,255,167,167,167,
255,168,168,168,255,167,167,167,255,167,167,167,255,166,166,166,255,166,166,166,
255,166,166,166,255,167,167,167,255,166,166,166,255,165,165,165,255,166,166,166,
255,165,165,165,255,165,165,165,255,166,166,166,255,149,149,149,255,114,114,114,
211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,164,164,164,254,180,180,180,255,182,182,182,255,181,181,181,255,179,179,
179,255,179,179,179,255,178,178,178,255,177,177,177,255,175,175,175,255,174,174,
174,255,174,174,174,255,97,97,97,255,108,108,108,255,76,233,131,255,43,252,105,
255,43,252,91,255,43,252,67,255,42,252,44,255,42,251,42,255,41,251,41,255,41,
250,41,255,137,189,137,255,168,168,168,255,167,167,167,255,168,168,168,255,168,
168,168,255,167,167,167,255,167,167,167,255,166,166,166,255,166,166,166,255,166,
166,166,255,166,166,166,255,166,166,166,255,166,166,166,255,165,165,165,255,165,
165,165,255,165,165,165,255,165,165,165,255,165,165,165,255,165,165,165,255,164,
164,164,255,164,164,164,255,164,164,164,255,161,161,161,255,129,129,129,255,113,
113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,163,163,163,254,179,179,179,255,181,181,181,255,180,180,180,255,
179,179,179,255,178,178,178,255,177,177,177,255,176,176,176,255,174,174,174,255,
173,173,173,255,172,172,172,255,95,95,95,255,106,106,106,255,41,253,126,255,40,
252,116,255,40,252,106,255,39,252,91,255,39,252,70,255,38,251,43,255,38,251,38,
255,38,250,38,255,38,250,38,255,71,228,71,255,166,166,166,255,166,166,166,255,
166,166,166,255,166,166,166,255,165,165,165,255,164,164,164,255,165,165,165,255,
165,165,165,255,165,165,165,255,165,165,165,255,164,164,164,255,164,164,164,255,
164,164,164,255,164,164,164,255,164,164,164,255,163,163,163,255,164,164,164,255,
163,163,163,255,163,163,163,255,152,152,152,255,139,139,139,255,123,123,123,255,
113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,162,162,162,254,179,179,179,255,181,181,181,255,179,179,179,255,
178,178,178,255,178,178,178,255,176,176,176,255,176,176,176,255,173,173,173,255,
172,172,172,255,171,171,171,255,93,93,93,255,104,104,104,255,37,253,134,255,37,
252,126,255,36,252,116,255,36,252,105,255,36,251,93,255,36,251,74,255,35,251,43,
255,35,250,35,255,35,250,35,255,35,249,35,255,68,227,68,255,165,165,165,255,165,
165,165,255,165,165,165,255,164,164,164,255,163,163,163,255,164,164,164,255,164,
164,164,255,164,164,164,255,164,164,164,255,163,163,163,255,164,164,164,255,163,
163,163,255,162,162,162,255,163,163,163,255,162,162,162,255,161,161,161,255,155,
155,155,255,145,145,145,255,139,139,139,255,138,138,138,255,123,123,123,255,113,
113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,162,162,162,254,178,178,178,255,180,180,180,255,179,179,179,255,
177,177,177,255,177,177,177,255,176,176,176,255,174,174,174,255,172,172,172,255,
172,172,172,255,170,170,170,255,90,90,90,255,102,102,102,255,35,253,142,255,35,
253,134,255,34,252,126,255,34,252,117,255,34,251,107,255,33,251,93,255,33,251,
76,255,33,250,48,255,33,249,33,255,33,245,33,255,33,242,33,255,107,221,66,255,
165,165,165,255,164,164,164,255,164,164,164,255,163,163,163,255,163,163,163,255,
163,163,163,255,162,162,162,255,162,162,162,255,163,163,163,255,162,162,162,255,
161,161,161,255,158,158,158,255,153,153,153,255,147,147,147,255,143,143,143,255,
141,141,141,255,141,141,141,255,140,140,140,255,138,138,138,255,123,123,123,255,
113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,161,161,161,254,178,178,178,255,179,179,179,255,178,178,178,255,
177,177,177,255,177,177,177,255,175,175,175,255,174,174,174,255,172,172,172,255,
171,171,171,255,170,170,170,255,88,88,88,255,101,101,101,255,33,253,149,255,33,
253,143,255,32,252,134,255,32,252,126,255,32,252,118,255,31,251,106,255,31,250,
95,255,31,248,79,255,31,244,54,255,31,241,31,255,40,237,31,255,102,234,31,255,
140,213,64,255,163,163,163,255,163,163,163,255,162,162,162,255,160,160,160,255,
158,158,158,255,156,156,156,255,155,155,155,255,152,152,152,255,149,149,149,255,
146,146,146,255,146,146,146,255,145,145,145,255,145,145,145,255,143,143,143,255,
142,142,142,255,141,141,141,255,140,140,140,255,138,138,138,255,123,123,123,255,
113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,161,161,161,254,177,177,177,255,179,179,179,255,178,178,178,255,
176,176,176,255,175,175,175,255,174,174,174,255,173,173,173,255,172,172,172,255,
170,170,170,255,170,170,170,255,88,88,88,255,101,101,101,255,30,253,155,255,30,
253,149,255,30,252,142,255,30,252,135,255,30,251,127,255,29,250,117,255,27,246,
106,255,24,243,93,255,23,239,76,255,21,235,50,255,43,231,22,255,103,226,16,255,
131,223,13,255,153,203,46,255,153,153,153,255,152,152,152,255,151,151,151,255,
151,151,151,255,150,150,150,255,150,150,150,255,149,149,149,255,148,148,148,255,
147,147,147,255,146,146,146,255,145,145,145,255,145,145,145,255,143,143,143,255,
142,142,142,255,141,141,141,255,140,140,140,255,139,139,139,255,123,123,123,255,
113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,160,160,160,254,177,177,177,255,179,179,179,255,177,177,177,255,
176,176,176,255,174,174,174,255,174,174,174,255,173,173,173,255,171,171,171,255,
169,169,169,255,169,169,169,255,86,86,86,255,99,99,99,255,28,253,160,255,23,253,
153,255,19,252,144,255,15,251,134,255,11,248,127,255,8,243,116,255,8,240,107,
255,8,237,96,255,8,232,84,255,8,228,68,255,57,224,47,255,107,220,15,255,136,215,
8,255,158,212,8,255,170,194,44,255,152,152,152,255,151,151,151,255,151,151,
151,255,151,151,151,255,150,150,150,255,149,149,149,255,148,148,148,255,147,147,
147,255,146,146,146,255,146,146,146,255,145,145,145,255,143,143,143,255,143,143,
143,255,141,141,141,255,140,140,140,255,139,139,139,255,123,123,123,255,113,113,
113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,160,160,160,254,177,177,177,255,178,178,178,255,176,176,176,255,176,
176,176,255,174,174,174,255,173,173,173,255,172,172,172,255,171,171,171,255,170,
170,170,255,168,168,168,255,82,82,82,255,88,88,88,255,6,253,159,255,7,252,154,
255,7,248,146,255,7,245,140,255,8,242,133,255,8,238,126,255,8,235,118,255,8,230,
109,255,8,226,98,255,8,223,86,255,77,218,72,255,117,213,52,255,142,210,18,255,
164,206,8,255,181,200,8,255,184,185,43,255,151,151,151,255,151,151,151,255,151,
151,151,255,150,150,150,255,149,149,149,255,148,148,148,255,147,147,147,255,146,
146,146,255,145,145,145,255,145,145,145,255,143,143,143,255,143,143,143,255,141,
141,141,255,141,141,141,255,139,139,139,255,123,123,123,255,113,113,113,211,0,0,
0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
160,160,160,254,176,176,176,255,178,178,178,255,176,176,176,255,175,175,175,255,
173,173,173,255,173,173,173,255,173,173,173,255,171,171,171,255,167,167,167,255,
161,161,161,255,70,70,70,255,84,84,84,255,6,250,166,255,7,247,160,255,8,244,155,
255,7,240,148,255,8,237,142,255,8,232,135,255,8,229,128,255,8,224,119,255,8,220,
110,255,25,216,100,255,90,212,89,255,124,208,75,255,150,203,58,255,169,198,28,
255,186,194,8,255,200,189,8,255,198,176,44,255,151,151,151,255,151,151,151,255,
150,150,150,255,149,149,149,255,149,149,149,255,148,148,148,255,146,146,146,255,
146,146,146,255,145,145,145,255,144,144,144,255,143,143,143,255,141,141,141,255,
141,141,141,255,140,140,140,255,123,123,123,255,113,113,113,211,0,0,0,76,0,0,0,
41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,159,159,159,
254,176,176,176,255,177,177,177,255,176,176,176,255,175,175,175,255,173,173,173,
255,173,173,173,255,172,172,172,255,169,169,169,255,161,161,161,255,159,159,159,
255,71,71,71,255,83,83,83,255,7,245,173,255,7,241,167,255,8,239,162,255,7,234,
155,255,8,230,150,255,8,226,142,255,8,222,136,255,8,218,129,255,8,215,121,255,
37,210,112,255,101,206,102,255,132,200,90,255,155,196,78,255,174,192,62,255,
189,186,34,255,204,182,9,255,217,176,8,255,209,166,43,255,151,151,151,255,150,
150,150,255,150,150,150,255,149,149,149,255,148,148,148,255,146,146,146,255,146,
146,146,255,145,145,145,255,145,145,145,255,143,143,143,255,141,141,141,255,141,
141,141,255,140,140,140,255,123,123,123,255,113,113,113,211,0,0,0,76,0,0,0,41,0,
0,0,18,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,159,159,159,254,
176,176,176,255,178,178,178,255,176,176,176,255,174,174,174,255,174,174,174,255,
172,172,172,255,172,172,172,255,163,163,163,255,161,161,161,255,160,160,160,255,
71,71,71,255,84,84,84,255,46,220,174,255,7,236,174,255,7,232,168,255,7,228,163,
255,8,224,157,255,8,220,151,255,8,217,144,255,8,212,137,255,8,208,129,255,64,
203,122,255,111,198,113,255,139,195,105,255,161,189,93,255,178,184,81,255,195,
180,66,255,208,174,41,255,220,169,13,255,232,162,7,255,218,154,43,255,150,150,
150,255,150,150,150,255,149,149,149,255,148,148,148,255,147,147,147,255,146,146,
146,255,145,145,145,255,145,145,145,255,143,143,143,255,142,142,142,255,141,141,
141,255,140,140,140,255,124,124,124,255,113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,
18,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,159,159,159,254,175,175,
175,255,177,177,177,255,176,176,176,255,175,175,175,255,174,174,174,255,172,172,
172,255,167,167,167,255,163,163,163,255,162,162,162,255,160,160,160,255,71,71,
71,255,85,85,85,255,84,196,172,255,6,230,179,255,7,226,175,255,7,221,169,255,8,
218,164,255,8,215,158,255,8,210,152,255,8,204,145,255,12,201,139,255,81,196,131,
255,120,191,124,255,145,187,115,255,165,181,106,255,183,176,96,255,198,171,84,
255,212,165,69,255,224,160,48,255,235,153,14,255,242,147,7,255,219,143,43,255,
149,149,149,255,149,149,149,255,148,148,148,255,147,147,147,255,146,146,146,255,
146,146,146,255,145,145,145,255,143,143,143,255,143,143,143,255,141,141,141,255,
140,140,140,255,124,124,124,255,113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,159,159,159,254,175,175,175,255,
178,178,178,255,176,176,176,255,175,175,175,255,173,173,173,255,173,173,173,255,
165,165,165,255,163,163,163,255,162,162,162,255,160,160,160,255,72,72,72,255,85,
85,85,255,85,194,175,255,7,223,185,255,7,219,181,255,7,215,175,255,8,212,171,
255,8,207,165,255,8,202,159,255,8,199,153,255,29,193,147,255,93,189,139,255,128,
184,133,255,151,178,126,255,171,173,117,255,187,168,108,255,202,162,98,255,215,
156,86,255,227,149,71,255,237,143,52,255,242,136,21,255,242,130,7,255,218,129,
43,255,149,149,149,255,148,148,148,255,147,147,147,255,146,146,146,255,145,145,
145,255,145,145,145,255,143,143,143,255,143,143,143,255,141,141,141,255,141,141,
141,255,124,124,124,255,113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,158,158,158,254,176,176,176,255,177,
177,177,255,176,176,176,255,175,175,175,255,173,173,173,255,170,170,170,255,164,
164,164,255,163,163,163,255,163,163,163,255,161,161,161,255,73,73,73,255,86,86,
86,255,122,176,169,255,8,217,192,255,7,213,186,255,8,209,182,255,7,204,176,255,
8,200,172,255,8,196,165,255,8,191,160,255,45,185,153,255,104,180,147,255,135,
175,140,255,155,166,131,255,167,158,126,255,192,159,119,255,206,153,110,255,219,
146,99,255,231,140,88,255,240,132,75,255,242,124,58,255,242,117,29,255,241,108,
7,255,216,109,42,255,149,149,149,255,148,148,148,255,146,146,146,255,146,146,
146,255,145,145,145,255,144,144,144,255,143,143,143,255,141,141,141,255,141,141,
141,255,125,125,125,255,113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,159,159,159,254,176,176,176,255,177,
177,177,255,176,176,176,255,175,175,175,255,174,174,174,255,167,167,167,255,164,
164,164,255,163,163,163,255,163,163,163,255,161,161,161,255,73,73,73,255,87,87,
87,255,160,160,160,255,8,210,196,255,8,206,191,255,8,202,188,255,7,197,182,255,
8,193,177,255,8,188,172,255,8,183,167,255,69,178,161,255,113,173,155,255,139,
164,146,255,206,206,202,255,241,241,241,255,190,161,148,255,210,141,120,255,222,
135,111,255,235,128,102,255,243,120,90,255,243,111,77,255,242,101,61,255,241,91,
35,255,240,78,10,255,216,83,42,255,148,148,148,255,146,146,146,255,146,146,146,
255,145,145,145,255,144,144,144,255,143,143,143,255,141,141,141,255,141,141,141,
255,125,125,125,255,113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,159,159,159,254,176,176,176,255,177,177,
177,255,177,177,177,255,175,175,175,255,174,174,174,255,166,166,166,255,164,164,
164,255,164,164,164,255,163,163,163,255,162,162,162,255,74,74,74,255,87,87,87,
255,160,160,160,255,47,192,191,255,8,199,197,255,8,194,192,255,7,190,188,255,8,
185,183,255,8,180,178,255,15,175,173,255,85,168,167,255,122,164,162,255,143,153,
151,255,224,223,222,255,248,248,248,255,196,165,164,255,213,130,128,255,226,123,
122,255,238,115,113,255,244,105,103,255,243,94,92,255,242,83,80,255,241,68,65,
255,240,46,43,255,239,17,11,255,215,41,41,255,147,147,147,255,146,146,146,255,
145,145,145,255,145,145,145,255,143,143,143,255,142,142,142,255,141,141,141,255,
125,125,125,255,113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,160,160,160,254,177,177,177,255,178,178,178,
255,177,177,177,255,175,175,175,255,174,174,174,255,165,165,165,255,164,164,164,
255,164,164,164,255,163,163,163,255,163,163,163,255,74,74,74,255,87,87,87,255,
160,160,160,255,86,178,184,255,8,191,203,255,7,185,199,255,7,180,193,255,8,175,
190,255,8,170,185,255,34,164,180,255,98,158,174,255,130,152,169,255,154,145,163,
255,168,140,155,255,183,148,160,255,199,123,142,255,218,115,138,255,230,106,131,
255,241,95,123,255,244,84,115,255,243,68,106,255,242,45,95,255,242,24,84,255,
240,6,69,255,239,6,51,255,238,6,21,255,192,76,76,255,146,146,146,255,145,145,
145,255,145,145,145,255,143,143,143,255,142,142,142,255,141,141,141,255,125,125,
125,255,113,113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,160,160,160,254,177,177,177,255,178,178,178,255,177,177,
177,255,176,176,176,255,173,173,173,255,165,165,165,255,164,164,164,255,164,164,
164,255,164,164,164,255,163,163,163,255,75,75,75,255,87,87,87,255,161,161,161,
255,123,168,174,255,9,181,209,255,8,176,205,255,7,170,199,255,8,165,196,255,8,
159,191,255,59,153,186,255,110,146,181,255,139,140,176,255,161,132,171,255,179,
125,165,255,195,116,159,255,209,106,152,255,222,97,146,255,234,85,141,255,243,
70,133,255,244,49,125,255,243,20,117,255,242,7,108,255,242,7,99,255,241,7,89,
255,239,6,75,255,238,6,59,255,192,76,83,255,146,146,146,255,146,146,146,255,145,
145,145,255,143,143,143,255,143,143,143,255,141,141,141,255,126,126,126,255,113,
113,113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,161,161,161,254,177,177,177,255,179,179,179,255,178,178,178,255,
176,176,176,255,172,172,172,255,165,165,165,255,165,165,165,255,165,165,165,255,
164,164,164,255,163,163,163,255,76,76,76,255,88,88,88,255,161,161,161,255,160,
160,160,255,10,173,214,255,9,168,210,255,8,162,206,255,7,155,200,255,8,149,197,
255,79,141,191,255,119,135,187,255,145,128,182,255,166,119,176,255,184,110,172,
255,199,100,166,255,212,89,160,255,225,75,154,255,237,57,148,255,244,27,141,255,
244,7,133,255,243,7,126,255,242,7,119,255,242,7,110,255,241,7,102,255,193,77,
117,255,149,149,149,255,148,148,148,255,146,146,146,255,146,146,146,255,145,145,
145,255,144,144,144,255,143,143,143,255,141,141,141,255,126,126,126,255,113,113,
113,211,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,161,161,161,254,178,178,178,255,180,180,180,255,178,178,178,255,177,
177,177,255,171,171,171,255,166,166,166,255,165,165,165,255,165,165,165,255,164,
164,164,255,163,163,163,255,77,77,77,255,89,89,89,255,161,161,161,255,161,161,
161,255,85,161,188,255,10,158,214,255,9,151,211,255,7,143,205,255,26,137,201,
255,92,129,197,255,127,121,192,255,151,113,187,255,171,103,183,255,189,92,177,
255,204,79,172,255,216,62,166,255,229,35,161,255,240,12,155,255,245,8,148,255,
245,8,142,255,244,8,136,255,242,7,127,255,196,79,134,255,150,150,150,255,149,
149,149,255,149,149,149,255,148,148,148,255,146,146,146,255,146,146,146,255,145,
145,145,255,144,144,144,255,143,143,143,255,141,141,141,255,126,126,126,255,115,
115,115,210,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,162,162,162,254,178,178,178,255,180,180,180,255,179,179,179,255,
177,177,177,255,170,170,170,255,166,166,166,255,165,165,165,255,165,165,165,255,
164,164,164,255,164,164,164,255,77,77,77,255,89,89,89,255,162,162,162,255,161,
161,161,255,86,156,192,255,11,148,220,255,10,141,216,255,7,131,211,255,40,125,
206,255,103,116,202,255,134,106,198,255,157,95,192,255,177,83,188,255,192,68,
183,255,208,42,177,255,220,15,172,255,232,8,167,255,242,8,161,255,246,8,155,255,
245,8,149,255,198,80,147,255,151,151,151,255,151,151,151,255,150,150,150,255,
150,150,150,255,149,149,149,255,148,148,148,255,146,146,146,255,146,146,146,255,
145,145,145,255,145,145,145,255,143,143,143,255,142,142,142,255,126,126,126,255,
115,115,115,210,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,163,163,163,254,179,179,179,255,180,180,180,255,180,180,180,255,
178,178,178,255,168,168,168,255,166,166,166,255,165,165,165,255,165,165,165,255,
165,165,165,255,164,164,164,255,77,77,77,255,89,89,89,255,162,162,162,255,161,
161,161,255,160,160,160,255,11,135,224,255,9,128,219,255,8,118,215,255,65,108,
211,255,112,99,207,255,141,86,202,255,163,72,198,255,182,51,193,255,197,21,189,
255,212,8,184,255,224,8,178,255,236,8,173,255,244,8,168,255,199,81,157,255,153,
153,153,255,152,152,152,255,151,151,151,255,151,151,151,255,150,150,150,255,149,
149,149,255,149,149,149,255,148,148,148,255,147,147,147,255,146,146,146,255,145,
145,145,255,145,145,145,255,143,143,143,255,142,142,142,255,126,126,126,255,115,
115,115,210,0,0,0,76,0,0,0,41,0,0,0,18,255,255,255,0,255,255,255,0,0,0,0,71,0,0,
0,37,255,255,255,0,0,0,0,17,0,0,0,91,255,255,255,0,255,255,255,0,0,0,0,93,0,0,
0,17,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,164,164,164,254,
180,180,180,255,182,182,182,255,180,180,180,255,178,178,178,255,167,167,167,255,
167,167,167,255,166,166,166,255,165,165,165,255,165,165,165,255,164,164,164,255,
78,78,78,255,90,90,90,255,161,161,161,255,161,161,161,255,161,161,161,255,85,
140,193,255,10,113,224,255,13,102,219,255,83,89,216,255,122,76,212,255,147,58,
207,255,169,27,203,255,186,8,199,255,202,8,193,255,215,8,189,255,208,45,176,255,
196,81,166,255,154,154,154,255,154,154,154,255,153,153,153,255,152,152,152,255,
151,151,151,255,151,151,151,255,151,151,151,255,150,150,150,255,149,149,149,255,
148,148,148,255,147,147,147,255,146,146,146,255,146,146,146,255,145,145,145,255,
143,143,143,255,143,143,143,255,126,126,126,255,115,115,115,210,0,0,0,76,0,0,0,
41,0,0,0,18,255,255,255,0,0,0,0,106,0,0,0,237,0,0,0,45,0,0,0,27,0,0,0,212,0,0,
0,149,0,0,0,2,0,0,0,149,0,0,0,219,0,0,0,19,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,165,165,165,254,180,180,180,255,182,182,182,255,181,181,
181,255,178,178,178,255,168,168,168,255,167,167,167,255,166,166,166,255,165,165,
165,255,166,166,166,255,165,165,165,255,79,79,79,255,91,91,91,255,162,162,162,
255,162,162,162,255,161,161,161,255,122,148,178,255,11,96,229,255,31,80,224,255,
94,63,220,255,130,35,217,255,154,12,212,255,174,8,208,255,190,8,203,255,191,45,
188,255,171,119,166,255,155,155,155,255,154,154,154,255,154,154,154,255,154,154,
154,255,153,153,153,255,152,152,152,255,151,151,151,255,151,151,151,255,151,151,
151,255,150,150,150,255,149,149,149,255,148,148,148,255,148,148,148,255,146,146,
146,255,145,145,145,255,145,145,145,255,143,143,143,255,143,143,143,255,126,126,
126,255,115,115,115,210,0,0,0,76,0,0,0,41,0,0,0,18,0,0,0,131,0,0,0,228,0,0,0,45,
0,0,0,41,0,0,0,226,0,0,0,137,0,0,0,7,0,0,0,171,0,0,0,203,0,0,0,22,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,166,166,166,254,181,
181,181,255,183,183,183,255,181,181,181,255,175,175,175,255,168,168,168,255,167,
167,167,255,167,167,167,255,166,166,166,255,166,166,166,255,165,165,165,255,80,
80,80,255,91,91,91,255,162,162,162,255,162,162,162,255,161,161,161,255,160,160,
160,255,49,93,214,255,48,45,229,255,106,16,225,255,137,8,221,255,160,8,217,255,
172,45,199,255,165,119,169,255,155,155,155,255,155,155,155,255,155,155,155,255,
154,154,154,255,154,154,154,255,154,154,154,255,153,153,153,255,153,153,153,255,
152,152,152,255,151,151,151,255,151,151,151,255,150,150,150,255,149,149,149,255,
149,149,149,255,148,148,148,255,146,146,146,255,146,146,146,255,145,145,145,255,
144,144,144,255,143,143,143,255,126,126,126,255,115,115,115,210,0,0,0,76,0,0,0,
44,0,0,0,162,0,0,0,215,0,0,0,30,0,0,0,57,0,0,0,235,0,0,0,112,0,0,0,15,0,0,0,
191,0,0,0,186,0,0,0,12,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,167,167,167,254,183,183,183,255,184,184,184,255,183,
183,183,255,171,171,171,255,168,168,168,255,168,168,168,255,167,167,167,255,166,
166,166,255,166,166,166,255,165,165,165,255,80,80,80,255,92,92,92,255,162,162,
162,255,163,163,163,255,162,162,162,255,160,160,160,255,123,127,179,255,73,12,
234,255,116,9,229,255,145,45,209,255,158,119,173,255,157,157,157,255,156,156,
156,255,156,156,156,255,155,155,155,255,155,155,155,255,154,154,154,255,154,154,
154,255,154,154,154,255,153,153,153,255,153,153,153,255,152,152,152,255,151,151,
151,255,151,151,151,255,150,150,150,255,150,150,150,255,149,149,149,255,148,148,
148,255,146,146,146,255,146,146,146,255,145,145,145,255,145,145,145,255,143,143,
143,255,127,127,127,255,115,115,115,210,0,0,0,82,0,0,0,190,0,0,0,203,0,0,0,19,0,
0,0,76,0,0,0,239,0,0,0,89,0,0,0,25,0,0,0,208,0,0,0,165,0,0,0,5,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,168,168,168,254,183,183,183,255,185,185,185,255,178,178,178,255,169,169,
169,255,169,169,169,255,168,168,168,255,167,167,167,255,166,166,166,255,165,165,
165,255,166,166,166,255,80,80,80,255,92,92,92,255,162,162,162,255,163,163,163,
255,162,162,162,255,161,161,161,255,160,160,160,255,123,85,198,255,147,120,177,
255,157,157,157,255,157,157,157,255,157,157,157,255,156,156,156,255,156,156,156,
255,155,155,155,255,155,155,155,255,155,155,155,255,154,154,154,255,154,154,154,
255,154,154,154,255,153,153,153,255,152,152,152,255,151,151,151,255,151,151,151,
255,150,150,150,255,150,150,150,255,149,149,149,255,148,148,148,255,147,147,147,
255,146,146,146,255,145,145,145,255,145,145,145,255,143,143,143,255,127,127,127,
255,106,106,106,213,0,0,0,214,0,0,0,193,0,0,0,27,0,0,0,96,0,0,0,238,0,0,0,68,0,
0,0,36,0,0,0,223,0,0,0,142,0,0,0,1,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,169,169,
169,254,185,185,185,255,181,181,181,255,170,170,170,255,170,170,170,255,169,169,
169,255,168,168,168,255,167,167,167,255,167,167,167,255,166,166,166,255,166,166,
166,255,81,81,81,255,22,22,22,255,20,20,20,255,18,18,18,255,17,17,17,255,17,17,
17,255,13,13,13,255,12,12,12,255,11,11,11,255,9,9,9,255,8,8,8,255,8,8,8,255,8,
8,8,255,8,8,8,255,8,8,8,255,8,8,8,255,8,8,8,255,8,8,8,255,8,8,8,255,8,8,8,255,
8,8,8,255,8,8,8,255,7,7,7,255,7,7,7,255,7,7,7,255,7,7,7,255,6,6,6,255,6,6,6,
255,5,5,5,255,5,5,5,255,5,5,5,255,4,4,4,255,3,3,3,255,3,3,3,255,1,1,1,255,0,0,0,
255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,236,0,0,0,
5,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,156,156,156,249,157,157,157,
255,156,156,156,255,155,155,155,255,154,154,154,255,154,154,154,255,153,153,153,
255,152,152,152,255,151,151,151,255,150,150,150,255,150,150,150,255,140,140,140,
255,133,133,133,255,131,131,131,255,130,130,130,255,130,130,130,255,129,129,129,
255,127,127,127,255,127,127,127,255,125,125,125,255,124,124,124,255,124,124,124,
255,123,123,123,255,123,123,123,255,123,123,123,255,122,122,122,255,122,122,122,
255,122,122,122,255,121,121,121,255,121,121,121,255,121,121,121,255,120,120,120,
255,119,119,119,255,119,119,119,255,119,119,119,255,119,119,119,255,118,118,118,
255,117,117,117,255,116,116,116,255,115,115,115,255,115,115,115,255,114,114,114,
255,113,113,113,255,112,112,112,255,106,106,106,255,89,89,89,209,0,0,0,199,0,0,
0,225,0,0,0,72,0,0,0,88,0,0,0,241,0,0,0,128,0,0,0,48,0,0,0,203,0,0,0,184,0,0,
0,12,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,150,150,150,63,139,139,139,188,130,
130,130,204,130,130,130,203,129,129,129,203,128,128,128,203,128,128,128,203,128,
128,128,203,127,127,127,203,126,126,126,202,126,126,126,202,125,125,125,202,124,
124,124,202,124,124,124,202,124,124,124,202,124,124,124,202,123,123,123,202,123,
123,123,202,121,121,121,202,120,120,120,201,120,120,120,201,119,119,119,201,120,
120,120,201,119,119,119,201,120,120,120,201,120,120,120,201,118,118,118,201,119,
119,119,202,119,119,119,202,118,118,118,202,118,118,118,202,118,118,118,202,117,
117,117,202,117,117,117,202,117,117,117,202,117,117,117,202,117,117,117,202,116,
116,116,202,116,116,116,202,115,115,115,202,115,115,115,202,115,115,115,202,114,
114,114,202,114,114,114,202,104,104,104,194,4,4,4,117,0,0,0,72,0,0,0,158,0,0,0,
230,0,0,0,44,0,0,0,47,0,0,0,230,0,0,0,135,0,0,0,10,0,0,0,179,0,0,0,202,0,0,0,21,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,0,0,0,47,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,
0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,
89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,
0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,
0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,
89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,89,0,0,0,81,0,0,0,58,0,0,0,37,0,0,0,123,0,
0,0,237,0,0,0,60,0,0,0,32,0,0,0,217,0,0,0,159,0,0,0,8,0,0,0,158,0,0,0,218,0,0,
0,33,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,0,0,0,27,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,
50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,
0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,
0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,
50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,
0,50,0,0,0,50,0,0,0,50,0,0,0,50,0,0,0,48,0,0,0,43,0,0,0,28,0,0,0,8,0,0,0,92,0,
0,0,241,0,0,0,79,0,0,0,20,0,0,0,202,0,0,0,180,0,0,0,10,0,0,0,134,0,0,0,231,0,
0,0,47,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,0,0,0,17,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,
0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,
32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,
0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,
0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,32,0,0,0,
32,0,0,0,32,0,0,0,32,0,0,0,31,0,0,0,27,0,0,0,14,255,255,255,0,255,255,255,0,0,
0,0,71,0,0,0,240,0,0,0,64,0,0,0,11,0,0,0,184,0,0,0,181,255,255,255,0,0,0,0,
109,0,0,0,239,0,0,0,32,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,0,0,0,7,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,
0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,
0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,
13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,
0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,13,
0,0,0,13,0,0,0,13,0,0,0,13,0,0,0,10,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,0,0,0,37,0,0,0,19,255,255,255,0,0,0,0,5,0,0,0,51,255,255,255,0,
255,255,255,0,0,0,0,51,0,0,0,7,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,0,0,0,25,
0,0,0,13,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,
255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,
255,255,0};
static Fl_RGB_Image image_oyranos_logo64(idata_oyranos_logo64, 64, 64, 4, 0);

Flmm_Tabs *top_tabs=(Flmm_Tabs *)0;

static void cb_3reload(Fl_Button*, void*) {
  //Fl::pushed(&bPL);
  updateUI();
}

Fl_Box *policy_box=(Fl_Box *)0;

int main(int argc, char **argv) {
  Fl::scheme("plastic");
  
  #ifdef USE_GETTEXT
    setlocale(LC_ALL,"");
  #endif
    oyExportStart_(EXPORT_CHECK_NO);
    
    Fl::add_handler( event_handler );
  { top_group = new Fl_Double_Window(505, 410, _("Oyranos Configuration"));
    { OyFl_Pack* o = new OyFl_Pack(0, 0, 480, 70);
      o->type(1);
      o->box(FL_NO_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_BACKGROUND_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(14);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->align(Fl_Align(FL_ALIGN_TOP));
      o->when(FL_WHEN_RELEASE);
      { Fl_Box* o = new Fl_Box(0, 0, 85, 70);
        o->image(image_oyranos_logo64);
        o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { OyFl_Box* o = new OyFl_Box(95, 0, 385, 70, _("Oyranos Configuration"));
        o->box(FL_NO_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_BACKGROUND_COLOR);
        o->labeltype(FL_ENGRAVED_LABEL);
        o->labelfont(0);
        o->labelsize(18);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        o->when(FL_WHEN_RELEASE);
        Fl_Group::current()->resizable(o);
        o->redraw();
      } // OyFl_Box* o
      o->end();
    } // OyFl_Pack* o
    { top_tabs = new Flmm_Tabs(0, 70, 505, 301);
      top_tabs->box(FL_THIN_UP_BOX);
      top_tabs->color(FL_BACKGROUND_COLOR);
      top_tabs->selection_color(FL_LIGHT2);
      top_tabs->labeltype(FL_NORMAL_LABEL);
      top_tabs->labelfont(0);
      top_tabs->labelsize(14);
      top_tabs->labelcolor(FL_FOREGROUND_COLOR);
      top_tabs->align(Fl_Align(FL_ALIGN_TOP));
      top_tabs->when(FL_WHEN_RELEASE);
      { Fl_Group* o = new Fl_Group(10, 95, 485, 266, _("Policy"));
        o->tooltip(_("Reset to a standard Policy for Oyranos."));
        o->end();
        Fl_Group::current()->resizable(o);
      } // Fl_Group* o
      top_tabs->end();
      Fl_Group::current()->resizable(top_tabs);
    } // Flmm_Tabs* top_tabs
    { Fl_Button* o = new Fl_Button(10, 375, 50, 25, _("@-3reload"));
      o->tooltip(_("Refresh"));
      o->callback((Fl_Callback*)cb_3reload);
      o->when(FL_WHEN_RELEASE_ALWAYS);
    } // Fl_Button* o
    { Fl_Pack* o = new Fl_Pack(160, 371, 255, 35);
      o->type(1);
      { Fl_Box* o = new Fl_Box(160, 371, 120, 35, _("Active Policy:"));
        o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { policy_box = new Fl_Box(280, 371, 135, 35, _("----"));
        policy_box->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      } // Fl_Box* policy_box
      o->end();
    } // Fl_Pack* o
    top_group->size_range(305, 255);
    top_group->end();
  } // Fl_Double_Window* top_group
  createUI();
  top_group->show(argc, argv);
  return Fl::run();
}

void listWindow( Fl_Widget *w ) {
  Fl_Group *g = dynamic_cast <Fl_Group*> (w);
  
    static int level = 0;
  
  
    if( g )
    {
      int n = g->children();
  
      std::cout << std::endl;
      for(int i = 0; i < level; ++i) std::cout << " ";
  
      std::cout << "Group t" << (int)w->type() << " " << w->x()<<"+"<<w->y()<<"+"<<w->w()<<"x"<<w->h() <<
                   " \"" << (w->label()?w->label():"") << "\":";
  
      ++level;
      for( int i = 0; i < n; ++i )
      {
        listWindow( g->child(i) );
      }
      --level;
      std::cout << std::endl;
    } else
    {
      std::cout << " t" << (int)w->type() << " " << w->x()<<"+"<<w->y()<<"+"<<w->w()<<"x"<<w->h() <<
                   " " << (w->label()?w->label():"- ");
    }
}

int event_handler( int e ) {
  int found = 0;
  
    switch (e)
    {
    case FL_SHORTCUT:
        /*if(Fl::event_key() == FL_Escape) {
          found = 1;
        } else
        if(Fl::event_key() == 'q'
         && Fl::event_state() == FL_CTRL) {
          exit();
          found = 1;
        } else*/
        if(Fl::event_key() == FL_F + 1) {
          make_help();
          found = 1;
        }
    break;
    }
    
    return found;
}

Fl_Double_Window *help_window=(Fl_Double_Window *)0;

Fl_Help_View *help_browser=(Fl_Help_View *)0;

Fl_Double_Window* make_help() {
  { help_window = new Fl_Double_Window(505, 410, _("Oyranos Help"));
    { help_browser = new Fl_Help_View(0, 0, 505, 410);
      help_browser->box(FL_THIN_UP_BOX);
      help_browser->color((Fl_Color)16);
      Fl_Group::current()->resizable(help_browser);
    } // Fl_Help_View* help_browser
    help_window->end();
  } // Fl_Double_Window* help_window
  help_window->show();
      const char * opts[] = {"add_html_header","1",
                             "add_oyranos_title","1",
                             "add_oyranos_copyright","1",
                             NULL};
    help_browser->value( oyDescriptionToHTML(oyGROUP_ALL, opts,0) );
  return help_window;
}
