'\"
'\" Copyright (c) 2005 Joe English
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: ttk_frame.n 43163 2011-02-09 15:07:48Z brlcad $
'\" 
.so man.macros
.TH ttk::frame n 8.5 Tk "Tk Themed Widget"
.BS
.SH NAME
ttk::frame \- Simple container widget
.SH SYNOPSIS
\fBttk::frame\fR \fIpathName \fR?\fIoptions\fR?
.BE
.SH DESCRIPTION
.PP
A \fBttk::frame\fR widget is a container, used to group other widgets
together.
.SO ttk_widget
\-class	\-cursor	\-takefocus
\-style
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-borderwidth borderWidth BorderWidth
The desired width of the widget border.  Defaults to 0. 
.OP \-relief relief Relief
One of the standard Tk border styles: 
\fBflat\fR, \fBgroove\fR, \fBraised\fR, \fBridge\fR,
\fBsolid\fR, or \fBsunken\fR.
Defaults to \fBflat\fR.
.OP \-padding padding Padding
Additional padding to include inside the border.
.OP \-width width Width
If specified, the widget's requested width in pixels.
.OP \-height height Height
If specified, the widget's requested height in pixels.
.SH "WIDGET COMMAND"
.PP
Supports the standard widget commands
\fBconfigure\fR, \fBcget\fR, \fBidentify\fR, \fBinstate\fR, and \fBstate\fR;
see \fIttk::widget(n)\fR.
.SH "NOTES"
.PP
Note that if the \fBpack\fR, \fBgrid\fR, or other geometry managers
are used to manage the children of the \fBframe\fR,
by the GM's requested size will normally take precedence
over the \fBframe\fR widget's \fB\-width\fR and \fB\-height\fR options.
\fBpack propagate\fR and \fBgrid propagate\fR can be used
to change this.
.SH "SEE ALSO"
ttk::widget(n), ttk::labelframe(n), frame(n)
.SH "KEYWORDS"
widget, frame, container
'\" Local Variables:
'\" mode: nroff
'\" End:
