'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 2001 Kevin B. Kenny <kennykb@acm.org>.  All rights reserved.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: list.n 33769 2009-02-14 00:28:44Z starseeker $
'\" 
.so man.macros
.TH list n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
list \- Create a list
.SH SYNOPSIS
\fBlist \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command returns a list comprised of all the \fIarg\fRs,
or an empty string if no \fIarg\fRs are specified.
Braces and backslashes get added as necessary, so that the \fBlindex\fR command
may be used on the result to re-extract the original arguments, and also
so that \fBeval\fR may be used to execute the resulting list, with
\fIarg1\fR comprising the command's name and the other \fIarg\fRs comprising
its arguments.  \fBList\fR produces slightly different results than
\fBconcat\fR:  \fBconcat\fR removes one level of grouping before forming
the list, while \fBlist\fR works directly from the original arguments.
.SH EXAMPLE
The command
.CS
\fBlist\fR a b "c d e  " "  f {g h}"
.CE
will return
.CS
\fBa b {c d e  } {  f {g h}}\fR
.CE
while \fBconcat\fR with the same arguments will return
.CS
\fBa b c d e f {g h}\fR
.CE

.SH "SEE ALSO"
lappend(n), lindex(n), linsert(n), llength(n), lrange(n),
.VS 8.5
lrepeat(n),
.VE 8.5
lreplace(n), lsearch(n), lset(n), lsort(n)

.SH KEYWORDS
element, list
