'\"
'\" Copyright (c) 1992-1999 Karl Lehenbauer & Mark Diekhans
'\" Copyright (c) 2004 Donal K. Fellows
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: lassign.n 30092 2008-01-25 22:37:10Z erikgreenwald $
'\" 
.so man.macros
.TH lassign n 8.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
lassign \- Assign list elements to variables
.SH SYNOPSIS
\fBlassign \fIlist varName \fR?\fIvarName ...\fR?
.BE

.SH DESCRIPTION
.PP
This command treats the value \fIlist\fR as a list and assigns
successive elements from that list to the variables given by the
\fIvarName\fR arguments in order.  If there are more variable names
than list elements, the remaining variables are set to the empty
string.  If there are more list elements than variables, a list of
unassigned elements is returned.
.SH EXAMPLES
An illustration of how multiple assignment works, and what happens
when there are either too few or too many elements.
.CS
lassign {a b c} x y z       ;# Empty return
puts $x                     ;# Prints "a"
puts $y                     ;# Prints "b"
puts $z                     ;# Prints "c"

lassign {d e} x y z         ;# Empty return
puts $x                     ;# Prints "d"
puts $y                     ;# Prints "e"
puts $z                     ;# Prints ""

lassign {f g h i} x y       ;# Returns "h i"
puts $x                     ;# Prints "f"
puts $y                     ;# Prints "g"
.CE
The \fBlassign\fR command has other uses.  It can be used to create
the analogue of the
.QW shift
command in many shell languages like this:
.CS
set ::argv [lassign $::argv argumentToReadOff]
.CE
.SH "SEE ALSO"
lindex(n), list(n), lset(n), set(n)

.SH KEYWORDS
assign, element, list, multiple, set, variable
