/*                          R A N D . C
 * BRL-CAD
 *
 * Copyright (c) 2004-2013 United States Government as represented by
 * the U.S. Army Research Laboratory.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this file; see the file named COPYING for more
 * information.
 */

/** @addtogroup rnd */
/** @{ */
/** @file libbn/rand.c
 *
 * @brief
 * These are our tables of random numbers.
 */

#include "common.h"

#include <stdio.h>
#include "bu.h"
#include "vmath.h"
#include "bn.h"


const float bn_rand_table[BN_RAND_TABSIZE] = {
    0.39646477f, 0.84048537f, 0.35333610f, 0.44658343f, 0.31869277f, 0.88642843f,
    0.01558285f, 0.58409022f, 0.15936863f, 0.38371587f, 0.69100437f, 0.05885891f,
    0.89985431f, 0.16354595f, 0.15907150f, 0.53306471f, 0.60414419f, 0.58269902f,
    0.26997112f, 0.39047820f, 0.29340057f, 0.74237741f, 0.29852561f, 0.07553808f,
    0.40498263f, 0.85737794f, 0.94196832f, 0.66283066f, 0.84647578f, 0.00275508f,
    0.46237925f, 0.53259602f, 0.78787662f, 0.26561223f, 0.98275226f, 0.30678513f,
    0.60085514f, 0.60871565f, 0.21243880f, 0.88589513f, 0.30465710f, 0.15185986f,
    0.33766190f, 0.38747695f, 0.64360983f, 0.75355328f, 0.60361610f, 0.53162825f,
    0.45936032f, 0.65248845f, 0.32718116f, 0.94637049f, 0.36803987f, 0.94389034f,
    0.00742826f, 0.51659995f, 0.27277095f, 0.02429916f, 0.59195450f, 0.20496351f,
    0.87769335f, 0.05936869f, 0.26084255f, 0.30282918f, 0.89149522f, 0.49819806f,
    0.71002558f, 0.28641399f, 0.86492358f, 0.67554067f, 0.45848997f, 0.95963556f,
    0.77467541f, 0.37655128f, 0.22863912f, 0.35453388f, 0.30031825f, 0.66976583f,
    0.71896657f, 0.56595451f, 0.82446531f, 0.39061191f, 0.81876631f, 0.84400846f,
    0.18046777f, 0.94339589f, 0.42488677f, 0.52066578f, 0.06564375f, 0.91350817f,
    0.88258457f, 0.76136413f, 0.39892255f, 0.68825684f, 0.76154830f, 0.40500880f,
    0.12525114f, 0.48463390f, 0.22246255f, 0.87312117f, 0.52882190f, 0.00141396f,
    0.86051381f, 0.01869740f, 0.81489194f, 0.24288402f, 0.31457184f, 0.96573252f,
    0.93556011f, 0.80943170f, 0.49210915f, 0.22013551f, 0.57635374f, 0.28902906f,
    0.32106698f, 0.26132334f, 0.17398786f, 0.00181730f, 0.04478414f, 0.24117455f,
    0.41545119f, 0.70162465f, 0.22184569f, 0.50391034f, 0.06703021f, 0.39306344f,
    0.47947653f, 0.21814221f, 0.21951128f, 0.91620319f, 0.35022175f, 0.19269394f,
    0.21123498f, 0.63368163f, 0.05356539f, 0.78341141f, 0.03067392f, 0.44409660f,
    0.17641289f, 0.93218022f, 0.90964827f, 0.47284483f, 0.87169546f, 0.69556736f,
    0.93018962f, 0.45509056f, 0.39856678f, 0.89330400f, 0.69354675f, 0.83873438f,
    0.73969914f, 0.65126955f, 0.67815424f, 0.57721232f, 0.27311828f, 0.93538805f,
    0.66193889f, 0.04741251f, 0.37303839f, 0.61819478f, 0.14862799f, 0.37730558f,
    0.64459140f, 0.02568782f, 0.84138051f, 0.07701881f, 0.74263392f, 0.25598614f,
    0.90184423f, 0.37764759f, 0.31952992f, 0.21143499f, 0.64853250f, 0.25131508f,
    0.22864432f, 0.25092218f, 0.94322116f, 0.13671508f, 0.27006077f, 0.54870719f,
    0.32402145f, 0.86508002f, 0.29670335f, 0.68005934f, 0.83314725f, 0.87630751f,
    0.64966456f, 0.07311548f, 0.89854697f, 0.25358126f, 0.61131863f, 0.84188993f,
    0.83201930f, 0.37258709f, 0.75704822f, 0.10921491f, 0.85081198f, 0.55932933f,
    0.85758046f, 0.34309698f, 0.69176960f, 0.34519729f, 0.89358465f, 0.95870788f,
    0.12173520f, 0.98154436f, 0.05502479f, 0.61477628f, 0.03812668f, 0.37647260f,
    0.52560486f, 0.28192396f, 0.56053796f, 0.60724297f, 0.81643958f, 0.44653499f,
    0.02711168f, 0.47185401f, 0.28489831f, 0.29272368f, 0.19568014f, 0.01757942f,
    0.82959923f, 0.57316544f, 0.10478060f, 0.73297648f, 0.11909752f, 0.22388840f,
    0.94725286f, 0.73905162f, 0.82135698f, 0.82613156f, 0.25097997f, 0.25649573f,
    0.33819320f, 0.38822167f, 0.52731848f, 0.26640913f, 0.40122053f, 0.87089457f,
    0.04589179f, 0.29457382f, 0.39424656f, 0.56000239f, 0.31082114f, 0.82257687f,
    0.47548149f, 0.09114359f, 0.26240109f, 0.91704409f, 0.97843590f, 0.33209335f,
    0.90207403f, 0.24063487f, 0.37316437f, 0.75228603f, 0.45782739f, 0.90062788f,
    0.42289451f, 0.56592348f, 0.97046216f, 0.35387088f, 0.43150651f, 0.17909136f,
    0.21531911f, 0.33717677f, 0.45436775f, 0.04472570f, 0.68388245f, 0.06214914f,
    0.55137528f, 0.31617124f, 0.26821790f, 0.50076599f, 0.06253696f, 0.96482654f,
    0.72957579f, 0.80631556f, 0.15197441f, 0.70501796f, 0.72995745f, 0.84256584f,
    0.61792858f, 0.95544778f, 0.47938813f, 0.52708549f, 0.02938659f, 0.60761211f,
    0.04756937f, 0.59276965f, 0.40264693f, 0.90439440f, 0.33013107f, 0.31083745f,
    0.85494474f, 0.73414953f, 0.09862653f, 0.34045859f, 0.40173949f, 0.98516706f,
    0.62959478f, 0.83196239f, 0.43711973f, 0.79122669f, 0.05946186f, 0.13513490f,
    0.54382390f, 0.93045165f, 0.88489902f, 0.38989459f, 0.41455752f, 0.85686265f,
    0.28675858f, 0.10775672f, 0.57667600f, 0.77760218f, 0.14225093f, 0.80867719f,
    0.74809422f, 0.41002486f, 0.47511577f, 0.34445954f, 0.41679885f, 0.02364775f,
    0.52581101f, 0.71789154f, 0.23602268f, 0.69486508f, 0.77995061f, 0.76275041f,
    0.12156272f, 0.37051796f, 0.92825143f, 0.76600634f, 0.28957953f, 0.98366071f,
    0.42810692f, 0.03781309f, 0.59832645f, 0.01559561f, 0.75672384f, 0.13067900f,
    0.37456716f, 0.21749617f, 0.57779700f, 0.20566339f, 0.78702094f, 0.74836919f,
    0.45533640f, 0.28526833f, 0.85022008f, 0.45000752f, 0.83501192f, 0.43024603f,
    0.33099577f, 0.95087211f, 0.24887282f, 0.35679405f, 0.41787068f, 0.49705314f,
    0.88529295f, 0.56316535f, 0.68550024f, 0.96775937f, 0.18236876f, 0.56780538f,
    0.02966464f, 0.20396187f, 0.15776493f, 0.54759438f, 0.20399063f, 0.21128662f,
    0.06729404f, 0.19309738f, 0.90152153f, 0.78204947f, 0.30258985f, 0.42200777f,
    0.98952543f, 0.79712060f, 0.38747161f, 0.18194028f, 0.22473139f, 0.73738293f,
    0.53350707f, 0.66473599f, 0.20183098f, 0.46882384f, 0.56649724f, 0.09746379f,
    0.27702369f, 0.01731167f, 0.56388407f, 0.88693968f, 0.07019007f, 0.06202093f,
    0.25330677f, 0.30706457f, 0.89663986f, 0.13407325f, 0.94770981f, 0.42945465f,
    0.07812638f, 0.78366722f, 0.44367027f, 0.42118211f, 0.70188645f, 0.18982070f,
    0.12622022f, 0.24805934f, 0.65792792f, 0.13750542f, 0.32277563f, 0.82251428f,
    0.01384098f, 0.92370735f, 0.37635347f, 0.58206852f, 0.26137310f, 0.41370918f,
    0.68769666f, 0.75372087f, 0.17132775f, 0.12920425f, 0.15899024f, 0.29275826f,
    0.85759328f, 0.27887709f, 0.68842366f, 0.83888960f, 0.81497662f, 0.04861429f,
    0.07294221f, 0.43097879f, 0.74982575f, 0.15195442f, 0.41226738f, 0.10251594f,
    0.76112259f, 0.64178617f, 0.73490959f, 0.54741372f, 0.09988188f, 0.73232412f,
    0.52882975f, 0.51947453f, 0.28649967f, 0.94732048f, 0.42613666f, 0.49429513f,
    0.70247499f, 0.25822254f, 0.81136807f, 0.88043637f, 0.00112771f, 0.10709923f,
    0.27325164f, 0.98398617f, 0.36112317f, 0.81679947f, 0.85526165f, 0.28941299f,
    0.99948609f, 0.00875904f, 0.06378548f, 0.96769399f, 0.68316238f, 0.30155620f,
    0.72542307f, 0.92358475f, 0.64901375f, 0.91576760f, 0.53612168f, 0.97667749f,
    0.23347556f, 0.41855917f, 0.58187885f, 0.78029750f, 0.20017003f, 0.90105181f,
    0.12913710f, 0.92866606f, 0.76486375f, 0.47974114f, 0.55637733f, 0.01208822f,
    0.38373625f, 0.37766509f, 0.72855173f, 0.54380673f, 0.67755567f, 0.58976557f,
    0.28276397f, 0.10782662f, 0.29873343f, 0.52877053f, 0.90501287f, 0.43730920f,
    0.95117220f, 0.23234421f, 0.51999770f, 0.61653656f, 0.18827655f, 0.97925561f,
    0.50319736f, 0.16005923f, 0.53953297f, 0.19256178f, 0.24906409f, 0.33018760f,
    0.15088122f, 0.62258310f, 0.21172293f, 0.94382294f, 0.62201213f, 0.21367579f,
    0.47367458f, 0.84272338f, 0.44118411f, 0.11902201f, 0.92041789f, 0.67426564f,
    0.16472098f, 0.78002358f, 0.70952318f, 0.18482036f, 0.77673340f, 0.21519147f,
    0.25450596f, 0.66286094f, 0.96061541f, 0.94208271f, 0.80800541f, 0.79734687f,
    0.98645123f, 0.69988945f, 0.66452100f, 0.11786686f, 0.68969624f, 0.15539494f,
    0.32768682f, 0.45121898f, 0.41156526f, 0.50746722f, 0.84627410f, 0.82489765f,
    0.56879108f, 0.69197801f, 0.14044106f, 0.84732625f, 0.70125160f, 0.20754978f,
    0.06695332f, 0.43922141f, 0.84497649f, 0.30101358f, 0.33906069f, 0.53742714f,
    0.03292710f, 0.87869117f, 0.18144436f, 0.96476526f, 0.72751967f, 0.44501378f,
    0.79927650f, 0.49539015f, 0.33107384f, 0.15359297f, 0.73721792f, 0.44891119f,
    0.35028905f, 0.61833266f, 0.94150374f, 0.13788360f, 0.75867440f, 0.04480321f,
    0.58663764f, 0.65751747f, 0.00990359f, 0.96680331f, 0.33626699f, 0.84459331f,
    0.61178133f, 0.01235191f, 0.85230017f, 0.51120210f, 0.23446091f, 0.67044493f,
    0.80213760f, 0.06027408f, 0.76044009f, 0.61856870f, 0.92402669f, 0.36177601f,
    0.20350460f, 0.32559878f, 0.55615096f, 0.87441762f, 0.94812956f, 0.03036690f,
    0.40538316f, 0.76681572f, 0.66196149f, 0.86851554f, 0.79405332f, 0.56904565f,
    0.58707982f, 0.57556754f, 0.57311427f, 0.28071644f, 0.74909981f, 0.41933082f,
    0.80136088f, 0.00111404f, 0.16827220f, 0.53737595f, 0.96463389f, 0.92216821f,
    0.09812967f, 0.79352987f, 0.32609668f, 0.84324004f, 0.04262168f, 0.37991233f,
    0.16672271f, 0.40084932f, 0.15288743f, 0.32741607f, 0.48020341f, 0.64494132f,
    0.12378731f, 0.63773727f, 0.74284151f, 0.89023276f, 0.89511602f, 0.09476246f,
    0.87901346f, 0.39630206f, 0.01325157f, 0.77360169f, 0.50697619f, 0.11875299f,
    0.07917336f, 0.55373911f, 0.07678998f, 0.77695809f, 0.15475466f, 0.41119012f,
    0.02868890f, 0.81818189f, 0.63057161f, 0.15637346f, 0.61123570f, 0.55551929f,
    0.88786545f, 0.48341520f, 0.33705686f, 0.11591437f, 0.08057005f, 0.47721493f,
    0.13099915f, 0.66802435f, 0.68941569f, 0.00186024f, 0.28043875f, 0.28696567f,
    0.78111478f, 0.97353869f, 0.14759043f, 0.34874942f, 0.46671974f, 0.34925594f,
    0.89451620f, 0.39183381f, 0.17273889f, 0.57633823f, 0.92675197f, 0.31266868f,
    0.49794719f, 0.22441621f, 0.43281549f, 0.71798237f, 0.56260682f, 0.92951971f,
    0.91421196f, 0.39609148f, 0.50271111f, 0.62784723f, 0.42192285f, 0.61555041f,
    0.71070714f, 0.24412578f, 0.87688152f, 0.25047744f, 0.36988002f, 0.56628297f,
    0.21786419f, 0.27199749f, 0.01926812f, 0.41508006f, 0.63293902f, 0.65415704f,
    0.26981691f, 0.47568941f, 0.06062798f, 0.20574399f, 0.27379098f, 0.25985808f,
    0.84287801f, 0.75766222f, 0.23469406f, 0.71481863f, 0.55056790f, 0.77546769f,
    0.69366582f, 0.48165395f, 0.83847807f, 0.11059789f, 0.80322752f, 0.86518332f,
    0.80342971f, 0.79956996f, 0.51615567f, 0.23402665f, 0.87779053f, 0.63146171f,
    0.99512074f, 0.98836098f, 0.28000438f, 0.45942571f, 0.45960435f, 0.96967357f,
    0.53161393f, 0.77654627f, 0.70570180f, 0.43782638f, 0.43191766f, 0.02038338f,
    0.19004420f, 0.59289301f, 0.13056690f, 0.04003430f, 0.59268429f, 0.30004982f,
    0.85682375f, 0.54608257f, 0.34994998f, 0.80346149f, 0.33174901f, 0.57462389f,
    0.66467700f, 0.04838776f, 0.61427891f, 0.70450838f, 0.79870563f, 0.91906587f,
    0.90011267f, 0.16049770f, 0.07501304f, 0.53333152f, 0.71782816f, 0.96830335f,
    0.46142079f, 0.39409409f, 0.74205247f, 0.97017616f, 0.07466423f, 0.00396880f,
    0.58934667f, 0.99720926f, 0.58605443f, 0.71450257f, 0.07735063f, 0.57777176f,
    0.68445195f, 0.45805182f, 0.43843468f, 0.75711266f, 0.26837314f, 0.34164253f,
    0.39050042f, 0.44338766f, 0.40946091f, 0.25185489f, 0.11267285f, 0.97801954f,
    0.82009196f, 0.90234104f, 0.46356207f, 0.66688069f, 0.23750772f, 0.56604339f,
    0.95380290f, 0.88238627f, 0.92761603f, 0.87819739f, 0.36008849f, 0.14993526f,
    0.23871129f, 0.02006514f, 0.59040581f, 0.72558514f, 0.57712148f, 0.63396868f,
    0.70329103f, 0.43137116f, 0.31465760f, 0.45511417f, 0.39940817f, 0.58188493f,
    0.40628451f, 0.74308326f, 0.97149811f, 0.36783513f, 0.03334644f, 0.66450604f,
    0.57675455f, 0.98217792f, 0.48378778f, 0.21773421f, 0.82009278f, 0.52050219f,
    0.03005330f, 0.64034290f, 0.37184202f, 0.46378676f, 0.51480345f, 0.43166945f,
    0.63149750f, 0.57813972f, 0.15443478f, 0.72663540f, 0.06082055f, 0.82803596f,
    0.12397288f, 0.23570890f, 0.59340780f, 0.39786342f, 0.40065108f, 0.92158799f,
    0.66062077f, 0.91787441f, 0.17697285f, 0.00918329f, 0.61035890f, 0.27714125f,
    0.66997465f, 0.45554272f, 0.21857858f, 0.02568675f, 0.06757884f, 0.16490334f,
    0.26484245f, 0.88407773f, 0.58429941f, 0.68611608f, 0.75178376f, 0.62053331f,
    0.51920603f, 0.93093194f, 0.86157311f, 0.86773765f, 0.89415988f, 0.29835242f,
    0.55578762f, 0.94440944f, 0.72822905f, 0.06934604f, 0.31213773f, 0.54624471f,
    0.50631544f, 0.77525638f, 0.65406240f, 0.16871710f, 0.61095184f, 0.56033928f,
    0.24714263f, 0.22761744f, 0.79364983f, 0.11285600f, 0.61761327f, 0.22499263f,
    0.50691925f, 0.17943005f, 0.27910714f, 0.65678093f, 0.64408139f, 0.79398722f,
    0.84840117f, 0.12803671f, 0.93833231f, 0.32620397f, 0.78173470f, 0.80191970f,
    0.65537508f, 0.10627944f, 0.69074281f, 0.59494370f, 0.92864953f, 0.42493397f,
    0.89982518f, 0.69431363f, 0.98919228f, 0.99236097f, 0.41161203f, 0.03012915f,
    0.94302675f, 0.71058484f, 0.75897544f, 0.31802531f, 0.66040998f, 0.75409221f,
    0.17377417f, 0.49430617f, 0.72906845f, 0.23812349f, 0.00534743f, 0.60928373f,
    0.45668616f, 0.09767355f, 0.61494335f, 0.10446236f, 0.20843376f, 0.50872015f,
    0.87316633f, 0.47013591f, 0.25844337f, 0.20276389f, 0.54166009f, 0.42224112f,
    0.09816068f, 0.19333972f, 0.95124378f, 0.32691462f, 0.26088813f, 0.72628485f,
    0.54834457f, 0.77973233f, 0.12514232f, 0.05238664f, 0.69970434f, 0.17129662f,
    0.48737869f, 0.91037489f, 0.07998871f, 0.16452908f, 0.53800937f, 0.29948063f,
    0.55422577f, 0.21020295f, 0.02739935f, 0.25399627f, 0.57120802f, 0.24000881f,
    0.11774320f, 0.33810484f, 0.14748690f, 0.22051884f, 0.63259469f, 0.52898741f,
    0.81488187f, 0.31214854f, 0.04166442f, 0.01178180f, 0.77614946f, 0.45558760f,
    0.66076230f, 0.27389164f, 0.64036896f, 0.57078570f, 0.76501193f, 0.25159684f,
    0.74658299f, 0.48265951f, 0.87039814f, 0.28268290f, 0.31429221f, 0.73108738f,
    0.55014797f, 0.27930268f, 0.64367509f, 0.64395311f, 0.23733366f, 0.02054776f,
    0.81614523f, 0.28009259f, 0.39549466f, 0.32990267f, 0.88445160f, 0.92871285f,
    0.79019956f, 0.34517222f, 0.28648062f, 0.89354353f, 0.89462838f, 0.19452477f,
    0.14186463f, 0.91962389f, 0.44289582f, 0.38952085f, 0.49719762f, 0.22982353f,
    0.99052801f, 0.75256173f, 0.35398875f, 0.13417099f, 0.93994345f, 0.97088491f,
    0.15145498f, 0.23067090f, 0.68079389f, 0.06146777f, 0.06999866f, 0.52000537f,
    0.32453850f, 0.43101508f, 0.18499239f, 0.26243931f, 0.47672436f, 0.50326530f,
    0.82668450f, 0.08310974f, 0.78932407f, 0.38344360f, 0.01115167f, 0.91702712f,
    0.82245722f, 0.94873009f, 0.09789368f, 0.62852837f, 0.37634165f, 0.44663951f,
    0.82864701f, 0.05819955f, 0.73995364f, 0.89338660f, 0.11417093f, 0.37565563f,
    0.75531821f, 0.67543002f, 0.69414089f, 0.74687905f, 0.68142244f, 0.04385994f,
    0.51100119f, 0.77355292f, 0.22839082f, 0.06815969f, 0.05094052f, 0.00808088f,
    0.94285300f, 0.88879444f, 0.33144257f, 0.18649060f, 0.18456602f, 0.22334871f,
    0.80063730f, 0.01252259f, 0.02064522f, 0.37546320f, 0.38256972f, 0.24588788f,
    0.45865628f, 0.94715004f, 0.80626959f, 0.13753732f, 0.97789551f, 0.93135690f,
    0.32503039f, 0.57205053f, 0.43713130f, 0.37169472f, 0.92359696f, 0.54477280f,
    0.22771783f, 0.71945435f, 0.16115116f, 0.25758243f, 0.29726726f, 0.93445346f,
    0.27133177f, 0.36625920f, 0.13804928f, 0.19654112f, 0.97941075f, 0.97407387f,
    0.46617237f, 0.39003165f, 0.47168203f, 0.32578068f, 0.51571010f, 0.75585681f,
    0.91173252f, 0.81464588f, 0.24271236f, 0.87835430f, 0.01931690f, 0.63908696f,
    0.33705804f, 0.47851562f, 0.26493030f, 0.01715658f, 0.53805493f, 0.95698606f,
    0.76987435f, 0.33433295f, 0.05839757f, 0.79255870f, 0.69877446f, 0.52635188f,
    0.85949752f, 0.42037089f, 0.77838817f, 0.71323587f, 0.46137467f, 0.14416121f,
    0.14052842f, 0.94796973f, 0.98743793f, 0.67506477f, 0.36351923f, 0.53379089f,
    0.26690813f, 0.62243055f, 0.84943780f, 0.82378338f, 0.27679276f, 0.41757404f,
    0.32523395f, 0.63698809f, 0.68577877f, 0.84739694f, 0.67453815f, 0.31379589f,
    0.15186396f, 0.37020105f, 0.70158059f, 0.16282464f, 0.66481828f, 0.33021097f,
    0.08527924f, 0.31027457f, 0.15759895f, 0.87033761f, 0.31447165f, 0.20500829f,
    0.83470948f, 0.94522718f, 0.99684706f, 0.72804066f, 0.88038525f, 0.17993617f,
    0.62488891f, 0.73909916f, 0.06873046f, 0.11556673f, 0.76069763f, 0.21640605f,
    0.15796581f, 0.48442746f, 0.09468491f, 0.92543900f, 0.12134504f, 0.80691614f,
    0.94569913f, 0.82037552f, 0.26075648f, 0.68414236f, 0.33516296f, 0.43606808f,
    0.03136254f, 0.44873334f, 0.69641195f, 0.18220942f, 0.14579246f, 0.24633508f,
    0.81187530f, 0.28393200f, 0.84646005f, 0.45769613f, 0.52241915f, 0.71916830f,
    0.45972586f, 0.58219356f, 0.77058682f, 0.74303172f, 0.75418072f, 0.12514247f,
    0.34625224f, 0.83923767f, 0.69874176f, 0.64076205f, 0.35110990f, 0.33977209f,
    0.88909188f, 0.24841571f, 0.51734057f, 0.66385747f, 0.82095555f, 0.67049021f,
    0.56372325f, 0.56861555f, 0.92660721f, 0.03544243f, 0.28554481f, 0.91515749f,
    0.65079961f, 0.38916163f, 0.91714585f, 0.93924922f, 0.07104736f, 0.49253405f,
    0.92021835f, 0.59492656f, 0.61510267f, 0.12424425f, 0.00754476f, 0.19782523f,
    0.19883383f, 0.71731799f, 0.25937293f, 0.83351979f, 0.70701056f, 0.83824376f,
    0.30481323f, 0.08143559f, 0.72728114f, 0.26186776f, 0.97840780f, 0.81913488f,
    0.08659232f, 0.33743060f, 0.70536365f, 0.76283466f, 0.24527282f, 0.00551574f,
    0.27899429f, 0.03136477f, 0.39592097f, 0.37734966f, 0.15993748f, 0.22152365f,
    0.06417676f, 0.78249634f, 0.01609090f, 0.09766092f, 0.69161364f, 0.82481149f,
    0.83044214f, 0.13766314f, 0.62567611f, 0.34648124f, 0.50469635f, 0.46731761f,
    0.87926085f, 0.51360233f, 0.78158268f, 0.54688146f, 0.13776192f, 0.12223265f,
    0.37783116f, 0.75481451f, 0.67187032f, 0.93993968f, 0.17106400f, 0.41689789f,
    0.90095430f, 0.59401434f, 0.90337106f, 0.04283122f, 0.38839579f, 0.48373914f,
    0.26639679f, 0.51098156f, 0.53388900f, 0.11106455f, 0.10973833f, 0.65497409f,
    0.35861673f, 0.41304702f, 0.38684881f, 0.38861834f, 0.71072661f, 0.35234868f,
    0.91908994f, 0.90923215f, 0.30708016f, 0.53153287f, 0.04584024f, 0.16035961f,
    0.08241219f, 0.68597392f, 0.24152430f, 0.14540544f, 0.85151099f, 0.96272446f,
    0.15209020f, 0.66167826f, 0.76963298f, 0.18306187f, 0.64496103f, 0.88322602f,
    0.17004280f, 0.22970732f, 0.11707908f, 0.03975910f, 0.18739250f, 0.10153946f,
    0.78273129f, 0.31261781f, 0.96681610f, 0.48529984f, 0.11189916f, 0.35750204f,
    0.98943970f, 0.24222239f, 0.23454868f, 0.44351865f, 0.09693648f, 0.47525380f,
    0.51832390f, 0.71061832f, 0.60536174f, 0.69772938f, 0.79641372f, 0.14991409f,
    0.59948054f, 0.57581969f, 0.82693393f, 0.52655141f, 0.18396973f, 0.16417968f,
    0.54113774f, 0.03120916f, 0.43118240f, 0.03705477f, 0.84939584f, 0.16805586f,
    0.75367692f, 0.16629029f, 0.16355482f, 0.48379094f, 0.89362949f, 0.38454127f,
    0.13249740f, 0.69961885f, 0.06388892f, 0.25840339f, 0.22312307f, 0.62661127f,
    0.60324095f, 0.78472088f, 0.88830085f, 0.69151093f, 0.88099625f, 0.50713854f,
    0.90149956f, 0.75684538f, 0.86599794f, 0.06284109f, 0.58778359f, 0.23410381f,
    0.47837951f, 0.33577834f, 0.80380595f, 0.82515916f, 0.48783997f, 0.97754757f,
    0.60459354f, 0.91419468f, 0.68190788f, 0.11616024f, 0.14968469f, 0.01484386f,
    0.37683694f, 0.30244626f, 0.94105415f, 0.36542821f, 0.11073204f, 0.73076121f,
    0.42387834f, 0.88505394f, 0.77469184f, 0.24249763f, 0.12031183f, 0.14650880f,
    0.18774278f, 0.69582623f, 0.18594764f, 0.69561026f, 0.59282427f, 0.72189474f,
    0.78652647f, 0.12374727f, 0.08488700f, 0.33580533f, 0.27487649f, 0.46930717f,
    0.12223051f, 0.12011581f, 0.41926361f, 0.23858772f, 0.01560299f, 0.93002825f,
    0.08669509f, 0.06738898f, 0.33651073f, 0.10413094f, 0.83875428f, 0.52611200f,
    0.18995741f, 0.71445975f, 0.95188495f, 0.05483756f, 0.11389985f, 0.30728189f,
    0.85544678f, 0.51712048f, 0.30763636f, 0.11454252f, 0.89421276f, 0.41433937f,
    0.96683330f, 0.73914275f, 0.50028227f, 0.70423969f, 0.67976363f, 0.60954897f,
    0.21377238f, 0.23127718f, 0.28652452f, 0.97570832f, 0.76138373f, 0.58160878f,
    0.94258919f, 0.18452705f, 0.40439755f, 0.31681769f, 0.68522652f, 0.37554639f,
    0.64835593f, 0.87804841f, 0.85441157f, 0.41283934f, 0.88924031f, 0.36214337f,
    0.75029458f, 0.79508875f, 0.70715172f, 0.99521715f, 0.85166791f, 0.83045884f,
    0.93819323f, 0.62410306f, 0.41186321f, 0.53502520f, 0.81646770f, 0.33511208f,
    0.88094574f, 0.41259867f, 0.91696616f, 0.33103261f, 0.16989513f, 0.53980369f,
    0.21089029f, 0.15537184f, 0.52074117f, 0.64391736f, 0.71001110f, 0.96722336f,
    0.62655582f, 0.19352873f, 0.19652090f, 0.82619206f, 0.56010807f, 0.88545505f,
    0.75812174f, 0.34549266f, 0.12631225f, 0.40808958f, 0.95156690f, 0.87926432f,
    0.01091339f, 0.48462036f, 0.65641666f, 0.90953759f, 0.81884974f, 0.08313831f,
    0.13739252f, 0.03700178f, 0.99623409f, 0.34896134f, 0.66954850f, 0.02122909f,
    0.12884641f, 0.43257745f, 0.78478221f, 0.48941593f, 0.07950125f, 0.51011847f,
    0.83836371f, 0.08273074f, 0.44183966f, 0.11850539f, 0.06567619f, 0.04636041f,
    0.37731752f, 0.54127132f, 0.57587074f, 0.21930263f, 0.79686471f, 0.61110745f,
    0.11239614f, 0.43445976f, 0.23344420f, 0.55955468f, 0.78025702f, 0.90587759f,
    0.51424044f, 0.70176886f, 0.00438665f, 0.93089201f, 0.32227454f, 0.94433412f,
    0.52882808f, 0.35897344f, 0.98082307f, 0.63672559f, 0.40675592f, 0.73029611f,
    0.79718033f, 0.83289500f, 0.35912491f, 0.73523154f, 0.26524352f, 0.90985766f,
    0.11540680f, 0.92642634f, 0.50243902f, 0.91701275f, 0.99210843f, 0.17884858f,
    0.84208972f, 0.35576873f, 0.94030752f, 0.75677768f, 0.32701883f, 0.05703666f,
    0.10718289f, 0.54239482f, 0.46669026f, 0.81808486f, 0.94145871f, 0.80625755f,
    0.49432001f, 0.75453334f, 0.43996266f, 0.16898902f, 0.16110126f, 0.33294432f,
    0.02137160f, 0.19508086f, 0.95404022f, 0.58019988f, 0.04106973f, 0.46852629f,
    0.34709349f, 0.46393951f, 0.27337984f, 0.38641706f, 0.07065264f, 0.24067118f,
    0.00788229f, 0.14663229f, 0.39338238f, 0.15231094f, 0.28686524f, 0.14091922f,
    0.48755575f, 0.08600964f, 0.38103706f, 0.85224310f, 0.23203833f, 0.20498248f,
    0.81848563f, 0.31811682f, 0.38677373f, 0.50907972f, 0.18362144f, 0.69818721f,
    0.24296072f, 0.33306600f, 0.85275074f, 0.67875562f, 0.36115710f, 0.86867365f,
    0.77337390f, 0.57887241f, 0.30549375f, 0.47475260f, 0.09579983f, 0.57751925f,
    0.76935336f, 0.28016905f, 0.77684416f, 0.46015672f, 0.77270791f, 0.98904684f,
    0.37299274f, 0.45216906f, 0.75338760f, 0.86066275f, 0.87934727f, 0.84870953f,
    0.13656602f, 0.19058923f, 0.23393366f, 0.31299008f, 0.06451366f, 0.78993980f,
    0.65567868f, 0.46164525f, 0.32113817f, 0.61085142f, 0.30780485f, 0.01553258f,
    0.46506638f, 0.85429998f, 0.44394019f, 0.71193856f, 0.86622522f, 0.31727764f,
    0.59739528f, 0.95999038f, 0.75236607f, 0.97717895f, 0.98845944f, 0.00110685f,
    0.74519566f, 0.59948487f, 0.95196711f, 0.00215843f, 0.38529653f, 0.60866461f,
    0.20766827f, 0.96787199f, 0.19853626f, 0.34042337f, 0.41711054f, 0.78376394f,
    0.28499823f, 0.74542367f, 0.97893854f, 0.77999021f, 0.75856188f, 0.43043826f,
    0.02399550f, 0.39406678f, 0.62818864f, 0.78321739f, 0.27475616f, 0.27616528f,
    0.59092547f, 0.65346187f, 0.85093651f, 0.25997639f, 0.35494196f, 0.36609947f,
    0.33324756f, 0.26593693f, 0.38501432f, 0.57710566f, 0.86694471f, 0.42853425f,
    0.67233089f, 0.88955319f, 0.80095512f, 0.57766286f, 0.28801410f, 0.11220959f,
    0.14994893f, 0.95346215f, 0.05115330f, 0.33923894f, 0.94689118f, 0.50818931f,
    0.79636759f, 0.57244585f, 0.56162556f, 0.92657841f, 0.08503698f, 0.70268735f,
    0.11428299f, 0.17253175f, 0.09354997f, 0.26086290f, 0.85628473f, 0.80523556f,
    0.10953611f, 0.27818728f, 0.55005375f, 0.87786380f, 0.05452842f, 0.83779496f,
    0.50301807f, 0.07853461f, 0.66340314f, 0.82328198f, 0.63196771f, 0.05333895f,
    0.02496850f, 0.98335094f, 0.20832115f, 0.98792252f, 0.71504034f, 0.63470091f,
    0.29950013f, 0.45574646f, 0.52719557f, 0.15773614f, 0.24066173f, 0.97188136f,
    0.07420548f, 0.33221847f, 0.18687574f, 0.34072899f, 0.24511444f, 0.58394877f,
    0.17897235f, 0.73976862f, 0.56236628f, 0.33084542f, 0.55535200f, 0.04026661f,
    0.99673609f, 0.92993273f, 0.63380399f, 0.39647042f, 0.32466895f, 0.72892237f,
    0.62670658f, 0.91935778f, 0.91565539f, 0.55105699f, 0.82288511f, 0.83738029f,
    0.13230596f, 0.61409905f, 0.33102089f, 0.99830501f, 0.73176906f, 0.56883094f,
    0.62208830f, 0.71231805f, 0.64613903f, 0.59484706f, 0.79923468f, 0.62173911f,
    0.86671859f, 0.50805419f, 0.85831456f, 0.61735511f, 0.39075307f, 0.70206796f,
    0.15457926f, 0.43149269f, 0.04098807f, 0.69213851f, 0.16256298f, 0.81511340f,
    0.62268765f, 0.67352228f, 0.28687992f, 0.55765997f, 0.22728199f, 0.10512828f,
    0.65946148f, 0.70695750f, 0.36741255f, 0.03321968f, 0.32985075f, 0.38065681f,
    0.07875382f, 0.96898541f, 0.13379212f, 0.48460052f, 0.64668432f, 0.30857389f,
    0.50388801f, 0.43682097f, 0.41085104f, 0.85599317f, 0.08505214f, 0.87399606f,
    0.32124118f, 0.19004074f, 0.83550096f, 0.04106973f, 0.92198789f, 0.75867300f,
    0.25784983f, 0.65099019f, 0.03336388f, 0.43112107f, 0.01940191f, 0.98235807f,
    0.10095235f, 0.17339695f, 0.81894218f, 0.65605885f, 0.44965030f, 0.81102496f,
    0.35040995f, 0.21115750f, 0.18789907f, 0.91891778f, 0.34097893f, 0.36455768f,
    0.37642212f, 0.53795720f, 0.21970575f, 0.78290199f, 0.13097548f, 0.10732775f,
    0.14852556f, 0.67926283f, 0.34850206f, 0.05789852f, 0.14360772f, 0.44732418f,
    0.71207344f, 0.41249598f, 0.38369556f, 0.50358289f, 0.97667044f, 0.35192068f,
    0.67292223f, 0.18083142f, 0.40289416f, 0.53982370f, 0.35673004f, 0.82667366f,
    0.67993037f, 0.45448807f, 0.81705398f, 0.64754801f, 0.05645953f, 0.59119537f,
    0.36112078f, 0.50578894f, 0.42578084f, 0.10586197f, 0.80944494f, 0.04437628f,
    0.23939812f, 0.84029307f, 0.15338027f, 0.66655224f, 0.75501772f, 0.16363826f,
    0.13954332f, 0.03640591f, 0.86677965f, 0.28598036f, 0.72432050f, 0.65843566f,
    0.67715250f, 0.64161301f, 0.78138684f, 0.52122744f, 0.81396682f, 0.23525096f,
    0.82170979f, 0.80058409f, 0.98835937f, 0.01858467f, 0.46001722f, 0.77418237f,
    0.34889885f, 0.08227679f, 0.92343489f, 0.73222398f, 0.18593124f, 0.76536543f,
    0.61432600f, 0.12130894f, 0.55341636f, 0.39637870f, 0.00580329f, 0.04224794f,
    0.43154582f, 0.87518874f, 0.43856396f, 0.66271913f, 0.38368254f, 0.40928257f,
    0.50337870f, 0.99416772f, 0.95021297f, 0.55086359f, 0.01463005f, 0.72636909f,
    0.65745074f, 0.00081230f, 0.31475020f, 0.58547970f, 0.84259510f, 0.10144061f,
    0.08338780f, 0.67066174f, 0.04987421f, 0.32221045f, 0.57289357f, 0.88458883f,
    0.53546253f, 0.53181886f, 0.44564044f, 0.37404670f, 0.12974876f, 0.26756614f,
    0.16929104f, 0.57378808f, 0.99836600f, 0.27063637f, 0.33202868f, 0.25075950f,
    0.57452442f, 0.10636918f, 0.69773359f, 0.89339249f, 0.41417913f, 0.97495142f,
    0.33599781f, 0.91406857f, 0.96511787f, 0.72399812f, 0.56673759f, 0.72997817f,
    0.20698347f, 0.37463587f, 0.66511363f, 0.67187469f, 0.98050220f, 0.08198928f,
    0.51876553f, 0.42077819f, 0.20283958f, 0.67506557f, 0.53338976f, 0.88423472f,
    0.38724614f, 0.70622265f, 0.68994838f, 0.95663912f, 0.22730750f, 0.12360727f,
    0.49092116f, 0.83835762f, 0.95062040f, 0.23869974f, 0.64576479f, 0.65754310f,
    0.62815059f, 0.96356518f, 0.36700222f, 0.20384731f, 0.28158357f, 0.34737755f,
    0.53614047f, 0.06755230f, 0.05247672f, 0.14866479f, 0.28903988f, 0.31944371f,
    0.67790589f, 0.57856175f, 0.62768840f, 0.77013400f, 0.30464148f, 0.87181519f,
    0.93195563f, 0.53223975f, 0.21788411f, 0.05765129f, 0.99131898f, 0.06017602f,
    0.26455795f, 0.17380561f, 0.75140265f, 0.56132862f, 0.72154615f, 0.29656591f,
    0.05020634f, 0.92560398f, 0.65562838f, 0.64075559f, 0.45900735f, 0.39006217f,
    0.70693959f, 0.74997666f, 0.02610552f, 0.58936327f, 0.91733292f, 0.47355250f,
    0.40897745f, 0.50457804f, 0.13804328f, 0.17749904f, 0.06127244f, 0.94163021f,
    0.55958132f, 0.01817415f, 0.88280129f, 0.39097941f, 0.58603669f, 0.31529723f,
    0.93874684f, 0.55246857f, 0.15425351f, 0.18270817f, 0.48239620f, 0.07952807f,
    0.40710687f, 0.83808682f, 0.87551600f, 0.59674891f, 0.55392539f, 0.03504402f,
    0.97194628f, 0.18143794f, 0.67766843f, 0.10131283f, 0.82108480f, 0.94600016f,
    0.01859663f, 0.27462766f, 0.94480291f, 0.30233267f, 0.92181684f, 0.69331861f,
    0.05823558f, 0.88596393f, 0.67830721f, 0.20233253f, 0.63420421f, 0.93615781f,
    0.11603123f, 0.39861027f, 0.67326915f, 0.40397403f, 0.16285015f, 0.27441518f,
    0.03520218f, 0.94431420f, 0.06258755f, 0.77586065f, 0.63977594f, 0.75688511f,
    0.28935800f, 0.31968745f, 0.26006937f, 0.50700603f, 0.98583888f, 0.18808550f,
    0.84299415f, 0.07812566f, 0.41436091f, 0.02345137f, 0.71058959f, 0.99727363f,
    0.12446444f, 0.78746386f, 0.36106969f, 0.11155264f, 0.42898452f, 0.33740698f,
    0.21802004f, 0.57290743f, 0.16798465f, 0.65356366f, 0.71504037f, 0.77013605f,
    0.40427630f, 0.06165743f, 0.77514496f, 0.40741624f, 0.61728445f, 0.01127253f,
    0.60112461f, 0.10910375f, 0.57821900f, 0.96309956f, 0.86472382f, 0.38844948f,
    0.53658283f, 0.21352301f, 0.82690294f, 0.47602811f, 0.71681049f, 0.44390239f,
    0.67476991f, 0.80054953f, 0.70823144f, 0.96394017f, 0.78723809f, 0.05443785f,
    0.87865947f, 0.95444005f, 0.68347773f, 0.97883715f, 0.90192083f, 0.07582916f,
    0.83628749f, 0.75288972f, 0.26586664f, 0.05695956f, 0.19525090f, 0.17120912f,
    0.82631786f, 0.91645865f, 0.33871985f, 0.40803659f, 0.15353169f, 0.28942814f,
    0.41416447f, 0.87885413f, 0.34385331f, 0.56938583f, 0.01625497f, 0.56807972f,
    0.85604628f, 0.75341863f, 0.55232899f, 0.75836933f, 0.69832404f, 0.66260711f,
    0.44490425f, 0.70209484f, 0.31040385f, 0.65555568f, 0.28800599f, 0.76348664f,
    0.83016930f, 0.75660831f, 0.20379669f, 0.54107301f, 0.13507721f, 0.86895963f,
    0.61195760f, 0.58039434f, 0.33572608f, 0.16392659f, 0.22823332f, 0.39811898f,
    0.95758536f, 0.94928874f, 0.73039579f, 0.56786612f, 0.26446383f, 0.08062597f,
    0.37762072f, 0.73810111f, 0.39469104f, 0.93939481f, 0.22902952f, 0.35188639f,
    0.74214395f, 0.95012693f, 0.09319190f, 0.97114877f, 0.31624107f, 0.72727100f,
    0.14509092f, 0.94418697f, 0.35804516f, 0.05112000f, 0.29093107f, 0.42974436f,
    0.92698174f, 0.68388500f, 0.94285437f, 0.75508718f, 0.36084068f, 0.40383196f,
    0.31187609f, 0.75575897f, 0.76025188f, 0.80065454f, 0.64304524f, 0.15325564f,
    0.97040890f, 0.22270266f, 0.83498072f, 0.47163203f, 0.89327637f, 0.57073643f,
    0.51766784f, 0.28848874f, 0.53180422f, 0.30856932f, 0.14697621f, 0.33899699f,
    0.56585343f, 0.41396431f, 0.82916494f, 0.73832739f, 0.81281029f, 0.96974427f,
    0.05917982f, 0.21840658f, 0.91254925f, 0.53218439f, 0.06645393f, 0.16531006f,
    0.47794297f, 0.28891123f, 0.06295557f, 0.53541282f, 0.70308362f, 0.69990253f,
    0.01026776f, 0.57888682f, 0.65946586f, 0.81155424f, 0.02354035f, 0.13110837f,
    0.82641089f, 0.64456998f, 0.74636133f, 0.98449562f, 0.58992637f, 0.02167233f,
    0.82620632f, 0.22933757f, 0.75107065f, 0.35149935f, 0.43752698f, 0.17202851f,
    0.46091576f, 0.29182233f, 0.90923845f, 0.48813696f, 0.34770286f, 0.84031617f,
    0.26399543f, 0.14689222f, 0.02920177f, 0.34707090f, 0.54496359f, 0.61956665f,
    0.26919258f, 0.70301586f, 0.44668159f, 0.23909403f, 0.00407794f, 0.66622638f,
    0.06307568f, 0.85994542f, 0.54972977f, 0.96810940f, 0.67886697f, 0.23926025f,
    0.91871877f, 0.65875971f, 0.94975913f, 0.65160416f, 0.20613966f, 0.66100585f,
    0.60929384f, 0.00522157f, 0.01352552f, 0.90211290f, 0.90162043f, 0.25762367f,
    0.40315991f, 0.76769302f, 0.24327867f, 0.85877565f, 0.64089239f, 0.20163279f,
    0.46519584f, 0.67262439f, 0.17891084f, 0.17694250f, 0.25833530f, 0.74946432f,
    0.83851853f, 0.74415649f, 0.85081077f, 0.11552736f, 0.81762537f, 0.57567877f,
    0.26693121f, 0.60067890f, 0.01233623f, 0.15631428f, 0.87382427f, 0.59430703f,
    0.70377557f, 0.20281627f, 0.00138292f, 0.47313408f, 0.12032132f, 0.84990472f,
    0.74679998f, 0.51810834f, 0.89505329f, 0.82878266f, 0.24452955f, 0.18172719f,
    0.35489688f, 0.63923570f, 0.62290247f, 0.09870198f, 0.71123217f, 0.32111017f,
    0.08470608f, 0.78402612f, 0.08433680f, 0.24911436f, 0.37382601f, 0.33110304f,
    0.35175922f, 0.68089127f, 0.73467109f, 0.92210611f, 0.73252090f, 0.99720778f,
    0.07482037f, 0.67228038f, 0.92699402f, 0.49055883f, 0.72152609f, 0.34418167f,
    0.35158891f, 0.63078540f, 0.06488613f, 0.14723501f, 0.31633401f, 0.30036503f,
    0.72829681f, 0.05845699f, 0.87348552f, 0.02539326f, 0.25196998f, 0.50332778f,
    0.95103492f, 0.59909741f, 0.74772927f, 0.47884426f, 0.41408444f, 0.21179913f,
    0.54099793f, 0.20658793f, 0.96035529f, 0.66398440f, 0.49498658f, 0.61067629f,
    0.54752438f, 0.98758676f, 0.87684259f, 0.52783592f, 0.11672464f, 0.76540677f,
    0.21831488f, 0.79426615f, 0.16858546f, 0.19106641f, 0.41482809f, 0.70180519f,
    0.66895505f, 0.91394555f, 0.14538004f, 0.77514315f, 0.41737956f, 0.56770803f,
    0.75813436f, 0.15904930f, 0.46208621f, 0.58046103f, 0.80785918f, 0.90202113f,
    0.15332375f, 0.04309245f, 0.03447005f, 0.12827243f, 0.70827435f, 0.59431141f,
    0.39800417f, 0.06703147f, 0.63431108f, 0.13141487f, 0.82364136f, 0.48582269f,
    0.39520588f, 0.73048386f, 0.12827687f, 0.59747988f, 0.38218825f, 0.15486439f,
    0.59315178f, 0.58943926f, 0.59683647f, 0.33332472f, 0.28878887f, 0.68436264f,
    0.69709523f, 0.92674187f, 0.35072549f, 0.97494610f, 0.88582730f, 0.69271971f,
    0.32716111f, 0.09010421f, 0.92091697f, 0.55996787f, 0.68065513f, 0.21743633f,
    0.63786980f, 0.78798902f, 0.81155176f, 0.81645532f, 0.34404285f, 0.10267134f,
    0.19513239f, 0.96259308f, 0.26516098f, 0.44542620f, 0.57998340f, 0.13321638f,
    0.59982457f, 0.77383876f, 0.70222766f, 0.11914411f, 0.31961169f, 0.91732398f,
    0.72773347f, 0.86942841f, 0.49756895f, 0.67454255f, 0.06894273f, 0.47004901f,
    0.96594027f, 0.38349396f, 0.33943464f, 0.15089975f, 0.50759678f, 0.98405657f,
    0.84076861f, 0.50786957f, 0.54062452f, 0.90070138f, 0.03366471f, 0.83141347f,
    0.53084483f, 0.81520570f, 0.16843795f, 0.12887521f, 0.78475530f, 0.88110020f,
    0.45518844f, 0.70968712f, 0.16068297f, 0.09958544f, 0.48806982f, 0.93078700f,
    0.86715515f, 0.26766775f, 0.82364627f, 0.25013288f, 0.37606389f, 0.10082662f,
    0.70266187f, 0.25066555f, 0.49869588f, 0.19280217f, 0.52736817f, 0.93269276f,
    0.49281815f, 0.41286925f, 0.32089329f, 0.75229927f, 0.27956918f, 0.05566025f,
    0.53712326f, 0.54550001f, 0.24385260f, 0.59024878f, 0.12345935f, 0.32655143f,
    0.91833481f, 0.63447686f, 0.10699877f, 0.70384469f, 0.05920560f, 0.87868694f,
    0.44766627f, 0.30347571f, 0.11489109f, 0.06202175f, 0.82823492f, 0.62989753f,
    0.97335763f, 0.86681851f, 0.10777320f, 0.49161164f, 0.70908275f, 0.23551309f,
    0.60672474f, 0.75987321f, 0.09989137f, 0.26367431f, 0.30157532f, 0.35772294f,
    0.16248163f, 0.50672150f, 0.54602107f, 0.05879029f, 0.28254053f, 0.42157995f,
    0.59298071f, 0.73934319f, 0.56294588f, 0.30366231f, 0.03507543f, 0.01771209f,
    0.35686198f, 0.67041865f, 0.20584056f, 0.84284487f, 0.11988366f, 0.67218765f,
    0.56356658f, 0.18432884f, 0.43821122f, 0.00674587f, 0.41605092f, 0.92134950f,
    0.55271774f, 0.59395440f, 0.91755903f, 0.73496854f, 0.78939640f, 0.19003227f,
    0.78695134f, 0.94964802f, 0.86586766f, 0.33665778f, 0.44436511f, 0.03459996f,
    0.11533141f, 0.83835059f, 0.35730399f, 0.81740206f, 0.75063630f, 0.02308454f,
    0.01786634f, 0.35111835f, 0.58220386f, 0.68711139f, 0.66164455f, 0.04724864f,
    0.25770826f, 0.06745381f, 0.18418331f, 0.89118043f, 0.46511939f, 0.77699125f,
    0.63955381f, 0.81103190f, 0.44353764f, 0.12067766f, 0.72246568f, 0.10708233f,
    0.09087837f, 0.97098644f, 0.07340694f, 0.06523760f, 0.40972294f, 0.69058746f,
    0.51670676f, 0.78765022f, 0.66148728f, 0.86556383f, 0.18341522f, 0.95580709f,
    0.52653754f, 0.65883644f, 0.20187022f, 0.79084036f, 0.61920148f, 0.85717020f,
    0.40428252f, 0.25285955f, 0.66010414f, 0.50310245f, 0.52124889f, 0.40172148f,
    0.44534206f, 0.85289989f, 0.16955704f, 0.46745253f, 0.90727202f, 0.15137941f,
    0.71185881f, 0.20673931f, 0.17282442f, 0.87290987f, 0.73776642f, 0.47536244f,
    0.68307623f, 0.04455988f, 0.52080416f, 0.06363940f, 0.43628161f, 0.58221055f,
    0.70868204f, 0.92696831f, 0.00272832f, 0.16417507f, 0.64793179f, 0.21615101f,
    0.58386089f, 0.61074942f, 0.89856647f, 0.45767367f, 0.45340821f, 0.49407289f,
    0.50872672f, 0.85351140f, 0.23121707f, 0.37324385f, 0.67001538f, 0.72990276f,
    0.66069740f, 0.62797860f, 0.21628282f, 0.44713658f, 0.65092174f, 0.98400849f,
    0.64501364f, 0.63555922f, 0.02031386f, 0.00929679f, 0.59231579f, 0.01022071f,
    0.55945264f, 0.77706162f, 0.96908244f, 0.56693662f, 0.08787933f, 0.59517717f,
    0.83456816f, 0.02077345f, 0.18912276f, 0.88808394f, 0.93990270f, 0.52442191f,
    0.29777014f, 0.57378119f, 0.19158909f, 0.12458072f, 0.01375421f, 0.33234240f,
    0.86555754f, 0.97093450f, 0.61667268f, 0.13185021f, 0.62575445f, 0.89180105f,
    0.13459692f, 0.02148055f, 0.47554430f, 0.76589505f, 0.32828543f, 0.16909003f,
    0.98152539f, 0.83938627f, 0.12693798f, 0.20211634f, 0.07196474f, 0.21561980f,
    0.39267931f, 0.28655092f, 0.61832650f, 0.65124178f, 0.09804221f, 0.87047680f,
    0.87880966f, 0.26238775f, 0.72714869f, 0.33809599f, 0.81605767f, 0.02901823f,
    0.81351039f, 0.81983860f, 0.72401183f, 0.10102948f, 0.31495573f, 0.32721513f,
    0.51613604f, 0.88865318f, 0.01183643f, 0.11133231f, 0.27194933f, 0.05973819f,
    0.26419079f, 0.45585551f, 0.12209796f, 0.68125743f, 0.44589051f, 0.92370725f,
    0.51333894f, 0.41090484f, 0.81104227f, 0.68760397f, 0.15117297f, 0.46166782f,
    0.76525005f, 0.93394293f, 0.11496696f, 0.88813101f, 0.79008934f, 0.27447053f,
    0.50187519f, 0.95396444f, 0.08474622f, 0.60813218f, 0.53346299f, 0.07717461f,
    0.27880135f, 0.31468634f, 0.98254009f, 0.27047696f, 0.97228850f, 0.04084992f,
    0.50532963f, 0.52143510f, 0.96424822f, 0.55834341f, 0.53186723f, 0.12928126f,
    0.63297547f, 0.27126104f, 0.63969912f, 0.33668652f, 0.27709607f, 0.35836771f,
    0.25491284f, 0.38491428f, 0.26669517f, 0.32550927f, 0.36079575f, 0.36511807f,
    0.49128306f, 0.87623104f, 0.99660848f, 0.43801121f, 0.93286371f, 0.58746863f,
    0.37384043f, 0.41534371f, 0.79734039f, 0.39497126f, 0.67976503f, 0.62179610f,
    0.76864614f, 0.48372765f, 0.16114198f, 0.93289364f, 0.82314392f, 0.86650463f,
    0.04565417f, 0.97683336f, 0.07594888f, 0.88371585f, 0.75437729f, 0.52480218f,
    0.19795215f, 0.62587778f, 0.75264199f, 0.92017403f, 0.61766826f, 0.06217101f,
    0.17457026f, 0.12225818f, 0.53390645f, 0.54202126f, 0.01198264f, 0.19100763f,
    0.44512524f, 0.54868460f, 0.48303749f, 0.20688546f, 0.63374014f, 0.74273044f,
    0.06976231f, 0.11215656f, 0.71631144f, 0.69785226f, 0.34457628f, 0.44907262f,
    0.82426273f, 0.45101351f, 0.88011689f, 0.64522688f, 0.25851709f, 0.35359473f,
    0.36842835f, 0.31087286f, 0.06225657f, 0.40061083f, 0.25722948f, 0.93695573f,
    0.07910673f, 0.55250415f, 0.26306064f, 0.65134612f, 0.86274307f, 0.76040336f,
    0.64224656f, 0.05527222f, 0.63465387f, 0.81360946f, 0.01756218f, 0.13881754f,
    0.15914602f, 0.49059240f, 0.37613461f, 0.39581518f, 0.43134116f, 0.19574371f,
    0.90546394f, 0.32237752f, 0.92070005f, 0.57794676f, 0.03063173f, 0.80312781f,
    0.44847771f, 0.96873535f, 0.09604634f, 0.54405053f, 0.72452231f, 0.65307756f,
    0.91683153f, 0.79547570f, 0.95218087f, 0.44093434f, 0.05370701f, 0.48341108f,
    0.50808599f, 0.07961491f, 0.36456962f, 0.40821134f, 0.49771478f, 0.21312319f,
    0.70771900f, 0.01802712f, 0.41240443f, 0.72332481f, 0.74566548f, 0.07783475f,
    0.30667350f, 0.88765206f, 0.58271763f, 0.25596251f, 0.96705511f, 0.25861868f,
    0.50020562f, 0.67737653f, 0.74914168f, 0.05167603f, 0.69451201f, 0.05067172f,
    0.86524277f, 0.05057197f, 0.61743668f, 0.28345598f, 0.36116131f, 0.17466187f,
    0.03632483f, 0.04397176f, 0.23042168f, 0.36248230f, 0.12146970f, 0.50634381f,
    0.68427804f, 0.91287052f, 0.90732209f, 0.29937753f, 0.58556695f, 0.88216188f,
    0.11688003f, 0.24658516f, 0.22663618f, 0.19731068f, 0.16830221f, 0.88593867f,
    0.70200537f, 0.33457263f, 0.86041968f, 0.55521554f, 0.01403669f, 0.39669796f,
    0.74867152f, 0.35181729f, 0.12678652f, 0.25407686f, 0.14244217f, 0.86932867f,
    0.52456770f, 0.79324301f, 0.37434139f, 0.88719778f, 0.46589506f, 0.82649027f,
    0.98527239f, 0.27073185f, 0.28186258f, 0.58663122f, 0.53793964f, 0.11772120f,
    0.43517569f, 0.07928799f, 0.29563707f, 0.57265089f, 0.01973573f, 0.65034563f,
    0.19073691f, 0.89248855f, 0.28166232f, 0.59772870f, 0.64440408f, 0.97792355f,
    0.12489173f, 0.30452369f, 0.49994647f, 0.13477852f, 0.42507341f, 0.37532567f,
    0.78926164f, 0.77184657f, 0.01459860f, 0.44082754f, 0.28556373f, 0.80897727f,
    0.07255588f, 0.36900776f, 0.90460144f, 0.01381822f, 0.21266146f, 0.43734677f,
    0.42766950f, 0.32381884f, 0.11933000f, 0.82247758f, 0.73775231f, 0.47414474f,
    0.14972808f, 0.43534136f, 0.61812880f, 0.23988686f, 0.86370833f, 0.44568770f,
    0.07184413f, 0.12585575f, 0.13290306f, 0.71467184f, 0.31987516f, 0.97842943f,
    0.93703174f, 0.09402039f, 0.94296405f, 0.34609999f, 0.50484272f, 0.10105256f,
    0.69247764f, 0.33889079f, 0.37738624f, 0.67766999f, 0.03290055f, 0.60766965f,
    0.74394835f, 0.56580320f, 0.54444604f, 0.02416489f, 0.96053432f, 0.64989130f,
    0.53865297f, 0.84842780f, 0.14497033f, 0.43756262f, 0.08073748f, 0.04542752f,
    0.74231497f, 0.57219133f, 0.60601763f, 0.89489031f, 0.76328121f, 0.93546812f,
    0.32818512f, 0.83250531f, 0.26383686f, 0.93520592f, 0.10694382f, 0.28593984f,
    0.50627131f, 0.05459252f, 0.64207800f, 0.11109143f, 0.02410949f, 0.62591678f,
    0.13898630f, 0.59362647f, 0.61176530f, 0.18697022f, 0.62387837f, 0.12471922f,
    0.63432733f, 0.17502842f, 0.13006353f, 0.87023567f, 0.26605380f, 0.24533266f,
    0.11307102f, 0.57725687f, 0.53384239f, 0.19273866f, 0.84286351f, 0.16428121f,
    0.78307944f, 0.47171256f, 0.65539683f, 0.75078757f, 0.26993092f, 0.20680054f,
    0.89062224f, 0.14280701f, 0.59151188f, 0.55936556f, 0.99523038f, 0.61409118f,
    0.12178031f, 0.45368713f, 0.59963240f, 0.73335856f, 0.25789168f, 0.19399655f,
    0.69161961f, 0.37854504f, 0.28369241f, 0.04183542f, 0.18372278f, 0.35621091f,
    0.91171838f, 0.62906761f, 0.91551318f, 0.88111322f, 0.91332010f, 0.30535886f,
    0.23208163f, 0.75591723f, 0.73230334f, 0.45000298f, 0.84995876f, 0.37819480f,
    0.09782391f, 0.09728269f, 0.45418018f, 0.66096794f, 0.60740309f, 0.25339599f,
    0.88556381f, 0.81945357f, 0.19415600f, 0.23327006f, 0.47418517f, 0.50132744f,
    0.68009447f, 0.56986153f, 0.98026763f, 0.43735312f, 0.05924920f, 0.28997095f,
    0.22213214f, 0.19584179f, 0.26304806f, 0.99296719f, 0.13548181f, 0.53597256f,
    0.40170888f, 0.48654007f, 0.13026393f, 0.58498728f, 0.51830166f, 0.14171475f,
    0.92991362f, 0.69178004f, 0.85867589f, 0.43353399f, 0.91032197f, 0.42915646f,
    0.37583094f, 0.78033317f, 0.44789492f, 0.18939256f, 0.42984912f, 0.12031170f,
    0.16121025f, 0.01865476f, 0.39565974f, 0.14668304f, 0.74079686f, 0.40695221f,
    0.58522660f, 0.63022693f, 0.43633514f, 0.34880725f, 0.66594773f, 0.29936163f,
    0.16811860f, 0.03860058f, 0.70394403f, 0.72231471f, 0.68605676f, 0.50205188f,
    0.37343846f, 0.08363673f, 0.57909586f, 0.49563442f, 0.49866058f, 0.59883851f,
    0.18307059f, 0.34862191f, 0.38284623f, 0.13762649f, 0.31618320f, 0.56327763f,
    0.73326133f, 0.88997858f, 0.13717060f, 0.92839688f, 0.01820541f, 0.21268153f,
    0.44852148f, 0.40660574f, 0.85121682f, 0.13010594f, 0.21072828f, 0.90872810f,
    0.25190127f, 0.96571483f, 0.47651001f, 0.31701091f, 0.09775980f, 0.77450085f,
    0.05735449f, 0.32652099f, 0.67604650f, 0.29626359f, 0.98786046f, 0.16969690f,
    0.34111008f, 0.11103827f, 0.82359404f, 0.41758347f, 0.95606322f, 0.24735670f,
    0.39101760f, 0.42304520f, 0.07629842f, 0.25827725f, 0.27713570f, 0.71222586f,
    0.94777521f, 0.46680045f, 0.90358975f, 0.63229476f, 0.02971087f, 0.80955489f,
    0.85490303f, 0.73332454f, 0.29701079f, 0.23428380f, 0.43143945f, 0.87282965f,
    0.37329514f, 0.58209996f, 0.46052435f, 0.57153801f, 0.13466181f, 0.09974419f,
    0.83834289f, 0.17247041f, 0.80444093f, 0.36084503f, 0.28306307f, 0.33209075f,
    0.43033955f, 0.24972348f, 0.37663435f, 0.03751623f, 0.65086670f, 0.48853011f,
    0.25752207f, 0.94851652f, 0.67421394f, 0.82098282f, 0.72600968f, 0.42388709f,
    0.71941515f, 0.64685489f, 0.04251911f, 0.14097982f, 0.81931728f, 0.51443430f,
    0.17067073f, 0.05256610f, 0.82348062f, 0.19785087f, 0.55166256f, 0.36027010f,
    0.83553959f, 0.02748641f, 0.93425043f, 0.79764408f, 0.79586139f, 0.01030830f,
    0.14254004f, 0.40329066f, 0.80173747f, 0.01918919f, 0.58746605f, 0.98562010f,
    0.32215059f, 0.78300744f, 0.54086497f, 0.01183996f, 0.19382398f, 0.55010409f,
    0.74520593f, 0.83621285f, 0.11434937f, 0.49466741f, 0.45720908f, 0.17371025f,
    0.91440231f, 0.19761280f, 0.97776279f, 0.94778974f, 0.78520668f, 0.75993995f,
    0.63988166f, 0.03360466f, 0.65345133f, 0.33741810f, 0.97518463f, 0.68462187f,
    0.28085992f, 0.55143958f, 0.79989913f, 0.29110049f, 0.36976620f, 0.40327895f,
    0.52422195f, 0.55852474f, 0.88267141f, 0.95971580f, 0.44262137f, 0.71386312f,
    0.03930301f, 0.28956130f, 0.78410790f, 0.21404605f, 0.59872571f, 0.40623665f,
    0.14551409f, 0.92654144f, 0.32927120f, 0.44497467f, 0.68041561f, 0.42421355f,
    0.23127308f, 0.99886755f, 0.23262914f, 0.94925216f, 0.52576316f, 0.62090428f,
    0.97549509f, 0.58295736f, 0.52847499f, 0.52499294f, 0.11377772f, 0.05428723f,
    0.86790567f, 0.68403694f, 0.71949956f, 0.54067301f, 0.60712753f, 0.91434256f,
    0.78000421f, 0.38565474f, 0.42296304f, 0.38051836f, 0.33776915f, 0.27099260f,
    0.26760921f, 0.87174820f, 0.07685093f, 0.44329070f, 0.77451723f, 0.44766852f,
    0.56834743f, 0.77968343f, 0.91311962f, 0.77947077f, 0.41303724f, 0.97225516f,
    0.08979550f, 0.00932069f, 0.82766448f, 0.87069481f, 0.53234612f, 0.89940173f,
    0.50455909f, 0.01695322f, 0.58241143f, 0.76213893f, 0.35292745f, 0.86972532f,
    0.60801566f, 0.36735676f, 0.60284786f, 0.90139751f, 0.99323060f, 0.06280776f,
    0.64651800f, 0.17228444f, 0.87335941f, 0.46484393f, 0.41051032f, 0.67875582f,
    0.47476726f, 0.65977698f, 0.33070318f, 0.53107402f, 0.55433807f, 0.17810236f,
    0.54930412f, 0.15690358f, 0.18346389f, 0.47828350f, 0.51022477f, 0.32661650f,
    0.10754613f, 0.10987161f, 0.01238629f, 0.95142795f, 0.95940083f, 0.56366110f,
    0.13583935f, 0.67540852f, 0.49203346f, 0.39626615f, 0.50650484f, 0.14350648f,
    0.70442828f, 0.01548833f, 0.66363946f, 0.12148005f, 0.69785327f, 0.39929313f,
    0.96968647f, 0.02731004f, 0.45740848f, 0.50391355f, 0.51299419f, 0.83009065f,
    0.59496543f, 0.59496592f, 0.83610618f, 0.12005625f, 0.70920114f, 0.74953527f,
    0.44020479f, 0.65639624f, 0.16319464f, 0.25762984f, 0.81220737f, 0.07756619f,
    0.20022046f, 0.16950506f, 0.96547942f, 0.19727100f, 0.81726336f, 0.25303056f,
    0.02677381f, 0.40915369f, 0.29983745f, 0.74505943f, 0.41758834f, 0.95107107f,
    0.85048932f, 0.49581990f, 0.42253783f, 0.91790322f, 0.07959654f, 0.04947580f,
    0.99356913f, 0.00797764f, 0.98655835f, 0.40160741f, 0.16804166f, 0.60586867f,
    0.36116068f, 0.29048722f, 0.47010892f, 0.27265925f, 0.65085293f, 0.96933078f,
    0.68585172f, 0.37845229f, 0.34509481f, 0.16747920f, 0.84873888f, 0.08134411f,
    0.85113768f, 0.96663149f, 0.61685880f, 0.25819913f, 0.90804227f, 0.32133128f,
    0.26873363f, 0.21699529f, 0.49197305f, 0.05908679f, 0.67027919f, 0.97546938f,
    0.29354478f, 0.16355479f, 0.97961621f, 0.74913276f, 0.53804889f, 0.62356279f,
    0.84510548f, 0.74192709f, 0.71570122f, 0.91141771f, 0.02942715f, 0.82894818f,
    0.68869987f, 0.41661766f, 0.95113782f, 0.73251084f, 0.34505623f, 0.72703619f,
    0.59542382f, 0.55570975f, 0.12918494f, 0.23079788f, 0.70635969f, 0.30252786f,
    0.25255492f, 0.96095156f, 0.56063415f, 0.29705582f, 0.48388354f, 0.16483471f,
    0.94230491f, 0.24874036f, 0.15009486f, 0.63450074f, 0.02269665f, 0.39362799f,
    0.31238144f, 0.15816203f, 0.61019541f, 0.48678874f, 0.18515253f, 0.46032698f,
    0.91067635f, 0.00759546f, 0.36148925f, 0.99584060f, 0.34801208f, 0.36202345f,
    0.62215612f, 0.89666678f, 0.78105422f, 0.98497424f, 0.31455745f, 0.07688824f,
    0.34229393f, 0.43679342f, 0.97472210f, 0.95858828f, 0.16584540f, 0.99324651f,
    0.96402143f, 0.85717907f, 0.09834350f, 0.00446583f, 0.04056849f, 0.76814498f,
    0.55380931f, 0.86863656f, 0.57393094f, 0.02748927f, 0.51864933f, 0.76892838f,
    0.33486268f, 0.11544810f, 0.19997272f, 0.06150180f, 0.69628830f, 0.16793087f,
    0.38171904f, 0.09805189f, 0.61795730f, 0.62394989f, 0.47919435f, 0.30364850f,
    0.85834017f, 0.83192898f, 0.91214951f, 0.01056750f, 0.56991278f, 0.46576893f,
    0.42625775f, 0.13798368f, 0.34753798f, 0.75606213f, 0.63764341f, 0.58803950f,
    0.17690054f, 0.95667807f, 0.43798673f, 0.74876615f, 0.78670237f, 0.16649930f,
    0.13981391f, 0.81709112f, 0.06352629f, 0.77541428f, 0.85213562f, 0.60982110f,
    0.31399744f, 0.95843141f, 0.62300280f, 0.96176742f, 0.83030776f, 0.99825887f,
    0.26331429f, 0.82843437f, 0.96064077f, 0.86180896f, 0.44896924f, 0.44189585f,
    0.43698718f, 0.61737576f, 0.98796578f, 0.70424403f, 0.25384554f, 0.57486171f,
    0.91519003f, 0.85053158f, 0.81005336f, 0.72018429f, 0.04842224f, 0.94529842f,
    0.16331144f, 0.24629028f, 0.59064443f, 0.18205138f, 0.14679423f, 0.04708226f,
    0.41032253f, 0.18755142f, 0.25665135f, 0.61768362f, 0.46533965f, 0.56218639f,
    0.83839556f, 0.21612406f, 0.97818276f, 0.94941727f, 0.33246099f, 0.59963034f,
    0.01846613f, 0.77226043f, 0.54104703f, 0.50579748f, 0.03066894f, 0.91960885f,
    0.85930916f, 0.04815602f, 0.06495406f, 0.64212750f, 0.68671226f, 0.72083225f,
    0.36012848f, 0.52433477f, 0.26474655f, 0.03253265f, 0.90133587f, 0.94977825f,
    0.64416448f, 0.33101214f, 0.37019532f, 0.04903235f, 0.49050120f, 0.94117034f,
    0.83920204f, 0.81031207f, 0.81608501f, 0.76925160f, 0.78079121f, 0.20016505f,
    0.25834919f, 0.35921566f, 0.68817023f, 0.66294782f, 0.18946707f, 0.50273705f,
    0.39160343f, 0.88421442f, 0.17571952f, 0.76964486f, 0.13017095f, 0.87197292f,
    0.24426241f, 0.24972187f, 0.56312704f, 0.15384830f, 0.15091202f, 0.77905437f,
    0.21298530f, 0.64600698f, 0.66915420f, 0.50460329f, 0.68861779f, 0.72534858f,
    0.58487818f, 0.75001514f, 0.38335367f, 0.44968277f, 0.03353412f, 0.35519846f,
    0.95080913f, 0.20673317f, 0.45983426f, 0.43377117f, 0.57860654f, 0.33282387f,
    0.42120774f, 0.42867583f, 0.08400530f, 0.19260875f, 0.75454705f, 0.44022695f,
    0.90065178f, 0.63442488f, 0.04404682f, 0.68638750f, 0.69516945f, 0.67964213f,
    0.58195254f, 0.15658237f, 0.30728546f, 0.33221676f, 0.02275314f, 0.70288666f,
    0.93688437f, 0.83563966f, 0.06683834f, 0.03163784f, 0.57317598f, 0.90332618f,
    0.84709326f, 0.01070375f, 0.97057062f, 0.01557599f, 0.25964063f, 0.97970641f,
    0.49650424f, 0.93751463f, 0.50940926f, 0.06999394f, 0.71010489f, 0.05951450f,
    0.31697736f, 0.02623365f, 0.95712525f, 0.90170935f, 0.94290571f, 0.43095741f,
    0.79398933f, 0.33021382f, 0.77035889f, 0.21664025f, 0.96824961f, 0.39301477f,
    0.19015828f, 0.69697318f, 0.59848021f, 0.65231613f, 0.95158850f, 0.24056626f,
    0.30602577f, 0.93711994f, 0.67748509f, 0.96767628f, 0.37459222f, 0.30036449f,
    0.54668466f, 0.18561001f, 0.65003720f, 0.88999350f, 0.07726681f, 0.54374686f,
    0.26865245f, 0.44949814f, 0.80972786f, 0.32781876f, 0.42261100f, 0.28298487f,
    0.50299699f, 0.80896938f, 0.06908590f, 0.05052620f, 0.18385489f, 0.89060223f,
    0.67596765f, 0.51492647f, 0.20078962f, 0.37015859f, 0.01137236f, 0.92018180f,
    0.94869365f, 0.25940426f, 0.44362413f, 0.63955852f, 0.47626578f, 0.73183833f,
    0.86862197f, 0.94771009f, 0.04185220f, 0.22638184f, 0.94609569f, 0.62257461f,
    0.32718704f, 0.01009828f, 0.85697497f, 0.71054544f, 0.38664571f, 0.45750474f,
    0.92082412f, 0.34981261f, 0.13989817f, 0.44884271f, 0.59303862f, 0.46468432f,
    0.89906563f, 0.52390336f, 0.13239346f, 0.35659210f, 0.85158740f, 0.79168434f,
    0.45483232f, 0.42946229f, 0.84406538f, 0.51995600f, 0.81147661f, 0.21792629f,
    0.18056740f, 0.88402572f, 0.21821975f, 0.52179478f, 0.36455743f, 0.50252126f,
    0.36958935f, 0.29031253f, 0.88322581f, 0.23240925f, 0.76756442f, 0.21154312f,
    0.81608690f, 0.72888508f, 0.24161096f, 0.02803250f, 0.50898931f, 0.63200632f,
    0.01235317f, 0.96751872f, 0.00596693f, 0.94540599f, 0.11916351f, 0.41036952f,
    0.79359038f, 0.38815488f, 0.88078982f, 0.84273991f, 0.55773169f, 0.78450643f,
    0.15532463f, 0.11087690f, 0.65612160f, 0.10414411f, 0.40686884f, 0.10790753f,
    0.40008297f, 0.66457177f, 0.94478144f, 0.91580812f, 0.74680723f, 0.48498351f,
    0.47919701f, 0.48366682f, 0.81407669f, 0.45548292f, 0.21341618f, 0.55604577f,
    0.63011741f, 0.11568323f, 0.77783864f, 0.44507494f, 0.56311602f, 0.57192246f,
    0.18744672f, 0.55534316f, 0.98179553f, 0.71261114f, 0.78971778f, 0.27579468f,
    0.37738804f, 0.08725811f, 0.55462815f, 0.91741883f, 0.62856459f, 0.91778153f,
    0.56361874f, 0.03488687f, 0.46770121f, 0.92272177f, 0.77865432f, 0.47542075f,
    0.86572382f, 0.30846909f, 0.04258394f, 0.36567526f, 0.80325130f, 0.15976596f,
    0.28278103f, 0.50950362f, 0.25054190f, 0.92833120f, 0.39451597f, 0.12400924f,
    0.60366358f, 0.04789403f, 0.67982555f, 0.80173938f, 0.98829883f, 0.31126026f,
    0.75104860f, 0.13235162f, 0.86772958f, 0.33592419f, 0.79307959f, 0.64230727f,
    0.10302327f, 0.66547720f, 0.16025926f, 0.97646982f, 0.78957686f, 0.14156171f,
    0.68630613f, 0.42688665f, 0.81641807f, 0.61291622f, 0.36055321f, 0.65311069f,
    0.59758071f, 0.69231761f, 0.30087287f, 0.39240225f, 0.94616151f, 0.63773967f,
    0.19105764f, 0.04989065f, 0.69214686f, 0.92022614f, 0.58420835f, 0.72674799f,
    0.67871745f, 0.18786155f, 0.06812167f, 0.69273440f, 0.95556472f, 0.07347767f,
    0.18614898f, 0.75784219f, 0.77198267f, 0.19464658f, 0.97802581f, 0.93154697f,
    0.76045086f, 0.21999738f, 0.89837883f, 0.17834361f, 0.09954517f, 0.62849139f,
    0.86276277f, 0.75140560f, 0.51287292f, 0.76116437f, 0.01704602f, 0.29458402f,
    0.46102228f, 0.59178293f, 0.10875866f, 0.69440919f, 0.53206421f, 0.84827982f,
    0.71977298f, 0.10174997f, 0.75189310f, 0.36576877f, 0.08766211f, 0.95642505f,
    0.69070985f, 0.90005695f, 0.36566039f, 0.58207272f, 0.91143468f, 0.77416264f,
    0.34383601f, 0.58332389f, 0.51810539f, 0.25631948f, 0.35051741f, 0.99876187f,
    0.54881699f, 0.20384774f, 0.07494492f, 0.83289562f, 0.40305926f, 0.37125948f,
    0.77943371f, 0.11564495f, 0.78510687f, 0.63182952f, 0.01003871f, 0.19149036f,
    0.12423076f, 0.84901943f, 0.75494166f, 0.21095160f, 0.64287662f, 0.04762861f,
    0.65379082f, 0.23853011f, 0.18266543f, 0.05502760f, 0.52139959f, 0.47340771f,
    0.26530790f, 0.73159343f, 0.13605749f, 0.53738871f, 0.31461027f, 0.99842950f,
    0.05486034f, 0.86978128f, 0.35312733f, 0.95215166f, 0.58268196f, 0.99773876f,
    0.12226111f, 0.67412280f, 0.94257148f, 0.85524844f, 0.47040517f, 0.77880797f,
    0.00647563f, 0.70231593f, 0.97591539f, 0.07731658f, 0.55738706f, 0.36142466f,
    0.28919391f, 0.87273538f, 0.20656569f, 0.02015289f, 0.21307323f, 0.65920031f,
    0.59975298f, 0.34163260f, 0.41817890f, 0.31309590f, 0.05980695f, 0.93868608f,
    0.18835050f, 0.07922173f, 0.05356133f, 0.77895470f, 0.19195842f, 0.74476566f,
    0.88971302f, 0.93874078f, 0.91263775f, 0.72763697f, 0.48205163f, 0.46984523f,
    0.68526601f, 0.39192863f, 0.30637009f, 0.40925093f, 0.86075896f, 0.64141035f,
    0.37606968f, 0.08455302f, 0.26039296f, 0.77204206f, 0.02505414f, 0.55267207f,
    0.02395482f, 0.11720525f, 0.95937772f, 0.97533250f, 0.15626459f, 0.26596589f,
    0.69178053f, 0.96739722f, 0.43683515f, 0.53712165f, 0.45434231f, 0.95439768f,
    0.98406868f, 0.05258748f, 0.67077224f, 0.61008697f, 0.21801553f, 0.66599979f,
    0.31620906f, 0.79579965f, 0.50703031f, 0.30006193f, 0.08184154f, 0.63867687f,
    0.62947374f, 0.95352375f, 0.35530642f, 0.52888537f, 0.75087233f, 0.92082748f,
    0.11493688f, 0.71592649f, 0.78173144f, 0.18002254f, 0.98390321f, 0.68572155f,
    0.31669596f, 0.64384449f, 0.79461531f, 0.71372631f, 0.39028739f, 0.12178050f,
    0.04807762f, 0.54084435f, 0.74946165f, 0.63504544f, 0.91895815f, 0.39997999f,
    0.42329829f, 0.77983289f, 0.83483829f, 0.03892205f, 0.95294535f, 0.40577275f,
    0.85545545f, 0.61273127f, 0.57132416f, 0.11563644f, 0.88087046f, 0.54439432f,
    0.93599067f, 0.28901987f, 0.24064290f, 0.63030622f, 0.21702494f, 0.16766900f,
    0.15166367f, 0.76687850f, 0.62507295f, 0.33458056f
};


double bn_sin_scale = BN_SINTABSIZE / (2.0 * M_PI);


const float bn_sin_table[BN_SINTABSIZE] = {
    0.0f,		0.00306796f,	0.00613588f,	0.00920375f,
    0.0122715f,	0.0153392f,	0.0184067f,	0.0214741f,
    0.0245412f,	0.0276081f,	0.0306748f,	0.0337412f,
    0.0368072f,	0.0398729f,	0.0429383f,	0.0460032f,
    0.0490677f,	0.0521317f,	0.0551952f,	0.0582583f,
    0.0613207f,	0.0643826f,	0.0674439f,	0.0705046f,
    0.0735646f,	0.0766239f,	0.0796824f,	0.0827403f,
    0.0857973f,	0.0888536f,	0.091909f,	0.0949635f,
    0.0980171f,	0.10107f,	0.104122f,	0.107172f,
    0.110222f,	0.113271f,	0.116319f,	0.119365f,
    0.122411f,	0.125455f,	0.128498f,	0.13154f,
    0.134581f,	0.13762f,	0.140658f,	0.143695f,
    0.14673f,	0.149765f,	0.152797f,	0.155828f,
    0.158858f,	0.161886f,	0.164913f,	0.167938f,
    0.170962f,	0.173984f,	0.177004f,	0.180023f,
    0.18304f,	0.186055f,	0.189069f,	0.19208f,
    0.19509f,	0.198098f,	0.201105f,	0.204109f,
    0.207111f,	0.210112f,	0.21311f,	0.216107f,
    0.219101f,	0.222094f,	0.225084f,	0.228072f,
    0.231058f,	0.234042f,	0.237024f,	0.240003f,
    0.24298f,	0.245955f,	0.248928f,	0.251898f,
    0.254866f,	0.257831f,	0.260794f,	0.263755f,
    0.266713f,	0.269668f,	0.272621f,	0.275572f,
    0.27852f,	0.281465f,	0.284408f,	0.287347f,
    0.290285f,	0.293219f,	0.296151f,	0.29908f,
    0.302006f,	0.304929f,	0.30785f,	0.310767f,
    0.313682f,	0.316593f,	0.319502f,	0.322408f,
    0.32531f,	0.32821f,	0.331106f,	0.334f,
    0.33689f,	0.339777f,	0.342661f,	0.345541f,
    0.348419f,	0.351293f,	0.354164f,	0.357031f,
    0.359895f,	0.362756f,	0.365613f,	0.368467f,
    0.371317f,	0.374164f,	0.377007f,	0.379847f,
    0.382683f,	0.385516f,	0.388345f,	0.39117f,
    0.393992f,	0.39681f,	0.399624f,	0.402435f,
    0.405241f,	0.408044f,	0.410843f,	0.413638f,
    0.41643f,	0.419217f,	0.422f,		0.42478f,
    0.427555f,	0.430326f,	0.433094f,	0.435857f,
    0.438616f,	0.441371f,	0.444122f,	0.446869f,
    0.449611f,	0.45235f,	0.455084f,	0.457813f,
    0.460539f,	0.46326f,	0.465976f,	0.468689f,
    0.471397f,	0.4741f,	0.476799f,	0.479494f,
    0.482184f,	0.484869f,	0.48755f,	0.490226f,
    0.492898f,	0.495565f,	0.498228f,	0.500885f,
    0.503538f,	0.506187f,	0.50883f,	0.511469f,
    0.514103f,	0.516732f,	0.519356f,	0.521975f,
    0.52459f,	0.527199f,	0.529804f,	0.532403f,
    0.534998f,	0.537587f,	0.540171f,	0.542751f,
    0.545325f,	0.547894f,	0.550458f,	0.553017f,
    0.55557f,	0.558119f,	0.560662f,	0.563199f,
    0.565732f,	0.568259f,	0.570781f,	0.573297f,
    0.575808f,	0.578314f,	0.580814f,	0.583309f,
    0.585798f,	0.588282f,	0.59076f,	0.593232f,
    0.595699f,	0.598161f,	0.600616f,	0.603067f,
    0.605511f,	0.60795f,	0.610383f,	0.61281f,
    0.615232f,	0.617647f,	0.620057f,	0.622461f,
    0.624859f,	0.627252f,	0.629638f,	0.632019f,
    0.634393f,	0.636762f,	0.639124f,	0.641481f,
    0.643832f,	0.646176f,	0.648514f,	0.650847f,
    0.653173f,	0.655493f,	0.657807f,	0.660114f,
    0.662416f,	0.664711f,	0.667f,		0.669283f,
    0.671559f,	0.673829f,	0.676093f,	0.67835f,
    0.680601f,	0.682846f,	0.685084f,	0.687315f,
    0.689541f,	0.691759f,	0.693971f,	0.696177f,
    0.698376f,	0.700569f,	0.702755f,	0.704934f,
    0.707107f,	0.709273f,	0.711432f,	0.713585f,
    0.715731f,	0.71787f,	0.720003f,	0.722128f,
    0.724247f,	0.726359f,	0.728464f,	0.730563f,
    0.732654f,	0.734739f,	0.736817f,	0.738887f,
    0.740951f,	0.743008f,	0.745058f,	0.747101f,
    0.749136f,	0.751165f,	0.753187f,	0.755201f,
    0.757209f,	0.759209f,	0.761202f,	0.763188f,
    0.765167f,	0.767139f,	0.769103f,	0.771061f,
    0.77301f,	0.774953f,	0.776888f,	0.778817f,
    0.780737f,	0.782651f,	0.784557f,	0.786455f,
    0.788346f,	0.79023f,	0.792107f,	0.793975f,
    0.795837f,	0.797691f,	0.799537f,	0.801376f,
    0.803208f,	0.805031f,	0.806848f,	0.808656f,
    0.810457f,	0.812251f,	0.814036f,	0.815814f,
    0.817585f,	0.819348f,	0.821103f,	0.82285f,
    0.824589f,	0.826321f,	0.828045f,	0.829761f,
    0.83147f,	0.83317f,	0.834863f,	0.836548f,
    0.838225f,	0.839894f,	0.841555f,	0.843208f,
    0.844854f,	0.846491f,	0.84812f,	0.849742f,
    0.851355f,	0.852961f,	0.854558f,	0.856147f,
    0.857729f,	0.859302f,	0.860867f,	0.862424f,
    0.863973f,	0.865514f,	0.867046f,	0.868571f,
    0.870087f,	0.871595f,	0.873095f,	0.874587f,
    0.87607f,	0.877545f,	0.879012f,	0.880471f,
    0.881921f,	0.883363f,	0.884797f,	0.886223f,
    0.88764f,	0.889048f,	0.890449f,	0.891841f,
    0.893224f,	0.894599f,	0.895966f,	0.897325f,
    0.898674f,	0.900016f,	0.901349f,	0.902673f,
    0.903989f,	0.905297f,	0.906596f,	0.907886f,
    0.909168f,	0.910441f,	0.911706f,	0.912962f,
    0.91421f,	0.915449f,	0.916679f,	0.917901f,
    0.919114f,	0.920318f,	0.921514f,	0.922701f,
    0.92388f,	0.925049f,	0.92621f,	0.927363f,
    0.928506f,	0.929641f,	0.930767f,	0.931884f,
    0.932993f,	0.934093f,	0.935184f,	0.936266f,
    0.937339f,	0.938404f,	0.939459f,	0.940506f,
    0.941544f,	0.942573f,	0.943593f,	0.944605f,
    0.945607f,	0.946601f,	0.947586f,	0.948561f,
    0.949528f,	0.950486f,	0.951435f,	0.952375f,
    0.953306f,	0.954228f,	0.955141f,	0.956045f,
    0.95694f,	0.957826f,	0.958703f,	0.959572f,
    0.960431f,	0.96128f,	0.962121f,	0.962953f,
    0.963776f,	0.96459f,	0.965394f,	0.96619f,
    0.966976f,	0.967754f,	0.968522f,	0.969281f,
    0.970031f,	0.970772f,	0.971504f,	0.972226f,
    0.97294f,	0.973644f,	0.974339f,	0.975025f,
    0.975702f,	0.97637f,	0.977028f,	0.977677f,
    0.978317f,	0.978948f,	0.97957f,	0.980182f,
    0.980785f,	0.981379f,	0.981964f,	0.982539f,
    0.983105f,	0.983662f,	0.98421f,	0.984749f,
    0.985278f,	0.985798f,	0.986308f,	0.986809f,
    0.987301f,	0.987784f,	0.988258f,	0.988722f,
    0.989177f,	0.989622f,	0.990058f,	0.990485f,
    0.990903f,	0.991311f,	0.99171f,	0.992099f,
    0.99248f,	0.99285f,	0.993212f,	0.993564f,
    0.993907f,	0.99424f,	0.994565f,	0.994879f,
    0.995185f,	0.995481f,	0.995767f,	0.996045f,
    0.996313f,	0.996571f,	0.99682f,	0.99706f,
    0.99729f,	0.997511f,	0.997723f,	0.997925f,
    0.998118f,	0.998302f,	0.998476f,	0.99864f,
    0.998795f,	0.998941f,	0.999078f,	0.999205f,
    0.999322f,	0.999431f,	0.999529f,	0.999619f,
    0.999699f,	0.999769f,	0.999831f,	0.999882f,
    0.999925f,	0.999958f,	0.999981f,	0.999995f,
    1.0f,		0.999995f,	0.999981f,	0.999958f,
    0.999925f,	0.999882f,	0.999831f,	0.999769f,
    0.999699f,	0.999619f,	0.999529f,	0.999431f,
    0.999322f,	0.999205f,	0.999078f,	0.998941f,
    0.998795f,	0.99864f,	0.998476f,	0.998302f,
    0.998118f,	0.997925f,	0.997723f,	0.997511f,
    0.99729f,	0.99706f,	0.99682f,	0.996571f,
    0.996313f,	0.996045f,	0.995767f,	0.995481f,
    0.995185f,	0.994879f,	0.994565f,	0.99424f,
    0.993907f,	0.993564f,	0.993212f,	0.99285f,
    0.99248f,	0.992099f,	0.99171f,	0.991311f,
    0.990903f,	0.990485f,	0.990058f,	0.989622f,
    0.989177f,	0.988722f,	0.988258f,	0.987784f,
    0.987301f,	0.986809f,	0.986308f,	0.985798f,
    0.985278f,	0.984749f,	0.98421f,	0.983662f,
    0.983105f,	0.982539f,	0.981964f,	0.981379f,
    0.980785f,	0.980182f,	0.97957f,	0.978948f,
    0.978317f,	0.977677f,	0.977028f,	0.97637f,
    0.975702f,	0.975025f,	0.974339f,	0.973644f,
    0.97294f,	0.972226f,	0.971504f,	0.970772f,
    0.970031f,	0.969281f,	0.968522f,	0.967754f,
    0.966976f,	0.96619f,	0.965394f,	0.96459f,
    0.963776f,	0.962953f,	0.962121f,	0.96128f,
    0.960431f,	0.959572f,	0.958703f,	0.957826f,
    0.95694f,	0.956045f,	0.955141f,	0.954228f,
    0.953306f,	0.952375f,	0.951435f,	0.950486f,
    0.949528f,	0.948561f,	0.947586f,	0.946601f,
    0.945607f,	0.944605f,	0.943593f,	0.942573f,
    0.941544f,	0.940506f,	0.939459f,	0.938404f,
    0.937339f,	0.936266f,	0.935184f,	0.934093f,
    0.932993f,	0.931884f,	0.930767f,	0.929641f,
    0.928506f,	0.927363f,	0.92621f,	0.925049f,
    0.92388f,	0.922701f,	0.921514f,	0.920318f,
    0.919114f,	0.917901f,	0.916679f,	0.915449f,
    0.91421f,	0.912962f,	0.911706f,	0.910441f,
    0.909168f,	0.907886f,	0.906596f,	0.905297f,
    0.903989f,	0.902673f,	0.901349f,	0.900016f,
    0.898674f,	0.897325f,	0.895966f,	0.894599f,
    0.893224f,	0.891841f,	0.890449f,	0.889048f,
    0.88764f,	0.886223f,	0.884797f,	0.883363f,
    0.881921f,	0.880471f,	0.879012f,	0.877545f,
    0.87607f,	0.874587f,	0.873095f,	0.871595f,
    0.870087f,	0.868571f,	0.867046f,	0.865514f,
    0.863973f,	0.862424f,	0.860867f,	0.859302f,
    0.857729f,	0.856147f,	0.854558f,	0.852961f,
    0.851355f,	0.849742f,	0.84812f,	0.846491f,
    0.844854f,	0.843208f,	0.841555f,	0.839894f,
    0.838225f,	0.836548f,	0.834863f,	0.83317f,
    0.83147f,	0.829761f,	0.828045f,	0.826321f,
    0.824589f,	0.82285f,	0.821103f,	0.819348f,
    0.817585f,	0.815814f,	0.814036f,	0.812251f,
    0.810457f,	0.808656f,	0.806848f,	0.805031f,
    0.803208f,	0.801376f,	0.799537f,	0.797691f,
    0.795837f,	0.793975f,	0.792107f,	0.79023f,
    0.788346f,	0.786455f,	0.784557f,	0.782651f,
    0.780737f,	0.778817f,	0.776888f,	0.774953f,
    0.77301f,	0.771061f,	0.769103f,	0.767139f,
    0.765167f,	0.763188f,	0.761202f,	0.759209f,
    0.757209f,	0.755201f,	0.753187f,	0.751165f,
    0.749136f,	0.747101f,	0.745058f,	0.743008f,
    0.740951f,	0.738887f,	0.736817f,	0.734739f,
    0.732654f,	0.730563f,	0.728464f,	0.726359f,
    0.724247f,	0.722128f,	0.720003f,	0.71787f,
    0.715731f,	0.713585f,	0.711432f,	0.709273f,
    0.707107f,	0.704934f,	0.702755f,	0.700569f,
    0.698376f,	0.696177f,	0.693971f,	0.691759f,
    0.689541f,	0.687315f,	0.685084f,	0.682846f,
    0.680601f,	0.67835f,	0.676093f,	0.673829f,
    0.671559f,	0.669283f,	0.667f,		0.664711f,
    0.662416f,	0.660114f,	0.657807f,	0.655493f,
    0.653173f,	0.650847f,	0.648514f,	0.646176f,
    0.643832f,	0.641481f,	0.639124f,	0.636762f,
    0.634393f,	0.632019f,	0.629638f,	0.627252f,
    0.624859f,	0.622461f,	0.620057f,	0.617647f,
    0.615232f,	0.61281f,	0.610383f,	0.60795f,
    0.605511f,	0.603067f,	0.600616f,	0.598161f,
    0.595699f,	0.593232f,	0.59076f,	0.588282f,
    0.585798f,	0.583309f,	0.580814f,	0.578314f,
    0.575808f,	0.573297f,	0.570781f,	0.568259f,
    0.565732f,	0.563199f,	0.560662f,	0.558119f,
    0.55557f,	0.553017f,	0.550458f,	0.547894f,
    0.545325f,	0.542751f,	0.540171f,	0.537587f,
    0.534998f,	0.532403f,	0.529804f,	0.527199f,
    0.52459f,	0.521975f,	0.519356f,	0.516732f,
    0.514103f,	0.511469f,	0.50883f,	0.506187f,
    0.503538f,	0.500885f,	0.498228f,	0.495565f,
    0.492898f,	0.490226f,	0.48755f,	0.484869f,
    0.482184f,	0.479494f,	0.476799f,	0.4741f,
    0.471397f,	0.468689f,	0.465976f,	0.46326f,
    0.460539f,	0.457813f,	0.455084f,	0.45235f,
    0.449611f,	0.446869f,	0.444122f,	0.441371f,
    0.438616f,	0.435857f,	0.433094f,	0.430326f,
    0.427555f,	0.42478f,	0.422f,		0.419217f,
    0.41643f,	0.413638f,	0.410843f,	0.408044f,
    0.405241f,	0.402435f,	0.399624f,	0.39681f,
    0.393992f,	0.39117f,	0.388345f,	0.385516f,
    0.382683f,	0.379847f,	0.377007f,	0.374164f,
    0.371317f,	0.368467f,	0.365613f,	0.362756f,
    0.359895f,	0.357031f,	0.354164f,	0.351293f,
    0.348419f,	0.345541f,	0.342661f,	0.339777f,
    0.33689f,	0.334f,		0.331106f,	0.32821f,
    0.32531f,	0.322408f,	0.319502f,	0.316593f,
    0.313682f,	0.310767f,	0.30785f,	0.304929f,
    0.302006f,	0.29908f,	0.296151f,	0.293219f,
    0.290285f,	0.287347f,	0.284408f,	0.281465f,
    0.27852f,	0.275572f,	0.272621f,	0.269668f,
    0.266713f,	0.263755f,	0.260794f,	0.257831f,
    0.254866f,	0.251898f,	0.248928f,	0.245955f,
    0.24298f,	0.240003f,	0.237024f,	0.234042f,
    0.231058f,	0.228072f,	0.225084f,	0.222094f,
    0.219101f,	0.216107f,	0.21311f,	0.210112f,
    0.207111f,	0.204109f,	0.201105f,	0.198098f,
    0.19509f,	0.19208f,	0.189069f,	0.186055f,
    0.18304f,	0.180023f,	0.177004f,	0.173984f,
    0.170962f,	0.167938f,	0.164913f,	0.161886f,
    0.158858f,	0.155828f,	0.152797f,	0.149765f,
    0.14673f,	0.143695f,	0.140658f,	0.13762f,
    0.134581f,	0.13154f,	0.128498f,	0.125455f,
    0.122411f,	0.119365f,	0.116319f,	0.113271f,
    0.110222f,	0.107172f,	0.104122f,	0.10107f,
    0.0980171f,	0.0949635f,	0.091909f,	0.0888536f,
    0.0857973f,	0.0827403f,	0.0796824f,	0.0766239f,
    0.0735646f,	0.0705046f,	0.0674439f,	0.0643826f,
    0.0613207f,	0.0582583f,	0.0551952f,	0.0521317f,
    0.0490677f,	0.0460032f,	0.0429383f,	0.0398729f,
    0.0368072f,	0.0337412f,	0.0306748f,	0.0276081f,
    0.0245412f,	0.0214741f,	0.0184067f,	0.0153392f,
    0.0122715f,	0.00920375f,	0.00613588f,	0.00306796f,
    2.92555e-13f,	-0.00306796f,	-0.00613588f,	-0.00920375f,
    -0.0122715f,	-0.0153392f,	-0.0184067f,	-0.0214741f,
    -0.0245412f,	-0.0276081f,	-0.0306748f,	-0.0337412f,
    -0.0368072f,	-0.0398729f,	-0.0429383f,	-0.0460032f,
    -0.0490677f,	-0.0521317f,	-0.0551952f,	-0.0582583f,
    -0.0613207f,	-0.0643826f,	-0.0674439f,	-0.0705046f,
    -0.0735646f,	-0.0766239f,	-0.0796824f,	-0.0827403f,
    -0.0857973f,	-0.0888536f,	-0.091909f,	-0.0949635f,
    -0.0980171f,	-0.10107f,	-0.104122f,	-0.107172f,
    -0.110222f,	-0.113271f,	-0.116319f,	-0.119365f,
    -0.122411f,	-0.125455f,	-0.128498f,	-0.13154f,
    -0.134581f,	-0.13762f,	-0.140658f,	-0.143695f,
    -0.14673f,	-0.149765f,	-0.152797f,	-0.155828f,
    -0.158858f,	-0.161886f,	-0.164913f,	-0.167938f,
    -0.170962f,	-0.173984f,	-0.177004f,	-0.180023f,
    -0.18304f,	-0.186055f,	-0.189069f,	-0.19208f,
    -0.19509f,	-0.198098f,	-0.201105f,	-0.204109f,
    -0.207111f,	-0.210112f,	-0.21311f,	-0.216107f,
    -0.219101f,	-0.222094f,	-0.225084f,	-0.228072f,
    -0.231058f,	-0.234042f,	-0.237024f,	-0.240003f,
    -0.24298f,	-0.245955f,	-0.248928f,	-0.251898f,
    -0.254866f,	-0.257831f,	-0.260794f,	-0.263755f,
    -0.266713f,	-0.269668f,	-0.272621f,	-0.275572f,
    -0.27852f,	-0.281465f,	-0.284408f,	-0.287347f,
    -0.290285f,	-0.293219f,	-0.296151f,	-0.29908f,
    -0.302006f,	-0.304929f,	-0.30785f,	-0.310767f,
    -0.313682f,	-0.316593f,	-0.319502f,	-0.322408f,
    -0.32531f,	-0.32821f,	-0.331106f,	-0.334f,
    -0.33689f,	-0.339777f,	-0.342661f,	-0.345541f,
    -0.348419f,	-0.351293f,	-0.354164f,	-0.357031f,
    -0.359895f,	-0.362756f,	-0.365613f,	-0.368467f,
    -0.371317f,	-0.374164f,	-0.377007f,	-0.379847f,
    -0.382683f,	-0.385516f,	-0.388345f,	-0.39117f,
    -0.393992f,	-0.39681f,	-0.399624f,	-0.402435f,
    -0.405241f,	-0.408044f,	-0.410843f,	-0.413638f,
    -0.41643f,	-0.419217f,	-0.422f,	-0.42478f,
    -0.427555f,	-0.430326f,	-0.433094f,	-0.435857f,
    -0.438616f,	-0.441371f,	-0.444122f,	-0.446869f,
    -0.449611f,	-0.45235f,	-0.455084f,	-0.457813f,
    -0.460539f,	-0.46326f,	-0.465976f,	-0.468689f,
    -0.471397f,	-0.4741f,	-0.476799f,	-0.479494f,
    -0.482184f,	-0.484869f,	-0.48755f,	-0.490226f,
    -0.492898f,	-0.495565f,	-0.498228f,	-0.500885f,
    -0.503538f,	-0.506187f,	-0.50883f,	-0.511469f,
    -0.514103f,	-0.516732f,	-0.519356f,	-0.521975f,
    -0.52459f,	-0.527199f,	-0.529804f,	-0.532403f,
    -0.534998f,	-0.537587f,	-0.540171f,	-0.542751f,
    -0.545325f,	-0.547894f,	-0.550458f,	-0.553017f,
    -0.55557f,	-0.558119f,	-0.560662f,	-0.563199f,
    -0.565732f,	-0.568259f,	-0.570781f,	-0.573297f,
    -0.575808f,	-0.578314f,	-0.580814f,	-0.583309f,
    -0.585798f,	-0.588282f,	-0.59076f,	-0.593232f,
    -0.595699f,	-0.598161f,	-0.600616f,	-0.603067f,
    -0.605511f,	-0.60795f,	-0.610383f,	-0.61281f,
    -0.615232f,	-0.617647f,	-0.620057f,	-0.622461f,
    -0.624859f,	-0.627252f,	-0.629638f,	-0.632019f,
    -0.634393f,	-0.636762f,	-0.639124f,	-0.641481f,
    -0.643832f,	-0.646176f,	-0.648514f,	-0.650847f,
    -0.653173f,	-0.655493f,	-0.657807f,	-0.660114f,
    -0.662416f,	-0.664711f,	-0.667f,	-0.669283f,
    -0.671559f,	-0.673829f,	-0.676093f,	-0.67835f,
    -0.680601f,	-0.682846f,	-0.685084f,	-0.687315f,
    -0.689541f,	-0.691759f,	-0.693971f,	-0.696177f,
    -0.698376f,	-0.700569f,	-0.702755f,	-0.704934f,
    -0.707107f,	-0.709273f,	-0.711432f,	-0.713585f,
    -0.715731f,	-0.71787f,	-0.720003f,	-0.722128f,
    -0.724247f,	-0.726359f,	-0.728464f,	-0.730563f,
    -0.732654f,	-0.734739f,	-0.736817f,	-0.738887f,
    -0.740951f,	-0.743008f,	-0.745058f,	-0.747101f,
    -0.749136f,	-0.751165f,	-0.753187f,	-0.755201f,
    -0.757209f,	-0.759209f,	-0.761202f,	-0.763188f,
    -0.765167f,	-0.767139f,	-0.769103f,	-0.771061f,
    -0.77301f,	-0.774953f,	-0.776888f,	-0.778817f,
    -0.780737f,	-0.782651f,	-0.784557f,	-0.786455f,
    -0.788346f,	-0.79023f,	-0.792107f,	-0.793975f,
    -0.795837f,	-0.797691f,	-0.799537f,	-0.801376f,
    -0.803208f,	-0.805031f,	-0.806848f,	-0.808656f,
    -0.810457f,	-0.812251f,	-0.814036f,	-0.815814f,
    -0.817585f,	-0.819348f,	-0.821103f,	-0.82285f,
    -0.824589f,	-0.826321f,	-0.828045f,	-0.829761f,
    -0.83147f,	-0.83317f,	-0.834863f,	-0.836548f,
    -0.838225f,	-0.839894f,	-0.841555f,	-0.843208f,
    -0.844854f,	-0.846491f,	-0.84812f,	-0.849742f,
    -0.851355f,	-0.852961f,	-0.854558f,	-0.856147f,
    -0.857729f,	-0.859302f,	-0.860867f,	-0.862424f,
    -0.863973f,	-0.865514f,	-0.867046f,	-0.868571f,
    -0.870087f,	-0.871595f,	-0.873095f,	-0.874587f,
    -0.87607f,	-0.877545f,	-0.879012f,	-0.880471f,
    -0.881921f,	-0.883363f,	-0.884797f,	-0.886223f,
    -0.88764f,	-0.889048f,	-0.890449f,	-0.891841f,
    -0.893224f,	-0.894599f,	-0.895966f,	-0.897325f,
    -0.898674f,	-0.900016f,	-0.901349f,	-0.902673f,
    -0.903989f,	-0.905297f,	-0.906596f,	-0.907886f,
    -0.909168f,	-0.910441f,	-0.911706f,	-0.912962f,
    -0.91421f,	-0.915449f,	-0.916679f,	-0.917901f,
    -0.919114f,	-0.920318f,	-0.921514f,	-0.922701f,
    -0.92388f,	-0.925049f,	-0.92621f,	-0.927363f,
    -0.928506f,	-0.929641f,	-0.930767f,	-0.931884f,
    -0.932993f,	-0.934093f,	-0.935184f,	-0.936266f,
    -0.937339f,	-0.938404f,	-0.939459f,	-0.940506f,
    -0.941544f,	-0.942573f,	-0.943593f,	-0.944605f,
    -0.945607f,	-0.946601f,	-0.947586f,	-0.948561f,
    -0.949528f,	-0.950486f,	-0.951435f,	-0.952375f,
    -0.953306f,	-0.954228f,	-0.955141f,	-0.956045f,
    -0.95694f,	-0.957826f,	-0.958703f,	-0.959572f,
    -0.960431f,	-0.96128f,	-0.962121f,	-0.962953f,
    -0.963776f,	-0.96459f,	-0.965394f,	-0.96619f,
    -0.966976f,	-0.967754f,	-0.968522f,	-0.969281f,
    -0.970031f,	-0.970772f,	-0.971504f,	-0.972226f,
    -0.97294f,	-0.973644f,	-0.974339f,	-0.975025f,
    -0.975702f,	-0.97637f,	-0.977028f,	-0.977677f,
    -0.978317f,	-0.978948f,	-0.97957f,	-0.980182f,
    -0.980785f,	-0.981379f,	-0.981964f,	-0.982539f,
    -0.983105f,	-0.983662f,	-0.98421f,	-0.984749f,
    -0.985278f,	-0.985798f,	-0.986308f,	-0.986809f,
    -0.987301f,	-0.987784f,	-0.988258f,	-0.988722f,
    -0.989177f,	-0.989622f,	-0.990058f,	-0.990485f,
    -0.990903f,	-0.991311f,	-0.99171f,	-0.992099f,
    -0.99248f,	-0.99285f,	-0.993212f,	-0.993564f,
    -0.993907f,	-0.99424f,	-0.994565f,	-0.994879f,
    -0.995185f,	-0.995481f,	-0.995767f,	-0.996045f,
    -0.996313f,	-0.996571f,	-0.99682f,	-0.99706f,
    -0.99729f,	-0.997511f,	-0.997723f,	-0.997925f,
    -0.998118f,	-0.998302f,	-0.998476f,	-0.99864f,
    -0.998795f,	-0.998941f,	-0.999078f,	-0.999205f,
    -0.999322f,	-0.999431f,	-0.999529f,	-0.999619f,
    -0.999699f,	-0.999769f,	-0.999831f,	-0.999882f,
    -0.999925f,	-0.999958f,	-0.999981f,	-0.999995f,
    -1.0f,		-0.999995f,	-0.999981f,	-0.999958f,
    -0.999925f,	-0.999882f,	-0.999831f,	-0.999769f,
    -0.999699f,	-0.999619f,	-0.999529f,	-0.999431f,
    -0.999322f,	-0.999205f,	-0.999078f,	-0.998941f,
    -0.998795f,	-0.99864f,	-0.998476f,	-0.998302f,
    -0.998118f,	-0.997925f,	-0.997723f,	-0.997511f,
    -0.99729f,	-0.99706f,	-0.99682f,	-0.996571f,
    -0.996313f,	-0.996045f,	-0.995767f,	-0.995481f,
    -0.995185f,	-0.994879f,	-0.994565f,	-0.99424f,
    -0.993907f,	-0.993564f,	-0.993212f,	-0.99285f,
    -0.99248f,	-0.992099f,	-0.99171f,	-0.991311f,
    -0.990903f,	-0.990485f,	-0.990058f,	-0.989622f,
    -0.989177f,	-0.988722f,	-0.988258f,	-0.987784f,
    -0.987301f,	-0.986809f,	-0.986308f,	-0.985798f,
    -0.985278f,	-0.984749f,	-0.98421f,	-0.983662f,
    -0.983105f,	-0.982539f,	-0.981964f,	-0.981379f,
    -0.980785f,	-0.980182f,	-0.97957f,	-0.978948f,
    -0.978317f,	-0.977677f,	-0.977028f,	-0.97637f,
    -0.975702f,	-0.975025f,	-0.974339f,	-0.973644f,
    -0.97294f,	-0.972226f,	-0.971504f,	-0.970772f,
    -0.970031f,	-0.969281f,	-0.968522f,	-0.967754f,
    -0.966976f,	-0.96619f,	-0.965394f,	-0.96459f,
    -0.963776f,	-0.962953f,	-0.962121f,	-0.96128f,
    -0.960431f,	-0.959572f,	-0.958703f,	-0.957826f,
    -0.95694f,	-0.956045f,	-0.955141f,	-0.954228f,
    -0.953306f,	-0.952375f,	-0.951435f,	-0.950486f,
    -0.949528f,	-0.948561f,	-0.947586f,	-0.946601f,
    -0.945607f,	-0.944605f,	-0.943593f,	-0.942573f,
    -0.941544f,	-0.940506f,	-0.939459f,	-0.938404f,
    -0.937339f,	-0.936266f,	-0.935184f,	-0.934093f,
    -0.932993f,	-0.931884f,	-0.930767f,	-0.929641f,
    -0.928506f,	-0.927363f,	-0.92621f,	-0.925049f,
    -0.92388f,	-0.922701f,	-0.921514f,	-0.920318f,
    -0.919114f,	-0.917901f,	-0.916679f,	-0.915449f,
    -0.91421f,	-0.912962f,	-0.911706f,	-0.910441f,
    -0.909168f,	-0.907886f,	-0.906596f,	-0.905297f,
    -0.903989f,	-0.902673f,	-0.901349f,	-0.900016f,
    -0.898674f,	-0.897325f,	-0.895966f,	-0.894599f,
    -0.893224f,	-0.891841f,	-0.890449f,	-0.889048f,
    -0.88764f,	-0.886223f,	-0.884797f,	-0.883363f,
    -0.881921f,	-0.880471f,	-0.879012f,	-0.877545f,
    -0.87607f,	-0.874587f,	-0.873095f,	-0.871595f,
    -0.870087f,	-0.868571f,	-0.867046f,	-0.865514f,
    -0.863973f,	-0.862424f,	-0.860867f,	-0.859302f,
    -0.857729f,	-0.856147f,	-0.854558f,	-0.852961f,
    -0.851355f,	-0.849742f,	-0.84812f,	-0.846491f,
    -0.844854f,	-0.843208f,	-0.841555f,	-0.839894f,
    -0.838225f,	-0.836548f,	-0.834863f,	-0.83317f,
    -0.83147f,	-0.829761f,	-0.828045f,	-0.826321f,
    -0.824589f,	-0.82285f,	-0.821103f,	-0.819348f,
    -0.817585f,	-0.815814f,	-0.814036f,	-0.812251f,
    -0.810457f,	-0.808656f,	-0.806848f,	-0.805031f,
    -0.803208f,	-0.801376f,	-0.799537f,	-0.797691f,
    -0.795837f,	-0.793975f,	-0.792107f,	-0.79023f,
    -0.788346f,	-0.786455f,	-0.784557f,	-0.782651f,
    -0.780737f,	-0.778817f,	-0.776888f,	-0.774953f,
    -0.77301f,	-0.771061f,	-0.769103f,	-0.767139f,
    -0.765167f,	-0.763188f,	-0.761202f,	-0.759209f,
    -0.757209f,	-0.755201f,	-0.753187f,	-0.751165f,
    -0.749136f,	-0.747101f,	-0.745058f,	-0.743008f,
    -0.740951f,	-0.738887f,	-0.736817f,	-0.734739f,
    -0.732654f,	-0.730563f,	-0.728464f,	-0.726359f,
    -0.724247f,	-0.722128f,	-0.720003f,	-0.71787f,
    -0.715731f,	-0.713585f,	-0.711432f,	-0.709273f,
    -0.707107f,	-0.704934f,	-0.702755f,	-0.700569f,
    -0.698376f,	-0.696177f,	-0.693971f,	-0.691759f,
    -0.689541f,	-0.687315f,	-0.685084f,	-0.682846f,
    -0.680601f,	-0.67835f,	-0.676093f,	-0.673829f,
    -0.671559f,	-0.669283f,	-0.667f,		-0.664711f,
    -0.662416f,	-0.660114f,	-0.657807f,	-0.655493f,
    -0.653173f,	-0.650847f,	-0.648514f,	-0.646176f,
    -0.643832f,	-0.641481f,	-0.639124f,	-0.636762f,
    -0.634393f,	-0.632019f,	-0.629638f,	-0.627252f,
    -0.624859f,	-0.622461f,	-0.620057f,	-0.617647f,
    -0.615232f,	-0.61281f,	-0.610383f,	-0.60795f,
    -0.605511f,	-0.603067f,	-0.600616f,	-0.598161f,
    -0.595699f,	-0.593232f,	-0.59076f,	-0.588282f,
    -0.585798f,	-0.583309f,	-0.580814f,	-0.578314f,
    -0.575808f,	-0.573297f,	-0.570781f,	-0.568259f,
    -0.565732f,	-0.563199f,	-0.560662f,	-0.558119f,
    -0.55557f,	-0.553017f,	-0.550458f,	-0.547894f,
    -0.545325f,	-0.542751f,	-0.540171f,	-0.537587f,
    -0.534998f,	-0.532403f,	-0.529804f,	-0.527199f,
    -0.52459f,	-0.521975f,	-0.519356f,	-0.516732f,
    -0.514103f,	-0.511469f,	-0.50883f,	-0.506187f,
    -0.503538f,	-0.500885f,	-0.498228f,	-0.495565f,
    -0.492898f,	-0.490226f,	-0.48755f,	-0.484869f,
    -0.482184f,	-0.479494f,	-0.476799f,	-0.4741f,
    -0.471397f,	-0.468689f,	-0.465976f,	-0.46326f,
    -0.460539f,	-0.457813f,	-0.455084f,	-0.45235f,
    -0.449611f,	-0.446869f,	-0.444122f,	-0.441371f,
    -0.438616f,	-0.435857f,	-0.433094f,	-0.430326f,
    -0.427555f,	-0.42478f,	-0.422f,		-0.419217f,
    -0.41643f,	-0.413638f,	-0.410843f,	-0.408044f,
    -0.405241f,	-0.402435f,	-0.399624f,	-0.39681f,
    -0.393992f,	-0.39117f,	-0.388345f,	-0.385516f,
    -0.382683f,	-0.379847f,	-0.377007f,	-0.374164f,
    -0.371317f,	-0.368467f,	-0.365613f,	-0.362756f,
    -0.359895f,	-0.357031f,	-0.354164f,	-0.351293f,
    -0.348419f,	-0.345541f,	-0.342661f,	-0.339777f,
    -0.33689f,	-0.334f,		-0.331106f,	-0.32821f,
    -0.32531f,	-0.322408f,	-0.319502f,	-0.316593f,
    -0.313682f,	-0.310767f,	-0.30785f,	-0.304929f,
    -0.302006f,	-0.29908f,	-0.296151f,	-0.293219f,
    -0.290285f,	-0.287347f,	-0.284408f,	-0.281465f,
    -0.27852f,	-0.275572f,	-0.272621f,	-0.269668f,
    -0.266713f,	-0.263755f,	-0.260794f,	-0.257831f,
    -0.254866f,	-0.251898f,	-0.248928f,	-0.245955f,
    -0.24298f,	-0.240003f,	-0.237024f,	-0.234042f,
    -0.231058f,	-0.228072f,	-0.225084f,	-0.222094f,
    -0.219101f,	-0.216107f,	-0.21311f,	-0.210112f,
    -0.207111f,	-0.204109f,	-0.201105f,	-0.198098f,
    -0.19509f,	-0.19208f,	-0.189069f,	-0.186055f,
    -0.18304f,	-0.180023f,	-0.177004f,	-0.173984f,
    -0.170962f,	-0.167938f,	-0.164913f,	-0.161886f,
    -0.158858f,	-0.155828f,	-0.152797f,	-0.149765f,
    -0.14673f,	-0.143695f,	-0.140658f,	-0.13762f,
    -0.134581f,	-0.13154f,	-0.128498f,	-0.125455f,
    -0.122411f,	-0.119365f,	-0.116319f,	-0.113271f,
    -0.110222f,	-0.107172f,	-0.104122f,	-0.10107f,
    -0.0980171f,	-0.0949635f,	-0.091909f,	-0.0888536f,
    -0.0857973f,	-0.0827403f,	-0.0796824f,	-0.0766239f,
    -0.0735646f,	-0.0705046f,	-0.0674439f,	-0.0643826f,
    -0.0613207f,	-0.0582583f,	-0.0551952f,	-0.0521317f,
    -0.0490677f,	-0.0460032f,	-0.0429383f,	-0.0398729f,
    -0.0368072f,	-0.0337412f,	-0.0306748f,	-0.0276081f,
    -0.0245412f,	-0.0214741f,	-0.0184067f,	-0.0153392f,
    -0.0122715f,	-0.00920375f,	-0.00613588f,	-0.00306796f
};

int bn_randhalftabsize = BN_RANDHALFTABSIZE;

float bn_rand_halftab[BN_RANDHALFTABSIZE] = {
    -0.500000f, -0.499015f, -0.458369f, -0.323357f, -0.135398f, -0.408669f, -0.407702f,
    -0.012783f,  0.026750f, -0.045567f, -0.266822f,  0.331292f,  0.431731f,  0.068060f,
    0.056094f, -0.449168f,  0.267051f, -0.481085f, -0.247640f, -0.201803f,  0.375981f,
    0.031557f,  0.420261f,  0.015431f,  0.310429f, -0.311580f,  0.386314f,  0.070614f,
    -0.423225f,  0.315274f,  0.484891f, -0.381648f,  0.393906f,  0.284484f, -0.399084f,
    -0.246689f, -0.480158f, -0.121623f,  0.178877f,  0.180923f,  0.252707f, -0.493771f,
    0.124407f, -0.373538f,  0.117550f,  0.270928f, -0.313464f, -0.003278f,  0.009500f,
    -0.184061f,  0.201703f, -0.132753f,  0.376312f, -0.129005f,  0.025252f, -0.072165f,
    0.042743f,  0.167979f, -0.328858f,  0.330779f,  0.361905f,  0.269221f, -0.447421f,
    0.466730f, -0.165716f, -0.417903f, -0.229685f, -0.425738f,  0.176226f,  0.310159f,
    -0.035789f,  0.069185f,  0.012203f,  0.086510f,  0.238759f,  0.371689f,  0.077967f,
    0.464704f, -0.166471f, -0.107172f, -0.323072f, -0.388131f,  0.352681f,  0.311172f,
    0.454887f,  0.404283f, -0.361085f,  0.186187f, -0.373013f, -0.495910f, -0.499497f,
    -0.307048f,  0.086780f, -0.125041f, -0.473214f, -0.035235f,  0.285343f, -0.057765f,
    -0.212096f,  0.353353f,  0.025972f,  0.228417f, -0.233686f,  0.283484f, -0.031956f,
    -0.303003f, -0.052823f,  0.228440f,  0.466093f,  0.256841f, -0.033943f,  0.368966f,
    -0.365961f,  0.346053f, -0.481912f,  0.440855f,  0.170082f,  0.299972f, -0.356783f,
    0.110460f,  0.408283f,  0.274415f, -0.133935f,  0.444288f,  0.384822f, -0.054829f,
    -0.336972f, -0.075183f, -0.020146f, -0.468872f,  0.108430f,  0.292261f, -0.317503f,
    0.025121f,  0.398759f, -0.191210f,  0.442626f, -0.111975f,  0.430512f,  0.411384f,
    -0.162282f,  0.032812f,  0.202077f,  0.471011f,  0.268085f,  0.251941f, -0.409136f,
    0.353967f, -0.325356f, -0.480230f, -0.080946f, -0.203630f, -0.121768f, -0.081284f,
    -0.361552f, -0.119153f, -0.200220f, -0.478988f, -0.261197f, -0.462891f, -0.278941f,
    0.025435f, -0.005475f,  0.382522f,  0.273830f, -0.440998f, -0.380199f,  0.047801f,
    -0.158084f, -0.043188f,  0.088122f,  0.085150f, -0.430073f,  0.318931f, -0.096839f,
    0.085483f, -0.308839f,  0.392277f, -0.323668f, -0.292296f, -0.384252f, -0.341085f,
    0.492644f,  0.181571f,  0.311796f,  0.142215f, -0.170658f,  0.237553f,  0.323483f,
    0.221261f,  0.157982f, -0.141226f,  0.110365f, -0.084996f,  0.314954f,  0.273965f,
    -0.225689f, -0.455258f,  0.101041f,  0.014091f,  0.130215f, -0.319107f, -0.221499f,
    -0.047511f,  0.142986f,  0.242832f, -0.086345f,  0.118052f,  0.118289f,  0.354436f,
    -0.318543f, -0.192072f, -0.476672f, -0.490818f,  0.451453f,  0.490755f, -0.295060f,
    0.104093f,  0.435652f,  0.059567f,  0.046866f, -0.060872f, -0.050248f, -0.193195f,
    -0.299186f, -0.284200f, -0.450104f, -0.290439f,  0.074563f,  0.414820f, -0.084390f,
    0.154159f, -0.144299f,  0.086702f, -0.108054f, -0.466150f, -0.214484f, -0.408396f,
    -0.055615f,  0.425937f,  0.421284f,  0.105927f,  0.361146f, -0.485283f,  0.186701f,
    0.344568f, -0.370353f, -0.440344f, -0.486928f, -0.108841f,  0.365676f, -0.484943f,
    0.424289f,  0.386719f,  0.162069f,  0.154911f, -0.423660f, -0.407023f, -0.496748f,
    0.026670f,  0.289756f,  0.154019f,  0.045893f,  0.298389f,  0.226753f, -0.246685f,
    -0.244754f, -0.361646f, -0.017051f, -0.032413f, -0.399124f,  0.004214f,  0.358395f,
    -0.489952f,  0.321570f,  0.464318f, -0.480541f,  0.429619f, -0.436920f, -0.462038f,
    -0.309743f, -0.223334f, -0.052686f,  0.149382f, -0.348877f, -0.012845f,  0.149658f,
    0.034280f, -0.143198f, -0.105884f,  0.221992f,  0.224702f, -0.193859f, -0.393419f,
    0.410780f,  0.240914f, -0.260942f,  0.151344f, -0.131589f, -0.473819f,  0.349258f,
    -0.458184f, -0.443879f, -0.073961f, -0.020267f,  0.001694f,  0.480527f,  0.107505f,
    0.412656f,  0.250416f,  0.213813f,  0.471132f, -0.470788f, -0.235711f, -0.481689f,
    -0.419324f, -0.345364f, -0.385648f,  0.256538f,  0.438249f, -0.371196f,  0.092612f,
    -0.377476f,  0.099178f, -0.434127f, -0.243974f, -0.087549f,  0.448387f, -0.146505f,
    -0.483004f,  0.473425f,  0.262359f,  0.361975f, -0.094870f,  0.367867f, -0.463239f,
    -0.291521f, -0.076667f,  0.484823f,  0.064353f,  0.076262f, -0.031777f, -0.035840f,
    0.261121f, -0.197916f, -0.082743f, -0.401476f, -0.363154f,  0.198138f, -0.319552f,
    0.393077f,  0.230879f, -0.197713f, -0.358782f,  0.324100f, -0.057797f,  0.090112f,
    0.477622f,  0.002689f,  0.397659f,  0.224808f, -0.238718f, -0.044965f, -0.238042f,
    0.460489f, -0.483069f,  0.440439f,  0.401961f, -0.402129f,  0.021122f, -0.415298f,
    0.295402f,  0.368910f, -0.404218f,  0.380272f, -0.493994f, -0.297988f, -0.027361f,
    0.144231f,  0.433968f, -0.401574f,  0.070898f,  0.007583f,  0.159436f,  0.392915f,
    0.235755f,  0.189250f,  0.309339f, -0.259591f,  0.263515f,  0.268728f,  0.042360f,
    -0.018949f, -0.085620f, -0.426432f,  0.026698f,  0.007623f,  0.251598f, -0.368907f,
    -0.490624f,  0.263973f, -0.398807f,  0.465288f, -0.410756f, -0.384080f,  0.396274f,
    0.245246f, -0.281470f,  0.085460f, -0.259207f,  0.384460f, -0.103907f, -0.443497f,
    0.427216f, -0.047580f,  0.370782f, -0.269769f, -0.011038f,  0.071254f,  0.352889f,
    -0.281636f,  0.420511f, -0.461374f, -0.091610f, -0.446181f, -0.394838f,  0.029782f,
    0.072954f, -0.385506f, -0.457432f,  0.000902f,  0.224749f, -0.005769f, -0.153914f,
    -0.464925f, -0.133495f,  0.415601f,  0.004929f,  0.361768f,  0.423538f, -0.484653f,
    -0.210038f, -0.260642f,  0.216462f, -0.398427f,  0.277378f, -0.255338f, -0.068337f,
    0.091599f,  0.014516f,  0.268635f,  0.221587f,  0.303579f,  0.240518f,  0.006180f,
    0.318314f, -0.440736f,  0.075870f,  0.361748f,  0.051174f,  0.328654f, -0.375942f,
    0.210174f, -0.498428f, -0.468203f, -0.208656f,  0.171436f, -0.199763f, -0.066163f,
    -0.226704f, -0.375709f, -0.365671f, -0.395057f, -0.083967f,  0.320584f, -0.239878f,
    -0.351670f, -0.486122f, -0.278728f, -0.147085f,  0.261930f, -0.078797f,  0.186691f,
    0.026691f, -0.170121f, -0.356356f, -0.124642f,  0.244665f,  0.229884f,  0.231954f,
    -0.326240f,  0.056697f,  0.185514f,  0.370456f,  0.058393f, -0.155261f,  0.035651f,
    0.462264f,  0.423171f,  0.252715f,  0.186961f, -0.163834f, -0.139267f,  0.207908f,
    0.162554f, -0.102549f, -0.486259f, -0.092049f,  0.167512f, -0.280554f, -0.411183f,
    0.117571f, -0.480818f, -0.282758f, -0.293945f, -0.125515f, -0.100177f, -0.206052f,
    0.024278f,  0.292152f, -0.102900f,  0.227059f,  0.197282f,  0.131985f, -0.376958f,
    0.233361f, -0.331294f, -0.471892f, -0.283510f, -0.329201f, -0.329917f,  0.028646f,
    -0.187107f,  0.401156f, -0.056281f, -0.420847f, -0.363008f,  0.035290f,  0.142834f,
    0.342087f,  0.469753f, -0.159588f, -0.132289f,  0.212868f, -0.454353f, -0.375227f,
    -0.241712f,  0.465184f,  0.337492f,  0.187851f,  0.188702f,  0.308773f,  0.024610f,
    0.083177f,  0.183919f, -0.039746f,  0.259754f, -0.223717f, -0.183072f, -0.434033f,
    -0.351594f, -0.027379f, -0.260416f,  0.444774f, -0.169420f, -0.239055f, -0.328651f,
    0.373876f,  0.363814f, -0.021525f, -0.283242f,  0.272772f, -0.397296f, -0.292259f,
    -0.269007f, -0.333827f, -0.234980f,  0.304494f, -0.391500f, -0.241745f,  0.379562f,
    -0.284800f,  0.165078f,  0.125837f,  0.292525f, -0.154049f,  0.130425f, -0.249486f,
    -0.464024f,  0.306997f, -0.094915f, -0.061596f,  0.256344f,  0.284341f, -0.019665f,
    0.215900f, -0.112299f, -0.471832f, -0.082507f,  0.400804f,  0.112354f,  0.334165f,
    0.257822f,  0.106587f,  0.361440f, -0.094292f, -0.262370f,  0.084804f, -0.394757f,
    -0.009542f,  0.345010f,  0.204126f, -0.395349f,  0.192993f, -0.466904f, -0.073107f,
    0.232294f, -0.224868f, -0.164259f, -0.185981f, -0.281609f,  0.107551f,  0.079483f,
    -0.429413f, -0.020660f, -0.339120f, -0.207083f,  0.157304f,  0.496661f, -0.407034f,
    -0.448374f, -0.477548f,  0.433532f, -0.436705f,  0.212304f,  0.056107f, -0.087852f,
    0.488242f, -0.039640f,  0.199764f,  0.187137f,  0.035025f,  0.076024f,  0.042324f,
    0.100958f, -0.128247f,  0.397791f, -0.254440f, -0.087608f,  0.070197f, -0.209937f,
    0.332116f, -0.232131f, -0.238060f, -0.006680f, -0.434049f, -0.390461f, -0.266999f,
    0.117532f,  0.203576f, -0.241134f,  0.303192f, -0.371813f, -0.095086f,  0.308443f,
    -0.338734f, -0.056969f,  0.190954f, -0.470903f,  0.042918f,  0.008058f,  0.413377f,
    -0.061190f,  0.363972f,  0.333358f,  0.165999f,  0.372171f,  0.414567f, -0.348833f,
    -0.407734f,  0.174812f, -0.368879f,  0.395940f, -0.184494f, -0.429422f,  0.081422f,
    -0.286190f,  0.193284f, -0.193001f,  0.304998f,  0.378733f,  0.243849f,  0.077276f,
    0.367274f,  0.345470f,  0.146554f, -0.402273f,  0.123799f,  0.303995f,  0.430262f,
    -0.055114f, -0.397387f,  0.442635f,  0.350835f, -0.364147f,  0.341756f,  0.183185f,
    0.052864f,  0.481669f, -0.151227f,  0.253355f, -0.290103f, -0.077681f,  0.354310f,
    -0.478591f, -0.245091f,  0.032371f,  0.127505f,  0.273860f,  0.127729f,  0.290272f,
    -0.387465f,  0.387194f,  0.273443f,  0.357243f, -0.020264f,  0.274054f, -0.214395f,
    -0.208276f, -0.302061f, -0.202996f, -0.023458f, -0.186022f, -0.095191f,  0.090476f,
    -0.084355f,  0.367308f, -0.453065f, -0.456189f,  0.262543f, -0.065006f, -0.009693f,
    0.033305f,  0.458349f, -0.043501f,  0.463680f, -0.114846f, -0.036864f, -0.463540f,
    -0.167424f,  0.368259f,  0.445686f,  0.202766f, -0.259352f, -0.301502f,  0.361911f,
    0.195628f, -0.330634f,  0.354752f, -0.313326f, -0.438593f,  0.418223f, -0.189645f,
    -0.309040f, -0.210489f,  0.498560f, -0.251602f,  0.348987f, -0.072578f, -0.042250f,
    0.210492f,  0.000323f, -0.199388f, -0.159290f, -0.490998f,  0.327981f, -0.133422f,
    0.376902f, -0.226300f,  0.108564f,  0.264369f, -0.281803f, -0.305588f, -0.126379f,
    0.154893f, -0.298101f, -0.071032f, -0.062505f, -0.441803f,  0.370058f,  0.166101f,
    -0.193844f, -0.389904f,  0.427995f,  0.439546f, -0.089984f, -0.286606f,  0.199112f,
    -0.215856f, -0.207019f,  0.133189f,  0.047851f,  0.087271f,  0.247304f, -0.431052f,
    0.456784f,  0.227227f, -0.418013f,  0.469032f, -0.393200f, -0.409359f, -0.059975f,
    -0.119828f,  0.211056f,  0.437598f, -0.209217f,  0.441990f, -0.325311f, -0.471477f,
    -0.112013f,  0.445305f,  0.214289f, -0.038621f, -0.163455f,  0.325957f,  0.085883f,
    0.390016f,  0.203631f,  0.419677f,  0.390181f,  0.131414f, -0.142152f, -0.432341f,
    0.292193f,  0.125854f, -0.043028f,  0.249714f, -0.207092f,  0.122832f,  0.027660f,
    0.297972f,  0.197903f, -0.262108f, -0.296908f,  0.078003f,  0.056564f,  0.400761f,
    0.485825f, -0.061966f, -0.098274f, -0.489431f, -0.022004f,  0.045855f, -0.450730f,
    -0.024846f,  0.229667f, -0.264724f, -0.142568f,  0.461916f, -0.425358f, -0.348784f,
    -0.326120f,  0.179416f, -0.307006f,  0.249040f, -0.416921f,  0.471513f, -0.181836f,
    0.207502f,  0.016010f,  0.397557f,  0.416574f, -0.353688f,  0.198158f,  0.328978f,
    0.247776f,  0.492856f,  0.330125f,  0.278833f,  0.167334f,  0.165123f, -0.251352f,
    -0.361083f,  0.082616f, -0.120460f, -0.324258f,  0.499364f,  0.098802f,  0.256520f,
    0.491894f,  0.116913f, -0.400299f, -0.410397f,  0.368316f,  0.056957f,  0.061984f,
    -0.274424f,  0.056367f,  0.316021f,  0.084443f,  0.235675f, -0.206804f,  0.418379f,
    -0.026336f, -0.342279f, -0.334208f,  0.234353f,  0.327632f,  0.474665f, -0.453953f,
    -0.422412f,  0.228267f,  0.038749f,  0.422804f, -0.428267f, -0.262485f,  0.427368f,
    -0.190566f,  0.228931f,  0.499725f, -0.244823f, -0.015832f, -0.372977f,  0.011578f,
    0.498390f,  0.352830f, -0.188938f, -0.078564f,  0.096208f, -0.172181f, -0.042378f,
    -0.030116f,  0.368525f,  0.052036f,  0.135386f, -0.444783f, -0.030651f, -0.288659f,
    -0.041250f, -0.409735f,  0.225661f,  0.364116f, -0.322971f,  0.264288f, -0.211151f,
    -0.147808f,  0.462524f, -0.494590f, -0.249533f, -0.234822f,  0.376898f, -0.409354f,
    0.399379f, -0.178095f,  0.305478f,  0.222877f, -0.020415f, -0.239099f, -0.019876f,
    0.003812f,  0.457014f,  0.139628f, -0.431971f,  0.111262f, -0.068276f, -0.286500f,
    -0.480814f, -0.064233f,  0.405344f,  0.074822f, -0.149439f, -0.240755f, -0.198985f,
    0.393831f, -0.460703f,  0.346019f, -0.443363f,  0.224551f, -0.481849f, -0.341033f,
    -0.402830f, -0.136329f,  0.059112f,  0.171062f, -0.183701f,  0.017762f,  0.319621f,
    0.291155f,  0.343438f,  0.020703f,  0.061588f, -0.095880f,  0.273436f,  0.417080f,
    0.166449f, -0.403355f,  0.331045f, -0.102442f, -0.482151f, -0.276101f,  0.221142f,
    -0.261926f,  0.143250f, -0.492568f,  0.472757f, -0.403718f, -0.438871f,  0.045193f,
    0.167218f, -0.313391f,  0.013874f, -0.319904f,  0.498382f, -0.439094f,  0.448419f,
    0.099510f,  0.049341f,  0.426818f, -0.414164f, -0.174557f, -0.408500f, -0.256681f,
    0.374161f,  0.170519f,  0.178279f, -0.264615f,  0.300649f,  0.060397f,  0.079377f,
    0.101434f,  0.033374f,  0.406955f,  0.398543f,  0.072246f,  0.328797f, -0.478302f,
    -0.043016f, -0.216301f,  0.070828f, -0.285288f, -0.422018f, -0.296508f,  0.265427f,
    0.075654f,  0.351232f,  0.300253f,  0.198410f,  0.090226f, -0.183897f, -0.150857f,
    0.246505f,  0.334178f, -0.487030f, -0.041389f, -0.185442f, -0.101167f, -0.304501f,
    0.196660f, -0.064955f,  0.344583f, -0.437994f, -0.149485f,  0.417694f,  0.024647f,
    0.491565f,  0.020446f,  0.363173f,  0.259068f,  0.004339f, -0.283352f, -0.030222f,
    -0.477386f, -0.497220f, -0.421718f,  0.058127f,  0.009557f, -0.009003f,  0.087194f,
    -0.363319f,  0.388720f, -0.432879f,  0.417522f,  0.229000f, -0.485458f,  0.394317f,
    0.198749f,  0.008778f,  0.330970f,  0.389769f, -0.282931f,  0.045829f,  0.226788f,
    0.040194f,  0.321913f, -0.011792f, -0.028416f, -0.476917f, -0.184456f,  0.203843f,
    -0.105745f, -0.146217f,  0.298884f,  0.018482f, -0.260054f, -0.288116f, -0.368264f,
    0.033013f,  0.251298f,  0.251321f,  0.286716f,  0.227639f, -0.173760f, -0.154600f,
    -0.229662f,  0.386705f, -0.016796f, -0.157810f, -0.070609f,  0.357912f, -0.042750f,
    -0.058172f, -0.275878f,  0.423117f, -0.285669f,  0.393024f,  0.440692f,  0.062849f,
    0.428692f,  0.432247f, -0.266865f,  0.179310f, -0.041392f,  0.049636f,  0.369865f,
    0.267137f, -0.217457f, -0.492280f, -0.457836f, -0.469984f, -0.059132f,  0.012701f,
    0.143365f, -0.195173f, -0.246838f,  0.446721f, -0.490388f, -0.277933f, -0.051530f,
    0.219603f, -0.171478f,  0.478476f, -0.377371f, -0.350390f,  0.264120f,  0.180142f,
    0.404895f,  0.097538f, -0.051256f,  0.014675f, -0.076450f, -0.427322f,  0.379651f,
    -0.309324f,  0.170467f,  0.121910f, -0.405083f,  0.130738f, -0.493291f, -0.123608f,
    0.345452f,  0.388160f, -0.329914f, -0.260739f, -0.476050f,  0.072789f,  0.351269f,
    -0.119268f,  0.444195f,  0.191683f,  0.323838f,  0.195405f,  0.412952f, -0.462713f,
    0.136848f, -0.144848f,  0.019772f,  0.469465f,  0.413557f, -0.052853f, -0.053678f,
    -0.154001f, -0.480367f, -0.238545f,  0.015637f, -0.254753f, -0.043083f, -0.370082f,
    -0.046942f, -0.391291f,  0.258816f, -0.185018f, -0.404742f,  0.202795f,  0.380336f,
    0.003814f,  0.382905f, -0.121541f, -0.175053f, -0.367183f,  0.118121f, -0.406588f,
    -0.217037f, -0.092970f, -0.487533f, -0.019140f, -0.111534f, -0.202710f, -0.262046f,
    -0.093772f,  0.366229f,  0.008332f,  0.406234f, -0.217953f,  0.134451f,  0.378872f,
    0.414181f, -0.177839f,  0.166958f,  0.069162f,  0.322480f,  0.149076f,  0.178790f,
    0.334634f,  0.183346f, -0.460139f, -0.423293f, -0.498813f,  0.450310f, -0.247911f,
    -0.028717f, -0.273247f,  0.124113f,  0.035527f,  0.256020f,  0.236531f,  0.091635f,
    0.159339f, -0.037180f,  0.390126f, -0.432367f,  0.198431f, -0.040498f,  0.315614f,
    0.160686f,  0.384149f,  0.486607f,  0.018981f, -0.245507f, -0.429945f,  0.476077f,
    0.141506f, -0.336319f, -0.342843f,  0.257526f, -0.360586f,  0.320092f, -0.392817f,
    0.358541f,  0.049849f, -0.357438f,  0.217704f, -0.370929f,  0.088139f, -0.297755f,
    0.487886f,  0.367485f, -0.300113f, -0.080731f,  0.344964f,  0.263875f,  0.427290f,
    -0.192055f,  0.484243f, -0.413104f, -0.195182f, -0.139210f, -0.317544f,  0.171749f,
    0.190921f,  0.050655f, -0.163249f, -0.017780f, -0.111366f,  0.300260f,  0.148797f,
    -0.351809f, -0.019045f,  0.175137f, -0.117203f, -0.233611f,  0.081803f, -0.304289f,
    0.373085f, -0.493279f,  0.208614f,  0.123765f, -0.084852f,  0.315312f,  0.449603f,
    -0.414446f, -0.354939f,  0.139990f, -0.288034f, -0.433575f, -0.123656f, -0.468479f,
    -0.015391f,  0.408717f, -0.171802f,  0.367443f, -0.428981f, -0.384487f, -0.469010f,
    0.493182f,  0.188779f, -0.202635f, -0.451876f, -0.268561f, -0.311111f, -0.321804f,
    0.200310f, -0.054628f,  0.120769f, -0.478555f,  0.239290f, -0.110920f, -0.389145f,
    0.360067f,  0.492008f, -0.308479f, -0.109419f,  0.366816f,  0.309570f,  0.013588f,
    -0.387284f, -0.172598f, -0.286699f,  0.225136f, -0.153687f,  0.362519f, -0.234538f,
    -0.333064f,  0.305679f,  0.059730f, -0.183821f,  0.005394f,  0.116738f, -0.062203f,
    0.129843f,  0.434541f, -0.122954f, -0.019967f, -0.208716f, -0.375057f, -0.251358f,
    -0.214265f,  0.379704f, -0.276845f, -0.385653f, -0.463172f,  0.400472f, -0.255808f,
    0.409281f,  0.437958f, -0.066897f, -0.485273f, -0.454923f,  0.430538f,  0.017967f,
    0.073622f, -0.487979f, -0.186402f,  0.422511f, -0.458163f, -0.134950f,  0.326002f,
    0.136185f, -0.125879f, -0.332822f,  0.295772f,  0.106054f,  0.304405f,  0.325447f,
    0.073578f, -0.215338f,  0.415067f, -0.439759f,  0.210131f,  0.288616f, -0.417261f,
    -0.098047f, -0.326711f, -0.290840f, -0.419137f, -0.283848f, -0.067449f,  0.051529f,
    -0.381413f, -0.121064f,  0.459541f, -0.337078f,  0.348858f,  0.120969f,  0.236834f,
    -0.077375f, -0.066302f, -0.052524f,  0.258419f, -0.426848f,  0.175066f,  0.341202f,
    -0.091662f, -0.142386f, -0.165485f,  0.038076f,  0.075211f, -0.336785f,  0.418796f,
    -0.393676f,  0.095726f,  0.049330f,  0.011954f,  0.387244f,  0.206708f, -0.165361f,
    -0.186663f,  0.301359f,  0.350575f, -0.366904f,  0.286856f, -0.228306f, -0.458989f,
    -0.257063f, -0.352996f,  0.454203f, -0.186632f,  0.314484f,  0.474507f, -0.065273f,
    0.206990f,  0.037349f, -0.242627f,  0.096220f, -0.455553f,  0.310013f, -0.454228f,
    -0.023576f, -0.333800f,  0.177027f, -0.338745f, -0.175101f, -0.430238f, -0.238185f,
    -0.252311f, -0.117374f, -0.198046f,  0.084789f,  0.143897f, -0.496224f, -0.186175f,
    -0.035920f,  0.113021f,  0.427207f, -0.446534f, -0.345525f,  0.413185f, -0.202473f,
    -0.273952f,  0.322072f, -0.163920f,  0.398007f,  0.167324f, -0.210948f,  0.488052f,
    0.159081f,  0.071688f, -0.046205f,  0.321241f,  0.468828f,  0.194289f,  0.214007f,
    -0.164965f, -0.039191f,  0.054900f,  0.239870f,  0.320949f,  0.068241f, -0.053732f,
    -0.215803f,  0.392918f, -0.306727f, -0.331035f,  0.428969f,  0.471575f,  0.280508f,
    0.246505f,  0.382217f,  0.032594f, -0.457273f, -0.072480f, -0.385880f, -0.291637f,
    0.154755f, -0.044541f, -0.207542f,  0.187791f,  0.202502f,  0.420668f,  0.009505f,
    0.494804f, -0.204417f, -0.064545f,  0.127437f, -0.138009f,  0.473598f,  0.461148f,
    0.477835f, -0.462885f,  0.261651f, -0.170826f,  0.481592f,  0.467897f,  0.066275f,
    -0.061753f, -0.314828f, -0.328882f, -0.391688f,  0.270143f,  0.492625f, -0.012013f,
    0.027081f, -0.119016f,  0.093073f, -0.093354f,  0.376210f, -0.082140f,  0.401626f,
    -0.241811f,  0.384765f, -0.352939f,  0.237169f,  0.193719f,  0.449832f,  0.015805f,
    0.020547f, -0.228556f, -0.066338f, -0.399562f,  0.386825f,  0.335098f,  0.488304f,
    0.007551f, -0.260704f, -0.226117f, -0.445393f,  0.117876f, -0.267731f, -0.388628f,
    0.065301f,  0.114287f,  0.334536f, -0.416407f,  0.111145f, -0.226397f, -0.296403f,
    0.107668f,  0.245774f, -0.323437f, -0.121547f,  0.000391f, -0.247291f, -0.408702f,
    -0.109699f,  0.435090f, -0.425750f,  0.493645f,  0.488120f,  0.394795f,  0.406675f,
    0.323868f,  0.300500f, -0.474589f,  0.352777f,  0.355856f,  0.004720f, -0.434688f,
    0.347622f, -0.175961f,  0.375781f,  0.444100f, -0.353810f,  0.458380f, -0.053221f,
    -0.264575f, -0.005171f, -0.297430f,  0.260606f, -0.285352f, -0.331852f,  0.409480f,
    0.242681f, -0.374876f, -0.492012f, -0.364069f,  0.314445f,  0.476235f,  0.073493f,
    0.101694f,  0.315135f,  0.376542f,  0.326305f, -0.118407f, -0.249638f, -0.092856f,
    0.210808f, -0.198491f,  0.063884f, -0.260748f, -0.472397f, -0.213410f, -0.414517f,
    -0.262069f, -0.426421f,  0.431197f,  0.172837f,  0.328006f, -0.228257f,  0.333826f,
    -0.203165f,  0.351203f, -0.470755f,  0.165862f, -0.046066f, -0.045853f, -0.363376f,
    0.060636f, -0.309750f, -0.081036f, -0.097555f,  0.149457f, -0.367563f,  0.001697f,
    0.355203f,  0.005375f,  0.010586f,  0.263841f,  0.142102f,  0.345430f, -0.423030f,
    -0.429947f,  0.318454f, -0.309617f,  0.248236f, -0.352906f, -0.388426f,  0.280798f,
    0.482528f, -0.362512f,  0.221836f, -0.466556f, -0.070071f,  0.484188f,  0.006897f,
    -0.283093f, -0.074214f, -0.186898f,  0.401832f,  0.494886f,  0.421071f,  0.067770f,
    0.030230f,  0.085761f,  0.029434f,  0.339625f, -0.265722f,  0.213790f, -0.087617f,
    -0.261712f,  0.223922f, -0.132268f,  0.195904f, -0.114597f,  0.447667f,  0.364276f,
    -0.184641f, -0.415947f,  0.305205f, -0.045367f,  0.000723f,  0.321188f,  0.342303f,
    0.471657f, -0.250926f, -0.324568f,  0.432329f,  0.441544f,  0.371859f,  0.115774f,
    0.200133f, -0.031729f, -0.334894f,  0.041913f, -0.419983f,  0.221437f,  0.123834f,
    0.204269f, -0.379748f, -0.159908f,  0.427890f,  0.086205f, -0.394541f,  0.218574f,
    -0.236022f,  0.183786f,  0.121574f, -0.182225f,  0.344533f, -0.103947f, -0.354385f,
    0.089811f,  0.243095f,  0.473529f,  0.116789f, -0.300445f, -0.278848f, -0.037617f,
    0.202425f, -0.252647f, -0.016042f, -0.360245f,  0.280739f,  0.058478f, -0.487941f,
    0.141422f, -0.355397f,  0.112164f,  0.088409f,  0.430802f, -0.088504f,  0.282728f,
    -0.476404f,  0.308846f, -0.117011f,  0.094168f,  0.097488f,  0.193359f,  0.113878f,
    -0.374654f,  0.436225f,  0.045568f, -0.338968f, -0.086479f,  0.058899f,  0.248381f,
    0.022858f, -0.301574f,  0.116436f, -0.132337f,  0.242770f, -0.473345f, -0.057769f,
    0.493518f, -0.171766f, -0.363071f,  0.304343f, -0.033005f,  0.277774f,  0.101470f,
    -0.365215f, -0.031333f,  0.062146f, -0.021482f, -0.216702f,  0.164502f,  0.275801f,
    0.197942f, -0.150580f,  0.372217f,  0.467464f,  0.158377f, -0.435341f, -0.205338f,
    0.433524f, -0.446395f,  0.280780f, -0.452188f, -0.222244f,  0.401764f,  0.453805f,
    -0.462475f, -0.478525f,  0.147751f,  0.257365f, -0.225107f, -0.091483f, -0.287927f,
    -0.397197f, -0.206188f,  0.161451f, -0.476115f, -0.045723f,  0.291036f,  0.384505f,
    -0.401519f,  0.300586f,  0.058916f,  0.102915f,  0.186858f, -0.044848f, -0.149919f,
    0.309495f,  0.164800f,  0.303306f, -0.106752f,  0.041534f,  0.259297f, -0.418380f,
    0.277251f, -0.177552f,  0.189926f,  0.465501f, -0.490784f,  0.113782f,  0.481322f,
    -0.055195f, -0.079051f, -0.221955f, -0.129669f,  0.296980f, -0.300751f,  0.448616f,
    0.068254f,  0.115737f, -0.379330f,  0.339720f, -0.033674f,  0.340860f, -0.185404f,
    0.060578f, -0.097110f,  0.160201f,  0.311383f,  0.279788f,  0.196366f, -0.055087f,
    -0.228742f, -0.071801f,  0.032109f,  0.038406f, -0.332957f,  0.043942f, -0.142554f,
    0.081409f, -0.392750f,  0.317450f,  0.461980f, -0.468983f,  0.249290f,  0.056345f,
    -0.185295f,  0.359900f, -0.055497f,  0.282021f, -0.198793f,  0.420450f,  0.472183f,
    0.316743f,  0.199598f,  0.272882f, -0.180957f, -0.199457f,  0.389655f,  0.129990f,
    0.319758f,  0.072467f,  0.383580f,  0.016053f, -0.265279f,  0.195443f,  0.166879f,
    -0.096863f,  0.160429f,  0.235886f,  0.053013f, -0.067125f,  0.468585f,  0.318926f,
    -0.315018f,  0.391771f,  0.190745f,  0.261813f, -0.498963f, -0.252602f,  0.110117f,
    0.488672f,  0.350780f,  0.214053f,  0.010719f,  0.399577f, -0.426530f,  0.269854f,
    0.051878f,  0.309125f,  0.194201f, -0.358346f, -0.416057f, -0.409096f,  0.058289f,
    0.186223f,  0.165741f,  0.323860f,  0.202975f,  0.080760f,  0.367913f, -0.202548f,
    -0.307909f, -0.123952f,  0.196702f, -0.089708f, -0.461908f,  0.422462f, -0.286524f,
    0.210788f,  0.371927f, -0.058028f,  0.485415f, -0.049897f, -0.249805f, -0.344516f,
    -0.272971f, -0.377205f, -0.392792f,  0.280031f,  0.490881f, -0.412956f,  0.453954f,
    0.357873f, -0.334912f,  0.215937f, -0.276075f,  0.071455f,  0.226387f, -0.181625f,
    -0.214352f, -0.185861f, -0.411949f,  0.170504f, -0.157789f,  0.034760f, -0.355398f,
    -0.243002f,  0.368607f, -0.459541f,  0.438484f, -0.220082f,  0.188305f, -0.358836f,
    0.211848f,  0.148426f,  0.441802f, -0.057036f, -0.071042f,  0.215349f, -0.126721f,
    -0.233138f,  0.396931f,  0.130043f,  0.268814f, -0.317264f, -0.374537f, -0.312631f,
    -0.126589f,  0.432470f, -0.433512f,  0.279681f, -0.062446f,  0.076047f,  0.394637f,
    -0.484959f, -0.419094f, -0.137064f, -0.173307f, -0.283630f,  0.185536f, -0.480515f,
    -0.053475f, -0.468203f, -0.041337f,  0.090483f, -0.319765f,  0.388162f, -0.058833f,
    0.497017f, -0.450667f,  0.332654f,  0.029120f, -0.281333f, -0.022143f, -0.289706f,
    -0.141581f,  0.199641f,  0.118578f,  0.098752f,  0.154717f,  0.267362f, -0.464668f,
    0.401469f,  0.240419f,  0.168201f, -0.209704f,  0.122922f,  0.326312f, -0.273473f,
    -0.040400f, -0.293093f,  0.396932f, -0.343970f, -0.223568f, -0.296113f,  0.465937f,
    -0.439153f, -0.318080f,  0.193856f, -0.338677f, -0.399493f, -0.229732f, -0.223046f,
    -0.428435f,  0.427838f, -0.068807f, -0.041420f,  0.004550f,  0.191221f,  0.420709f,
    -0.494552f,  0.384072f,  0.298805f,  0.397271f,  0.393424f,  0.426872f,  0.027324f,
    0.426490f,  0.069878f,  0.140417f, -0.495010f, -0.368130f, -0.371644f,  0.082388f,
    -0.232204f, -0.385157f,  0.060723f, -0.107944f,  0.470563f, -0.186168f,  0.383471f,
    0.397175f, -0.004278f, -0.036138f,  0.205974f, -0.186075f, -0.460419f,  0.365837f,
    0.247261f,  0.278708f, -0.258698f, -0.096175f, -0.354027f, -0.093163f,  0.355806f,
    0.051239f,  0.330018f, -0.117577f, -0.261770f,  0.389923f, -0.394202f, -0.495025f,
    -0.287718f, -0.397418f, -0.167436f,  0.300681f,  0.024171f,  0.177334f,  0.109395f,
    0.040134f, -0.348161f, -0.362550f,  0.317563f, -0.029937f, -0.061525f,  0.449312f,
    0.329849f, -0.414277f, -0.129821f, -0.397377f,  0.374018f, -0.445164f, -0.081104f,
    0.449931f,  0.276622f, -0.193968f,  0.149972f, -0.245835f, -0.074929f, -0.442392f,
    -0.246045f,  0.055353f, -0.216699f,  0.070069f, -0.362600f, -0.271123f, -0.354884f,
    -0.067422f,  0.108733f,  0.280959f,  0.178318f, -0.345674f,  0.261824f,  0.091675f,
    -0.175757f, -0.467522f,  0.209247f, -0.433569f, -0.403667f,  0.155093f,  0.494792f,
    0.353789f, -0.453616f,  0.307202f, -0.455779f,  0.306807f, -0.380622f,  0.458514f,
    -0.053677f,  0.348305f,  0.232101f, -0.209719f,  0.322907f, -0.495186f, -0.175412f,
    -0.124667f,  0.004440f, -0.477622f,  0.437756f, -0.441206f,  0.213791f, -0.391801f,
    -0.140723f,  0.337343f, -0.161820f, -0.340391f,  0.299907f,  0.032939f, -0.418641f,
    -0.434431f, -0.135705f, -0.126172f, -0.395208f, -0.218637f,  0.167051f,  0.193436f,
    0.036756f, -0.114840f,  0.423095f, -0.061175f, -0.371374f,  0.492466f, -0.229546f,
    -0.461931f, -0.376948f,  0.013243f, -0.273424f, -0.456170f, -0.347802f, -0.165476f,
    -0.248415f, -0.126889f,  0.366951f, -0.337687f,  0.312752f, -0.434384f, -0.000815f,
    -0.210759f,  0.485765f,  0.341021f,  0.246165f, -0.186055f, -0.434512f,  0.045084f,
    -0.365383f, -0.065554f, -0.080040f,  0.422727f, -0.154678f, -0.002824f,  0.137973f,
    -0.229323f, -0.340732f,  0.397154f, -0.422785f, -0.479020f,  0.103134f,  0.100509f,
    -0.395692f, -0.051411f, -0.266707f,  0.170813f, -0.028960f,  0.130651f, -0.410282f,
    0.414095f, -0.063466f,  0.302117f,  0.288372f,  0.068036f,  0.420135f, -0.467457f,
    -0.304704f, -0.181623f, -0.145391f, -0.486255f,  0.158170f,  0.065405f, -0.342828f,
    0.409173f, -0.039799f,  0.036488f, -0.296698f, -0.473887f,  0.433655f, -0.436394f,
    -0.315104f, -0.225832f, -0.469079f, -0.350142f,  0.272654f, -0.148209f, -0.067171f,
    0.133945f,  0.048656f,  0.131301f,  0.388123f,  0.140043f, -0.102389f, -0.293156f,
    -0.336311f, -0.348566f,  0.066530f, -0.165089f, -0.440085f, -0.435567f,  0.247632f,
    0.479441f,  0.054739f,  0.324972f, -0.413478f,  0.210287f,  0.007279f, -0.400460f,
    0.448500f, -0.227692f, -0.470858f,  0.026751f, -0.475089f,  0.110852f,  0.248482f,
    -0.407250f, -0.433716f,  0.016621f,  0.206583f,  0.495873f, -0.219386f,  0.238303f,
    0.075391f, -0.048070f,  0.027343f,  0.444956f,  0.131203f,  0.445253f,  0.117519f,
    -0.267384f, -0.092985f, -0.328030f,  0.248427f,  0.032223f,  0.444457f,  0.336250f,
    0.260052f,  0.250661f,  0.424229f,  0.048363f, -0.392582f, -0.133964f,  0.348500f,
    -0.397938f, -0.243168f, -0.004603f,  0.134505f, -0.339883f, -0.102071f,  0.291767f,
    -0.461276f,  0.398765f,  0.133059f, -0.068008f,  0.426631f, -0.482220f, -0.420086f,
    0.092560f,  0.023324f, -0.458002f,  0.474371f, -0.267108f,  0.492748f, -0.132906f,
    0.463656f, -0.089106f, -0.106717f,  0.147624f, -0.136774f, -0.169215f,  0.218715f,
    -0.485242f, -0.054058f,  0.095791f, -0.342093f, -0.363682f,  0.023423f,  0.326546f,
    -0.226368f, -0.299985f, -0.445083f,  0.168582f,  0.219068f,  0.184864f,  0.119210f,
    0.398695f,  0.165559f,  0.474251f,  0.354064f,  0.140167f,  0.421567f,  0.411078f,
    -0.097515f,  0.291525f,  0.472779f,  0.270517f, -0.294044f, -0.016001f,  0.387524f,
    0.064578f,  0.304927f, -0.078976f, -0.191366f, -0.154122f,  0.002863f, -0.328438f,
    -0.480525f, -0.237724f,  0.131454f, -0.369190f,  0.332835f,  0.061694f,  0.233997f,
    0.310899f,  0.139863f,  0.355263f, -0.272755f, -0.345215f, -0.216739f,  0.030429f,
    -0.321889f,  0.093791f,  0.223844f,  0.342928f,  0.362593f,  0.398825f,  0.069676f,
    0.002328f, -0.414601f, -0.046536f, -0.422120f, -0.139580f, -0.391768f, -0.259250f,
    0.444392f, -0.008773f,  0.444036f,  0.062266f,  0.118308f,  0.157244f,  0.158304f,
    0.166011f, -0.355178f, -0.453940f,  0.314437f, -0.442498f, -0.387902f,  0.157580f,
    0.398970f, -0.294107f,  0.188974f,  0.263023f, -0.241756f,  0.173712f,  0.356284f,
    -0.352961f, -0.482250f,  0.325743f, -0.302669f, -0.396839f,  0.089236f, -0.219098f,
    -0.206969f, -0.134091f,  0.101977f, -0.377370f, -0.286801f,  0.331057f,  0.029815f,
    0.180839f, -0.015913f, -0.194436f, -0.015664f,  0.434992f, -0.001531f,  0.422559f,
    0.369411f, -0.102743f,  0.201354f,  0.302539f, -0.440732f,  0.241270f, -0.307095f,
    -0.397034f, -0.109899f,  0.110894f, -0.370411f,  0.103889f, -0.083896f,  0.030160f,
    0.042412f, -0.228220f, -0.350083f,  0.336563f,  0.322742f,  0.437796f, -0.086912f,
    -0.337931f, -0.374589f,  0.446172f, -0.304226f, -0.083020f,  0.107194f,  0.265002f,
    -0.248943f, -0.390532f,  0.136292f,  0.012456f,  0.415661f, -0.083108f,  0.083179f,
    0.309465f, -0.303668f,  0.363313f, -0.178916f,  0.013425f,  0.033631f, -0.458941f,
    -0.260081f,  0.170788f,  0.349448f, -0.276681f, -0.397157f, -0.080940f,  0.201398f,
    -0.229048f,  0.470508f,  0.306265f,  0.259711f, -0.348186f, -0.217108f, -0.170855f,
    0.246710f, -0.482450f,  0.449357f,  0.437036f, -0.254934f,  0.364044f, -0.041058f,
    0.338522f,  0.401442f,  0.221440f,  0.417998f, -0.019326f,  0.492671f, -0.147756f,
    0.462246f,  0.359220f,  0.251233f,  0.496413f, -0.085694f,  0.441625f, -0.112449f,
    0.096418f,  0.183320f,  0.038381f, -0.276271f,  0.109093f, -0.124271f,  0.301278f,
    0.045109f, -0.198293f,  0.129408f,  0.036932f,  0.163918f,  0.314637f,  0.348838f,
    -0.158937f,  0.207769f, -0.379614f,  0.436733f,  0.341132f,  0.432752f,  0.327339f,
    0.245550f, -0.495221f, -0.493089f,  0.465945f, -0.153264f,  0.467638f, -0.490822f,
    0.495036f, -0.299396f, -0.139483f,  0.088272f, -0.292638f, -0.152144f,  0.392425f,
    -0.224082f, -0.432540f, -0.394586f, -0.042162f,  0.252349f, -0.256397f, -0.216940f,
    -0.215102f,  0.025758f,  0.301260f,  0.320140f, -0.107498f, -0.429113f, -0.298450f,
    0.228207f,  0.160764f,  0.237835f, -0.471822f,  0.398861f, -0.311104f, -0.093637f,
    -0.225053f, -0.142539f,  0.380669f,  0.342315f, -0.272078f,  0.401967f,  0.189377f,
    -0.116548f,  0.027663f, -0.170643f, -0.483620f, -0.482917f,  0.093553f, -0.484579f,
    -0.499859f, -0.360235f,  0.321437f,  0.450742f,  0.482251f,  0.041500f,  0.054751f,
    -0.251743f, -0.315190f, -0.382259f,  0.396462f, -0.494276f, -0.013091f,  0.369976f,
    0.233115f, -0.062254f, -0.180240f, -0.249616f,  0.032580f,  0.172862f,  0.298632f,
    -0.117948f, -0.156320f, -0.344142f,  0.229370f, -0.359403f, -0.350490f, -0.103771f,
    0.037555f, -0.284122f, -0.371864f,  0.381218f, -0.295347f,  0.237205f, -0.333552f,
    -0.075371f, -0.291126f,  0.198446f, -0.492229f, -0.022554f, -0.224605f,  0.070320f,
    0.434561f,  0.488086f, -0.026618f, -0.351432f,  0.277934f, -0.398158f, -0.346255f,
    0.324509f, -0.419721f, -0.258084f, -0.284778f, -0.252377f, -0.169116f, -0.342407f,
    0.296295f, -0.099673f,  0.152979f, -0.323980f, -0.188609f,  0.248211f, -0.409866f,
    0.298189f,  0.142075f,  0.143060f,  0.057565f,  0.160700f,  0.133570f, -0.477663f,
    0.066998f,  0.294534f,  0.475450f,  0.102125f, -0.129405f,  0.180188f, -0.279957f,
    0.338462f, -0.291225f, -0.216825f,  0.035790f,  0.025372f,  0.288038f,  0.091181f,
    0.243953f,  0.300639f,  0.498089f, -0.471592f,  0.449857f,  0.289620f,  0.133413f,
    0.436084f, -0.126115f, -0.416774f,  0.084182f, -0.148539f,  0.298230f,  0.122071f,
    0.066944f,  0.439292f,  0.373716f, -0.048955f, -0.420531f,  0.306757f,  0.143678f,
    0.276803f, -0.120430f, -0.180290f, -0.179075f, -0.432394f, -0.461495f, -0.481750f,
    -0.352766f,  0.296405f, -0.469966f, -0.036143f, -0.363986f, -0.237090f,  0.051497f,
    0.328069f, -0.023147f,  0.110832f, -0.111051f, -0.178709f, -0.289576f, -0.242414f,
    0.330827f, -0.444736f,  0.073846f, -0.496082f,  0.490660f,  0.107685f,  0.296311f,
    0.321536f, -0.353433f,  0.214133f, -0.016069f,  0.412554f,  0.461863f, -0.469173f,
    -0.021238f,  0.482955f, -0.024243f, -0.000316f,  0.382556f,  0.114320f,  0.195393f,
    -0.209109f,  0.489521f, -0.302442f,  0.270277f,  0.212005f, -0.371732f,  0.106492f,
    0.268207f,  0.048750f,  0.341016f,  0.338026f, -0.180601f,  0.061829f,  0.163251f,
    -0.117404f, -0.435439f,  0.404713f,  0.260447f, -0.029876f, -0.214318f,  0.476354f,
    -0.153240f, -0.127677f, -0.441514f, -0.315034f,  0.185934f, -0.355334f, -0.373378f,
    0.107364f, -0.144982f, -0.473631f,  0.234123f,  0.494107f,  0.150191f,  0.353409f,
    -0.220451f,  0.232972f,  0.110263f, -0.100108f,  0.178131f,  0.059581f, -0.278067f,
    -0.127817f, -0.316479f, -0.360193f, -0.188033f,  0.116563f, -0.034725f, -0.132585f,
    -0.198830f,  0.446000f, -0.060490f,  0.374227f, -0.465145f, -0.220225f,  0.076502f,
    0.468575f,  0.471805f,  0.158579f,  0.168989f,  0.459132f, -0.468781f, -0.261614f,
    0.238199f,  0.121367f,  0.303408f,  0.372663f, -0.078981f,  0.287251f,  0.329089f,
    -0.388555f,  0.251989f,  0.127707f, -0.036240f,  0.327723f, -0.200711f,  0.422227f,
    0.453221f,  0.129674f,  0.096370f, -0.180287f,  0.254758f, -0.161951f, -0.166974f,
    -0.034370f,  0.112412f, -0.338953f,  0.324612f,  0.157944f, -0.283519f,  0.046968f,
    -0.000445f,  0.481012f, -0.005448f,  0.253616f, -0.442197f, -0.186235f, -0.242298f,
    0.361848f, -0.278730f, -0.294618f, -0.110111f,  0.150834f,  0.177532f,  0.425680f,
    -0.134153f,  0.019732f,  0.106103f, -0.076018f, -0.276646f,  0.012902f,  0.159677f,
    0.443118f, -0.174598f,  0.214938f, -0.321903f, -0.063988f, -0.281610f,  0.012284f,
    0.358879f, -0.398961f,  0.030963f,  0.357590f,  0.353483f, -0.003042f, -0.162428f,
    -0.437683f,  0.452720f, -0.395148f, -0.080365f, -0.173947f,  0.457710f, -0.012584f,
    0.349416f, -0.315067f,  0.185298f,  0.047537f,  0.267175f, -0.473600f, -0.349846f,
    0.328844f,  0.356136f, -0.073176f, -0.488234f, -0.070527f, -0.406707f, -0.321502f,
    -0.274239f, -0.156585f,  0.383682f,  0.292956f, -0.261377f,  0.406381f,  0.203711f,
    -0.489003f,  0.396713f, -0.161861f, -0.316740f, -0.117852f, -0.221102f, -0.448105f,
    0.460087f, -0.033551f,  0.322180f,  0.182711f, -0.277342f, -0.218480f,  0.197087f,
    -0.011306f, -0.286385f,  0.092980f, -0.149435f,  0.046020f,  0.455995f,  0.304909f,
    -0.194424f,  0.215725f, -0.035885f, -0.469627f,  0.166163f,  0.258032f,  0.352188f,
    -0.155045f,  0.192468f,  0.338946f, -0.286384f,  0.386140f, -0.209057f, -0.028246f,
    -0.164791f,  0.449336f, -0.289847f, -0.300843f, -0.328044f, -0.158919f, -0.317789f,
    0.414256f, -0.256636f, -0.271241f,  0.134584f, -0.417138f, -0.058392f,  0.024033f,
    0.488197f,  0.036226f, -0.349857f, -0.142429f,  0.417202f, -0.199274f,  0.059943f,
    0.051965f, -0.123862f,  0.296295f,  0.405802f,  0.237476f, -0.305459f,  0.423105f,
    -0.190625f, -0.355744f,  0.231246f, -0.350625f,  0.056698f, -0.139371f, -0.004965f,
    0.373226f,  0.019263f,  0.388946f,  0.439944f,  0.047518f,  0.378480f, -0.469523f,
    -0.111863f, -0.104001f, -0.321760f, -0.436053f, -0.082900f,  0.407300f, -0.380387f,
    -0.122990f, -0.342156f,  0.144068f, -0.448446f,  0.397648f, -0.485536f,  0.049495f,
    -0.306705f, -0.462324f,  0.450833f,  0.252588f,  0.155273f, -0.208972f,  0.456364f,
    0.074830f, -0.021312f, -0.033977f,  0.248855f,  0.310354f,  0.377653f, -0.182642f,
    -0.011298f,  0.003837f,  0.096489f,  0.077210f,  0.445695f, -0.422705f,  0.257730f,
    -0.234251f, -0.001373f, -0.220655f, -0.490795f,  0.342834f,  0.270906f,  0.146951f,
    0.432134f,  0.101271f,  0.464755f,  0.406931f, -0.436889f,  0.007116f,  0.295712f,
    0.007483f, -0.456627f,  0.477032f,  0.231643f,  0.091607f, -0.363285f, -0.187723f,
    -0.219140f,  0.115847f,  0.466319f, -0.147417f,  0.267222f, -0.281669f,  0.389659f,
    -0.006964f, -0.318099f, -0.332819f, -0.445678f, -0.151817f,  0.258205f, -0.080594f,
    -0.283670f,  0.328461f, -0.285749f,  0.215074f,  0.232397f, -0.304064f,  0.126026f,
    -0.226405f, -0.099932f, -0.276018f, -0.001404f, -0.321734f,  0.172110f, -0.463537f,
    -0.195367f,  0.389793f, -0.363307f,  0.137201f,  0.456571f, -0.444529f, -0.028683f,
    0.353765f,  0.411536f,  0.242353f,  0.050196f, -0.341811f,  0.307342f, -0.137619f,
    -0.268420f, -0.458914f, -0.235242f,  0.145671f, -0.441232f,  0.208303f, -0.272384f,
    0.403570f,  0.177112f, -0.052934f,  0.050904f,  0.182382f,  0.465963f, -0.368907f,
    -0.019219f, -0.003136f, -0.008707f,  0.264145f,  0.333339f, -0.267451f,  0.449621f,
    -0.085263f,  0.095273f,  0.178899f, -0.139700f, -0.209872f, -0.495480f, -0.009534f,
    -0.299695f, -0.092544f,  0.477955f, -0.262018f,  0.308096f, -0.080972f,  0.232787f,
    0.001210f,  0.321330f,  0.165732f, -0.314817f,  0.143961f, -0.216966f,  0.198745f,
    0.431497f,  0.300835f, -0.255912f, -0.490316f, -0.057579f, -0.425260f, -0.386488f,
    0.430819f, -0.212868f, -0.297892f,  0.335199f,  0.450812f, -0.097338f, -0.224813f,
    0.388645f,  0.081460f, -0.076914f, -0.368050f,  0.076154f, -0.095650f, -0.435414f,
    0.426547f,  0.039599f,  0.223250f, -0.152889f, -0.302758f,  0.181422f, -0.498175f,
    0.233302f,  0.053146f,  0.398238f,  0.333345f,  0.432926f, -0.167577f, -0.212356f,
    0.378972f, -0.100329f, -0.251974f,  0.291950f, -0.463288f, -0.179687f,  0.465313f,
    0.394349f, -0.470027f,  0.438650f,  0.160275f,  0.296999f,  0.301879f, -0.216957f,
    -0.373150f, -0.434249f, -0.308934f, -0.417289f,  0.254248f,  0.117471f,  0.171868f,
    0.310258f, -0.174066f, -0.486476f,  0.244893f, -0.286626f,  0.324431f,  0.182866f,
    -0.155570f, -0.125499f, -0.187656f, -0.427927f, -0.178494f,  0.131985f, -0.370332f,
    0.464608f, -0.196607f,  0.118338f,  0.058676f,  0.250639f,  0.112808f, -0.379675f,
    -0.203469f, -0.299777f, -0.253117f, -0.018398f, -0.093459f, -0.499286f, -0.085774f,
    -0.217693f, -0.165958f,  0.183672f,  0.258372f, -0.387483f, -0.157268f,  0.072566f,
    -0.439212f, -0.130108f,  0.200573f,  0.031274f, -0.477052f, -0.241437f,  0.297866f,
    0.351284f, -0.265705f, -0.460440f, -0.131381f,  0.364924f,  0.403901f, -0.283307f,
    -0.307021f, -0.139380f,  0.084144f,  0.260069f, -0.255688f,  0.167745f, -0.136327f,
    0.337547f,  0.198838f, -0.298034f,  0.226392f, -0.102112f,  0.115870f, -0.337933f,
    -0.461605f,  0.024641f, -0.181778f, -0.443785f,  0.463995f,  0.343631f,  0.028870f,
    -0.064412f,  0.256696f,  0.146983f, -0.046804f, -0.482205f,  0.005717f, -0.089043f,
    -0.383946f,  0.198812f,  0.431164f, -0.207573f, -0.422601f, -0.046937f, -0.447972f,
    -0.361172f,  0.445571f,  0.495319f, -0.455233f,  0.329058f,  0.497628f, -0.220682f,
    -0.136631f, -0.441314f, -0.106112f, -0.093835f,  0.404768f, -0.186786f, -0.040476f,
    0.046071f,  0.329501f,  0.450003f,  0.398274f,  0.290670f,  0.443073f, -0.114693f,
    0.028881f,  0.466774f, -0.381786f, -0.399146f,  0.198615f,  0.388098f,  0.104691f,
    0.428351f, -0.236835f, -0.402894f,  0.197490f, -0.385458f, -0.160515f, -0.331808f,
    0.284890f, -0.070811f,  0.177037f, -0.315029f, -0.102711f,  0.358996f,  0.270734f,
    -0.336742f, -0.149140f,  0.178668f,  0.401214f, -0.172239f, -0.294550f, -0.257439f,
    -0.141462f, -0.359519f, -0.484891f, -0.325432f,  0.235737f, -0.036008f, -0.323239f,
    0.117976f, -0.001305f,  0.380365f, -0.284450f, -0.150127f, -0.493248f,  0.399305f,
    0.175084f, -0.234269f,  0.310116f, -0.484329f, -0.298855f,  0.039005f,  0.250127f,
    0.020916f, -0.334525f,  0.088676f, -0.421179f,  0.354968f, -0.277807f, -0.084044f,
    -0.234220f,  0.089947f, -0.073423f, -0.138337f, -0.278604f,  0.365858f,  0.080781f,
    -0.009248f,  0.013316f, -0.482323f, -0.136875f,  0.123167f,  0.041747f, -0.474798f,
    -0.190371f, -0.365489f, -0.347403f, -0.170406f,  0.064215f,  0.070236f, -0.033893f,
    -0.442893f, -0.083533f,  0.018376f,  0.272124f, -0.399752f, -0.124919f, -0.376197f,
    0.258663f, -0.325794f,  0.456338f,  0.297886f, -0.006390f,  0.002238f,  0.028420f,
    0.168295f,  0.443769f, -0.186302f,  0.175604f,  0.351910f, -0.307103f,  0.254280f,
    -0.184106f,  0.337625f, -0.209375f, -0.483133f,  0.109168f,  0.394049f, -0.464645f,
    0.176147f,  0.371241f, -0.380885f, -0.247594f, -0.460726f,  0.306356f, -0.185576f,
    0.388180f, -0.237622f, -0.116477f, -0.022516f,  0.194236f, -0.001471f, -0.188899f,
    -0.318893f, -0.057491f, -0.327996f,  0.462319f, -0.336960f,  0.093008f,  0.367538f,
    0.128507f,  0.432946f,  0.055016f, -0.201857f, -0.063700f, -0.138705f, -0.353041f,
    -0.096655f, -0.327412f,  0.429350f, -0.098320f, -0.370848f,  0.082367f, -0.134300f,
    -0.105978f,  0.165162f,  0.108898f,  0.187626f,  0.025664f, -0.057841f, -0.345316f,
    0.010823f,  0.005363f,  0.119907f,  0.080979f,  0.334755f,  0.256747f,  0.480106f,
    0.111193f, -0.309782f,  0.394163f, -0.040443f, -0.459010f, -0.471958f, -0.218484f,
    -0.344928f,  0.119812f,  0.401409f, -0.340441f,  0.161823f, -0.207413f, -0.142167f,
    0.351541f, -0.006516f, -0.232697f, -0.090194f,  0.171811f, -0.485828f,  0.398056f,
    -0.464424f, -0.269017f, -0.007088f, -0.109097f,  0.304045f, -0.202864f, -0.209103f,
    0.301905f, -0.008251f,  0.005640f,  0.295518f,  0.106099f, -0.072833f, -0.140710f,
    -0.476033f, -0.120438f, -0.139254f,  0.302144f, -0.400176f, -0.086480f, -0.088805f,
    -0.060150f, -0.159438f,  0.132525f, -0.286404f, -0.200932f, -0.469708f, -0.266276f,
    0.317096f, -0.469702f, -0.346280f, -0.079750f, -0.185594f, -0.349063f, -0.236640f,
    -0.159254f, -0.312220f, -0.133632f, -0.412777f, -0.055730f, -0.377249f, -0.408336f,
    0.068872f, -0.056429f,  0.158694f,  0.498781f, -0.108173f,  0.181460f,  0.241726f,
    -0.464337f, -0.432512f, -0.400710f,  0.138730f,  0.284340f,  0.267180f, -0.398911f,
    -0.479795f,  0.452928f,  0.427485f, -0.267507f, -0.026395f, -0.482477f, -0.057755f,
    0.294221f,  0.057854f,  0.158602f,  0.428472f,  0.282554f, -0.065503f, -0.134925f,
    -0.413240f, -0.405769f, -0.067222f,  0.428093f,  0.304894f,  0.403743f,  0.336671f,
    -0.385266f, -0.372752f,  0.373648f, -0.425837f,  0.025505f, -0.451213f, -0.297291f,
    -0.414040f, -0.495882f,  0.323344f,  0.465238f, -0.163869f, -0.183766f,  0.399132f,
    -0.286323f,  0.475420f,  0.056926f, -0.476374f,  0.074166f, -0.006003f,  0.123751f,
    0.074210f,  0.183779f,  0.110097f, -0.079011f,  0.364925f,  0.123292f,  0.080468f,
    -0.113824f, -0.086245f, -0.230750f,  0.424793f,  0.176345f,  0.305018f, -0.294900f,
    -0.293187f, -0.030045f, -0.010729f,  0.427807f,  0.377866f, -0.038617f, -0.214138f,
    0.201429f,  0.272849f,  0.205987f, -0.086241f,  0.133338f, -0.446488f,  0.051255f,
    -0.486999f,  0.176162f,  0.259635f,  0.327795f,  0.036180f, -0.463907f,  0.085662f,
    0.215104f, -0.193519f, -0.153823f,  0.120009f,  0.011843f, -0.058671f, -0.155087f,
    -0.471505f,  0.277338f, -0.270379f, -0.207640f,  0.134718f, -0.353141f,  0.192429f,
    -0.482437f, -0.458205f, -0.186993f, -0.265814f, -0.414874f,  0.485593f,  0.292042f,
    -0.448437f,  0.311108f,  0.033732f,  0.318513f,  0.373996f,  0.167871f, -0.287665f,
    -0.476732f,  0.492192f, -0.133712f, -0.290638f, -0.483747f,  0.233732f,  0.166976f,
    -0.334282f, -0.488059f, -0.321651f,  0.278203f, -0.189983f,  0.175427f, -0.404329f,
    -0.221608f,  0.047582f, -0.267123f,  0.226699f,  0.040187f,  0.196944f,  0.461124f,
    -0.475684f, -0.481412f, -0.363240f,  0.155615f, -0.009480f,  0.338549f, -0.168046f,
    0.359932f, -0.012640f, -0.078475f,  0.340129f, -0.362169f, -0.191270f, -0.077053f,
    0.138517f,  0.172714f,  0.351142f,  0.213573f,  0.279278f, -0.490000f, -0.351521f,
    -0.319511f, -0.311368f,  0.413801f,  0.089749f,  0.104698f,  0.225793f,  0.017248f,
    -0.163610f, -0.398811f,  0.153997f, -0.289247f, -0.170881f,  0.096943f, -0.168020f,
    0.367315f,  0.121412f,  0.038280f,  0.484383f,  0.459979f, -0.088996f,  0.130187f,
    0.268869f, -0.377180f,  0.141321f,  0.038907f, -0.168188f,  0.060852f, -0.493653f,
    -0.039638f,  0.079634f, -0.428466f, -0.024714f,  0.049064f, -0.173973f, -0.475351f,
    -0.066355f,  0.396729f,  0.284105f,  0.010106f, -0.143496f,  0.481226f,  0.424922f,
    0.134458f,  0.245045f,  0.412534f,  0.028837f, -0.415295f, -0.208250f,  0.473907f,
    -0.286989f, -0.381609f,  0.331447f,  0.187304f,  0.367236f,  0.446311f, -0.211187f,
    -0.330509f, -0.298324f, -0.009214f, -0.232419f,  0.339236f,  0.075540f,  0.498871f,
    -0.371879f, -0.010045f,  0.396844f, -0.185285f,  0.369010f, -0.037428f, -0.237019f,
    -0.054688f, -0.368531f,  0.199732f,  0.142926f,  0.144026f, -0.034745f, -0.402442f,
    -0.081754f,  0.169405f, -0.321393f, -0.489286f, -0.473762f, -0.185750f,  0.206673f,
    -0.070468f, -0.050590f, -0.269268f, -0.198438f, -0.393468f, -0.073194f,  0.069091f,
    0.317501f, -0.161140f, -0.279230f,  0.395515f,  0.046905f,  0.241511f,  0.144369f,
    -0.267123f, -0.416590f,  0.404916f, -0.432414f, -0.322172f, -0.062221f,  0.004327f,
    0.392561f,  0.269192f,  0.019152f, -0.395022f,  0.278490f,  0.323714f, -0.209639f,
    -0.072854f,  0.354642f,  0.102074f,  0.100382f, -0.257152f,  0.075391f, -0.465011f,
    0.343521f,  0.368173f, -0.075139f, -0.481469f, -0.336571f,  0.092228f,  0.191975f,
    -0.499965f, -0.354181f, -0.001222f, -0.278609f,  0.319766f,  0.077786f, -0.153691f,
    0.254439f, -0.024388f, -0.089465f, -0.213990f,  0.449988f,  0.143379f, -0.421679f,
    0.227716f,  0.301908f,  0.246768f,  0.097337f, -0.422927f, -0.278093f,  0.039956f,
    0.207664f, -0.468064f, -0.051017f, -0.218859f,  0.308241f,  0.264450f, -0.014699f,
    0.454826f,  0.163988f, -0.047499f, -0.110795f,  0.289497f, -0.304091f, -0.461352f,
    -0.183799f,  0.239414f,  0.475329f,  0.267682f, -0.334278f, -0.293943f,  0.473898f,
    -0.079868f, -0.066599f, -0.303514f, -0.171127f, -0.143866f,  0.394242f, -0.189766f,
    -0.208637f,  0.102832f, -0.049088f, -0.050279f,  0.072065f,  0.052867f, -0.086578f,
    -0.174408f, -0.311230f, -0.361345f,  0.062385f,  0.120440f,  0.372153f, -0.442883f,
    -0.340915f,  0.352411f,  0.086584f, -0.354207f, -0.436239f, -0.107073f,  0.271749f,
    0.460165f,  0.411241f,  0.416949f, -0.224556f, -0.466852f,  0.363604f,  0.054691f,
    -0.089801f,  0.473790f, -0.053356f,  0.253527f, -0.325778f, -0.300952f,  0.404968f,
    -0.490876f,  0.494065f,  0.109043f, -0.455322f, -0.325181f,  0.201464f, -0.215521f,
    0.228331f,  0.075415f, -0.305295f, -0.119800f,  0.240643f, -0.468777f,  0.466034f,
    0.339385f, -0.257980f,  0.114199f,  0.026956f,  0.090184f, -0.301950f, -0.188039f,
    0.124427f, -0.304844f, -0.365258f, -0.352701f,  0.420124f,  0.391476f, -0.419671f,
    0.398565f,  0.175025f,  0.427247f, -0.235781f,  0.176070f,  0.130967f,  0.110441f,
    0.342396f,  0.345638f, -0.336294f,  0.038941f,  0.286623f, -0.154775f, -0.131909f,
    0.273231f,  0.433800f, -0.165671f,  0.260543f,  0.400586f,  0.253393f, -0.052349f,
    0.498151f,  0.377831f,  0.007725f, -0.379316f, -0.066050f,  0.038210f, -0.104805f,
    0.020612f, -0.013529f,  0.219541f,  0.363896f, -0.115950f,  0.496474f, -0.418763f,
    -0.162805f, -0.055126f,  0.288180f,  0.496121f, -0.481496f, -0.130011f, -0.374475f,
    -0.448907f,  0.045482f, -0.474336f, -0.249308f,  0.494013f,  0.490514f, -0.382371f,
    0.072713f,  0.200828f,  0.391388f,  0.008002f,  0.214317f, -0.111479f,  0.121299f,
    0.363177f,  0.167039f,  0.300420f,  0.338618f, -0.141165f,  0.405032f, -0.421508f,
    -0.496702f, -0.080717f,  0.390043f, -0.396724f,  0.407521f, -0.065452f,  0.401921f,
    -0.479972f,  0.383473f,  0.444261f, -0.244875f,  0.226510f, -0.248509f, -0.155231f,
    -0.068505f, -0.276084f,  0.228577f, -0.464398f, -0.041402f,  0.330875f,  0.392402f,
    -0.077930f, -0.007882f, -0.062064f, -0.008152f, -0.490941f, -0.213377f,  0.295831f,
    0.405151f, -0.287989f, -0.156053f,  0.047877f,  0.004472f,  0.057513f,  0.060059f,
    0.051028f, -0.384215f,  0.309117f, -0.286685f, -0.099931f, -0.169764f,  0.223147f,
    0.478323f,  0.347559f,  0.183371f,  0.181768f, -0.344829f,  0.073395f,  0.368076f,
    -0.238079f,  0.083737f, -0.469345f, -0.227342f,  0.352613f, -0.106795f,  0.110236f,
    -0.035258f, -0.468869f, -0.290573f, -0.189919f, -0.107229f, -0.069011f, -0.385519f,
    -0.146551f, -0.191382f,  0.488811f, -0.303303f,  0.115286f,  0.376560f,  0.029970f,
    -0.366093f, -0.169529f,  0.415759f,  0.258027f,  0.371885f,  0.369451f, -0.094078f,
    0.043066f, -0.436434f,  0.075798f, -0.409499f, -0.020406f,  0.258096f,  0.419893f,
    -0.049689f,  0.104188f,  0.122930f,  0.389564f, -0.154461f,  0.353519f, -0.236240f,
    -0.078151f,  0.478813f,  0.309420f,  0.008216f, -0.207388f, -0.099854f,  0.352477f,
    0.137866f,  0.188487f,  0.330584f, -0.059756f,  0.302574f, -0.142574f, -0.459729f,
    0.079884f, -0.189222f,  0.392070f,  0.184116f,  0.495258f, -0.246415f, -0.330546f,
    -0.179482f, -0.359361f, -0.150079f, -0.470498f, -0.347298f, -0.188952f,  0.370464f,
    0.404825f,  0.315549f, -0.305637f,  0.151221f,  0.250069f,  0.151634f, -0.067211f,
    -0.299355f, -0.101854f, -0.112730f, -0.431014f,  0.160022f, -0.015993f, -0.167908f,
    -0.318768f, -0.166153f,  0.118008f,  0.224154f,  0.426756f,  0.369319f, -0.192407f,
    0.057344f,  0.055172f, -0.348504f,  0.168037f,  0.230389f, -0.004711f, -0.421512f,
    0.133774f, -0.391227f, -0.292924f,  0.090320f,  0.287753f,  0.195046f, -0.196972f,
    -0.087700f, -0.373059f,  0.052447f, -0.265524f,  0.221175f,  0.340219f, -0.444738f,
    -0.308547f, -0.102133f, -0.293767f,  0.471313f, -0.059170f, -0.242359f,  0.442380f,
    -0.017521f, -0.384294f,  0.476241f, -0.376124f,  0.073822f, -0.463052f,  0.203634f,
    -0.280785f,  0.467059f,  0.390731f, -0.314232f,  0.383344f,  0.026637f, -0.022265f,
    0.225284f, -0.355752f,  0.054137f,  0.091845f, -0.104103f, -0.303285f,  0.227300f,
    0.258846f, -0.010468f,  0.066672f, -0.107642f,  0.276638f, -0.107030f, -0.228580f,
    -0.367888f, -0.465993f,  0.150387f, -0.180724f,  0.297208f,  0.059342f, -0.176349f,
    -0.036360f,  0.185154f,  0.356145f, -0.116493f, -0.248416f, -0.398110f,  0.339367f,
    -0.013005f,  0.238933f,  0.356300f,  0.194069f, -0.129246f,  0.139009f, -0.328709f,
    0.162393f, -0.267262f, -0.059745f, -0.210780f,  0.131373f,  0.418576f, -0.318408f,
    0.088332f,  0.275476f,  0.271283f, -0.420673f, -0.415204f, -0.184681f, -0.042428f,
    -0.275229f,  0.187050f,  0.426852f,  0.029911f,  0.239419f,  0.301049f, -0.209122f,
    0.015319f, -0.090127f,  0.303053f, -0.143377f,  0.300135f, -0.294120f, -0.162451f,
    0.328714f,  0.380484f,  0.193433f, -0.160480f, -0.273701f,  0.312698f, -0.374611f,
    -0.009496f, -0.264205f, -0.416480f,  0.062164f,  0.005707f, -0.056852f, -0.450429f,
    -0.164363f, -0.385922f, -0.076561f,  0.007690f, -0.185677f,  0.374968f, -0.050424f,
    0.056408f, -0.495696f,  0.004196f, -0.300007f, -0.086111f, -0.021558f, -0.269415f,
    -0.431731f, -0.245728f, -0.130552f,  0.332987f, -0.146039f,  0.413728f,  0.296810f,
    0.020220f, -0.079417f,  0.266039f,  0.183038f, -0.294822f, -0.401700f, -0.042442f,
    0.213802f, -0.376359f, -0.231328f, -0.429254f, -0.074848f, -0.317813f,  0.357730f,
    0.217587f,  0.478104f, -0.446649f,  0.371115f, -0.121752f,  0.478462f, -0.074705f,
    0.198263f,  0.340980f,  0.293053f, -0.345914f,  0.087289f,  0.476892f,  0.230915f,
    -0.053774f,  0.421831f,  0.423805f,  0.430786f,  0.344664f, -0.482479f, -0.051459f,
    -0.490872f, -0.178401f, -0.021257f, -0.286103f, -0.136433f, -0.045539f, -0.075969f,
    0.068102f, -0.164219f,  0.127144f,  0.386842f,  0.489226f, -0.240389f,  0.246834f,
    0.041960f, -0.091163f, -0.248565f,  0.278240f, -0.211378f, -0.221962f,  0.140923f,
    0.293092f,  0.160268f,  0.160073f, -0.155554f, -0.074758f, -0.373801f,  0.088051f,
    0.107116f,  0.463156f, -0.470951f,  0.430552f, -0.307723f,  0.045224f,  0.168893f,
    0.094193f,  0.291857f, -0.067152f, -0.267168f,  0.358467f,  0.133296f, -0.103808f,
    -0.210656f, -0.202149f,  0.137554f, -0.227223f, -0.341336f, -0.321614f, -0.339774f,
    0.055467f,  0.451432f,  0.015331f, -0.350934f,  0.380083f,  0.083321f,  0.005590f,
    -0.245258f,  0.350877f,  0.346934f,  0.179197f, -0.481303f, -0.258164f, -0.294303f,
    -0.010065f, -0.332727f, -0.388471f, -0.002286f,  0.343401f, -0.097610f, -0.222309f,
    -0.341504f, -0.335752f,  0.486876f, -0.185621f,  0.426389f, -0.028441f, -0.328970f,
    -0.200594f,  0.147535f,  0.266314f,  0.343158f,  0.383451f,  0.190775f, -0.442502f,
    -0.339095f, -0.053834f, -0.112457f, -0.451086f,  0.235481f,  0.110508f,  0.176080f,
    0.378137f,  0.303876f,  0.307149f,  0.430047f, -0.391074f,  0.294324f,  0.409090f,
    0.043676f, -0.288980f,  0.030457f,  0.326584f,  0.311979f, -0.435605f,  0.245435f,
    0.388301f,  0.146404f, -0.337726f,  0.007974f,  0.001598f,  0.192865f, -0.012448f,
    0.469522f, -0.461637f, -0.462221f,  0.345503f,  0.101171f,  0.329403f, -0.206001f,
    -0.137874f,  0.328526f, -0.343137f,  0.426066f, -0.471889f,  0.424049f,  0.437958f,
    -0.495270f, -0.025104f,  0.364098f,  0.012810f,  0.054094f,  0.018758f,  0.489463f,
    -0.157008f, -0.020977f,  0.074264f, -0.435277f, -0.355001f, -0.478184f,  0.008137f,
    -0.243101f,  0.314338f, -0.090306f, -0.167235f,  0.145001f,  0.121876f, -0.489019f,
    0.294997f,  0.329087f, -0.094200f,  0.438243f, -0.364265f,  0.183923f,  0.051997f,
    0.219944f, -0.169707f, -0.345465f, -0.194672f,  0.334953f,  0.485020f,  0.028534f,
    0.127317f,  0.071506f,  0.294586f,  0.355751f, -0.203940f,  0.166941f, -0.145614f,
    -0.414784f, -0.493988f, -0.082192f,  0.487290f, -0.278095f,  0.283816f,  0.161097f,
    0.162471f,  0.492881f, -0.102857f, -0.466293f,  0.151083f, -0.020173f,  0.042948f,
    0.364363f, -0.360597f, -0.299316f, -0.203576f,  0.163664f,  0.480784f,  0.188729f,
    0.059955f,  0.005553f, -0.245144f,  0.157446f, -0.059496f, -0.232926f, -0.026781f,
    0.491697f,  0.113089f, -0.329070f,  0.048146f,  0.160785f,  0.196591f,  0.393107f,
    0.463079f, -0.499020f,  0.016192f,  0.020008f,  0.155073f,  0.411033f, -0.215087f,
    -0.191498f,  0.159489f, -0.205745f, -0.223674f,  0.288565f,  0.061570f, -0.031663f,
    -0.056593f,  0.100373f,  0.249010f, -0.144457f,  0.267255f, -0.247412f,  0.130821f,
    0.120896f, -0.112768f,  0.481021f,  0.162984f,  0.307100f,  0.404662f, -0.340081f,
    0.248364f, -0.361859f,  0.190060f, -0.067195f, -0.079348f, -0.052421f,  0.224013f,
    -0.124424f, -0.491210f,  0.004690f, -0.480188f, -0.351428f,  0.054150f, -0.063045f,
    -0.291742f, -0.367719f,  0.227996f,  0.009273f, -0.001598f,  0.446753f,  0.497530f,
    0.450128f, -0.309890f,  0.329454f, -0.293417f,  0.497360f,  0.323194f,  0.470100f,
    0.479106f,  0.258841f, -0.337569f,  0.281944f,  0.092788f,  0.187072f,  0.187342f,
    -0.486799f, -0.105031f, -0.004518f, -0.129716f, -0.315956f, -0.102501f,  0.194993f,
    0.466787f,  0.266274f, -0.138809f,  0.302531f, -0.370480f, -0.175183f,  0.199203f,
    0.321864f,  0.103657f, -0.388617f,  0.143248f, -0.322135f,  0.419271f, -0.232464f,
    0.343354f,  0.207666f, -0.391077f, -0.137914f, -0.056606f, -0.411170f, -0.070445f,
    0.289059f, -0.011514f,  0.181448f, -0.368362f,  0.498690f,  0.090218f,  0.346934f,
    -0.089797f, -0.135826f, -0.319515f,  0.003324f,  0.097691f, -0.481373f,  0.019319f,
    0.310195f,  0.363616f, -0.124479f, -0.253181f, -0.275632f,  0.007971f, -0.004862f,
    0.060030f,  0.211656f,  0.351414f,  0.031393f,  0.194092f, -0.425283f,  0.103967f,
    -0.182686f,  0.450341f, -0.199763f,  0.443801f,  0.181772f,  0.465150f,  0.131020f,
    0.258261f, -0.129325f,  0.190638f, -0.475931f, -0.369459f,  0.337185f,  0.366090f,
    0.011422f, -0.371965f,  0.109857f,  0.316622f, -0.313365f,  0.333699f, -0.284507f,
    0.208840f, -0.000391f,  0.321607f,  0.073618f,  0.422730f,  0.362481f,  0.014853f,
    0.068466f,  0.231603f, -0.191002f, -0.428785f,  0.397234f,  0.299620f,  0.371992f,
    -0.246711f,  0.373021f, -0.342696f, -0.336007f,  0.179629f, -0.211497f,  0.362744f,
    -0.216386f,  0.086687f,  0.211240f,  0.329277f,  0.497277f,  0.313894f, -0.249027f,
    0.143774f, -0.262838f,  0.352151f, -0.191180f, -0.276216f, -0.159553f, -0.443638f,
    0.061605f,  0.492621f, -0.136754f, -0.257084f, -0.246673f,  0.280559f,  0.419858f,
    0.491381f, -0.359997f,  0.294995f,  0.211582f,  0.304912f, -0.128329f,  0.415419f,
    0.060378f,  0.005411f, -0.017551f,  0.448961f,  0.394871f,  0.137348f, -0.389550f,
    0.283095f, -0.253198f, -0.091029f, -0.223625f, -0.436356f, -0.394858f,  0.132825f,
    -0.466657f,  0.343767f, -0.403980f,  0.450790f, -0.340447f,  0.344229f,  0.265905f,
    -0.305036f,  0.226451f,  0.053416f,  0.052580f, -0.212353f,  0.343114f, -0.090369f,
    0.346118f,  0.005392f, -0.014449f, -0.454066f, -0.163864f,  0.497832f,  0.478716f,
    0.352668f, -0.219017f, -0.423100f,  0.148420f,  0.004050f,  0.041297f, -0.218190f,
    -0.282503f, -0.302687f,  0.019706f,  0.025934f, -0.169043f, -0.473531f,  0.318773f,
    0.080589f,  0.382111f,  0.033582f,  0.451865f,  0.225080f,  0.127526f, -0.309764f,
    0.251226f,  0.460452f,  0.053041f,  0.017819f,  0.351686f,  0.255011f, -0.455983f,
    -0.319821f, -0.121912f,  0.262132f,  0.156476f,  0.114639f,  0.023486f, -0.134597f,
    -0.453683f, -0.188618f, -0.179319f,  0.193173f,  0.333468f, -0.073502f,  0.031742f,
    0.475606f, -0.372560f, -0.493982f, -0.387729f,  0.254136f, -0.031322f, -0.292146f,
    -0.244318f,  0.098403f,  0.223288f,  0.302425f, -0.352734f, -0.367548f, -0.238064f,
    -0.306902f,  0.020982f, -0.046021f,  0.140049f,  0.272214f, -0.370379f, -0.027816f,
    -0.363063f,  0.180902f,  0.230130f, -0.043735f, -0.104523f,  0.300257f, -0.477482f,
    0.233572f, -0.401177f,  0.412382f,  0.238170f, -0.299914f, -0.478182f,  0.042778f,
    -0.220221f, -0.306821f,  0.375984f,  0.156427f,  0.202019f,  0.055128f, -0.070106f,
    0.020365f,  0.073992f, -0.496378f, -0.188664f, -0.427210f, -0.230775f, -0.018521f,
    -0.108123f,  0.225566f, -0.172834f, -0.368733f,  0.004442f,  0.361993f,  0.265994f,
    -0.278433f,  0.064540f, -0.171152f, -0.403189f, -0.079047f,  0.148230f,  0.430846f,
    -0.005506f,  0.094600f,  0.245254f,  0.052037f, -0.226354f,  0.498696f, -0.147295f,
    0.303345f,  0.355904f,  0.222157f,  0.229819f,  0.044961f,  0.106707f, -0.283473f,
    -0.497082f,  0.288935f,  0.278353f, -0.352650f,  0.224142f, -0.351126f,  0.287461f,
    0.367993f, -0.140399f, -0.016378f,  0.347875f,  0.475042f, -0.248888f,  0.259342f,
    0.196592f, -0.041460f, -0.321745f,  0.024117f,  0.115644f, -0.143126f,  0.389474f,
    -0.388389f,  0.445448f,  0.401893f, -0.403887f,  0.141191f,  0.286259f, -0.127599f,
    0.483291f,  0.203090f, -0.471304f, -0.368261f, -0.083725f,  0.465642f, -0.120498f,
    -0.383564f,  0.168581f,  0.240441f,  0.245591f,  0.267394f,  0.204454f, -0.271251f,
    0.001961f,  0.092715f, -0.322031f,  0.452835f,  0.044280f, -0.347165f, -0.193841f,
    0.468810f, -0.434913f,  0.335311f, -0.095279f, -0.151657f, -0.403076f,  0.300374f,
    0.490753f, -0.393644f,  0.142712f,  0.031754f, -0.365748f, -0.493038f,  0.222984f,
    0.013416f,  0.433728f, -0.217164f,  0.173759f, -0.194409f, -0.315747f, -0.198306f,
    -0.256182f, -0.262839f, -0.340336f, -0.328945f, -0.115217f,  0.231186f,  0.433782f,
    0.018150f, -0.026175f,  0.491773f, -0.114278f,  0.060385f, -0.367772f, -0.400182f,
    -0.132757f,  0.203522f,  0.331695f, -0.420543f,  0.429150f, -0.104277f, -0.154306f,
    0.433704f,  0.310854f,  0.217376f, -0.010129f, -0.374965f,  0.472169f, -0.393585f,
    0.391206f, -0.246663f,  0.497286f,  0.379548f, -0.428818f, -0.090956f, -0.486258f,
    -0.000169f, -0.032551f,  0.143589f,  0.458377f, -0.185455f, -0.351359f, -0.116967f,
    0.280103f, -0.285993f,  0.098094f, -0.264703f,  0.016312f, -0.422807f,  0.207755f,
    -0.281349f, -0.285449f, -0.275250f,  0.389810f,  0.321614f,  0.320481f, -0.089106f,
    -0.209755f,  0.235283f, -0.078068f, -0.315184f, -0.011761f, -0.037821f, -0.039831f,
    -0.462325f,  0.253889f, -0.424593f,  0.104303f, -0.063733f, -0.416836f, -0.406810f,
    -0.327475f, -0.291659f, -0.044695f, -0.447492f, -0.408275f, -0.118184f, -0.110712f,
    0.357787f, -0.439232f, -0.148614f, -0.309246f, -0.316713f,  0.045698f,  0.026969f,
    0.260498f, -0.401342f,  0.039312f,  0.050916f, -0.085317f, -0.465900f, -0.207301f,
    0.411985f, -0.016832f, -0.286422f,  0.430554f,  0.256682f, -0.403518f,  0.160936f,
    0.031353f,  0.341148f, -0.161979f,  0.364649f,  0.252270f,  0.083449f, -0.426949f,
    0.102927f,  0.349200f,  0.286594f, -0.279764f, -0.146734f, -0.244895f,  0.292246f,
    0.408051f, -0.398691f, -0.416371f, -0.405118f,  0.463965f, -0.174599f,  0.196404f,
    -0.437340f, -0.421670f,  0.458888f, -0.433563f,  0.156750f, -0.469896f, -0.144420f,
    -0.330384f, -0.036805f,  0.273787f,  0.229504f, -0.297392f, -0.486043f, -0.114914f,
    -0.127058f,  0.047776f, -0.394194f,  0.219037f,  0.232636f, -0.348722f, -0.028150f,
    0.223710f, -0.160895f, -0.254921f,  0.331066f, -0.296442f,  0.225215f, -0.399487f,
    0.162268f, -0.329589f, -0.434945f, -0.447687f, -0.087948f,  0.441559f,  0.430861f,
    -0.242637f,  0.158608f,  0.231119f,  0.063097f, -0.240083f,  0.187849f, -0.026355f,
    0.026197f, -0.289157f, -0.316617f, -0.438248f,  0.369926f,  0.146715f, -0.258289f,
    0.069399f,  0.114538f,  0.267830f,  0.168302f,  0.069632f,  0.348182f,  0.182855f,
    0.224231f, -0.006639f, -0.320839f,  0.210515f,  0.427894f, -0.029478f, -0.423628f,
    -0.027754f,  0.188517f, -0.443587f,  0.001566f,  0.178940f,  0.489910f, -0.313305f,
    0.070851f,  0.042825f,  0.352181f, -0.409576f, -0.445507f, -0.456724f, -0.310761f,
    -0.109617f,  0.248576f,  0.082187f, -0.469921f, -0.143921f,  0.435180f, -0.302139f,
    0.476772f, -0.427837f,  0.235650f,  0.111673f,  0.092069f,  0.422122f, -0.008783f,
    -0.317307f, -0.479365f, -0.254743f,  0.354208f,  0.393741f, -0.308316f,  0.238825f,
    0.409554f,  0.417914f, -0.415542f, -0.215553f,  0.378972f, -0.424552f,  0.184435f,
    -0.030688f, -0.311406f,  0.122976f,  0.355782f, -0.057765f, -0.055132f,  0.185159f,
    0.108591f,  0.139442f, -0.405993f, -0.315444f, -0.132521f,  0.285065f,  0.308364f,
    -0.379936f, -0.163396f,  0.320262f, -0.089222f, -0.164071f,  0.405998f,  0.148907f,
    -0.482268f,  0.188880f, -0.478012f,  0.366626f, -0.452797f,  0.015369f, -0.167495f,
    0.226138f, -0.068754f, -0.392893f,  0.264268f, -0.298608f, -0.179080f, -0.317690f,
    0.056439f, -0.435341f, -0.062678f, -0.418548f,  0.493753f,  0.256669f, -0.437233f,
    -0.312643f, -0.004250f,  0.085356f, -0.323042f, -0.234424f,  0.438218f, -0.038073f,
    -0.488861f,  0.015880f, -0.265946f, -0.294556f, -0.453699f,  0.421035f, -0.324814f,
    -0.396669f, -0.162293f, -0.145183f, -0.257835f, -0.207042f,  0.266029f, -0.424665f,
    0.196365f,  0.469498f, -0.455244f,  0.468417f, -0.030056f,  0.471588f,  0.344200f,
    0.333246f,  0.114865f,  0.445934f, -0.094930f, -0.188930f,  0.334125f,  0.245234f,
    -0.169413f,  0.268051f,  0.131218f,  0.123734f,  0.077213f,  0.153980f, -0.371229f,
    -0.481862f,  0.362983f,  0.496144f,  0.140777f,  0.047700f, -0.477788f,  0.257329f,
    0.167223f, -0.150895f, -0.360190f,  0.121417f, -0.087038f,  0.444851f, -0.127944f,
    -0.219288f, -0.472123f,  0.197299f, -0.381640f,  0.225124f, -0.398108f, -0.353638f,
    0.456110f, -0.307997f, -0.379123f, -0.007707f, -0.065680f,  0.472418f, -0.041689f,
    -0.055700f, -0.221578f,  0.408450f, -0.081235f, -0.407526f,  0.265743f, -0.291486f,
    -0.495677f, -0.190908f, -0.142888f,  0.283684f,  0.101358f, -0.416371f, -0.376564f,
    -0.374553f, -0.394729f,  0.234477f,  0.486403f, -0.159572f, -0.446390f,  0.413464f,
    -0.160232f, -0.305358f,  0.327241f,  0.473764f,  0.162535f, -0.158862f,  0.124934f,
    0.058012f, -0.150813f,  0.081025f,  0.203985f, -0.415452f, -0.373273f, -0.112639f,
    0.309440f, -0.227670f, -0.293722f,  0.181164f, -0.446315f,  0.008591f, -0.278493f,
    -0.256447f, -0.461234f,  0.490570f, -0.329013f, -0.239070f, -0.216189f, -0.120593f,
    -0.468874f, -0.007820f, -0.407340f,  0.109475f,  0.105667f,  0.407434f,  0.201447f,
    -0.127838f, -0.417519f, -0.055668f,  0.227209f, -0.285467f,  0.374889f,  0.155501f,
    0.206790f,  0.188801f,  0.219831f, -0.046290f, -0.003446f, -0.210547f,  0.416516f,
    -0.299309f,  0.389159f, -0.294084f,  0.134804f,  0.411723f, -0.098804f, -0.412630f,
    0.161312f, -0.431095f, -0.032346f,  0.403658f,  0.432573f, -0.262434f, -0.065550f,
    0.136058f, -0.481604f, -0.023151f,  0.222766f, -0.058916f, -0.454242f, -0.380452f,
    -0.181666f, -0.200292f,  0.215158f, -0.111851f,  0.050539f, -0.353352f, -0.230480f,
    -0.387457f,  0.221173f, -0.073794f,  0.382768f, -0.053327f, -0.462480f,  0.252116f,
    0.184485f, -0.048662f, -0.468611f, -0.128432f,  0.412219f, -0.448392f, -0.497438f,
    0.413996f,  0.258537f,  0.100800f, -0.174530f, -0.387843f,  0.270874f,  0.328114f,
    0.280668f,  0.438652f,  0.474190f,  0.131122f,  0.012804f,  0.230446f,  0.165778f,
    -0.357130f, -0.365600f, -0.344399f, -0.084820f,  0.480095f,  0.266043f, -0.208403f,
    0.167532f, -0.384402f, -0.430025f, -0.431962f, -0.135967f,  0.044185f, -0.247083f,
    -0.484220f,  0.167323f,  0.285656f,  0.008048f,  0.250475f,  0.111845f, -0.173628f,
    0.373855f, -0.304886f,  0.329734f,  0.207034f, -0.286753f,  0.460443f, -0.137880f,
    -0.438947f, -0.320477f, -0.495679f,  0.025258f, -0.234383f, -0.378097f, -0.415470f,
    -0.177547f, -0.165028f,  0.393366f, -0.289400f,  0.078961f, -0.060668f, -0.275985f,
    -0.151414f,  0.321000f,  0.227999f, -0.003557f,  0.300952f,  0.055547f,  0.054773f,
    -0.046673f,  0.187767f,  0.059099f, -0.091256f, -0.354646f,  0.214116f,  0.216115f,
    0.333217f,  0.118522f, -0.205868f,  0.417060f, -0.062663f,  0.288760f, -0.310525f,
    -0.271836f, -0.335615f, -0.231146f, -0.362129f,  0.067060f,  0.251359f,  0.223976f,
    0.226740f, -0.312021f,  0.098106f,  0.029182f,  0.192753f,  0.015248f, -0.059192f,
    0.492370f, -0.212095f, -0.476715f,  0.002039f, -0.137814f,  0.187263f,  0.094571f,
    -0.045927f,  0.450724f, -0.333066f,  0.384111f, -0.302160f, -0.080339f,  0.449922f,
    0.360505f, -0.180684f, -0.424491f,  0.402799f,  0.201107f, -0.341278f,  0.130149f,
    -0.179370f, -0.196224f,  0.314261f,  0.057934f,  0.217972f,  0.193065f,  0.028050f,
    0.436738f, -0.340561f,  0.287336f,  0.272307f,  0.029911f, -0.272849f, -0.260786f,
    0.301674f, -0.353250f, -0.300035f, -0.360740f, -0.126033f,  0.324511f,  0.079936f,
    -0.303124f, -0.494064f,  0.184101f, -0.133252f,  0.388903f, -0.159926f, -0.480745f,
    0.276389f,  0.441386f,  0.098788f, -0.354500f,  0.204157f, -0.279437f, -0.083224f,
    -0.363488f,  0.125839f,  0.132677f,  0.123243f,  0.453237f,  0.249049f, -0.162933f,
    -0.077739f,  0.282555f,  0.206996f, -0.028232f, -0.149645f, -0.429838f,  0.020149f,
    0.075099f,  0.411274f,  0.195254f,  0.231385f, -0.499614f,  0.263215f,  0.196573f,
    0.294266f, -0.205226f, -0.294145f,  0.140150f,  0.412296f,  0.318290f,  0.253925f,
    -0.395934f, -0.007295f,  0.277857f, -0.360608f, -0.154399f, -0.202092f, -0.054652f,
    0.332305f, -0.221989f,  0.310871f, -0.387810f, -0.134059f,  0.199947f,  0.039926f,
    -0.060735f, -0.021940f,  0.338166f, -0.310183f, -0.185676f, -0.002102f,  0.247083f,
    -0.261982f, -0.205147f, -0.492576f,  0.286041f, -0.149376f,  0.247997f,  0.152511f,
    -0.388413f,  0.325542f, -0.402949f,  0.470777f,  0.487984f, -0.109229f, -0.266988f,
    -0.288669f, -0.139489f,  0.443488f, -0.122574f,  0.149515f,  0.444554f, -0.123762f,
    -0.392742f,  0.226592f, -0.033833f, -0.112733f, -0.367307f, -0.321556f, -0.180404f,
    0.453926f,  0.403999f,  0.444653f,  0.472730f, -0.495094f,  0.003801f, -0.315775f,
    0.406542f, -0.243986f, -0.262758f,  0.358991f,  0.189193f, -0.124568f, -0.314541f,
    0.100926f, -0.305180f,  0.271215f,  0.449903f,  0.053904f,  0.232186f,  0.202634f,
    -0.261518f,  0.000463f, -0.034180f,  0.417469f,  0.072643f, -0.145071f,  0.024418f,
    -0.377868f,  0.111151f, -0.141251f, -0.104230f,  0.266406f,  0.165686f, -0.036862f,
    0.417943f,  0.038593f, -0.159203f, -0.332383f, -0.028066f,  0.242000f,  0.171566f,
    0.317849f,  0.456212f, -0.314867f, -0.396869f, -0.301928f, -0.361089f, -0.355834f,
    -0.006316f, -0.094083f,  0.414823f, -0.171578f,  0.004360f, -0.477772f, -0.016580f,
    -0.467408f, -0.366289f,  0.115670f, -0.331873f,  0.430651f, -0.230059f,  0.109245f,
    -0.061203f, -0.153057f, -0.129708f,  0.019657f, -0.382689f,  0.123519f, -0.226168f,
    0.424879f,  0.444547f, -0.363365f,  0.142158f, -0.337209f,  0.385312f, -0.450451f,
    -0.326566f, -0.015265f, -0.268376f, -0.073296f, -0.489305f, -0.468908f,  0.234894f,
    -0.017481f, -0.232101f,  0.238098f, -0.079270f,  0.055847f, -0.179858f,  0.381094f,
    -0.301561f,  0.151473f, -0.418673f,  0.492199f,  0.418778f,  0.288563f, -0.051950f,
    -0.478846f,  0.221485f,  0.361724f, -0.412630f,  0.326052f,  0.177744f,  0.125358f,
    0.344250f,  0.453255f, -0.283217f,  0.331462f,  0.438069f,  0.088491f, -0.259486f,
    0.013325f, -0.106462f, -0.492469f, -0.198420f, -0.355977f,  0.037298f,  0.126807f,
    0.139907f,  0.093974f, -0.494579f, -0.268366f, -0.351872f,  0.353561f, -0.192056f,
    -0.149623f,  0.139929f,  0.215982f, -0.266325f, -0.166803f,  0.315821f,  0.075832f,
    -0.457961f, -0.402053f,  0.012389f, -0.312338f,  0.159175f,  0.416014f,  0.153149f,
    -0.154031f,  0.294305f, -0.452258f,  0.027395f,  0.147188f,  0.231303f,  0.099202f,
    0.358606f,  0.131588f, -0.117857f, -0.413684f,  0.102802f,  0.488275f, -0.243529f,
    0.363499f,  0.071913f, -0.347741f, -0.311142f,  0.135078f, -0.394408f, -0.005254f,
    0.246662f,  0.129977f,  0.430412f,  0.075318f, -0.368007f,  0.422688f,  0.127217f,
    -0.290440f, -0.103413f,  0.143817f, -0.129813f,  0.233188f,  0.354878f, -0.412985f,
    0.165312f, -0.407858f,  0.044945f,  0.209466f, -0.422517f,  0.238832f, -0.072907f,
    0.292117f,  0.035790f,  0.202469f, -0.406544f,  0.203334f,  0.403173f, -0.236355f,
    -0.401705f,  0.253700f,  0.012173f,  0.491147f,  0.006749f, -0.423653f, -0.258461f,
    -0.213948f,  0.439918f,  0.180781f, -0.356886f, -0.228182f,  0.196834f, -0.248943f,
    -0.155650f,  0.319253f,  0.030534f,  0.161788f,  0.434422f,  0.105534f, -0.192174f,
    0.416625f, -0.207836f, -0.016976f, -0.306783f,  0.450071f, -0.401499f,  0.136313f,
    0.159730f,  0.229896f, -0.122925f, -0.202834f,  0.177016f, -0.063166f,  0.371965f,
    -0.117077f,  0.384534f, -0.158108f,  0.464525f,  0.243132f,  0.089701f,  0.338725f,
    0.481301f,  0.113979f,  0.093489f,  0.486476f,  0.496591f,  0.465587f, -0.164758f,
    0.272859f, -0.303219f, -0.288199f,  0.251408f, -0.408489f, -0.324909f,  0.467054f,
    0.286989f, -0.056219f,  0.056457f, -0.134979f, -0.198056f,  0.002780f,  0.020108f,
    0.286547f, -0.063651f,  0.124891f,  0.264893f,  0.020740f, -0.012756f,  0.447031f,
    -0.062012f,  0.446989f, -0.203246f,  0.481137f, -0.024577f,  0.274158f,  0.236036f,
    -0.197103f,  0.152606f,  0.406457f, -0.085947f,  0.050233f,  0.150033f,  0.276842f,
    -0.043894f, -0.402904f, -0.145335f,  0.354682f, -0.063059f, -0.123513f,  0.457616f,
    -0.195554f, -0.439687f, -0.101836f,  0.206022f,  0.458992f, -0.165116f,  0.374265f,
    -0.280839f, -0.159547f, -0.420331f,  0.441141f, -0.100487f, -0.417219f, -0.484007f,
    -0.012573f, -0.262448f,  0.404631f, -0.227286f,  0.383984f, -0.180528f, -0.425190f,
    -0.206381f,  0.106547f,  0.460013f,  0.383167f, -0.272707f, -0.429857f, -0.025891f,
    0.459068f, -0.122031f,  0.007503f,  0.312825f,  0.302062f, -0.430962f, -0.448412f,
    -0.221830f,  0.242658f,  0.327818f, -0.216986f, -0.279200f,  0.326150f,  0.040245f,
    -0.087273f,  0.452721f, -0.396935f,  0.187473f, -0.147009f,  0.278085f, -0.236806f,
    0.393517f, -0.371958f, -0.221306f,  0.416390f, -0.144629f, -0.339972f, -0.227750f,
    0.005832f,  0.256464f,  0.284884f, -0.308253f, -0.055411f,  0.083298f, -0.416822f,
    0.280172f,  0.153712f, -0.133117f,  0.007763f,  0.238261f, -0.487584f,  0.388959f,
    -0.063909f, -0.147873f, -0.476026f, -0.147707f, -0.168390f,  0.225744f, -0.326253f,
    0.079683f,  0.154940f, -0.120442f, -0.119691f,  0.033348f,  0.088840f,  0.495662f,
    0.192139f,  0.031344f, -0.073023f,  0.102381f,  0.489158f, -0.432444f,  0.098724f,
    0.122681f, -0.358070f,  0.344104f,  0.062388f,  0.353255f,  0.046147f,  0.117904f,
    0.077420f,  0.001519f,  0.073885f,  0.005382f,  0.370088f, -0.440888f,  0.106731f,
    -0.369580f, -0.276844f,  0.221113f, -0.016678f, -0.269509f, -0.337637f,  0.224356f,
    -0.097967f, -0.264669f,  0.373471f,  0.345511f, -0.231126f,  0.222672f,  0.283787f,
    -0.394536f,  0.324223f, -0.251579f, -0.020010f,  0.221881f, -0.023540f,  0.196788f,
    0.236568f,  0.053344f,  0.425341f, -0.257653f,  0.401173f,  0.218243f, -0.114244f,
    -0.355251f,  0.057523f, -0.452353f, -0.010722f,  0.182074f, -0.325469f, -0.142953f,
    0.415384f, -0.014248f,  0.091115f,  0.276343f, -0.391283f,  0.174280f, -0.002761f,
    -0.344613f, -0.101751f, -0.059274f, -0.301506f,  0.224206f,  0.227139f,  0.467465f,
    0.117695f, -0.391325f,  0.009888f,  0.197911f,  0.244262f,  0.125463f,  0.290587f,
    -0.042313f, -0.279566f,  0.161781f,  0.020397f,  0.195281f,  0.410657f, -0.191277f,
    0.494689f, -0.395752f,  0.172984f, -0.299851f, -0.415571f, -0.364433f, -0.496861f,
    -0.083614f, -0.390494f,  0.340320f, -0.304418f, -0.436881f,  0.483999f, -0.329083f,
    -0.068146f,  0.216090f,  0.018116f, -0.224572f, -0.386656f,  0.332655f,  0.095202f,
    0.046780f, -0.019785f,  0.238368f,  0.414382f,  0.229836f, -0.144659f, -0.317097f,
    -0.137273f, -0.121619f,  0.304834f, -0.227485f, -0.428797f, -0.084645f,  0.276173f,
    0.389509f, -0.265071f,  0.148201f,  0.350323f, -0.168210f,  0.212599f, -0.117325f,
    -0.306980f,  0.192302f,  0.337462f,  0.459153f,  0.007958f,  0.059416f, -0.198704f,
    -0.307667f, -0.245229f,  0.080974f, -0.355115f,  0.055698f,  0.398991f,  0.188437f,
    0.488080f, -0.365503f, -0.110271f,  0.230586f,  0.047390f, -0.366076f, -0.378636f,
    0.091367f, -0.440039f, -0.277758f, -0.385491f,  0.252214f,  0.003693f,  0.001656f,
    -0.337116f,  0.159640f,  0.471305f, -0.386405f,  0.429138f, -0.356221f, -0.078617f,
    0.220948f,  0.454374f,  0.238237f, -0.054620f,  0.079587f,  0.371998f,  0.327067f,
    -0.487580f,  0.467863f,  0.213125f,  0.107461f, -0.306661f, -0.371319f,  0.063127f,
    -0.060800f, -0.365805f,  0.478195f, -0.190072f, -0.448307f,  0.013509f,  0.422377f,
    -0.274460f,  0.110262f, -0.454492f,  0.112900f, -0.117718f,  0.384049f, -0.094125f,
    -0.327543f,  0.241604f,  0.303534f, -0.417995f,  0.273195f, -0.188181f,  0.406215f,
    0.365024f,  0.297239f, -0.224862f, -0.079237f,  0.487067f,  0.122923f,  0.485802f,
    0.174349f,  0.199343f, -0.267622f, -0.130213f,  0.282105f,  0.021844f,  0.334487f,
    -0.029481f, -0.385222f,  0.065099f,  0.441178f,  0.220362f, -0.221118f,  0.022062f,
    -0.135245f, -0.161330f, -0.012691f,  0.401112f, -0.149990f, -0.493790f, -0.033008f,
    -0.230570f, -0.411414f, -0.086634f,  0.429369f, -0.396969f,  0.146387f, -0.225679f,
    -0.380186f,  0.401929f, -0.029804f, -0.381924f,  0.330731f,  0.085805f, -0.379614f,
    -0.135252f, -0.208346f,  0.099941f, -0.163647f, -0.045089f,  0.086480f, -0.151239f,
    0.004508f,  0.282064f, -0.243733f, -0.045855f,  0.230440f,  0.372873f,  0.354952f,
    -0.220228f, -0.427220f, -0.266052f,  0.279720f, -0.253729f,  0.272700f,  0.433182f,
    -0.192257f,  0.213308f, -0.403243f,  0.281650f,  0.062823f,  0.355292f, -0.070464f,
    0.230606f, -0.499527f,  0.191751f,  0.124290f, -0.323076f,  0.345594f,  0.139280f,
    -0.396484f, -0.012333f,  0.415856f,  0.470156f, -0.053679f, -0.003799f, -0.395298f,
    0.437136f,  0.495764f,  0.102893f,  0.434720f, -0.448266f,  0.047638f,  0.125123f,
    -0.005460f,  0.284584f, -0.236266f,  0.204791f, -0.024031f, -0.055382f, -0.200578f,
    -0.004804f, -0.316419f, -0.454743f, -0.400138f,  0.439939f, -0.186907f,  0.390090f,
    -0.355393f, -0.270772f, -0.480112f, -0.079585f,  0.490434f,  0.306663f,  0.122671f,
    0.028217f,  0.051467f,  0.013303f, -0.476890f, -0.280233f,  0.078988f, -0.165040f,
    -0.350569f,  0.338960f,  0.066508f,  0.080484f, -0.454956f, -0.148926f,  0.254901f,
    -0.191121f, -0.017256f,  0.225105f, -0.115316f, -0.334982f,  0.066813f,  0.217638f,
    0.315339f,  0.029313f,  0.331091f, -0.212039f,  0.473081f,  0.165728f, -0.492072f,
    -0.399485f,  0.307525f,  0.323162f, -0.146166f,  0.187564f,  0.433651f,  0.043408f,
    -0.389007f,  0.146173f, -0.051671f,  0.119093f, -0.436240f,  0.476234f, -0.028749f,
    0.169402f,  0.435521f, -0.219409f, -0.160522f, -0.069379f,  0.049206f,  0.447604f,
    0.045119f,  0.441215f,  0.245326f,  0.227158f,  0.049220f,  0.013996f, -0.218821f,
    0.352859f, -0.474869f,  0.485834f,  0.106165f, -0.181507f, -0.484958f, -0.198595f,
    -0.431275f, -0.198294f,  0.448551f, -0.317366f,  0.323788f, -0.038783f,  0.137133f,
    0.449214f, -0.195074f,  0.287680f,  0.278688f,  0.055067f, -0.052720f, -0.062095f,
    -0.121485f, -0.013458f, -0.493774f, -0.444271f,  0.403764f, -0.195988f,  0.438566f,
    -0.288090f, -0.334665f,  0.101157f, -0.210583f,  0.464551f, -0.017533f,  0.385512f,
    0.266142f, -0.461576f,  0.389605f, -0.442263f,  0.353438f,  0.087019f, -0.357910f,
    0.071779f, -0.380375f,  0.479100f, -0.143303f, -0.392225f, -0.262720f, -0.460935f,
    0.465793f, -0.123281f, -0.338608f,  0.367757f,  0.091193f, -0.479088f, -0.389404f,
    0.430748f,  0.167470f, -0.424127f, -0.267424f,  0.381116f,  0.017252f, -0.455737f,
    0.120259f, -0.107237f,  0.345849f,  0.305532f, -0.287072f,  0.131238f,  0.163400f,
    0.179271f,  0.363926f, -0.152488f,  0.233865f, -0.113051f,  0.297496f,  0.115255f,
    -0.293256f, -0.345070f,  0.390804f, -0.434119f,  0.415031f, -0.411082f,  0.297828f,
    0.433196f, -0.132154f, -0.128330f, -0.259871f, -0.420769f, -0.434587f, -0.484349f,
    0.201372f, -0.083851f,  0.395076f, -0.107986f,  0.419503f, -0.299347f,  0.398009f,
    0.186752f,  0.129970f,  0.194697f, -0.363983f,  0.262073f,  0.398052f,  0.250365f,
    -0.364270f,  0.162225f,  0.026818f, -0.218484f,  0.483567f,  0.062229f,  0.143514f,
    -0.422795f,  0.019861f, -0.242167f,  0.371007f, -0.057800f,  0.305637f, -0.394124f,
    0.467667f, -0.378511f,  0.072753f, -0.005237f, -0.030289f, -0.015147f, -0.180080f,
    0.131807f, -0.038852f, -0.425931f, -0.423269f, -0.067577f,  0.410338f, -0.388345f,
    -0.241040f, -0.331118f, -0.403451f, -0.347742f, -0.494457f,  0.444351f, -0.431580f,
    0.144573f,  0.085815f,  0.490848f, -0.342230f, -0.364650f,  0.450386f,  0.314574f,
    0.161752f, -0.237428f,  0.466885f,  0.224701f,  0.013986f,  0.080785f,  0.419453f,
    0.255403f, -0.282727f,  0.369136f, -0.313980f, -0.272275f, -0.101842f,  0.076580f,
    0.258085f,  0.077538f,  0.474385f,  0.346595f, -0.307200f,  0.306367f, -0.227116f,
    -0.023526f, -0.163943f, -0.220535f, -0.313079f,  0.247705f,  0.017943f, -0.285650f,
    -0.429507f, -0.188715f, -0.420826f, -0.234458f, -0.494348f,  0.425117f,  0.360058f,
    -0.362056f, -0.420377f, -0.026669f, -0.115741f, -0.249224f,  0.124252f, -0.294159f,
    0.250515f,  0.053069f, -0.482873f,  0.330297f,  0.449810f,  0.165196f,  0.153813f,
    0.480452f, -0.163003f, -0.078093f, -0.127974f,  0.140787f, -0.421021f,  0.031849f,
    0.254523f, -0.004203f, -0.008680f,  0.185974f,  0.437285f,  0.015847f,  0.067216f,
    0.359827f, -0.102175f,  0.215111f,  0.143412f, -0.091919f,  0.055589f, -0.300932f,
    0.373829f,  0.067377f, -0.241653f,  0.340907f,  0.470879f, -0.282590f, -0.003140f,
    -0.377534f,  0.394871f,  0.330016f, -0.357862f, -0.016290f,  0.332369f,  0.419908f,
    0.058128f,  0.036131f,  0.304178f,  0.034722f,  0.046208f,  0.003638f,  0.122985f,
    -0.249540f,  0.430459f,  0.006725f, -0.389943f, -0.286378f,  0.414092f,  0.252034f,
    0.051293f, -0.236156f, -0.386992f, -0.266779f, -0.212978f, -0.070711f, -0.096842f,
    -0.203196f, -0.309992f,  0.288182f,  0.170850f,  0.437851f, -0.414849f, -0.411433f,
    0.011570f, -0.272207f, -0.463783f,  0.197645f, -0.068895f, -0.443952f,  0.394052f,
    0.073052f, -0.273662f,  0.307498f,  0.232066f,  0.000400f,  0.290974f,  0.071236f,
    -0.155925f,  0.391676f, -0.051440f,  0.057602f, -0.456903f,  0.383335f, -0.328350f,
    -0.381356f,  0.164342f, -0.215480f, -0.172001f,  0.353254f, -0.331029f, -0.093203f,
    -0.206330f,  0.416893f, -0.314683f,  0.336837f,  0.296294f,  0.234720f, -0.029883f,
    0.000643f,  0.372129f,  0.176918f,  0.273050f,  0.198415f, -0.473335f,  0.439987f,
    -0.266143f, -0.222874f,  0.034277f, -0.115132f,  0.412916f, -0.054222f,  0.267603f,
    0.112066f,  0.174873f, -0.053332f, -0.252627f, -0.241064f,  0.122542f,  0.473366f,
    -0.000896f,  0.241229f,  0.467403f,  0.299296f, -0.188737f, -0.260349f, -0.133170f,
    -0.445270f, -0.357840f, -0.334940f,  0.240352f, -0.202416f, -0.481982f, -0.411027f,
    0.172352f, -0.124133f,  0.115750f,  0.368198f, -0.368458f,  0.316125f, -0.089954f,
    0.045619f, -0.305913f, -0.089733f,  0.380257f, -0.101197f, -0.306397f,  0.458140f,
    -0.321529f, -0.487652f,  0.074375f,  0.478811f, -0.267750f, -0.049765f, -0.328427f,
    -0.318465f,  0.135147f,  0.435527f,  0.052121f,  0.217596f,  0.022776f, -0.455850f,
    0.431018f,  0.174748f,  0.364546f, -0.121909f, -0.070296f,  0.462861f,  0.159778f,
    -0.204872f,  0.105585f, -0.463017f,  0.115850f, -0.215893f, -0.314290f,  0.254583f,
    -0.274986f, -0.062822f, -0.145880f,  0.337941f, -0.269067f,  0.086464f, -0.266486f,
    0.258952f, -0.213221f,  0.148873f,  0.470088f,  0.058892f,  0.420517f,  0.118768f,
    -0.431087f,  0.414795f,  0.022010f, -0.273391f,  0.469768f, -0.250019f,  0.498644f,
    -0.241633f,  0.324408f,  0.020191f,  0.074793f,  0.324381f,  0.200770f, -0.022128f,
    -0.235296f,  0.349468f, -0.446581f, -0.207160f, -0.326966f,  0.303698f,  0.458689f,
    0.283389f,  0.082601f, -0.266333f,  0.404616f,  0.161458f,  0.401028f, -0.281316f,
    0.077272f,  0.420518f,  0.348261f, -0.350248f, -0.285292f, -0.324716f,  0.182899f,
    0.099127f, -0.033771f,  0.106200f,  0.459519f,  0.355471f,  0.447472f, -0.045036f,
    0.470324f, -0.011847f,  0.110902f, -0.125448f, -0.393463f, -0.428974f,  0.337432f,
    0.050432f, -0.152254f,  0.141438f,  0.119250f, -0.100304f,  0.186239f, -0.252614f,
    -0.441447f,  0.420065f,  0.269170f,  0.401273f,  0.004186f,  0.328106f, -0.089121f,
    0.222055f, -0.268572f,  0.000244f,  0.422960f, -0.478470f,  0.023063f, -0.255575f,
    0.228672f,  0.040785f, -0.393088f, -0.004391f, -0.215566f, -0.361503f, -0.438840f,
    -0.116085f,  0.003562f,  0.095758f,  0.319760f,  0.087676f, -0.239128f, -0.342246f,
    0.242307f, -0.399732f, -0.488494f, -0.240877f,  0.192788f, -0.266908f, -0.040546f,
    -0.441284f, -0.322684f,  0.399205f,  0.202307f,  0.375299f, -0.309793f,  0.102730f,
    0.015912f, -0.493861f, -0.480311f, -0.443655f,  0.348829f, -0.183680f,  0.268214f,
    -0.001087f, -0.389842f, -0.298128f, -0.211894f, -0.047940f, -0.340442f, -0.198474f,
    -0.448413f, -0.219522f,  0.264849f,  0.110277f, -0.263522f,  0.276537f,  0.165837f,
    -0.163739f,  0.476921f, -0.076002f,  0.273855f, -0.452751f, -0.095093f,  0.185050f,
    0.211651f,  0.433780f, -0.213654f,  0.354363f, -0.360197f,  0.135400f,  0.368666f,
    0.316412f,  0.171768f, -0.249582f, -0.470051f,  0.089088f,  0.213363f, -0.203030f,
    -0.382643f, -0.173108f, -0.396945f, -0.113898f,  0.040797f,  0.058039f,  0.321655f,
    0.281183f, -0.057295f,  0.237322f, -0.105772f, -0.119344f,  0.183375f,  0.183963f,
    0.049132f,  0.204235f, -0.309035f, -0.057062f,  0.120822f, -0.129120f, -0.455577f,
    -0.060956f, -0.008461f, -0.282204f,  0.244722f, -0.306530f, -0.264936f, -0.035772f,
    -0.365453f, -0.371124f, -0.257997f, -0.284173f,  0.138905f, -0.284738f, -0.075580f,
    0.131962f,  0.099662f, -0.402416f, -0.411953f, -0.060251f,  0.287114f, -0.082282f,
    -0.042067f, -0.171994f,  0.403254f,  0.396506f, -0.100713f, -0.051583f, -0.103099f,
    -0.196872f, -0.393918f,  0.099259f,  0.433555f, -0.286299f,  0.467825f, -0.317954f,
    0.286446f,  0.281913f, -0.232266f, -0.331026f,  0.014222f, -0.477326f, -0.373215f,
    0.268210f,  0.480098f, -0.415371f, -0.233141f, -0.153122f,  0.352689f,  0.476126f,
    0.317203f, -0.206807f,  0.156533f, -0.142474f,  0.392055f,  0.148008f,  0.047346f,
    0.044133f,  0.399438f, -0.006555f,  0.250845f, -0.169733f, -0.356505f,  0.186824f,
    0.392821f,  0.276070f,  0.412512f,  0.209581f,  0.270638f,  0.152374f,  0.324785f,
    -0.246007f,  0.372065f,  0.351700f, -0.326759f,  0.489295f,  0.176275f, -0.390739f,
    0.071319f, -0.019727f, -0.095390f,  0.279263f,  0.076768f,  0.425785f,  0.496670f,
    0.449205f,  0.142059f,  0.145284f, -0.367712f,  0.197010f,  0.211088f,  0.174694f,
    0.204606f,  0.479362f,  0.318281f, -0.001512f, -0.233162f, -0.260496f,  0.430344f,
    0.105300f, -0.240693f,  0.421945f, -0.449322f,  0.425562f,  0.298277f, -0.158816f,
    0.345204f, -0.289384f, -0.360942f,  0.260961f, -0.424701f, -0.084630f,  0.168548f,
    0.167006f, -0.216686f, -0.273748f, -0.367061f, -0.044641f, -0.420822f, -0.438896f,
    -0.148115f,  0.083676f, -0.351189f, -0.110647f,  0.138296f, -0.053734f,  0.138082f,
    0.263704f,  0.151496f, -0.285179f,  0.267117f,  0.406613f, -0.280664f,  0.343934f,
    0.071687f,  0.396505f, -0.078428f,  0.159597f, -0.260303f, -0.005699f,  0.222304f,
    -0.455672f, -0.434436f,  0.437117f, -0.145679f,  0.396630f, -0.446808f,  0.303453f,
    -0.186044f,  0.295753f, -0.105266f, -0.024121f,  0.433586f, -0.256216f,  0.188335f,
    -0.350195f,  0.412603f, -0.087291f,  0.350130f,  0.069780f, -0.350154f, -0.000832f,
    -0.243755f,  0.230757f,  0.114793f,  0.417142f, -0.482827f,  0.126576f,  0.095731f,
    -0.450096f, -0.246784f,  0.430587f,  0.385706f, -0.123450f, -0.115232f,  0.375894f,
    -0.383087f, -0.197429f, -0.130194f,  0.390343f, -0.022327f,  0.103868f, -0.126639f,
    -0.487562f, -0.219883f,  0.262870f,  0.416039f, -0.249719f, -0.231272f,  0.185853f,
    -0.237678f,  0.280978f,  0.038151f,  0.471933f,  0.331728f,  0.360403f, -0.028095f,
    0.014682f, -0.330237f, -0.386369f, -0.378692f, -0.207149f, -0.060567f, -0.201381f,
    0.456053f,  0.111723f, -0.308015f,  0.427002f, -0.134900f, -0.266659f, -0.432717f,
    -0.263785f,  0.240187f, -0.447028f, -0.454867f,  0.340086f, -0.103735f,  0.089157f,
    -0.080150f, -0.453205f, -0.424032f, -0.267619f, -0.431797f,  0.383392f,  0.342081f,
    -0.302321f, -0.392474f,  0.067535f,  0.416687f,  0.032323f, -0.255574f,  0.235574f,
    0.002500f,  0.002284f, -0.441704f,  0.090527f,  0.486153f,  0.209707f,  0.477138f,
    -0.354067f,  0.230228f, -0.054520f,  0.130553f, -0.012778f, -0.392811f,  0.451743f,
    0.216602f,  0.479449f,  0.100831f, -0.067609f, -0.378449f, -0.149630f,  0.426967f,
    -0.392885f, -0.324150f,  0.255611f,  0.323078f, -0.263893f, -0.476653f, -0.324386f,
    0.185224f,  0.056368f,  0.296471f,  0.143092f,  0.239169f,  0.252502f,  0.316537f,
    0.398787f, -0.288600f,  0.049513f, -0.170652f,  0.119420f,  0.195148f, -0.045459f,
    -0.188167f,  0.055185f,  0.408081f,  0.109399f,  0.380743f,  0.408089f,  0.023721f,
    -0.255295f,  0.050490f, -0.066469f, -0.419383f,  0.276167f,  0.040674f,  0.365160f,
    0.374867f, -0.340939f, -0.443170f,  0.360028f,  0.106614f, -0.448936f,  0.258436f,
    -0.296836f,  0.154022f, -0.462367f,  0.299589f, -0.333143f,  0.104007f, -0.112787f,
    0.459175f,  0.312270f,  0.383314f,  0.343101f,  0.063523f, -0.025324f, -0.047256f,
    0.470385f,  0.005798f, -0.033088f,  0.388211f,  0.283513f,  0.058703f, -0.349908f,
    -0.247387f, -0.165377f, -0.497889f, -0.109281f,  0.330129f,  0.274553f, -0.497855f,
    -0.313186f,  0.058564f, -0.434462f, -0.394104f,  0.493354f, -0.245056f, -0.436950f,
    -0.405092f, -0.196892f, -0.475108f, -0.041605f, -0.025227f, -0.410021f,  0.008030f,
    -0.474191f, -0.212501f, -0.251612f, -0.089039f,  0.018569f, -0.296964f,  0.067348f,
    0.078356f, -0.243555f,  0.477434f,  0.168215f, -0.246331f, -0.381248f, -0.375763f,
    0.270133f, -0.322672f, -0.442177f,  0.314990f,  0.389670f, -0.104356f,  0.460270f,
    0.152164f,  0.346887f,  0.132488f, -0.131186f,  0.106697f, -0.341982f, -0.026779f,
    -0.274865f, -0.088049f,  0.417124f, -0.018147f,  0.471461f, -0.099180f, -0.319218f,
    -0.085497f, -0.049020f,  0.273409f, -0.300683f, -0.008438f,  0.048299f,  0.215070f,
    -0.183244f,  0.475386f, -0.287244f,  0.040274f, -0.325806f, -0.312305f,  0.289436f,
    -0.475999f, -0.114761f, -0.149807f,  0.153097f, -0.028086f, -0.051497f,  0.392531f,
    -0.214854f,  0.062047f,  0.364664f,  0.433602f,  0.267514f, -0.481859f, -0.268461f,
    0.186160f, -0.117894f, -0.282159f, -0.299984f, -0.118141f,  0.121082f,  0.133126f,
    -0.260023f,  0.176307f,  0.030035f,  0.296474f, -0.455111f, -0.276215f, -0.149961f,
    -0.198985f, -0.093794f, -0.047634f,  0.400401f, -0.291435f,  0.026687f, -0.094109f,
    0.384742f, -0.046307f,  0.481097f,  0.124065f, -0.280061f, -0.291530f, -0.457518f,
    -0.179052f,  0.319653f, -0.209736f, -0.005725f,  0.400860f,  0.329187f, -0.351278f,
    0.168161f, -0.434362f,  0.251564f,  0.118122f,  0.063250f, -0.244968f,  0.449798f,
    0.343732f,  0.495013f,  0.400480f,  0.209020f,  0.227145f,  0.227339f, -0.170319f,
    -0.475675f, -0.456962f, -0.404452f, -0.356027f, -0.496116f, -0.018643f, -0.176868f,
    -0.097829f,  0.278288f, -0.297150f, -0.135681f, -0.477023f,  0.450287f,  0.266516f,
    0.415337f,  0.394272f, -0.153287f, -0.285638f, -0.320313f, -0.177386f, -0.083322f,
    0.167439f,  0.450131f,  0.132169f, -0.094034f, -0.001698f,  0.188941f, -0.468472f,
    -0.396533f, -0.234524f, -0.392249f,  0.302635f,  0.256603f, -0.092623f,  0.031861f,
    0.062116f,  0.271750f,  0.244395f, -0.203154f,  0.326124f, -0.285935f, -0.308207f,
    0.486759f,  0.040390f, -0.112127f,  0.072046f, -0.144795f, -0.326843f,  0.481455f,
    0.377719f,  0.348241f,  0.106433f, -0.205903f,  0.385514f, -0.200221f, -0.012656f,
    0.402240f, -0.215432f, -0.172632f, -0.356084f, -0.432632f,  0.349083f, -0.096497f,
    -0.253513f, -0.379369f, -0.435834f, -0.097418f, -0.134036f,  0.186242f,  0.177176f,
    -0.032776f,  0.092672f,  0.213516f, -0.416611f, -0.156269f,  0.224687f,  0.490219f,
    -0.281447f, -0.097870f,  0.392900f,  0.300185f,  0.191550f,  0.081701f, -0.317024f,
    -0.313694f, -0.016629f,  0.141387f, -0.446277f, -0.015245f, -0.085197f,  0.202620f,
    -0.010285f, -0.165668f, -0.238652f,  0.459249f,  0.106523f,  0.241057f, -0.097943f,
    -0.391719f, -0.266673f, -0.174400f, -0.472909f,  0.491767f, -0.395536f, -0.489109f,
    0.010376f,  0.303403f, -0.386349f,  0.358655f,  0.157779f, -0.374775f, -0.072144f,
    0.353934f, -0.237447f,  0.345511f,  0.068380f, -0.188470f, -0.401281f, -0.053165f,
    -0.318479f, -0.038769f, -0.464461f, -0.275314f,  0.117889f, -0.288479f, -0.496087f,
    -0.363289f, -0.014021f, -0.275940f,  0.245617f, -0.171881f,  0.051024f, -0.288415f,
    0.051606f, -0.478969f, -0.386365f,  0.336108f,  0.484709f,  0.188354f,  0.364481f,
    -0.403274f, -0.411086f, -0.496679f, -0.398149f,  0.099291f, -0.468088f, -0.085699f,
    0.189707f, -0.135811f,  0.494958f,  0.244125f,  0.186665f,  0.202147f, -0.084661f,
    0.060534f,  0.293760f, -0.151891f, -0.331467f, -0.231072f,  0.144119f, -0.255342f,
    0.231576f,  0.203105f, -0.375616f,  0.192208f,  0.344219f, -0.350044f,  0.400545f,
    0.194448f, -0.256457f, -0.340976f,  0.284587f, -0.286574f, -0.480092f,  0.029613f,
    0.078832f, -0.223271f, -0.127743f,  0.111781f, -0.231716f,  0.344881f,  0.139089f,
    0.031596f, -0.015389f,  0.023952f,  0.073980f, -0.113299f,  0.266125f, -0.101714f,
    0.312841f,  0.040298f, -0.095532f,  0.341053f, -0.248513f, -0.242363f, -0.140588f,
    -0.156027f,  0.289329f, -0.080036f, -0.012318f, -0.021724f, -0.213387f, -0.039547f,
    0.460038f,  0.170953f, -0.417316f,  0.492091f, -0.086315f,  0.245961f,  0.001017f,
    0.038928f,  0.425683f, -0.340096f, -0.341466f,  0.492916f, -0.490673f,  0.154304f,
    0.353040f,  0.255168f, -0.117964f, -0.421229f, -0.159982f, -0.207611f, -0.026800f,
    -0.083995f, -0.039211f, -0.440681f, -0.082403f, -0.106332f, -0.354001f, -0.128146f,
    -0.111291f, -0.089199f,  0.105024f, -0.467707f, -0.018338f, -0.422995f, -0.397739f,
    0.429742f, -0.236801f, -0.221670f,  0.210194f,  0.290438f,  0.012367f,  0.490300f,
    -0.323142f, -0.487132f, -0.082585f,  0.279346f,  0.427891f,  0.072520f,  0.049229f,
    -0.379120f, -0.117633f, -0.244459f,  0.167688f,  0.445234f, -0.145725f,  0.117066f,
    0.343390f,  0.159677f,  0.260640f,  0.149466f, -0.107320f,  0.321860f, -0.398549f,
    0.482107f,  0.268815f,  0.021598f,  0.419782f,  0.264538f, -0.242809f,  0.306229f,
    -0.087469f, -0.340521f, -0.341008f, -0.069558f,  0.028401f, -0.006100f, -0.422591f,
    -0.326996f,  0.261097f,  0.192381f, -0.453781f,  0.117108f,  0.188794f, -0.293757f,
    -0.444799f,  0.392857f, -0.092028f,  0.017489f, -0.335671f,  0.012825f,  0.408591f,
    0.154132f,  0.383405f, -0.244260f, -0.298263f, -0.078053f,  0.490792f,  0.058423f,
    -0.030548f, -0.390787f, -0.470213f, -0.370445f,  0.004096f,  0.330706f,  0.050363f,
    -0.103859f, -0.148190f,  0.473471f,  0.344213f,  0.408324f,  0.497222f, -0.378865f,
    0.180038f, -0.237751f,  0.016199f,  0.050293f, -0.498231f, -0.166146f,  0.287421f,
    0.299553f,  0.463823f, -0.143245f, -0.235392f,  0.249905f, -0.306028f, -0.088976f,
    0.157909f, -0.331784f, -0.414098f, -0.169272f,  0.109376f, -0.249195f,  0.410860f,
    0.079185f,  0.043261f,  0.061568f,  0.422043f,  0.302288f, -0.437512f, -0.457830f,
    0.118704f, -0.349165f, -0.200957f,  0.336924f, -0.208357f,  0.489050f, -0.475234f,
    -0.168257f,  0.131193f,  0.283570f,  0.122365f,  0.067526f,  0.426597f, -0.372159f,
    -0.497736f,  0.019573f, -0.003577f, -0.087525f,  0.042585f, -0.195195f,  0.378202f,
    -0.158260f, -0.293693f, -0.190006f,  0.277621f,  0.137496f, -0.253897f, -0.148100f,
    -0.220373f, -0.489968f,  0.203938f, -0.437382f,  0.192490f, -0.466051f, -0.374834f,
    0.221931f, -0.391028f, -0.001612f, -0.322833f, -0.332383f, -0.305782f, -0.265762f,
    0.347845f, -0.157790f, -0.143218f, -0.185381f,  0.022245f,  0.071450f,  0.226598f,
    0.414949f,  0.434802f, -0.390485f,  0.291875f, -0.130396f,  0.474300f,  0.076213f,
    -0.433632f, -0.484090f,  0.298192f, -0.398220f, -0.159339f, -0.456517f, -0.321980f,
    0.189155f, -0.122178f,  0.116388f, -0.050949f, -0.392058f,  0.447653f, -0.316014f,
    0.141668f,  0.108418f,  0.347861f,  0.398546f, -0.388296f,  0.150440f,  0.168674f,
    0.496768f, -0.190439f, -0.103048f, -0.455886f,  0.039336f,  0.297240f,  0.343766f,
    0.163278f, -0.473130f,  0.067270f,  0.018545f, -0.055606f,  0.189465f, -0.017197f,
    0.257689f,  0.199229f, -0.424053f,  0.354112f,  0.188300f, -0.077336f, -0.078358f,
    0.419444f, -0.064809f,  0.259385f,  0.451658f, -0.300861f, -0.075586f, -0.155108f,
    -0.339774f, -0.251513f, -0.147119f, -0.149858f, -0.096396f, -0.080338f,  0.278954f,
    -0.172474f, -0.359466f,  0.044857f,  0.405574f, -0.349360f, -0.035504f, -0.074538f,
    0.472396f,  0.142046f, -0.111570f, -0.374477f, -0.053070f,  0.213189f,  0.185699f,
    -0.442822f,  0.060004f,  0.210920f, -0.440541f,  0.462215f,  0.024482f, -0.472048f,
    -0.066917f, -0.346022f, -0.182297f, -0.366522f, -0.268322f,  0.319765f, -0.289905f,
    0.398692f, -0.007881f, -0.406543f, -0.249076f, -0.295381f, -0.092539f,  0.304931f,
    0.345824f, -0.258584f,  0.220397f,  0.375819f, -0.498045f,  0.444945f, -0.453062f,
    0.355269f, -0.399650f,  0.114063f, -0.118725f,  0.434741f, -0.040330f,  0.247813f,
    -0.070630f, -0.176402f,  0.462603f,  0.012918f, -0.405887f, -0.251067f,  0.060061f,
    -0.133025f, -0.481375f, -0.279155f, -0.313105f, -0.269809f, -0.455458f, -0.498758f,
    -0.393157f, -0.382124f, -0.204915f,  0.368506f,  0.247811f, -0.142705f, -0.287492f,
    0.486264f,  0.438432f,  0.346359f,  0.208659f,  0.181711f, -0.436678f, -0.160406f,
    0.396309f, -0.297237f,  0.420967f, -0.069573f, -0.493763f,  0.054845f, -0.398996f,
    0.340956f,  0.237610f,  0.083833f, -0.443427f, -0.176115f,  0.191796f,  0.353903f,
    0.494974f, -0.439759f,  0.285437f,  0.115532f, -0.038098f,  0.425094f,  0.288499f,
    -0.166759f, -0.029927f,  0.056873f,  0.376398f,  0.173882f, -0.405925f, -0.140264f,
    -0.110499f, -0.110900f, -0.304973f,  0.088944f,  0.253890f, -0.229564f,  0.379421f,
    0.103399f,  0.207843f,  0.438278f, -0.332227f, -0.055150f,  0.400816f, -0.461770f,
    -0.164959f,  0.237958f, -0.034351f,  0.367514f, -0.126175f,  0.258222f, -0.481670f,
    -0.287200f,  0.363990f,  0.035150f, -0.000986f, -0.062326f, -0.247502f, -0.164028f,
    -0.052605f,  0.067013f,  0.151976f, -0.008614f, -0.102658f, -0.253493f,  0.456004f,
    0.100564f,  0.100456f, -0.256135f, -0.003219f,  0.399770f,  0.344503f, -0.145246f,
    0.492883f, -0.149856f,  0.147254f,  0.197940f,  0.461177f,  0.038464f, -0.415889f,
    0.462590f,  0.109931f, -0.326028f, -0.218135f, -0.495875f,  0.455944f, -0.421060f,
    0.092299f,  0.086885f, -0.314284f,  0.025622f, -0.112738f, -0.378751f, -0.268352f,
    -0.126670f,  0.108794f, -0.465540f,  0.483989f, -0.347291f,  0.309220f, -0.191323f,
    -0.213825f, -0.133005f,  0.150712f,  0.092531f,  0.346727f, -0.190551f, -0.246841f,
    0.285493f,  0.379576f,  0.000609f,  0.013365f,  0.264727f,  0.294246f,  0.437143f,
    0.025500f,  0.394744f,  0.188604f, -0.384546f,  0.048533f,  0.069569f, -0.456230f,
    0.287696f,  0.455387f, -0.010664f,  0.130394f,  0.056292f, -0.296999f,  0.387997f,
    0.158030f, -0.213387f,  0.353123f,  0.491520f, -0.461954f, -0.121898f,  0.398824f,
    0.097545f,  0.391926f,  0.284411f, -0.211558f,  0.094492f, -0.319530f, -0.193883f,
    -0.158341f, -0.237046f, -0.182049f,  0.229198f, -0.195281f, -0.127493f,  0.084631f,
    -0.126974f, -0.245391f,  0.466509f,  0.480070f, -0.291799f,  0.424513f,  0.144987f,
    -0.259554f,  0.462863f, -0.147540f, -0.043885f, -0.349112f, -0.247679f,  0.447322f,
    0.300477f, -0.453138f, -0.171985f, -0.405239f, -0.334910f,  0.248424f, -0.224675f,
    0.092185f,  0.427875f,  0.292262f,  0.013957f, -0.113857f,  0.314892f, -0.393508f,
    -0.471926f, -0.004209f, -0.474755f,  0.053113f,  0.025726f,  0.428350f, -0.249532f,
    0.086629f, -0.011770f, -0.058997f, -0.239406f,  0.141895f, -0.499195f, -0.129117f,
    0.377637f, -0.030285f, -0.322821f, -0.038794f,  0.244381f, -0.361384f,  0.115027f,
    0.255751f,  0.072904f,  0.171869f, -0.001581f,  0.142664f,  0.040083f,  0.099845f,
    0.441241f, -0.493251f, -0.281682f, -0.408094f,  0.325496f, -0.469948f, -0.312962f,
    0.254955f,  0.004917f, -0.125228f, -0.422527f,  0.316577f, -0.267435f,  0.029625f,
    0.338853f,  0.371397f, -0.163475f,  0.318085f, -0.426526f,  0.485016f,  0.456972f,
    0.099948f, -0.268958f,  0.499103f, -0.092564f, -0.229896f,  0.155665f,  0.345260f,
    0.410779f,  0.321908f, -0.416863f, -0.011302f,  0.454264f,  0.127093f, -0.150868f,
    -0.076584f,  0.316949f, -0.352282f, -0.286604f, -0.480958f,  0.345965f, -0.425636f,
    -0.230489f, -0.230041f,  0.335934f,  0.242879f,  0.098294f,  0.366664f,  0.328694f,
    -0.438097f,  0.355300f,  0.447891f,  0.369729f,  0.355581f,  0.344375f, -0.197022f,
    0.195328f,  0.339010f,  0.320886f, -0.216107f, -0.417053f, -0.425212f, -0.443381f,
    0.314767f, -0.330293f,  0.462409f,  0.365738f,  0.416317f,  0.064307f,  0.171233f,
    0.385338f, -0.190803f,  0.070102f,  0.103416f,  0.488640f, -0.157189f, -0.033063f,
    -0.045152f,  0.112712f,  0.086726f, -0.377966f,  0.297149f, -0.149371f, -0.004438f,
    -0.087822f,  0.227616f,  0.000439f, -0.356405f, -0.372472f, -0.499620f,  0.006228f,
    0.353576f, -0.080843f, -0.037367f, -0.238439f,  0.300123f, -0.433999f, -0.045482f,
    -0.020177f, -0.260857f, -0.368881f,  0.298144f, -0.057618f,  0.241901f, -0.398546f,
    0.386359f,  0.102486f,  0.239525f,  0.149610f, -0.200417f,  0.204508f, -0.192007f,
    -0.098752f, -0.478410f, -0.255696f,  0.145171f,  0.358859f, -0.286823f, -0.017625f,
    -0.236368f, -0.366306f, -0.265298f,  0.078205f,  0.402130f,  0.225245f, -0.388615f,
    -0.241764f, -0.145594f, -0.495166f, -0.086173f, -0.206454f, -0.160893f,  0.190543f,
    0.413511f,  0.244444f,  0.154813f,  0.219217f,  0.280155f,  0.241169f,  0.348485f,
    0.442661f, -0.245977f,  0.091943f,  0.096079f,  0.305116f,  0.468966f, -0.163611f,
    0.275873f, -0.456111f,  0.066681f,  0.354259f,  0.086490f,  0.331579f, -0.347053f,
    -0.327692f, -0.495831f, -0.375800f, -0.445723f, -0.172137f,  0.322046f, -0.337172f,
    -0.131644f,  0.203134f,  0.105833f,  0.105951f,  0.421846f, -0.437364f, -0.273938f,
    -0.455009f, -0.009297f, -0.454381f, -0.019010f, -0.283645f,  0.365438f,  0.290282f,
    -0.046581f, -0.499254f, -0.000969f,  0.416463f, -0.400801f,  0.365394f,  0.329042f,
    0.253856f,  0.048479f, -0.280558f,  0.266493f, -0.025476f, -0.180834f,  0.319384f,
    -0.030953f, -0.061790f, -0.344732f,  0.373365f, -0.380199f, -0.131116f, -0.226638f,
    -0.015821f,  0.098586f,  0.498978f, -0.355682f, -0.434726f, -0.178716f, -0.392697f,
    -0.026541f, -0.472946f, -0.376591f,  0.266861f, -0.357338f, -0.082023f, -0.055367f,
    -0.045673f,  0.117709f, -0.487416f,  0.126407f, -0.435719f,  0.231782f, -0.346380f,
    -0.160918f,  0.444274f, -0.437204f, -0.294602f,  0.309686f,  0.213109f, -0.487121f,
    0.378569f, -0.493376f,  0.251568f,  0.060438f,  0.201435f, -0.038908f, -0.464990f,
    0.329650f, -0.310890f, -0.246962f, -0.400636f,  0.152914f,  0.089416f, -0.023660f,
    0.350052f, -0.314151f,  0.143940f, -0.084181f, -0.392884f, -0.428085f, -0.084507f,
    0.238422f,  0.464566f, -0.201798f,  0.111251f, -0.179186f, -0.021258f,  0.091557f,
    0.326609f, -0.167292f,  0.405874f, -0.215170f,  0.491447f,  0.374180f,  0.215247f,
    -0.450914f,  0.401865f,  0.159183f, -0.290688f,  0.205163f,  0.340890f,  0.357469f,
    0.099155f,  0.165748f,  0.346253f, -0.007504f, -0.107870f, -0.460630f, -0.022220f,
    0.060975f,  0.042812f, -0.124499f,  0.417375f,  0.436033f,  0.359136f,  0.223688f,
    0.238157f,  0.364168f, -0.481373f,  0.100684f,  0.183336f,  0.017961f, -0.123373f,
    0.042571f,  0.168186f, -0.248133f,  0.196496f,  0.301457f,  0.468778f, -0.114796f,
    -0.076065f, -0.480583f, -0.411687f, -0.459019f, -0.397810f, -0.330231f, -0.363961f,
    0.165579f,  0.186058f,  0.444701f, -0.354473f,  0.284996f,  0.080172f, -0.461192f,
    0.169748f,  0.088820f, -0.313815f, -0.166354f, -0.318117f, -0.077946f, -0.404715f,
    0.435330f, -0.114313f,  0.383964f, -0.426469f,  0.415172f,  0.490604f, -0.262685f,
    0.440021f,  0.214964f,  0.468520f, -0.196382f,  0.379730f,  0.219625f,  0.305506f,
    -0.378552f,  0.227498f,  0.389531f,  0.458075f,  0.364830f, -0.363830f, -0.045076f,
    -0.324873f,  0.424487f, -0.354948f, -0.419389f,  0.250109f,  0.041849f,  0.104969f,
    -0.360971f, -0.290109f,  0.427898f,  0.319290f,  0.015038f,  0.155054f,  0.197775f,
    -0.482075f,  0.391240f,  0.058760f,  0.087600f, -0.199299f,  0.115695f,  0.067011f,
    0.000135f, -0.359411f,  0.375632f,  0.371292f,  0.236813f,  0.114375f, -0.465058f,
    -0.164682f,  0.429663f, -0.317240f, -0.362970f, -0.068370f, -0.120003f, -0.456853f,
    0.428175f,  0.002287f,  0.262075f, -0.438008f, -0.026794f, -0.387090f, -0.442243f,
    0.310395f,  0.371492f,  0.173265f, -0.420607f,  0.293369f,  0.046607f,  0.293717f,
    0.017497f, -0.387981f,  0.090112f, -0.081064f, -0.049629f, -0.173409f, -0.345317f,
    0.402622f, -0.414277f,  0.010558f,  0.083156f, -0.225142f,  0.408832f, -0.019420f,
    0.449999f,  0.312530f,  0.205283f, -0.450869f,  0.305588f, -0.400530f, -0.245740f,
    -0.263891f,  0.429616f, -0.106553f, -0.425534f,  0.068896f,  0.299547f,  0.279391f,
    -0.499309f,  0.038598f,  0.197806f, -0.349535f,  0.204754f,  0.120914f, -0.444978f,
    -0.470410f,  0.008035f,  0.436055f,  0.346959f, -0.476841f, -0.499817f, -0.448211f,
    0.423745f,  0.326053f, -0.055869f,  0.331247f,  0.298665f, -0.396731f,  0.153602f,
    0.312204f, -0.389619f,  0.329874f,  0.246429f,  0.362528f, -0.399796f, -0.260556f,
    0.253815f,  0.288416f,  0.121542f, -0.485787f,  0.178877f,  0.444373f, -0.018679f,
    0.240997f, -0.497591f, -0.010974f, -0.434158f,  0.089381f, -0.087346f,  0.296497f,
    0.441907f, -0.332981f, -0.149742f, -0.267202f, -0.132849f, -0.263678f,  0.298619f,
    -0.130452f,  0.263360f, -0.007112f, -0.318959f, -0.421951f, -0.221575f,  0.105078f,
    0.144861f, -0.064275f,  0.114632f,  0.283104f,  0.392760f, -0.389924f,  0.064894f,
    -0.487660f,  0.364488f,  0.254249f,  0.358624f,  0.367545f, -0.141876f,  0.360356f,
    -0.136870f, -0.219006f, -0.183178f,  0.144492f,  0.255343f, -0.082330f, -0.219207f,
    0.069686f, -0.483578f,  0.204595f, -0.470619f,  0.003658f,  0.005341f, -0.250157f,
    0.406873f,  0.227190f,  0.137112f, -0.308989f,  0.258599f,  0.291260f,  0.480278f,
    0.144860f,  0.399664f,  0.318089f,  0.252974f,  0.241985f,  0.023920f, -0.230759f,
    0.046996f,  0.465965f, -0.059433f, -0.004669f,  0.157416f,  0.059199f,  0.332985f,
    0.334452f,  0.107338f,  0.381986f,  0.280171f, -0.046289f,  0.002229f, -0.267584f,
    0.304822f, -0.390736f, -0.152005f, -0.442033f,  0.030946f, -0.370238f,  0.246817f,
    0.161594f, -0.206494f, -0.433502f,  0.223012f, -0.237485f,  0.466564f,  0.476749f,
    -0.190737f,  0.092400f, -0.083523f, -0.143599f,  0.376118f, -0.040711f, -0.027191f,
    -0.028727f,  0.152292f,  0.403331f,  0.099754f,  0.176294f, -0.449111f,  0.099455f,
    -0.418899f, -0.303508f, -0.418841f, -0.427297f, -0.133514f, -0.022409f,  0.033830f,
    0.012603f,  0.208103f, -0.183321f,  0.230639f,  0.075041f,  0.115842f,  0.040244f,
    -0.171242f,  0.005524f, -0.176519f,  0.008834f, -0.425212f, -0.191038f, -0.434031f,
    -0.038702f, -0.429547f, -0.478576f,  0.272767f,  0.449274f, -0.194195f,  0.042411f,
    0.367754f,  0.402031f, -0.348633f,  0.486547f, -0.106566f, -0.233394f,  0.097298f,
    -0.223832f, -0.364590f,  0.017336f, -0.342755f, -0.223126f,  0.379636f, -0.032782f,
    -0.407576f, -0.127183f, -0.214623f,  0.351278f, -0.014170f, -0.425559f, -0.425253f,
    0.215410f, -0.061156f, -0.224076f,  0.126822f, -0.375592f, -0.042591f,  0.251011f,
    0.000664f,  0.007479f,  0.330116f,  0.152937f,  0.104998f,  0.261256f, -0.183251f,
    -0.183762f, -0.030986f, -0.282403f,  0.307088f,  0.335390f, -0.036987f,  0.210516f,
    -0.226923f, -0.101870f,  0.061764f, -0.286995f,  0.023071f,  0.001249f,  0.358034f,
    -0.404206f, -0.371944f, -0.314480f, -0.382623f,  0.237045f,  0.282994f,  0.146810f,
    -0.355264f,  0.001407f, -0.398723f,  0.255441f, -0.386468f,  0.040777f,  0.429447f,
    0.029319f,  0.121797f, -0.254459f, -0.321373f,  0.232688f, -0.001439f,  0.307398f,
    0.067468f,  0.426542f, -0.473494f, -0.177796f,  0.180939f, -0.215467f,  0.091150f,
    -0.241598f, -0.304881f,  0.255792f,  0.458058f, -0.196247f,  0.278679f, -0.459529f,
    0.141461f, -0.043577f, -0.461653f,  0.322477f,  0.211861f, -0.112627f, -0.137045f,
    0.145024f, -0.473261f, -0.273107f,  0.276308f, -0.273020f, -0.284800f,  0.441738f,
    -0.475997f, -0.198927f,  0.340581f,  0.309141f, -0.112703f,  0.248779f, -0.131153f,
    -0.135806f,  0.385330f,  0.341812f,  0.327446f,  0.317308f, -0.454386f, -0.152039f,
    -0.380269f,  0.294138f,  0.195042f,  0.081374f,  0.212595f, -0.157624f,  0.356125f,
    0.276828f, -0.483484f, -0.255111f,  0.385453f, -0.062680f,  0.482552f,  0.058890f,
    -0.273996f, -0.321895f,  0.332963f, -0.485814f, -0.222135f,  0.092583f, -0.417688f,
    -0.486602f,  0.342058f, -0.038717f, -0.416788f,  0.312553f,  0.231528f, -0.229837f,
    0.312870f, -0.133634f,  0.047256f, -0.305094f,  0.398601f,  0.409111f, -0.185946f,
    -0.469249f, -0.063663f,  0.235306f,  0.391504f,  0.230181f,  0.287427f,  0.236060f,
    0.005178f, -0.128382f,  0.125728f,  0.444077f,  0.269425f, -0.219944f, -0.242945f,
    0.315829f,  0.036542f, -0.195438f,  0.432694f,  0.421803f, -0.148160f,  0.217955f,
    -0.357989f,  0.079089f, -0.282728f, -0.478682f,  0.388810f, -0.285431f, -0.032169f,
    0.431651f,  0.252249f,  0.127088f, -0.001567f,  0.216786f, -0.295299f, -0.425970f,
    0.200741f,  0.170299f,  0.132509f, -0.241570f,  0.088999f, -0.366420f,  0.286136f,
    0.369324f,  0.224119f,  0.456433f,  0.306688f,  0.128231f,  0.151836f, -0.084180f,
    -0.052619f,  0.132102f,  0.322605f, -0.200225f,  0.370425f,  0.236726f,  0.480214f,
    -0.084244f, -0.230532f, -0.110722f, -0.382079f, -0.354010f, -0.309404f,  0.054706f,
    -0.416264f,  0.183713f,  0.024678f,  0.064019f,  0.251580f, -0.278930f,  0.272168f,
    0.484808f, -0.202901f,  0.490034f,  0.468414f, -0.367222f, -0.336361f,  0.190798f,
    -0.439118f, -0.469490f, -0.134051f, -0.122914f, -0.414225f, -0.085408f,  0.150739f,
    -0.155189f, -0.435517f, -0.001220f,  0.461160f, -0.079920f,  0.072525f, -0.161353f,
    0.086896f, -0.163965f,  0.195725f,  0.297705f, -0.273830f,  0.087350f,  0.428785f,
    0.287050f, -0.453062f, -0.141154f, -0.332860f,  0.407001f, -0.228401f, -0.166070f,
    0.048652f, -0.358005f, -0.414822f,  0.033053f,  0.100562f, -0.102834f,  0.497175f,
    0.336630f, -0.399904f, -0.020020f,  0.090873f,  0.175887f,  0.253660f, -0.047857f,
    0.243087f, -0.415452f, -0.193150f,  0.450452f, -0.032809f, -0.409576f,  0.411247f,
    -0.289283f, -0.448824f, -0.124202f, -0.032344f,  0.252259f,  0.361878f, -0.023560f,
    0.040864f, -0.116551f, -0.249029f, -0.360556f, -0.321887f,  0.278466f, -0.184514f,
    -0.421527f, -0.229815f, -0.475179f,  0.176385f, -0.098969f,  0.256480f, -0.061365f,
    0.486998f,  0.225906f, -0.391981f,  0.044377f, -0.434052f, -0.359239f,  0.317222f,
    -0.112675f,  0.066856f,  0.491181f,  0.101193f,  0.025957f, -0.397195f, -0.244714f,
    -0.215348f,  0.388606f, -0.406145f, -0.205222f,  0.296377f,  0.190770f, -0.389768f,
    0.327247f,  0.393976f, -0.171439f,  0.155061f, -0.080602f, -0.041101f, -0.112132f,
    0.134287f,  0.431110f,  0.388113f,  0.451262f,  0.366855f,  0.060829f,  0.489870f,
    -0.175291f, -0.482747f, -0.240497f, -0.313897f, -0.261604f, -0.389605f,  0.239237f,
    0.378438f,  0.360819f, -0.406128f, -0.058816f,  0.272509f, -0.021258f,  0.226251f,
    -0.377796f, -0.172248f, -0.420787f,  0.326913f, -0.460076f, -0.062880f,  0.480872f,
    0.260631f,  0.069582f,  0.401233f, -0.476979f, -0.460530f,  0.373013f, -0.219611f,
    -0.429035f, -0.100394f,  0.000313f,  0.149973f,  0.438935f, -0.101570f, -0.031259f,
    0.092430f, -0.012658f,  0.427884f, -0.497396f, -0.297346f, -0.395612f, -0.043116f,
    -0.305838f,  0.312018f, -0.465715f,  0.405184f,  0.461446f,  0.226056f,  0.332013f,
    0.372813f,  0.327553f, -0.223066f, -0.110038f, -0.234092f,  0.361192f, -0.002686f,
    0.042772f,  0.387228f, -0.375548f, -0.111891f,  0.276732f, -0.283211f,  0.336000f,
    -0.431735f, -0.121768f,  0.266973f, -0.268217f,  0.127440f,  0.296842f, -0.367631f,
    -0.012793f,  0.147801f,  0.182843f, -0.304240f,  0.141512f,  0.092732f, -0.387502f,
    -0.370394f,  0.464237f, -0.120154f,  0.328653f,  0.031538f,  0.243436f,  0.343155f,
    0.306526f,  0.140626f,  0.314468f,  0.152624f, -0.222244f, -0.060834f,  0.436106f,
    0.384702f, -0.301687f, -0.403450f, -0.352530f, -0.060882f, -0.018131f,  0.154366f,
    0.185587f, -0.432470f,  0.109436f,  0.285543f,  0.230370f,  0.439143f, -0.296219f,
    0.038325f,  0.383624f,  0.015708f, -0.425620f, -0.445325f,  0.233592f, -0.029804f,
    -0.387966f,  0.141816f, -0.150009f, -0.035251f, -0.226045f, -0.212132f,  0.480043f,
    0.137282f, -0.451975f,  0.213587f, -0.151830f,  0.043481f, -0.467486f,  0.011160f,
    0.215842f, -0.198867f, -0.306165f, -0.040209f,  0.039229f,  0.104144f,  0.064793f,
    -0.448287f, -0.383037f,  0.259793f, -0.020562f,  0.389590f,  0.385616f,  0.178276f,
    -0.215844f, -0.091587f,  0.473736f,  0.360253f,  0.459551f, -0.233407f,  0.134797f,
    0.015808f, -0.108699f, -0.120339f, -0.246089f, -0.035142f,  0.063221f,  0.026659f,
    0.162069f,  0.450935f,  0.150894f,  0.037816f,  0.035036f,  0.311463f,  0.073364f,
    0.019617f, -0.367469f, -0.469305f,  0.233382f, -0.159963f,  0.118198f,  0.326802f,
    -0.071179f,  0.085807f,  0.154123f, -0.059154f, -0.249821f,  0.021646f,  0.487701f,
    -0.120676f,  0.458074f,  0.287915f,  0.336799f, -0.231511f, -0.357341f,  0.430864f,
    -0.334945f,  0.290719f,  0.451659f,  0.084368f, -0.052677f,  0.052040f, -0.101137f,
    0.132711f, -0.079309f,  0.164662f, -0.440628f,  0.352667f, -0.345164f, -0.113485f,
    -0.333445f,  0.435051f,  0.253089f, -0.263238f, -0.141258f,  0.449312f, -0.300757f,
    0.075739f, -0.292765f,  0.471216f,  0.022564f, -0.498503f,  0.082836f,  0.427585f,
    -0.317338f,  0.452982f, -0.207054f,  0.111329f,  0.135733f, -0.170093f,  0.418322f,
    -0.374755f,  0.083571f,  0.027616f,  0.086197f,  0.268402f,  0.216737f, -0.343924f,
    -0.011205f, -0.418724f,  0.023950f,  0.057837f, -0.236970f,  0.115473f, -0.227438f,
    0.080952f, -0.376239f, -0.355852f,  0.281636f, -0.001944f,  0.140254f,  0.336489f,
    -0.037647f, -0.081209f,  0.280227f, -0.306390f, -0.466709f,  0.024506f,  0.350091f,
    0.296348f,  0.214418f, -0.205454f, -0.468251f,  0.113878f,  0.337748f, -0.496296f,
    0.168950f, -0.065553f, -0.400373f,  0.389757f, -0.131160f, -0.471886f,  0.425230f,
    0.335812f, -0.048216f,  0.261290f, -0.433777f, -0.169985f,  0.165038f, -0.167540f,
    0.444784f, -0.421430f, -0.250568f, -0.430867f,  0.368604f,  0.008839f, -0.445504f,
    -0.247581f,  0.440497f,  0.137342f, -0.406371f, -0.144620f,  0.281397f, -0.149216f,
    0.139844f,  0.485207f, -0.023580f, -0.407020f, -0.377224f, -0.498674f,  0.480221f,
    0.130907f,  0.403136f, -0.011194f,  0.010837f,  0.431552f,  0.191348f, -0.050879f,
    0.291789f,  0.488159f, -0.071917f,  0.131690f,  0.332401f,  0.038656f,  0.356751f,
    -0.023819f,  0.368575f, -0.302903f,  0.058355f,  0.226867f, -0.386169f, -0.174112f,
    0.169705f,  0.179058f,  0.227021f,  0.095262f,  0.414580f,  0.439601f, -0.086722f,
    -0.231803f,  0.007657f,  0.447648f, -0.496672f,  0.302862f, -0.228205f,  0.180324f,
    -0.240859f,  0.448205f, -0.214484f, -0.464128f,  0.227160f,  0.016895f, -0.340576f,
    -0.127468f, -0.208998f,  0.427252f,  0.253913f,  0.316374f,  0.391115f, -0.286405f,
    0.187495f,  0.420026f,  0.297559f,  0.392758f, -0.247524f, -0.055521f,  0.102614f,
    -0.448884f,  0.025615f,  0.288705f, -0.108215f,  0.067662f, -0.275963f, -0.049370f,
    -0.355093f, -0.371399f,  0.165376f,  0.365166f, -0.005719f,  0.310065f,  0.015454f,
    0.230663f, -0.154834f,  0.028306f,  0.082167f, -0.342317f, -0.242365f,  0.179848f,
    0.491677f,  0.009787f,  0.250193f, -0.255793f,  0.179001f,  0.464744f, -0.442190f,
    0.003899f, -0.228069f,  0.118777f, -0.255956f, -0.316487f, -0.057188f, -0.147912f,
    0.202977f, -0.367260f, -0.039639f,  0.339871f,  0.406919f,  0.416783f,  0.072763f,
    0.151308f, -0.434114f,  0.148712f,  0.088215f,  0.155039f, -0.389048f,  0.247845f,
    -0.049525f, -0.278628f,  0.432755f,  0.259508f, -0.389399f, -0.039262f, -0.423923f,
    0.476460f,  0.213682f,  0.399001f, -0.020133f,  0.490751f, -0.291893f, -0.299032f,
    -0.132062f,  0.434711f, -0.132334f, -0.095347f,  0.438428f,  0.077395f,  0.332025f,
    -0.085609f, -0.390159f, -0.007675f,  0.322935f, -0.032051f,  0.188945f,  0.146177f,
    -0.098337f,  0.391463f, -0.497964f, -0.253334f, -0.017052f,  0.089665f, -0.261732f,
    0.379923f,  0.313191f, -0.006028f,  0.094179f,  0.039874f, -0.477699f, -0.332971f,
    -0.224378f, -0.140571f,  0.451716f, -0.297910f,  0.140566f,  0.278662f, -0.206361f,
    -0.325160f, -0.221639f,  0.189753f, -0.288274f, -0.377036f,  0.282828f, -0.228497f,
    0.380659f,  0.217025f,  0.443841f,  0.335150f,  0.125805f, -0.479913f, -0.248989f,
    0.443483f,  0.174906f,  0.041558f, -0.439278f, -0.189507f, -0.422538f,  0.404131f,
    0.251545f,  0.340826f, -0.004289f, -0.453769f, -0.198817f,  0.006939f,  0.231178f,
    -0.136384f, -0.280629f, -0.204869f,  0.195398f, -0.106396f,  0.314926f,  0.465707f,
    -0.248780f,  0.107727f,  0.151542f,  0.481587f,  0.396074f, -0.399487f, -0.063463f,
    -0.143792f,  0.100521f,  0.143813f,  0.310906f,  0.375967f, -0.010413f,  0.370847f,
    0.279663f,  0.263446f, -0.288107f,  0.118507f, -0.308990f, -0.208042f, -0.201098f,
    -0.000132f, -0.015358f,  0.144433f, -0.393940f, -0.385855f, -0.232837f,  0.263362f,
    0.346961f, -0.105817f, -0.089374f, -0.025457f, -0.405510f, -0.388931f,  0.223631f,
    0.025006f, -0.491805f,  0.123514f,  0.118919f,  0.172080f,  0.049712f, -0.098378f,
    -0.456790f,  0.241667f, -0.071761f, -0.051220f,  0.081135f,  0.362984f, -0.148200f,
    -0.026933f,  0.073002f, -0.063899f,  0.488951f,  0.455533f, -0.336010f,  0.427480f,
    0.026920f, -0.235616f,  0.438964f, -0.224739f,  0.268747f,  0.262634f,  0.091902f,
    0.056609f,  0.282317f,  0.245806f, -0.028141f,  0.488051f, -0.097688f,  0.273113f,
    0.269293f, -0.261057f,  0.111844f,  0.470198f, -0.371459f, -0.291532f, -0.020869f,
    0.087493f, -0.443651f,  0.196458f,  0.397110f, -0.398224f, -0.254987f,  0.464747f,
    0.136875f,  0.009403f,  0.335201f,  0.293384f,  0.461558f,  0.440404f, -0.158488f,
    0.368123f, -0.196460f, -0.460839f,  0.477876f,  0.353003f,  0.348257f,  0.128632f,
    -0.385092f, -0.205903f,  0.121301f, -0.126972f,  0.133045f, -0.365251f, -0.313096f,
    0.053823f,  0.199984f, -0.005427f,  0.445462f,  0.204223f,  0.085499f,  0.447583f,
    -0.108460f,  0.439179f, -0.241290f,  0.131033f, -0.046599f, -0.443720f,  0.310462f,
    0.005521f, -0.412325f, -0.244821f,  0.465419f, -0.323120f,  0.321346f,  0.470221f,
    0.244248f, -0.332700f,  0.106024f, -0.123145f, -0.004182f, -0.498634f,  0.130841f,
    0.114034f, -0.276550f, -0.355420f, -0.400239f, -0.137445f, -0.300927f,  0.218025f,
    -0.347822f,  0.286307f, -0.493258f, -0.388329f, -0.156811f,  0.336286f, -0.265279f,
    0.057276f, -0.081372f,  0.345402f, -0.213436f, -0.095287f,  0.051936f, -0.281592f,
    -0.410011f, -0.394115f, -0.446831f,  0.311411f,  0.122348f,  0.159308f,  0.128282f,
    -0.031590f, -0.441904f,  0.245220f, -0.361467f,  0.260169f, -0.217363f,  0.303039f,
    -0.420070f,  0.078694f, -0.045565f,  0.015756f,  0.031698f, -0.343046f, -0.429676f,
    -0.207090f, -0.013476f,  0.289723f,  0.075060f, -0.062974f, -0.084395f,  0.462042f,
    -0.176553f, -0.132363f,  0.295440f, -0.115386f,  0.160689f, -0.479771f,  0.053687f,
    -0.318866f,  0.433351f,  0.370854f,  0.416843f,  0.465162f, -0.080524f,  0.324979f,
    0.166934f, -0.469274f,  0.402721f,  0.393670f, -0.442251f, -0.188478f,  0.483095f,
    -0.067835f,  0.088543f, -0.458188f, -0.322125f, -0.416340f,  0.485786f, -0.215827f,
    0.023222f, -0.368348f, -0.132183f, -0.265111f, -0.267096f,  0.472256f,  0.445594f,
    0.239530f, -0.360724f,  0.456585f, -0.207165f,  0.465050f, -0.342361f, -0.416393f,
    -0.235735f, -0.400521f, -0.456665f, -0.064719f,  0.380489f, -0.341982f,  0.307077f,
    0.405408f,  0.276955f, -0.459673f,  0.014427f,  0.077229f, -0.257131f, -0.063699f,
    0.406847f, -0.474205f, -0.420208f,  0.248092f,  0.071925f, -0.338536f,  0.380566f,
    -0.430790f,  0.377440f,  0.370286f, -0.225599f, -0.175237f,  0.326582f, -0.146415f,
    0.376293f,  0.271309f,  0.039325f,  0.008921f, -0.193135f, -0.275907f,  0.007771f,
    -0.458040f,  0.166369f, -0.379067f,  0.291777f,  0.446066f, -0.276327f, -0.454293f,
    -0.263230f, -0.445849f, -0.447083f,  0.273737f,  0.320122f, -0.345940f,  0.168151f,
    0.122712f,  0.218512f,  0.091365f,  0.386269f,  0.205784f, -0.120716f,  0.366699f,
    0.223141f, -0.399264f, -0.342043f,  0.301731f,  0.394883f, -0.063443f, -0.274067f,
    0.309722f,  0.269134f,  0.125242f,  0.372325f, -0.097533f, -0.030776f,  0.054267f,
    0.327189f,  0.112842f, -0.128196f, -0.170842f, -0.233306f,  0.156528f,  0.316355f,
    0.394235f, -0.439238f, -0.378524f, -0.161122f,  0.044319f, -0.431990f,  0.311030f,
    0.293657f, -0.094364f,  0.239562f, -0.293755f,  0.493475f,  0.047921f, -0.028639f,
    -0.187170f,  0.402873f, -0.417264f, -0.056769f, -0.045582f, -0.100443f,  0.199092f,
    0.142375f,  0.230818f, -0.120167f, -0.166169f, -0.180281f, -0.180130f,  0.244827f,
    0.020938f,  0.340927f, -0.164941f, -0.449462f,  0.314393f, -0.268072f, -0.093238f,
    -0.162579f, -0.360179f, -0.216156f,  0.209620f,  0.140885f, -0.439470f,  0.367626f,
    0.067022f,  0.204937f,  0.006341f,  0.248122f,  0.108970f,  0.025180f, -0.275345f,
    -0.294775f, -0.097158f, -0.402159f,  0.491438f,  0.331174f,  0.007068f, -0.022336f,
    0.337354f, -0.466280f,  0.082792f, -0.206000f, -0.223779f,  0.230937f,  0.433782f,
    0.351664f,  0.297757f, -0.438054f, -0.396204f,  0.477093f,  0.435587f, -0.113793f,
    0.245026f,  0.252541f,  0.229263f,  0.020534f, -0.238939f, -0.381150f,  0.253363f,
    0.326344f,  0.431019f, -0.306510f, -0.071657f, -0.440694f,  0.124228f,  0.233549f,
    0.100692f,  0.119547f, -0.068673f,  0.427342f, -0.118845f, -0.326446f,  0.260372f,
    -0.407029f,  0.159523f, -0.119834f,  0.195843f,  0.132848f, -0.273936f, -0.145467f,
    0.293108f,  0.490908f,  0.379573f, -0.101916f, -0.092353f, -0.099435f,  0.099726f,
    0.152693f, -0.358050f,  0.428631f,  0.319767f,  0.086971f,  0.366660f, -0.488723f,
    -0.479807f, -0.133447f,  0.447216f, -0.343856f, -0.055854f, -0.386749f, -0.477706f,
    -0.170980f, -0.167402f, -0.374190f,  0.253127f, -0.151201f, -0.482587f, -0.236071f,
    -0.461211f, -0.258908f,  0.271277f,  0.224182f,  0.495396f, -0.175178f,  0.476733f,
    -0.161058f,  0.078693f,  0.469078f,  0.376757f,  0.175655f,  0.219492f,  0.116519f,
    0.044098f,  0.112511f,  0.197954f, -0.252272f, -0.153127f,  0.117193f,  0.241893f,
    0.396428f,  0.387522f,  0.197981f, -0.139661f,  0.322655f, -0.101665f, -0.138324f,
    -0.340996f, -0.270628f,  0.339508f,  0.471958f, -0.400593f,  0.453164f, -0.131616f,
    0.116698f,  0.207084f,  0.372387f,  0.037701f, -0.433940f, -0.216973f, -0.376889f,
    -0.404236f, -0.371934f,  0.481388f,  0.376698f,  0.365300f,  0.318411f,  0.268438f,
    0.460578f, -0.413968f, -0.218780f,  0.433854f, -0.440598f, -0.262203f, -0.007961f,
    -0.024902f, -0.053800f,  0.088325f,  0.499473f, -0.113926f, -0.492763f, -0.392254f,
    0.013614f,  0.048078f,  0.350388f, -0.011001f, -0.385108f,  0.017907f,  0.150803f,
    0.040762f, -0.036469f, -0.163469f, -0.018755f, -0.137859f, -0.244222f, -0.078043f,
    0.104827f, -0.146370f,  0.057098f, -0.130249f, -0.252151f, -0.392227f,  0.194163f,
    0.350310f,  0.408522f,  0.099317f, -0.103341f,  0.377613f, -0.252314f, -0.144369f,
    0.027339f, -0.277725f, -0.480161f,  0.133937f, -0.154253f, -0.327323f, -0.427664f,
    -0.284278f, -0.470567f,  0.310521f,  0.418385f,  0.107106f, -0.021089f, -0.111989f,
    -0.207848f, -0.483543f, -0.497885f,  0.277879f,  0.453983f,  0.479851f,  0.194661f,
    0.147793f,  0.128498f, -0.113076f, -0.021980f, -0.101786f,  0.141362f,  0.093182f,
    -0.256017f,  0.236996f,  0.151226f, -0.087993f, -0.313927f, -0.137834f,  0.446160f,
    0.385606f,  0.123211f,  0.231988f, -0.050578f,  0.117302f,  0.274857f,  0.042155f,
    0.233426f, -0.410648f,  0.007528f,  0.355623f,  0.115047f, -0.274572f,  0.408289f,
    0.470979f,  0.457003f,  0.122714f, -0.339796f, -0.471587f, -0.448036f, -0.033926f,
    0.497341f, -0.425573f,  0.356690f, -0.060077f,  0.042703f, -0.298373f,  0.076916f,
    0.219259f,  0.012135f, -0.109273f,  0.399768f,  0.300105f, -0.327951f,  0.078668f,
    -0.485586f,  0.424564f,  0.030725f, -0.391716f, -0.045526f,  0.273367f,  0.124443f,
    -0.242159f,  0.004048f,  0.498675f, -0.076018f,  0.258037f, -0.284764f,  0.314710f,
    -0.032151f,  0.162633f, -0.463368f,  0.469399f, -0.149532f, -0.192094f, -0.287055f,
    0.405453f, -0.178655f, -0.135115f,  0.314646f, -0.343608f,  0.040800f,  0.224186f,
    0.338270f, -0.412986f,  0.185313f,  0.051730f,  0.392841f, -0.492874f, -0.312052f,
    0.288345f,  0.182014f,  0.193358f, -0.335923f, -0.061051f,  0.196433f, -0.368747f,
    -0.371922f,  0.087628f, -0.346299f, -0.273885f,  0.211393f, -0.108602f, -0.062806f,
    0.167272f, -0.104063f,  0.133937f,  0.278116f,  0.110305f,  0.069227f, -0.124596f,
    -0.348186f, -0.137468f, -0.330530f, -0.492127f,  0.289176f,  0.018820f,  0.141560f,
    0.138559f, -0.427688f,  0.150896f,  0.080260f, -0.226530f, -0.358447f,  0.060247f,
    -0.352520f, -0.310932f, -0.195187f,  0.071976f, -0.140446f, -0.336000f, -0.157349f,
    -0.112694f,  0.031622f,  0.229859f, -0.159082f,  0.091644f, -0.185974f, -0.299618f,
    0.071039f, -0.297859f,  0.275054f, -0.308132f,  0.254950f, -0.244362f, -0.318857f,
    -0.028888f, -0.107839f,  0.209880f, -0.054010f,  0.406464f,  0.050740f, -0.363650f,
    0.000851f,  0.276265f, -0.491883f, -0.196673f, -0.442732f,  0.258712f, -0.486793f,
    0.217507f,  0.258523f, -0.282027f, -0.114458f, -0.350634f,  0.056290f, -0.128810f,
    0.092832f,  0.202216f, -0.296529f, -0.394026f,  0.294091f,  0.391558f, -0.436813f,
    -0.017670f, -0.194756f,  0.226986f, -0.071961f,  0.239143f, -0.242257f,  0.383659f,
    -0.205750f, -0.296243f, -0.136528f,  0.117589f, -0.495845f, -0.277395f, -0.327855f,
    -0.274799f, -0.039788f,  0.267876f, -0.222978f, -0.367759f, -0.282561f,  0.484876f,
    0.373408f, -0.117035f,  0.312739f,  0.209933f, -0.050202f,  0.103387f, -0.286673f,
    -0.429369f, -0.242711f,  0.351156f, -0.072444f, -0.331931f, -0.112019f, -0.488555f,
    0.175374f,  0.102066f,  0.142358f, -0.371739f, -0.241111f, -0.369635f,  0.489325f,
    0.302180f, -0.007206f, -0.474525f,  0.446799f, -0.230000f,  0.477482f, -0.490345f,
    -0.473056f, -0.306034f,  0.242458f,  0.389518f,  0.405648f, -0.084476f,  0.113189f,
    0.384872f,  0.363511f,  0.311985f,  0.209997f,  0.437808f, -0.006195f,  0.477910f,
    0.063234f, -0.388027f,  0.135883f, -0.266481f,  0.105306f, -0.259167f,  0.439849f,
    0.140227f, -0.401530f,  0.277973f,  0.135528f, -0.068222f, -0.410319f,  0.440835f,
    0.216678f,  0.404884f, -0.397451f,  0.148398f, -0.123271f, -0.334696f,  0.224947f,
    0.438182f,  0.177210f,  0.206664f, -0.087324f,  0.341448f,  0.392386f, -0.424220f,
    0.479403f,  0.008877f, -0.433120f,  0.018798f,  0.295669f, -0.048544f, -0.373646f,
    0.129187f, -0.018981f, -0.089746f, -0.010643f, -0.043377f, -0.210661f,  0.239697f,
    0.401574f, -0.436472f,  0.295273f,  0.005510f, -0.472070f, -0.385178f, -0.133254f,
    -0.187617f,  0.334905f, -0.309069f, -0.376841f, -0.182345f,  0.132188f, -0.238070f,
    -0.360349f,  0.413692f,  0.242367f, -0.257225f,  0.464331f, -0.290459f,  0.068140f,
    -0.440266f,  0.107566f, -0.424093f,  0.032634f,  0.443516f,  0.470980f, -0.420953f,
    -0.300384f, -0.324589f,  0.280051f,  0.389290f, -0.178031f,  0.152247f,  0.429989f,
    0.057126f,  0.119781f, -0.489342f, -0.147525f,  0.081039f,  0.020379f,  0.220586f,
    -0.445940f,  0.201293f,  0.183822f, -0.215203f, -0.000771f, -0.074300f,  0.436630f,
    -0.318717f,  0.036913f, -0.411725f,  0.307332f, -0.122236f, -0.236567f,  0.248664f,
    0.028862f,  0.004049f,  0.133336f, -0.473087f, -0.010337f, -0.335907f,  0.468450f,
    -0.070121f, -0.212098f, -0.066605f, -0.138223f, -0.163935f,  0.397468f,  0.050451f,
    -0.445915f, -0.133317f,  0.381950f,  0.357853f, -0.204688f,  0.262107f, -0.499092f,
    0.066964f,  0.249105f,  0.312636f, -0.385799f, -0.249220f,  0.306280f,  0.146803f,
    0.193452f,  0.156554f, -0.468223f, -0.126471f,  0.449040f, -0.030011f,  0.060487f,
    0.398644f, -0.454057f,  0.256644f, -0.098594f,  0.212233f,  0.347805f,  0.106813f,
    -0.481160f,  0.169456f, -0.153429f,  0.374102f, -0.413606f,  0.190798f, -0.078274f,
    -0.365270f, -0.302586f, -0.107109f,  0.360610f, -0.383077f, -0.051887f,  0.261259f,
    0.457475f,  0.323545f,  0.461366f, -0.497398f, -0.192712f,  0.065156f,  0.004960f,
    0.405808f, -0.300099f,  0.257153f,  0.183792f, -0.284739f,  0.395831f,  0.438722f,
    0.197213f, -0.177441f,  0.386830f, -0.178743f, -0.312481f,  0.237199f, -0.111242f,
    0.251262f, -0.259127f, -0.145158f,  0.422452f, -0.288027f,  0.005995f, -0.366628f,
    -0.432321f,  0.026808f,  0.177453f,  0.369997f,  0.248645f, -0.142925f, -0.351135f,
    0.383443f,  0.165365f,  0.200052f,  0.016710f, -0.092118f, -0.072303f, -0.361291f,
    -0.261548f,  0.342183f, -0.202451f, -0.478841f, -0.309367f,  0.439838f, -0.314771f,
    -0.040296f, -0.404671f,  0.420013f, -0.321063f,  0.142517f,  0.389486f, -0.494416f,
    0.178740f, -0.494771f,  0.094273f, -0.195598f, -0.059918f,  0.077531f, -0.265435f,
    -0.171465f, -0.444969f,  0.017288f,  0.386351f,  0.453956f,  0.175300f,  0.390488f,
    -0.342711f,  0.249311f,  0.438874f, -0.478303f,  0.388538f, -0.085566f,  0.446503f,
    0.301738f,  0.300606f, -0.037318f,  0.355640f,  0.225445f, -0.220842f, -0.270474f,
    0.343811f,  0.373860f,  0.236184f, -0.405028f, -0.267791f,  0.236947f,  0.105654f,
    -0.150832f,  0.361031f,  0.082197f, -0.200333f, -0.383053f, -0.456675f,  0.352500f,
    0.010549f,  0.474232f,  0.282558f,  0.367079f, -0.113688f, -0.048528f, -0.125329f,
    -0.100668f, -0.487825f, -0.281132f,  0.498010f,  0.215246f,  0.120613f,  0.405728f,
    0.159282f,  0.028950f, -0.261387f,  0.320388f,  0.161838f, -0.075563f, -0.083942f,
    -0.265462f, -0.389472f, -0.085936f, -0.493494f,  0.381448f, -0.102576f,  0.467795f,
    -0.425055f, -0.275648f,  0.422733f,  0.018189f, -0.339236f, -0.209549f,  0.308620f,
    0.293698f,  0.243233f, -0.323280f, -0.360389f, -0.020917f,  0.146888f, -0.466562f,
    -0.093553f, -0.028191f,  0.231691f,  0.065562f,  0.201048f, -0.324472f,  0.374529f,
    -0.415586f,  0.184602f,  0.327584f, -0.057856f, -0.055674f, -0.429635f, -0.268514f,
    -0.450925f,  0.440883f,  0.484691f,  0.095181f,  0.396396f, -0.112895f, -0.482972f,
    0.052539f,  0.297465f, -0.342451f, -0.019445f, -0.337343f,  0.155477f, -0.137909f,
    0.083909f, -0.013459f,  0.095102f, -0.076509f, -0.419203f,  0.183512f,  0.238115f,
    0.456176f, -0.496482f,  0.353756f, -0.287366f,  0.326770f, -0.200415f,  0.185134f,
    0.499892f,  0.296355f, -0.155755f, -0.098667f,  0.144564f,  0.455292f, -0.321958f,
    -0.182668f, -0.181663f,  0.346518f,  0.465507f, -0.297237f,  0.256030f, -0.106092f,
    -0.348008f,  0.053149f,  0.344235f, -0.002473f, -0.060220f, -0.354944f, -0.310206f,
    0.495092f, -0.143400f,  0.479296f,  0.025720f, -0.486048f, -0.040138f,  0.424697f,
    0.412367f, -0.475826f, -0.265648f, -0.204985f, -0.410719f,  0.452619f, -0.108686f,
    0.407984f, -0.353634f,  0.410013f, -0.029874f, -0.224116f,  0.170561f,  0.126111f,
    0.052859f,  0.302208f, -0.164361f,  0.368084f, -0.284487f,  0.252993f, -0.172092f,
    0.048637f, -0.488345f, -0.168828f, -0.279691f, -0.394617f, -0.215682f, -0.391862f,
    0.242898f, -0.427820f,  0.165666f, -0.488107f, -0.439148f,  0.165144f,  0.002133f,
    0.392125f,  0.014602f, -0.402396f,  0.152007f,  0.188887f,  0.043456f, -0.275723f,
    0.175098f, -0.064041f,  0.088154f,  0.328396f,  0.167933f,  0.198246f,  0.423334f,
    -0.182441f,  0.206435f,  0.243642f,  0.023217f, -0.476010f,  0.120303f, -0.094171f,
    0.018324f,  0.029973f, -0.265901f,  0.030513f,  0.004233f, -0.394889f, -0.370351f,
    -0.107853f,  0.252035f, -0.327738f,  0.288821f, -0.497513f, -0.278119f,  0.265351f,
    0.306623f,  0.241156f,  0.063933f,  0.334613f,  0.379082f,  0.359259f, -0.486036f,
    -0.048809f,  0.391415f,  0.230936f, -0.346779f,  0.499531f,  0.098013f, -0.451515f,
    0.443960f, -0.313066f,  0.300862f,  0.221351f,  0.203975f,  0.087355f, -0.183046f,
    0.498137f,  0.316808f,  0.241532f, -0.136703f, -0.312922f,  0.450966f,  0.406484f,
    0.281369f, -0.089314f, -0.016019f, -0.438956f, -0.462192f,  0.153958f, -0.311273f,
    0.485281f, -0.042947f, -0.284546f, -0.326267f, -0.276530f, -0.287588f,  0.262478f,
    0.100845f,  0.173733f, -0.211962f,  0.444421f,  0.497432f,  0.411953f,  0.254771f,
    0.304221f,  0.092135f, -0.279639f, -0.377669f,  0.121987f, -0.270841f,  0.047880f,
    -0.150602f,  0.355461f, -0.356751f, -0.246530f,  0.437597f, -0.259409f, -0.066666f,
    0.277126f,  0.296941f, -0.433336f, -0.424547f, -0.274259f,  0.156118f, -0.468156f,
    -0.476119f,  0.460732f, -0.126060f,  0.257444f,  0.012707f, -0.082719f,  0.276847f,
    -0.463274f, -0.121504f,  0.185551f,  0.055610f,  0.213625f,  0.258856f,  0.034643f,
    -0.227897f,  0.428611f, -0.297115f, -0.419113f,  0.389485f, -0.013648f, -0.230359f,
    0.291951f, -0.302597f,  0.149352f, -0.057645f,  0.403952f,  0.074430f,  0.052797f,
    -0.107569f, -0.384847f, -0.254798f, -0.318691f,  0.171945f,  0.439920f, -0.152676f,
    0.413787f, -0.429054f,  0.271557f, -0.463257f,  0.197184f,  0.061316f, -0.248334f,
    0.108853f, -0.424210f,  0.267954f, -0.205814f, -0.209039f, -0.095290f,  0.206922f,
    -0.290251f, -0.169815f, -0.107011f, -0.054192f, -0.455876f, -0.364618f,  0.134684f,
    0.351490f, -0.465030f, -0.326086f, -0.070247f,  0.062853f, -0.366098f,  0.231149f,
    -0.391473f, -0.230326f,  0.293850f, -0.064505f, -0.155366f,  0.193170f,  0.221120f,
    -0.427191f,  0.365517f,  0.388739f, -0.098377f,  0.365515f, -0.205906f,  0.057767f,
    0.373856f, -0.206789f, -0.469990f,  0.034462f, -0.292163f, -0.331527f,  0.007473f,
    0.467239f, -0.191917f, -0.445147f, -0.044571f,  0.044935f, -0.333565f,  0.490363f,
    0.494305f, -0.080888f, -0.197836f,  0.141217f, -0.205508f,  0.378787f, -0.074809f,
    0.005200f,  0.310867f,  0.367455f, -0.495351f, -0.324859f,  0.214085f,  0.259340f,
    -0.091393f, -0.210284f, -0.065038f, -0.011947f, -0.331028f,  0.485979f, -0.201596f,
    0.342539f, -0.386073f, -0.464165f, -0.423763f, -0.400683f, -0.427724f,  0.023286f,
    -0.334601f,  0.374007f, -0.108346f,  0.292100f,  0.183888f, -0.232714f, -0.494506f,
    -0.128013f, -0.040704f,  0.309381f, -0.060039f,  0.348118f, -0.495532f, -0.477516f,
    -0.242078f,  0.362480f,  0.175873f, -0.087880f,  0.106674f, -0.419854f, -0.210456f,
    0.047055f,  0.461919f, -0.011181f, -0.272611f, -0.085735f,  0.362976f,  0.061335f,
    -0.343711f, -0.347459f,  0.011996f,  0.349140f,  0.260502f, -0.071834f,  0.489758f,
    0.006713f,  0.163666f, -0.138222f,  0.027451f, -0.395319f, -0.496797f,  0.430993f,
    0.100563f, -0.329121f,  0.382667f,  0.432856f, -0.011184f, -0.482745f, -0.164249f,
    0.308859f,  0.114298f, -0.354563f, -0.388831f, -0.281278f, -0.254218f, -0.030265f,
    0.355772f, -0.356278f,  0.186413f,  0.113588f, -0.087756f, -0.157086f,  0.067903f,
    -0.499891f, -0.060851f, -0.346295f, -0.090987f,  0.010884f, -0.160621f, -0.209890f,
    0.289254f, -0.213125f, -0.314000f, -0.043673f,  0.298350f, -0.286008f,  0.052851f,
    -0.340452f, -0.115651f,  0.212024f,  0.185028f, -0.385868f,  0.202434f, -0.166560f,
    0.028585f,  0.010077f, -0.494980f, -0.402402f,  0.229666f, -0.256483f, -0.218024f,
    -0.078357f,  0.214127f,  0.437475f, -0.393424f, -0.037229f, -0.024059f, -0.179919f,
    0.144657f,  0.424119f, -0.204024f,  0.267878f,  0.296463f, -0.319368f,  0.044631f,
    0.197628f, -0.454280f, -0.000323f, -0.291729f, -0.474474f,  0.449745f, -0.272668f,
    -0.260722f, -0.227032f,  0.307130f,  0.414415f, -0.365023f,  0.138752f,  0.453164f,
    -0.189020f,  0.376762f,  0.174981f, -0.246933f, -0.425236f, -0.464032f, -0.315001f,
    0.163100f,  0.043640f, -0.291362f,  0.333917f,  0.011268f, -0.093612f, -0.337981f,
    -0.156141f, -0.207299f,  0.477029f, -0.450890f, -0.204280f,  0.487744f,  0.208605f,
    0.114515f,  0.126521f,  0.479539f,  0.260970f,  0.019449f, -0.313818f,  0.186659f,
    0.318114f, -0.247227f,  0.380675f,  0.227554f,  0.403388f,  0.268881f, -0.198961f,
    -0.182347f,  0.401129f, -0.344828f,  0.031843f, -0.234323f,  0.111633f,  0.138410f,
    -0.099349f, -0.190334f,  0.459667f,  0.399882f,  0.015277f, -0.379598f,  0.477100f,
    -0.003285f, -0.078305f, -0.066676f, -0.314453f,  0.146779f, -0.123043f,  0.360702f,
    -0.171366f, -0.103749f,  0.483349f,  0.223183f, -0.375214f, -0.125779f, -0.422092f,
    -0.458903f,  0.424904f,  0.272818f, -0.238276f,  0.286680f, -0.274576f,  0.152669f,
    0.122957f,  0.342277f,  0.281936f, -0.356633f, -0.466158f, -0.111656f, -0.266611f,
    -0.478283f,  0.253225f,  0.288586f, -0.160822f,  0.144470f, -0.048743f, -0.094119f,
    -0.426081f, -0.122099f,  0.091038f, -0.292192f, -0.143995f,  0.297836f,  0.393442f,
    0.368955f, -0.189922f,  0.277755f, -0.193347f, -0.208931f,  0.400238f,  0.089451f,
    -0.427648f,  0.312038f, -0.494650f,  0.213852f,  0.088047f,  0.209314f,  0.041278f,
    0.305375f, -0.087863f, -0.400567f,  0.333804f, -0.268788f,  0.438238f,  0.247675f,
    0.392646f,  0.079898f,  0.111732f, -0.286420f,  0.079246f, -0.282806f,  0.098987f,
    0.330225f, -0.037780f, -0.219257f, -0.286875f, -0.262958f,  0.243842f,  0.320138f,
    -0.294596f, -0.375065f, -0.136824f, -0.318855f,  0.444358f,  0.404043f,  0.347035f,
    -0.269710f, -0.387110f,  0.142353f,  0.314616f,  0.350144f,  0.083891f,  0.149193f,
    -0.362766f,  0.491126f,  0.206032f,  0.371332f,  0.018099f,  0.330062f, -0.398279f,
    -0.460922f,  0.361527f,  0.100043f,  0.398445f,  0.031341f,  0.434763f,  0.464137f,
    0.372700f,  0.336593f,  0.442853f, -0.095608f, -0.036743f, -0.036788f, -0.292554f,
    0.187431f,  0.328777f, -0.281548f,  0.399351f,  0.202222f,  0.295815f, -0.471144f,
    0.473216f,  0.200610f,  0.019442f, -0.156959f, -0.392749f,  0.016606f, -0.296609f,
    0.145336f,  0.093901f,  0.208887f, -0.316581f,  0.048811f, -0.443500f,  0.228300f,
    0.341025f, -0.260179f, -0.104255f, -0.172674f, -0.400288f,  0.452623f, -0.422565f,
    -0.376500f,  0.468382f, -0.020647f, -0.146018f,  0.328963f,  0.182394f, -0.386982f,
    -0.372862f, -0.058161f, -0.210664f,  0.102950f, -0.215849f, -0.356412f, -0.488954f,
    0.225110f,  0.115747f,  0.194283f,  0.254213f,  0.063483f, -0.490838f, -0.097242f,
    0.247585f, -0.478194f,  0.425825f,  0.361447f, -0.145979f,  0.472891f, -0.340388f,
    -0.129448f,  0.180211f,  0.170336f, -0.268017f,  0.079899f, -0.383355f, -0.463328f,
    -0.265403f, -0.200232f, -0.043462f, -0.026433f, -0.036669f,  0.077342f,  0.226932f,
    -0.237771f, -0.198800f, -0.390291f, -0.079536f, -0.387669f,  0.267919f, -0.072847f,
    0.435715f, -0.269472f, -0.256894f, -0.205591f,  0.351172f, -0.001973f,  0.136164f,
    0.158549f, -0.302724f, -0.368340f,  0.282239f,  0.139078f, -0.182331f, -0.456014f,
    0.419402f, -0.119255f,  0.280389f, -0.417708f,  0.092064f,  0.147763f, -0.191455f,
    -0.190390f, -0.159996f, -0.142223f,  0.435001f, -0.033408f,  0.197151f,  0.066641f,
    0.274207f, -0.476942f,  0.231153f,  0.405236f,  0.064787f,  0.172146f, -0.489138f,
    -0.474920f,  0.227612f, -0.053745f, -0.332829f, -0.429019f, -0.244796f,  0.128470f,
    -0.198554f,  0.110540f,  0.089552f, -0.089746f, -0.150553f, -0.191029f, -0.062630f,
    -0.001872f, -0.403400f, -0.356436f,  0.035863f, -0.380514f, -0.401696f, -0.241335f,
    0.429958f,  0.219104f, -0.462482f, -0.474413f,  0.206442f, -0.499783f,  0.067821f,
    -0.197982f, -0.405488f, -0.148065f,  0.475649f,  0.294971f,  0.269753f, -0.048506f,
    0.348389f, -0.214058f, -0.136029f, -0.153727f,  0.168905f,  0.445594f, -0.498450f,
    -0.153834f,  0.450970f, -0.329887f,  0.459852f,  0.408904f, -0.221240f, -0.362431f,
    0.232828f,  0.025035f,  0.277307f, -0.111605f, -0.299513f,  0.128897f,  0.495655f,
    -0.338928f,  0.249545f, -0.171014f,  0.071982f, -0.103323f,  0.420835f, -0.104559f,
    -0.472633f, -0.098040f,  0.485460f, -0.078090f,  0.025050f, -0.279250f, -0.326176f,
    -0.069952f,  0.373470f, -0.398169f,  0.139467f,  0.271544f,  0.148075f,  0.314924f,
    0.063853f,  0.447193f, -0.221268f, -0.094671f,  0.170085f,  0.175807f,  0.281767f,
    0.195417f, -0.225038f, -0.443905f,  0.009282f, -0.456004f, -0.027684f, -0.350989f,
    0.109987f,  0.122082f, -0.400613f,  0.021223f,  0.127606f,  0.018619f, -0.074134f,
    0.315305f,  0.352785f, -0.432088f,  0.046590f,  0.410243f, -0.244099f,  0.310988f,
    0.418757f,  0.195981f, -0.109823f,  0.337774f, -0.081446f, -0.024502f,  0.412044f,
    0.481193f, -0.103331f,  0.422793f,  0.428782f, -0.023800f, -0.425988f,  0.338774f,
    -0.121583f, -0.012012f,  0.465852f, -0.038850f,  0.464993f, -0.461419f,  0.472475f,
    -0.321058f,  0.221047f,  0.207495f, -0.413720f, -0.114885f, -0.278762f, -0.109016f,
    0.488320f, -0.341753f,  0.014995f,  0.419428f,  0.431727f, -0.389645f, -0.064034f,
    -0.049180f, -0.084140f, -0.234642f,  0.051672f,  0.480242f, -0.435255f, -0.238303f,
    -0.126641f,  0.183981f,  0.048247f,  0.101954f,  0.304714f, -0.490975f, -0.322929f,
    0.028744f, -0.314620f,  0.233568f, -0.293781f, -0.105514f,  0.213280f,  0.174689f,
    0.279758f,  0.445950f,  0.306587f, -0.228795f,  0.117093f,  0.173902f,  0.405132f,
    -0.408093f,  0.392389f,  0.022863f,  0.391282f, -0.466033f,  0.100114f,  0.133486f,
    -0.173439f,  0.408494f,  0.476999f, -0.454266f,  0.412890f,  0.038295f, -0.398858f,
    -0.351382f, -0.127798f,  0.398341f,  0.089896f, -0.326568f, -0.062921f, -0.353169f,
    0.237844f,  0.322124f, -0.484980f, -0.238296f, -0.016680f,  0.158650f, -0.247032f,
    -0.495082f, -0.334025f,  0.205035f, -0.374781f,  0.378621f, -0.321026f,  0.139604f,
    -0.499108f,  0.360604f,  0.257978f,  0.034941f, -0.363456f,  0.461406f, -0.143308f,
    -0.032041f, -0.329469f,  0.435280f, -0.202926f,  0.432767f,  0.469440f,  0.408614f,
    0.254092f, -0.034519f,  0.359805f,  0.321679f, -0.366859f,  0.003691f,  0.152739f,
    0.175575f,  0.156827f, -0.165111f, -0.017185f,  0.351767f,  0.021140f, -0.300971f,
    -0.100959f,  0.145534f, -0.025904f,  0.189672f,  0.194179f, -0.000873f,  0.168459f,
    0.113327f,  0.483672f,  0.310637f, -0.159639f, -0.186868f, -0.342514f, -0.341233f,
    -0.145484f, -0.385496f, -0.346932f, -0.446565f, -0.338233f, -0.191338f, -0.072812f,
    -0.418145f,  0.354068f,  0.334808f, -0.054310f, -0.042711f, -0.465477f, -0.238704f,
    -0.363909f, -0.166322f, -0.204863f,  0.086423f, -0.252976f,  0.367989f,  0.002577f,
    0.394799f,  0.384724f, -0.109764f,  0.013096f,  0.208028f, -0.380047f, -0.120891f,
    0.193186f, -0.020895f,  0.214205f, -0.107844f,  0.424390f,  0.197150f, -0.047226f,
    -0.479942f,  0.471516f, -0.080354f,  0.310827f, -0.365773f,  0.436518f, -0.261875f,
    -0.250645f,  0.188477f, -0.110784f, -0.456882f, -0.361558f,  0.084623f,  0.435323f,
    0.396543f, -0.050604f, -0.212402f,  0.366928f,  0.083517f, -0.476187f, -0.399979f,
    0.446304f, -0.181529f,  0.011488f, -0.395655f,  0.247007f,  0.267754f, -0.169522f,
    0.031065f,  0.153572f, -0.253614f, -0.382342f,  0.195432f, -0.419764f, -0.298062f,
    0.248233f, -0.402742f,  0.078242f, -0.456393f,  0.265284f,  0.436391f,  0.269133f,
    0.467407f,  0.398243f, -0.248840f,  0.367447f,  0.205161f,  0.200761f, -0.067587f,
    -0.019517f, -0.050143f, -0.092164f,  0.248823f, -0.174127f,  0.025421f, -0.380975f,
    -0.309920f, -0.439001f, -0.054574f,  0.344442f,  0.296761f, -0.466443f,  0.191440f,
    0.304010f, -0.194485f, -0.457417f, -0.485659f, -0.085313f, -0.044733f, -0.363079f,
    -0.424161f, -0.082654f, -0.062835f,  0.207418f, -0.114257f,  0.132558f, -0.056239f,
    -0.325608f, -0.085804f, -0.043923f, -0.499618f, -0.401809f, -0.043422f,  0.239595f,
    -0.384119f,  0.103626f,  0.369308f, -0.005090f, -0.153835f, -0.194997f, -0.427068f,
    0.020492f,  0.150382f, -0.465725f,  0.208288f,  0.204490f,  0.167865f, -0.161901f,
    -0.166054f, -0.200993f, -0.061544f, -0.461595f, -0.051629f,  0.294392f, -0.482651f,
    0.404294f,  0.116482f, -0.177995f, -0.261086f, -0.189930f, -0.136570f, -0.031962f,
    0.106080f, -0.054934f,  0.382927f, -0.056475f,  0.419755f, -0.123775f,  0.185584f,
    -0.303552f,  0.016746f,  0.365515f, -0.394940f, -0.493898f,  0.007930f, -0.476927f,
    -0.315102f,  0.118713f, -0.442483f, -0.014015f, -0.186336f, -0.416789f,  0.328733f,
    -0.404898f, -0.434908f, -0.340689f, -0.246266f,  0.381878f,  0.366546f,  0.294529f,
    -0.267985f, -0.151521f, -0.225727f,  0.015868f, -0.109270f, -0.057708f, -0.483073f,
    -0.265188f,  0.274535f,  0.096143f, -0.102888f,  0.015671f, -0.403278f,  0.174329f,
    0.259629f,  0.167541f,  0.256045f, -0.031159f, -0.231499f, -0.034756f, -0.313859f,
    0.007534f, -0.265722f, -0.473903f,  0.191306f,  0.234520f, -0.171368f,  0.024507f,
    -0.128546f, -0.388347f,  0.172733f, -0.061926f,  0.141030f, -0.232087f,  0.025542f,
    0.325513f,  0.495493f, -0.469018f,  0.492206f, -0.057576f, -0.178168f, -0.057209f,
    -0.236415f, -0.474491f, -0.363509f,  0.259836f,  0.156065f,  0.304511f,  0.068571f,
    0.431304f, -0.005105f,  0.235001f,  0.294475f, -0.263779f, -0.148967f, -0.149275f,
    0.032065f,  0.137976f,  0.055799f,  0.293770f, -0.119635f, -0.385405f, -0.137438f,
    -0.457831f, -0.039051f,  0.270327f,  0.261285f,  0.181247f, -0.101945f, -0.406403f,
    -0.230654f,  0.086044f, -0.461458f,  0.353791f, -0.412018f, -0.057628f, -0.465027f,
    -0.479020f,  0.223515f, -0.256319f, -0.476111f,  0.335466f, -0.000221f, -0.113946f,
    -0.141949f,  0.475449f,  0.134757f, -0.364200f, -0.119259f, -0.210553f,  0.100049f,
    -0.029438f,  0.449713f, -0.466041f, -0.465345f, -0.231581f, -0.330985f, -0.364140f,
    -0.169370f,  0.228680f, -0.387522f,  0.473019f, -0.238233f,  0.206914f, -0.279598f,
    -0.283581f, -0.119955f, -0.194866f, -0.279085f,  0.223876f,  0.378488f,  0.311126f,
    -0.476955f,  0.031209f,  0.312116f,  0.179842f, -0.093812f, -0.496051f,  0.407506f,
    -0.289027f, -0.200153f,  0.434592f, -0.319023f, -0.067295f,  0.021079f, -0.319281f,
    0.058642f, -0.250102f, -0.019263f,  0.112515f, -0.440336f, -0.030828f, -0.247653f,
    -0.410721f,  0.106147f,  0.452578f,  0.141321f,  0.219195f, -0.023204f,  0.470523f,
    -0.177527f, -0.278930f,  0.472032f, -0.316318f,  0.008646f, -0.361948f, -0.270467f,
    -0.041209f,  0.454278f, -0.071162f,  0.372754f,  0.056035f,  0.319402f, -0.050081f,
    -0.079146f, -0.226527f, -0.340398f, -0.448334f, -0.405399f,  0.319451f,  0.156682f,
    0.340992f,  0.355347f, -0.054343f,  0.457190f, -0.346053f,  0.077369f,  0.415540f,
    -0.111508f,  0.363635f, -0.379919f, -0.075076f, -0.174912f, -0.106529f,  0.006436f,
    0.119195f, -0.015451f,  0.175064f, -0.224252f, -0.134662f,  0.049347f,  0.386334f,
    0.040098f,  0.204028f,  0.297436f,  0.122114f, -0.411816f,  0.209097f,  0.143495f,
    -0.179840f,  0.132029f,  0.366905f,  0.360049f,  0.314684f,  0.141458f,  0.119871f,
    0.182181f, -0.017830f, -0.352004f, -0.274179f, -0.126710f,  0.136153f,  0.491147f,
    -0.087420f, -0.282374f, -0.185070f,  0.121469f, -0.434312f, -0.163676f,  0.475934f,
    -0.259971f,  0.002361f, -0.071098f,  0.090127f,  0.044509f,  0.148256f, -0.293727f,
    -0.162477f, -0.451702f,  0.052672f, -0.208175f, -0.200462f, -0.451655f, -0.174817f,
    -0.434972f,  0.374819f, -0.373437f, -0.059019f,  0.351126f,  0.402373f, -0.307714f,
    0.397426f, -0.482058f,  0.340126f,  0.202250f, -0.119799f,  0.126813f,  0.139476f,
    0.350146f, -0.350575f,  0.452499f,  0.389193f, -0.201318f, -0.464983f, -0.206949f,
    -0.272597f,  0.360104f,  0.253205f, -0.155401f, -0.318207f, -0.079026f,  0.254468f,
    -0.469409f, -0.120817f, -0.313076f, -0.214679f, -0.484069f, -0.259233f,  0.404028f,
    -0.394368f, -0.127275f,  0.263613f, -0.165271f,  0.428715f,  0.117991f, -0.411892f,
    0.245294f,  0.237985f,  0.439944f, -0.288788f, -0.355972f,  0.041885f, -0.353408f,
    -0.236397f, -0.281421f, -0.266014f, -0.310086f, -0.297471f, -0.091547f, -0.330631f,
    0.475310f,  0.449671f,  0.445094f, -0.491347f, -0.302928f,  0.433244f, -0.045341f,
    0.240398f,  0.237118f,  0.075501f, -0.115946f,  0.009389f,  0.020125f,  0.040590f,
    0.443123f,  0.156684f,  0.380533f,  0.454210f,  0.397500f,  0.437039f, -0.084121f,
    -0.103134f,  0.168054f, -0.294356f,  0.379914f, -0.281311f, -0.357297f, -0.039880f,
    -0.485693f,  0.228393f, -0.438582f, -0.248021f,  0.389140f,  0.064949f, -0.449668f,
    -0.073584f,  0.082460f, -0.297986f, -0.060940f, -0.041629f, -0.406311f, -0.413788f,
    -0.442257f, -0.110408f,  0.173746f,  0.036313f,  0.266175f, -0.134851f, -0.361768f,
    0.286626f,  0.084107f,  0.363208f,  0.284310f,  0.140992f,  0.364898f, -0.480841f,
    0.285164f, -0.299562f,  0.457739f,  0.090498f, -0.380285f, -0.234605f,  0.038524f,
    -0.016355f, -0.105925f,  0.410582f, -0.364135f,  0.275504f, -0.287222f,  0.145964f,
    -0.455121f, -0.016189f,  0.402971f,  0.160081f,  0.093203f, -0.340387f, -0.072614f,
    -0.317572f,  0.215638f,  0.146836f,  0.239126f,  0.180320f,  0.198108f, -0.452691f,
    0.333322f,  0.243839f, -0.211132f, -0.219536f, -0.009204f, -0.177853f,  0.243687f,
    -0.114109f,  0.043540f,  0.308106f,  0.198855f, -0.099105f, -0.269461f, -0.431057f,
    0.056128f,  0.286157f, -0.131932f, -0.227563f,  0.150270f,  0.268549f, -0.403227f,
    0.035210f, -0.236327f,  0.434525f,  0.057619f, -0.062810f, -0.207025f, -0.480622f,
    -0.387790f, -0.390129f, -0.122990f, -0.308221f, -0.014773f, -0.138134f,  0.209323f,
    0.089766f, -0.253823f, -0.009570f,  0.305507f, -0.200374f, -0.154367f,  0.019566f,
    0.227492f, -0.475368f, -0.087628f, -0.027746f,  0.313588f, -0.476546f, -0.160122f,
    -0.065010f,  0.282477f, -0.068769f, -0.065563f, -0.493295f, -0.292308f, -0.251832f,
    -0.143535f,  0.281108f, -0.339439f, -0.204780f, -0.491207f,  0.222473f, -0.263368f,
    0.013715f,  0.360681f, -0.269082f,  0.483636f,  0.110950f, -0.152485f,  0.316384f,
    0.286799f, -0.272135f,  0.060105f, -0.286741f,  0.216470f, -0.205515f, -0.006419f,
    -0.036845f, -0.041443f,  0.326063f, -0.072989f,  0.105401f,  0.313057f, -0.354227f,
    -0.233342f,  0.167921f, -0.478713f,  0.461632f,  0.327338f, -0.189771f, -0.142595f,
    -0.294570f, -0.080349f,  0.291085f,  0.061928f, -0.095665f,  0.331083f,  0.112058f,
    -0.300327f, -0.288008f,  0.364579f,  0.311907f, -0.134489f,  0.201284f, -0.239576f,
    -0.317277f, -0.359722f, -0.492927f,  0.260876f,  0.265443f, -0.303963f,  0.311402f,
    0.169569f,  0.118327f, -0.327369f, -0.341272f,  0.350087f,  0.186855f, -0.317800f,
    0.363138f, -0.255710f, -0.072907f,  0.159416f,  0.277411f,  0.167947f,  0.327751f,
    0.454850f,  0.404835f,  0.059257f, -0.039947f,  0.087817f, -0.015723f, -0.331808f,
    0.371172f, -0.468317f, -0.481840f, -0.262213f,  0.378836f,  0.225878f,  0.258178f,
    0.351988f, -0.135040f,  0.199587f, -0.052799f,  0.321273f,  0.388618f,  0.085167f,
    -0.064444f,  0.212726f,  0.117702f,  0.306146f, -0.040671f,  0.074518f,  0.129333f,
    0.084191f,  0.466527f, -0.322058f,  0.357061f,  0.439231f, -0.001345f,  0.028408f,
    0.314518f,  0.202514f, -0.359180f,  0.258509f,  0.037262f, -0.052788f,  0.318864f,
    0.292782f,  0.434740f, -0.282729f, -0.111184f, -0.200233f, -0.199360f,  0.132233f,
    -0.310532f, -0.439936f, -0.398707f,  0.321795f, -0.064202f,  0.070088f, -0.252432f,
    -0.264903f, -0.042032f, -0.235833f,  0.395938f,  0.040339f, -0.458370f, -0.080521f,
    0.349779f, -0.477290f,  0.220156f,  0.059370f,  0.413719f, -0.126646f,  0.293400f,
    0.394080f, -0.446041f,  0.387662f,  0.101762f, -0.359683f, -0.461561f,  0.034576f,
    -0.064780f,  0.002057f,  0.365708f, -0.125598f,  0.186872f,  0.436985f,  0.374164f,
    -0.025845f, -0.482834f, -0.207847f,  0.478332f,  0.457603f, -0.057962f,  0.387406f,
    -0.328829f,  0.121334f, -0.275506f,  0.028258f,  0.316621f,  0.215681f, -0.420302f,
    -0.183873f,  0.031024f,  0.425680f,  0.108593f,  0.021682f,  0.202683f, -0.233906f,
    0.180520f,  0.427848f, -0.346965f,  0.327654f, -0.417270f,  0.117362f,  0.219045f,
    0.458888f,  0.051520f, -0.436650f,  0.393124f, -0.252728f,  0.468524f, -0.078907f,
    -0.256330f, -0.138861f, -0.264746f, -0.341213f, -0.053858f,  0.043900f, -0.416840f,
    -0.398115f, -0.437805f, -0.492725f,  0.305121f,  0.299618f, -0.465979f, -0.329263f,
    0.342717f, -0.493052f, -0.075401f, -0.261068f, -0.417184f, -0.133126f,  0.084640f,
    0.424260f, -0.376416f,  0.386286f, -0.093304f,  0.212850f, -0.303849f, -0.463817f,
    -0.479916f, -0.228038f,  0.171791f,  0.239787f, -0.038762f,  0.316490f, -0.041026f,
    0.308889f,  0.438036f, -0.269072f, -0.320824f,  0.171703f, -0.400908f,  0.298377f,
    0.399644f, -0.170177f,  0.166283f,  0.165340f,  0.255677f, -0.334234f, -0.272128f,
    0.393861f,  0.390461f, -0.022282f, -0.102078f,  0.172721f, -0.081379f,  0.378752f,
    0.293546f, -0.393155f, -0.262276f, -0.398051f,  0.373574f,  0.436778f, -0.107260f,
    -0.108883f, -0.480001f,  0.094162f,  0.280527f,  0.323235f,  0.367001f,  0.038924f,
    -0.031240f, -0.149593f,  0.222135f,  0.291666f, -0.483841f,  0.016132f,  0.051796f,
    0.241082f, -0.096272f, -0.403535f,  0.380078f,  0.019755f,  0.020918f,  0.447595f,
    0.179332f,  0.179150f, -0.137115f, -0.332988f,  0.405147f, -0.189114f,  0.467425f,
    -0.441437f, -0.118009f,  0.239477f,  0.200705f, -0.451965f,  0.302724f, -0.387177f,
    -0.147065f,  0.044500f, -0.169310f,  0.129984f,  0.457850f, -0.344562f,  0.242785f,
    -0.161302f,  0.147934f,  0.215992f,  0.422036f,  0.303071f,  0.311126f, -0.187225f,
    -0.114223f,  0.458634f, -0.049761f, -0.398052f, -0.352038f,  0.439195f,  0.355141f,
    0.424428f,  0.179696f,  0.457533f, -0.112926f,  0.395673f,  0.309514f,  0.158021f,
    0.017199f,  0.134426f,  0.243631f, -0.480219f,  0.446050f, -0.362005f,  0.276459f,
    -0.011691f, -0.388921f,  0.008159f,  0.383704f,  0.244008f, -0.364271f, -0.018162f,
    -0.434289f, -0.101804f, -0.479294f,  0.177580f,  0.249238f, -0.460342f,  0.377399f,
    -0.010918f,  0.114081f,  0.364307f, -0.228707f,  0.450042f, -0.369816f,  0.112019f,
    -0.188066f,  0.173241f,  0.254666f,  0.041114f, -0.206570f, -0.403259f,  0.421196f,
    0.103488f, -0.230908f,  0.420430f,  0.071221f, -0.418757f,  0.014641f, -0.091187f,
    -0.166531f,  0.026252f,  0.491307f, -0.003697f,  0.001154f,  0.052928f,  0.023346f,
    0.137441f,  0.022320f,  0.095145f,  0.330038f,  0.078063f,  0.285314f, -0.297446f,
    0.441708f,  0.118920f, -0.083315f, -0.050598f, -0.460064f, -0.361617f,  0.121538f,
    -0.481737f,  0.316732f,  0.226417f,  0.186108f, -0.461919f,  0.484598f, -0.448036f,
    -0.331042f,  0.164848f, -0.206929f,  0.287261f, -0.038549f, -0.363624f, -0.462640f,
    -0.004289f,  0.371369f,  0.380650f,  0.066356f, -0.242093f,  0.137509f,  0.058627f,
    -0.288385f, -0.430088f,  0.420480f, -0.146046f,  0.132450f, -0.241715f, -0.171188f,
    0.138755f, -0.412695f,  0.080512f, -0.436336f, -0.070622f, -0.354102f,  0.033075f,
    -0.175612f,  0.459946f,  0.413774f, -0.408470f, -0.124112f,  0.234004f,  0.279934f,
    0.029503f, -0.307155f,  0.132817f,  0.363839f,  0.181852f, -0.438256f,  0.458515f,
    0.340759f,  0.059605f, -0.473884f,  0.144931f, -0.210040f, -0.177932f,  0.331089f,
    0.080347f,  0.030416f, -0.050574f,  0.178324f,  0.434377f, -0.009411f, -0.075255f,
    0.400561f, -0.226105f, -0.324583f, -0.331500f,  0.255663f,  0.376318f,  0.433254f,
    0.415451f, -0.286710f, -0.382951f,  0.442408f,  0.179976f,  0.043854f,  0.313739f,
    -0.399313f, -0.377965f, -0.459593f, -0.026155f, -0.452516f,  0.155108f,  0.021628f,
    -0.387701f, -0.372760f, -0.113858f,  0.230494f,  0.109795f, -0.267619f,  0.255387f,
    -0.398110f,  0.474046f, -0.324901f, -0.436395f, -0.493087f,  0.179438f, -0.171379f,
    0.401408f,  0.266591f,  0.405918f, -0.436735f, -0.000677f,  0.377981f,  0.214940f,
    -0.440210f, -0.180361f,  0.317032f, -0.193708f, -0.493016f,  0.137425f,  0.421249f,
    0.140051f,  0.342467f, -0.313406f,  0.048210f, -0.393470f, -0.048679f, -0.341051f,
    -0.069302f, -0.364485f, -0.262051f, -0.125555f,  0.274013f,  0.284297f,  0.389757f,
    -0.073009f,  0.174424f, -0.109993f,  0.379738f, -0.357018f, -0.220550f, -0.148393f,
    -0.252804f, -0.436807f, -0.199547f, -0.115045f, -0.344107f,  0.119837f,  0.456786f,
    -0.387090f,  0.376492f,  0.179661f,  0.249598f, -0.117911f,  0.160655f,  0.064273f,
    -0.405627f, -0.412837f, -0.031449f, -0.353181f, -0.113181f,  0.209340f, -0.053592f,
    -0.280639f,  0.030106f,  0.492732f, -0.291658f,  0.290442f,  0.446316f,  0.273698f,
    -0.095150f, -0.476798f, -0.344124f,  0.105088f, -0.177417f, -0.419990f,  0.300665f,
    -0.031081f,  0.185360f,  0.071941f,  0.065031f, -0.385363f,  0.259612f,  0.195752f,
    0.010550f,  0.291446f,  0.418917f,  0.005608f, -0.028207f,  0.335679f, -0.382067f,
    -0.156810f, -0.410792f,  0.029713f, -0.342503f,  0.422414f,  0.399725f, -0.252636f,
    -0.402846f, -0.178326f, -0.075509f, -0.150043f,  0.361755f,  0.017949f, -0.464235f,
    0.383624f,  0.183485f,  0.147359f, -0.158506f, -0.034035f,  0.473877f,  0.392783f,
    -0.423001f, -0.468516f, -0.498259f, -0.018739f,  0.359956f, -0.149339f, -0.402138f,
    -0.124694f, -0.140715f,  0.045751f, -0.233281f,  0.219486f, -0.196772f,  0.124219f,
    -0.423931f, -0.233779f,  0.049960f, -0.157012f,  0.049070f,  0.365398f, -0.450651f,
    -0.163637f,  0.298740f,  0.126891f,  0.211323f, -0.201202f, -0.365722f,  0.222478f,
    0.379836f, -0.150175f,  0.412297f,  0.105852f,  0.097211f, -0.160181f, -0.401954f,
    -0.478235f, -0.421933f, -0.072631f, -0.297437f,  0.326101f,  0.131937f, -0.004495f,
    -0.152603f,  0.329271f,  0.156687f,  0.426630f,  0.320671f,  0.040334f,  0.138980f,
    0.054588f,  0.284021f, -0.033573f, -0.147745f,  0.214942f, -0.307740f, -0.397849f,
    0.036278f,  0.257297f, -0.065147f,  0.220556f, -0.184631f, -0.469348f, -0.095331f,
    0.298293f,  0.395599f,  0.146787f, -0.135373f, -0.177407f,  0.245832f,  0.037886f,
    -0.397813f, -0.259692f, -0.024603f,  0.301835f,  0.436097f, -0.474310f, -0.425074f,
    0.248507f, -0.063976f, -0.176382f,  0.079736f,  0.177769f,  0.015864f, -0.368945f,
    0.180671f, -0.181986f, -0.086483f, -0.272240f, -0.129752f, -0.306264f, -0.462784f,
    0.476310f,  0.036971f, -0.038623f, -0.429828f, -0.446332f, -0.436216f, -0.478238f,
    0.426105f,  0.226858f,  0.143859f,  0.380316f, -0.251469f, -0.027836f, -0.214683f,
    0.256724f,  0.272391f,  0.292184f,  0.063565f, -0.354693f, -0.090587f, -0.307590f,
    0.213818f, -0.223771f,  0.285666f, -0.173278f,  0.395937f, -0.066431f,  0.323951f,
    -0.350118f,  0.058258f,  0.135502f,  0.013497f,  0.068842f, -0.433210f,  0.388588f,
    0.198955f, -0.439485f, -0.168481f,  0.284825f,  0.019604f, -0.278248f, -0.125979f,
    0.137201f, -0.226533f, -0.109046f,  0.351957f, -0.254378f,  0.220510f,  0.186493f,
    0.338902f,  0.177042f,  0.190977f,  0.354465f, -0.104524f,  0.136253f,  0.361393f,
    0.219961f, -0.456284f, -0.069824f, -0.000363f, -0.242168f, -0.054573f,  0.099640f,
    -0.324632f, -0.490213f,  0.301979f,  0.247953f,  0.461887f,  0.396674f,  0.043277f,
    -0.247714f,  0.115142f, -0.266858f, -0.296270f,  0.047685f,  0.465286f,  0.224908f,
    -0.170062f,  0.247834f, -0.328042f, -0.102064f, -0.194025f, -0.436542f, -0.282086f,
    -0.291324f,  0.485782f,  0.428246f,  0.204002f,  0.152624f, -0.002912f,  0.401422f,
    0.084586f, -0.384136f,  0.426796f, -0.178238f, -0.115137f, -0.205271f, -0.145923f,
    0.204160f,  0.374208f, -0.010597f,  0.295001f,  0.439221f, -0.147570f, -0.091569f,
    0.132860f, -0.250771f, -0.376042f,  0.205886f, -0.006840f, -0.081049f, -0.110457f,
    -0.082025f,  0.384274f, -0.266253f, -0.057415f,  0.330579f, -0.243035f, -0.424709f,
    -0.000052f,  0.356390f, -0.427697f,  0.329887f,  0.272955f, -0.054250f,  0.032325f,
    -0.183010f, -0.443397f,  0.317905f, -0.013946f, -0.164596f,  0.013090f,  0.251274f,
    0.231012f,  0.219056f,  0.294079f,  0.387707f, -0.316673f,  0.388841f,  0.295290f,
    -0.485155f,  0.274864f,  0.255310f, -0.207201f,  0.324058f, -0.318887f, -0.229206f,
    -0.135473f, -0.116363f,  0.206889f,  0.328743f,  0.260086f,  0.405553f,  0.117191f,
    -0.229362f, -0.079843f,  0.160131f,  0.047037f,  0.272935f,  0.351437f,  0.150193f,
    -0.352990f,  0.462391f, -0.010896f,  0.391847f, -0.498931f, -0.059832f,  0.495205f,
    0.063178f,  0.411330f,  0.003849f, -0.116003f,  0.028085f,  0.092869f, -0.159516f,
    -0.315168f,  0.176745f,  0.012652f,  0.249949f,  0.066373f, -0.043692f, -0.216301f,
    0.050849f, -0.015012f,  0.408096f,  0.072229f, -0.445728f,  0.282886f, -0.053342f,
    0.166322f, -0.225299f,  0.061473f,  0.180374f,  0.104526f, -0.378119f,  0.171589f,
    -0.094873f, -0.122416f, -0.000471f, -0.110549f,  0.326875f, -0.357758f,  0.172192f,
    -0.354328f, -0.135726f, -0.040058f, -0.326197f,  0.420557f,  0.030114f, -0.227415f,
    0.472338f,  0.253678f, -0.175107f, -0.479390f, -0.295591f,  0.396660f,  0.435040f,
    -0.495738f, -0.490528f,  0.388044f,  0.402908f,  0.186402f, -0.138081f, -0.313466f,
    -0.380319f, -0.325319f, -0.315239f,  0.167935f, -0.267195f, -0.466995f,  0.373371f,
    0.491409f, -0.193346f,  0.428160f,  0.432262f,  0.057669f,  0.232261f, -0.120654f,
    -0.419094f, -0.483650f,  0.055448f, -0.351523f,  0.092698f, -0.201351f, -0.357835f,
    -0.419134f, -0.450546f, -0.263329f,  0.188077f,  0.112880f, -0.294889f,  0.030571f,
    0.222085f,  0.229939f, -0.082179f, -0.297996f,  0.369629f, -0.450287f,  0.118650f,
    0.056765f,  0.103277f, -0.022665f, -0.395107f,  0.415445f, -0.409539f,  0.228114f,
    -0.027745f, -0.431112f, -0.420337f, -0.474472f,  0.206329f, -0.298893f,  0.278206f,
    0.185760f, -0.358251f, -0.212215f, -0.448222f,  0.212844f,  0.046970f, -0.369315f,
    0.405485f, -0.290547f,  0.211871f,  0.400187f,  0.429499f,  0.006818f, -0.109663f,
    0.018089f, -0.246879f,  0.223347f, -0.104970f, -0.124974f, -0.453559f,  0.155829f,
    0.248990f,  0.210942f,  0.438892f,  0.310926f,  0.089069f,  0.228468f, -0.457765f,
    -0.290025f,  0.088118f,  0.408701f,  0.428272f,  0.199383f,  0.443091f,  0.073418f,
    0.228461f,  0.115322f,  0.469640f, -0.480601f, -0.493675f, -0.331176f, -0.116591f,
    -0.162962f,  0.169829f, -0.389935f,  0.345226f,  0.130483f,  0.108841f,  0.013771f,
    -0.459084f,  0.358986f, -0.415714f,  0.206830f,  0.274019f, -0.486065f,  0.486028f,
    0.380731f, -0.083274f, -0.306613f,  0.194028f, -0.367782f,  0.314473f, -0.288149f,
    -0.096514f, -0.466878f,  0.424641f, -0.170831f,  0.343989f, -0.287102f, -0.280372f,
    -0.344112f, -0.027086f, -0.146348f, -0.342959f,  0.216247f,  0.045167f,  0.346942f,
    0.351240f, -0.037559f, -0.251074f,  0.184276f,  0.335052f,  0.439142f, -0.402750f,
    0.379772f, -0.079409f, -0.484837f, -0.071448f, -0.074848f, -0.075668f,  0.114965f,
    0.098318f,  0.415993f,  0.262431f,  0.197401f,  0.346457f, -0.333458f,  0.324590f,
    0.109297f,  0.458939f, -0.158433f, -0.146610f,  0.169355f, -0.028412f, -0.488582f,
    -0.126033f,  0.461371f, -0.496161f,  0.105183f, -0.302684f, -0.101748f, -0.220081f,
    0.161547f,  0.148641f, -0.010976f,  0.366369f, -0.386664f, -0.482598f, -0.255477f,
    0.203149f, -0.213869f, -0.316444f,  0.404275f, -0.340677f,  0.430567f, -0.081426f,
    0.282997f,  0.334659f, -0.330380f, -0.208097f, -0.088031f, -0.159778f,  0.344459f,
    -0.186488f, -0.304707f, -0.288262f, -0.355916f,  0.119020f, -0.313232f, -0.219985f,
    -0.245609f, -0.058200f, -0.491873f,  0.287005f,  0.351607f,  0.430602f,  0.327912f,
    -0.208802f,  0.273756f, -0.245914f, -0.328070f,  0.152182f,  0.453416f,  0.405653f,
    0.376466f,  0.274698f, -0.102790f,  0.281766f,  0.475176f, -0.316197f,  0.005018f,
    -0.118658f,  0.246425f, -0.295596f,  0.077722f, -0.132413f,  0.072043f,  0.043131f,
    0.350407f,  0.079953f,  0.468868f, -0.115905f,  0.082596f, -0.206293f,  0.464490f,
    0.381524f,  0.053429f, -0.162634f, -0.022537f,  0.283525f, -0.446703f, -0.088891f,
    -0.375419f, -0.322340f, -0.419295f, -0.251987f,  0.273979f, -0.211185f,  0.280826f,
    0.347929f,  0.068858f, -0.135505f, -0.321979f,  0.443021f, -0.295945f,  0.386802f,
    -0.173425f,  0.254119f, -0.396233f, -0.208489f, -0.359086f, -0.073752f, -0.253654f,
    0.143874f, -0.232037f,  0.326004f,  0.149669f, -0.388230f, -0.029808f,  0.007192f,
    0.172235f,  0.336852f,  0.028868f, -0.453317f, -0.479365f,  0.383474f,  0.224445f,
    0.390239f,  0.168683f, -0.253181f, -0.033257f,  0.176844f, -0.211754f,  0.032176f,
    0.234120f, -0.093501f,  0.033382f, -0.063640f, -0.368495f, -0.464544f,  0.389825f,
    0.332485f,  0.225527f, -0.292530f, -0.150789f, -0.203505f, -0.114342f, -0.479069f,
    0.455008f,  0.237070f, -0.181799f, -0.020971f, -0.375878f, -0.228329f, -0.119189f,
    0.140722f, -0.080714f, -0.294076f,  0.305294f, -0.120241f, -0.257091f, -0.050528f,
    -0.277342f, -0.459016f, -0.130867f,  0.170335f,  0.104262f, -0.040605f,  0.218945f,
    -0.363684f,  0.024629f,  0.157761f,  0.220554f, -0.096315f, -0.226150f,  0.271136f,
    0.156790f,  0.131180f,  0.449869f, -0.352650f,  0.271364f, -0.134858f, -0.466543f,
    -0.244108f,  0.040697f,  0.156510f,  0.271834f,  0.195825f, -0.112750f,  0.032522f,
    -0.207777f,  0.246973f, -0.050607f, -0.191231f,  0.445736f, -0.343616f,  0.082614f,
    -0.152983f, -0.202251f, -0.379459f, -0.435901f, -0.049362f, -0.323792f, -0.281992f,
    -0.460539f,  0.155214f,  0.148107f,  0.200130f, -0.115374f, -0.317263f,  0.490992f,
    -0.029874f,  0.171035f, -0.047262f, -0.424110f, -0.487212f, -0.102541f, -0.095228f,
    0.386107f,  0.295286f,  0.181660f,  0.309081f,  0.109297f, -0.110081f,  0.050125f,
    0.004345f, -0.305130f,  0.495531f,  0.200203f,  0.084599f,  0.442798f,  0.207662f,
    0.277714f,  0.396249f, -0.048683f,  0.438012f, -0.028185f,  0.438373f,  0.108740f,
    0.269638f, -0.499717f, -0.024139f,  0.167957f,  0.291542f, -0.218929f, -0.330437f,
    -0.168755f, -0.050847f, -0.036014f, -0.452660f, -0.371495f, -0.381857f,  0.249359f,
    -0.364921f,  0.265088f,  0.228486f, -0.465895f, -0.059343f, -0.491908f,  0.182298f,
    0.400358f, -0.157148f,  0.174754f, -0.300407f,  0.064778f, -0.158968f, -0.123327f,
    0.345489f, -0.080350f,  0.332668f, -0.007334f, -0.076379f,  0.268049f,  0.320200f,
    0.415726f, -0.175262f,  0.348009f, -0.374519f, -0.389378f,  0.285840f,  0.083993f,
    -0.319022f,  0.484020f,  0.411252f, -0.457390f,  0.347311f,  0.204768f, -0.371853f,
    0.414001f, -0.495051f,  0.005141f, -0.031100f,  0.116413f, -0.384709f, -0.128040f,
    -0.006982f,  0.220914f, -0.272386f,  0.017621f, -0.337851f, -0.276829f, -0.088898f,
    -0.135821f,  0.270818f,  0.422553f,  0.156217f, -0.372062f, -0.100812f, -0.005997f,
    -0.039001f,  0.247675f,  0.406623f, -0.290696f,  0.092506f, -0.462679f, -0.081605f,
    -0.348798f,  0.091817f, -0.115165f,  0.093227f,  0.401722f, -0.374000f,  0.275195f,
    0.294887f, -0.174084f, -0.361205f, -0.260717f, -0.446251f, -0.269203f, -0.277068f,
    -0.234731f, -0.101179f, -0.111433f,  0.243741f, -0.361478f,  0.100277f,  0.471288f,
    0.451826f, -0.125287f, -0.001791f,  0.164365f,  0.301031f, -0.206531f, -0.355759f,
    -0.312285f, -0.441246f,  0.152471f,  0.266421f, -0.249031f,  0.384092f, -0.429481f,
    0.229702f,  0.462887f,  0.133648f,  0.049744f,  0.428161f,  0.281369f,  0.216514f,
    0.239300f, -0.037467f, -0.129518f,  0.293584f, -0.466210f,  0.157602f, -0.117765f,
    -0.360428f, -0.321895f,  0.416424f,  0.126033f, -0.350193f,  0.155614f, -0.371507f,
    -0.233488f,  0.071949f,  0.308989f, -0.289030f, -0.195217f, -0.177694f,  0.312799f,
    -0.191586f, -0.131288f,  0.157583f, -0.144180f, -0.022468f,  0.250208f,  0.419103f,
    -0.339361f,  0.188034f, -0.317621f, -0.345941f, -0.128868f, -0.144612f, -0.186368f,
    -0.293045f,  0.367870f,  0.141050f, -0.008598f,  0.126631f,  0.361387f, -0.006347f,
    0.363190f, -0.333993f,  0.187760f, -0.478322f, -0.499679f, -0.318092f,  0.255306f,
    0.273727f, -0.420499f,  0.243013f,  0.120937f,  0.423895f,  0.463529f, -0.199544f,
    -0.093778f, -0.387484f, -0.084227f,  0.396035f, -0.216723f,  0.250310f,  0.289218f,
    0.308970f,  0.296945f, -0.241526f, -0.258340f, -0.041872f,  0.460317f,  0.368396f,
    -0.248841f, -0.329583f,  0.124406f,  0.450459f,  0.113024f,  0.438325f,  0.229104f,
    -0.332049f, -0.120116f,  0.064457f,  0.481403f, -0.326297f, -0.186103f, -0.374698f,
    0.459002f,  0.276054f, -0.175447f,  0.180657f,  0.424055f, -0.482306f, -0.197754f,
    0.262445f,  0.464956f, -0.465598f, -0.022222f,  0.253464f,  0.316098f,  0.317496f,
    -0.042232f,  0.122578f,  0.079829f,  0.098794f,  0.437900f, -0.369407f,  0.474973f,
    0.343090f,  0.077804f, -0.473535f,  0.436856f, -0.318326f,  0.446675f,  0.085430f,
    0.309656f,  0.290534f,  0.396527f, -0.278749f,  0.308937f, -0.473984f, -0.214913f,
    0.159246f, -0.163490f,  0.224263f, -0.487044f, -0.436681f, -0.061616f,  0.172475f,
    0.235946f,  0.050472f,  0.186952f,  0.421629f, -0.495096f, -0.365359f,  0.408910f,
    0.461599f,  0.129166f, -0.044043f,  0.479518f, -0.221254f,  0.178861f,  0.262489f,
    0.261072f, -0.000952f, -0.325878f,  0.313115f,  0.218964f,  0.050991f, -0.140120f,
    -0.090544f,  0.233017f, -0.495866f,  0.253162f,  0.092012f,  0.206318f,  0.222036f,
    -0.139090f,  0.054059f, -0.279661f, -0.439372f,  0.101373f,  0.142944f, -0.203667f,
    -0.278011f, -0.212387f, -0.008228f, -0.208045f,  0.293681f, -0.170102f, -0.382296f,
    0.222591f,  0.048288f,  0.132543f, -0.047865f,  0.373394f,  0.407810f,  0.063584f,
    -0.348286f, -0.374453f, -0.417782f,  0.191685f, -0.450325f, -0.485501f, -0.161684f,
    0.058480f, -0.180624f,  0.365079f,  0.039430f,  0.196700f, -0.135298f,  0.495489f,
    -0.007898f, -0.459339f,  0.356451f,  0.176653f,  0.044622f, -0.302197f,  0.384578f,
    -0.106526f,  0.183764f,  0.165094f, -0.219038f, -0.260974f, -0.221498f, -0.344922f,
    -0.373077f, -0.369051f,  0.408952f, -0.068262f,  0.338072f,  0.261394f, -0.490517f,
    0.400133f, -0.486743f,  0.458436f,  0.039383f, -0.384215f, -0.355432f, -0.230751f,
    0.092980f, -0.384676f,  0.464915f,  0.285370f,  0.372519f, -0.230057f,  0.015054f,
    -0.129310f,  0.198030f, -0.255588f, -0.247365f,  0.266491f,  0.223800f,  0.138869f,
    0.214615f, -0.081248f,  0.103875f, -0.203650f, -0.152954f, -0.424598f, -0.089519f,
    0.389363f, -0.198307f, -0.349637f,  0.398476f,  0.332994f,  0.389343f,  0.352643f,
    0.043459f, -0.095376f, -0.199912f, -0.421213f, -0.193609f, -0.458095f, -0.070231f,
    0.402517f, -0.482845f,  0.016884f,  0.170464f, -0.355987f, -0.324767f, -0.313013f,
    -0.233913f, -0.168916f, -0.032623f,  0.459932f,  0.439405f, -0.115731f,  0.357912f,
    -0.097431f,  0.055035f, -0.032834f, -0.246793f,  0.011543f, -0.111959f,  0.181947f,
    -0.157872f,  0.250646f, -0.133140f, -0.411174f,  0.211387f,  0.265520f, -0.097548f,
    0.458453f,  0.499115f,  0.196326f,  0.006304f, -0.310251f, -0.469755f,  0.224073f,
    0.444479f,  0.045079f, -0.249649f,  0.173162f,  0.233023f, -0.236909f,  0.095147f,
    -0.066544f,  0.114312f,  0.340773f, -0.216020f, -0.292138f, -0.019792f, -0.145231f,
    -0.431441f, -0.300734f, -0.054884f,  0.282691f,  0.191966f, -0.346986f, -0.207711f,
    0.443856f,  0.285187f, -0.487445f, -0.104790f, -0.398238f, -0.455531f,  0.436765f,
    0.480865f, -0.455380f, -0.233689f,  0.193838f, -0.015297f,  0.312976f,  0.469725f,
    -0.119953f,  0.432640f,  0.292965f,  0.287301f,  0.419362f,  0.161222f,  0.398941f,
    -0.234311f,  0.054756f, -0.406095f, -0.320623f,  0.468435f,  0.232435f,  0.273312f,
    0.185261f,  0.433997f, -0.139593f,  0.403215f,  0.021210f, -0.198467f, -0.137649f,
    -0.019743f,  0.477601f,  0.297271f,  0.482135f,  0.347223f,  0.229016f, -0.126463f,
    -0.325552f,  0.033543f,  0.132820f,  0.037571f, -0.340476f, -0.125816f, -0.085207f,
    -0.196936f, -0.142989f,  0.127870f,  0.370372f,  0.076798f, -0.256424f,  0.115493f,
    -0.085530f,  0.067085f,  0.014280f,  0.438560f, -0.204822f, -0.290873f, -0.151735f,
    0.237661f, -0.147435f,  0.462269f,  0.179467f,  0.037413f, -0.200506f,  0.291017f,
    0.013437f,  0.275479f, -0.036090f,  0.419155f, -0.112262f, -0.389503f, -0.261180f,
    0.096156f,  0.187445f, -0.018330f, -0.494535f,  0.267223f, -0.143705f,  0.289069f,
    0.035687f, -0.349345f,  0.010748f, -0.430834f, -0.259318f,  0.335023f, -0.492815f,
    -0.051248f,  0.155204f, -0.021897f, -0.164183f,  0.219201f, -0.340457f, -0.038047f,
    0.038191f,  0.032297f,  0.217532f,  0.204587f,  0.154013f, -0.118250f,  0.309281f,
    -0.403118f, -0.001866f, -0.192288f, -0.135012f,  0.400519f, -0.383260f,  0.204391f,
    -0.146000f,  0.163692f,  0.355140f, -0.013784f, -0.114724f,  0.369167f,  0.136007f,
    0.391515f,  0.255791f, -0.215031f, -0.140088f, -0.206562f,  0.007380f,  0.331000f,
    0.128636f,  0.417854f, -0.224380f, -0.227561f,  0.100751f, -0.087531f,  0.232947f,
    0.098479f, -0.171295f,  0.298630f,  0.329179f, -0.483626f,  0.023079f,  0.198829f,
    0.043509f,  0.387706f, -0.265570f,  0.053199f,  0.101033f, -0.463902f, -0.156588f,
    -0.294918f, -0.167288f,  0.371305f, -0.321490f, -0.410113f, -0.280137f,  0.489825f,
    0.226233f,  0.346818f, -0.047269f,  0.441221f, -0.284894f, -0.013240f, -0.271813f,
    0.384475f,  0.311919f,  0.491867f, -0.164643f,  0.420581f,  0.001928f, -0.453563f,
    0.041951f, -0.425282f, -0.315125f, -0.138892f, -0.249229f,  0.140553f,  0.122545f,
    -0.437425f, -0.411547f,  0.395411f, -0.346766f,  0.391884f, -0.099183f,  0.381134f,
    -0.158142f, -0.048482f,  0.335560f,  0.432682f,  0.274977f,  0.134003f, -0.291386f,
    -0.335953f,  0.116798f, -0.225361f,  0.480766f, -0.493651f,  0.410034f, -0.176490f,
    0.362653f,  0.281465f,  0.294640f,  0.205244f, -0.344374f,  0.409954f, -0.296076f,
    -0.489164f, -0.098958f,  0.245992f, -0.177048f, -0.321526f, -0.380801f,  0.334593f,
    -0.184298f, -0.492367f,  0.380379f, -0.444620f,  0.468024f, -0.196544f,  0.063600f,
    -0.311146f,  0.391470f, -0.039437f, -0.036266f,  0.279706f, -0.007256f,  0.114028f,
    -0.164612f, -0.280442f,  0.254420f, -0.439500f,  0.083555f,  0.499223f,  0.480222f,
    -0.112315f,  0.088452f, -0.063372f,  0.033378f,  0.252013f,  0.187817f,  0.047883f,
    0.006082f,  0.071956f, -0.372789f, -0.149713f, -0.015985f,  0.320771f, -0.038463f,
    0.350525f,  0.160183f, -0.176745f, -0.026629f, -0.060048f,  0.070391f, -0.094641f,
    0.330808f,  0.380974f, -0.002376f,  0.285300f,  0.495120f,  0.091509f,  0.469219f,
    -0.194715f,  0.002814f, -0.086178f,  0.359267f,  0.012544f,  0.274588f, -0.036626f,
    -0.464804f,  0.438322f, -0.227193f, -0.205608f,  0.143575f, -0.121403f,  0.257543f,
    -0.128466f, -0.076997f, -0.061915f,  0.337810f, -0.090565f,  0.034455f,  0.400460f,
    -0.371294f, -0.180023f,  0.000031f, -0.323353f, -0.103108f, -0.094683f,  0.393858f,
    0.156467f,  0.286754f,  0.245251f, -0.096376f, -0.052776f,  0.389079f,  0.471002f,
    -0.486730f,  0.379131f, -0.245039f, -0.107465f, -0.402397f,  0.148378f, -0.177409f,
    0.179886f,  0.184816f, -0.136321f, -0.143376f, -0.004481f,  0.065070f, -0.426101f,
    -0.217209f,  0.467518f, -0.399452f,  0.048869f,  0.008811f, -0.406540f,  0.337957f,
    -0.168529f, -0.128644f,  0.311548f, -0.082401f,  0.498762f,  0.043649f,  0.386236f,
    0.408523f, -0.011583f, -0.474589f, -0.424301f,  0.437229f,  0.042428f,  0.053265f,
    0.001804f,  0.193964f, -0.225738f,  0.392929f, -0.218635f,  0.237392f, -0.486838f,
    -0.127321f, -0.069647f, -0.367463f, -0.442445f,  0.199490f,  0.278414f,  0.271313f,
    0.369574f,  0.464349f, -0.334386f, -0.321916f,  0.358338f, -0.168476f,  0.401035f,
    0.398643f,  0.478001f, -0.351270f, -0.213876f,  0.429545f, -0.142177f,  0.182459f,
    0.214999f, -0.448852f, -0.010972f,  0.337130f, -0.192097f, -0.116948f,  0.223330f,
    0.160720f, -0.110571f,  0.251446f, -0.449557f, -0.333690f, -0.355119f, -0.173607f,
    -0.420830f,  0.142342f, -0.440787f,  0.001198f,  0.064784f,  0.208685f,  0.424535f,
    0.209153f,  0.123167f,  0.065966f, -0.216581f, -0.365767f, -0.178271f, -0.262355f,
    0.223596f, -0.083484f,  0.213662f,  0.314295f,  0.350625f, -0.409550f,  0.113850f,
    -0.135559f,  0.012295f,  0.250734f,  0.233311f, -0.496374f,  0.233769f,  0.207939f,
    0.378884f,  0.231227f, -0.274472f, -0.418547f, -0.326329f,  0.311865f, -0.044788f,
    -0.446382f, -0.497563f, -0.155721f, -0.084573f, -0.435384f, -0.321474f, -0.484557f,
    0.486884f,  0.016780f,  0.162146f, -0.437924f, -0.117776f,  0.049320f,  0.234091f,
    0.476897f,  0.080955f, -0.124705f, -0.002369f, -0.285187f, -0.471077f,  0.293056f,
    0.300680f,  0.427349f,  0.103193f,  0.310822f, -0.049864f,  0.325136f,  0.440169f,
    0.387923f,  0.443123f,  0.021971f,  0.024197f, -0.102779f,  0.331579f,  0.424245f,
    -0.153149f, -0.136076f, -0.063852f, -0.188485f,  0.212941f,  0.415480f,  0.054813f,
    -0.486796f,  0.205351f,  0.280162f, -0.103834f,  0.469295f,  0.072572f, -0.041198f,
    -0.014791f,  0.306220f,  0.093981f,  0.240738f, -0.277685f, -0.159441f,  0.360184f,
    -0.316891f, -0.441768f, -0.489209f,  0.009035f, -0.320633f,  0.017326f,  0.139946f,
    0.240256f,  0.231066f, -0.351462f, -0.450943f,  0.429021f,  0.445226f,  0.202729f,
    -0.087199f, -0.264247f, -0.188153f,  0.173144f, -0.194660f,  0.208016f,  0.192247f,
    0.243089f, -0.302626f, -0.238656f,  0.154180f,  0.064577f,  0.196790f, -0.042283f,
    0.325069f,  0.250433f, -0.322510f, -0.150014f,  0.066859f,  0.059469f, -0.392810f,
    -0.417353f,  0.287085f,  0.252696f, -0.000928f,  0.017124f,  0.138709f,  0.213874f,
    -0.001584f, -0.455883f, -0.210530f,  0.079001f, -0.161103f, -0.054010f,  0.189145f,
    0.178671f, -0.180301f, -0.254095f, -0.325146f,  0.139725f, -0.239679f, -0.176968f,
    0.440764f,  0.046727f, -0.328255f,  0.158269f, -0.014779f, -0.139187f,  0.368181f,
    -0.295771f,  0.027065f,  0.018066f,  0.050937f,  0.426788f,  0.460895f, -0.330562f,
    -0.216088f,  0.251065f,  0.371190f,  0.220102f,  0.398276f, -0.251362f,  0.135913f,
    -0.277901f,  0.001947f,  0.039212f,  0.175732f, -0.232903f, -0.391659f,  0.241329f,
    -0.085174f,  0.016410f, -0.240250f,  0.413440f,  0.248960f, -0.453730f, -0.384500f,
    -0.122472f,  0.016953f,  0.134291f,  0.156378f,  0.039070f,  0.159447f,  0.277607f,
    -0.332243f, -0.185507f, -0.043676f, -0.373020f, -0.111745f, -0.116724f, -0.241072f,
    0.110215f,  0.423021f, -0.392221f,  0.289035f, -0.028802f, -0.364124f,  0.348787f,
    -0.057695f,  0.390131f,  0.058261f,  0.366246f, -0.295542f,  0.101038f, -0.168540f,
    -0.321918f, -0.375910f,  0.262835f,  0.168927f,  0.379036f,  0.162734f, -0.248451f,
    -0.234907f, -0.452114f, -0.197845f,  0.458263f,  0.354167f,  0.125086f, -0.311801f,
    0.237709f, -0.254292f, -0.018172f, -0.247475f, -0.053034f,  0.032797f, -0.138150f,
    0.116863f, -0.163566f, -0.176725f,  0.323337f, -0.146947f,  0.153097f,  0.215639f,
    0.182300f, -0.434203f, -0.360572f,  0.399867f,  0.031391f,  0.269151f,  0.063260f,
    -0.328240f,  0.027916f, -0.356733f, -0.398832f, -0.090183f,  0.488478f, -0.248629f,
    -0.120200f,  0.169301f, -0.349761f,  0.450651f, -0.481024f, -0.367048f, -0.156862f,
    0.092474f, -0.167047f,  0.246009f, -0.075288f,  0.240695f, -0.148890f, -0.380060f,
    0.148717f,  0.370719f,  0.388333f,  0.270249f,  0.237898f,  0.191348f, -0.396029f,
    -0.344919f, -0.294545f, -0.033528f,  0.364552f,  0.390173f, -0.107174f,  0.130418f,
    0.000979f,  0.159391f, -0.435181f,  0.480827f,  0.410358f,  0.336896f, -0.392939f,
    0.203521f,  0.283382f, -0.054351f, -0.387029f,  0.107773f, -0.118533f, -0.053035f,
    0.214256f,  0.416239f, -0.212820f, -0.222923f, -0.485473f, -0.284436f,  0.404361f,
    -0.299984f,  0.122320f, -0.298820f,  0.390562f, -0.247353f,  0.068285f, -0.121713f,
    0.317632f, -0.470503f,  0.429956f, -0.338442f, -0.467311f, -0.355466f,  0.203332f,
    0.365221f, -0.258979f, -0.342566f, -0.141775f,  0.425175f,  0.267356f,  0.447012f,
    -0.073031f,  0.143445f,  0.238131f,  0.228681f, -0.185088f,  0.106148f,  0.234014f,
    -0.438851f,  0.025150f, -0.221758f, -0.089147f,  0.075736f, -0.023142f,  0.216448f,
    0.003810f,  0.235936f,  0.211614f,  0.226204f,  0.291870f,  0.032111f, -0.250957f,
    -0.004701f, -0.010220f,  0.114022f, -0.276307f,  0.407542f, -0.413832f, -0.169568f,
    -0.160882f,  0.031724f, -0.002001f, -0.010979f,  0.070725f, -0.383033f, -0.346678f,
    -0.229158f, -0.027821f, -0.256028f, -0.459555f,  0.171394f, -0.244674f, -0.213424f,
    -0.380637f,  0.025950f,  0.462982f,  0.249311f,  0.230530f,  0.181197f,  0.308226f,
    -0.150413f,  0.160384f, -0.339528f, -0.038570f, -0.091351f, -0.061295f, -0.161469f,
    -0.095829f, -0.029694f,  0.309595f,  0.186899f,  0.192035f,  0.362648f, -0.101778f,
    0.206307f,  0.159369f,  0.203600f,  0.105363f, -0.247082f, -0.080800f,  0.189505f,
    -0.379902f,  0.254987f,  0.450258f,  0.226242f, -0.480154f, -0.138024f, -0.312452f,
    0.409268f,  0.301519f, -0.434738f,  0.238819f,  0.142845f, -0.113862f, -0.134684f,
    0.110147f, -0.064431f,  0.393353f, -0.137869f,  0.441496f,  0.010688f,  0.476432f,
    0.331946f, -0.392614f, -0.267168f,  0.130157f, -0.317319f, -0.163297f, -0.349367f,
    -0.025488f, -0.197566f, -0.464642f, -0.124452f,  0.120001f,  0.019868f, -0.129757f,
    -0.484634f,  0.332966f,  0.363093f, -0.414977f, -0.074113f, -0.458391f,  0.355909f,
    -0.011602f, -0.128382f, -0.091191f, -0.060993f,  0.182026f,  0.046931f,  0.102798f,
    0.101437f, -0.194738f,  0.319571f, -0.169169f,  0.197545f,  0.371951f,  0.051002f,
    -0.323143f,  0.090331f, -0.006148f, -0.279476f,  0.267719f,  0.478404f,  0.336909f,
    0.146073f,  0.452472f,  0.445217f, -0.220159f, -0.066988f, -0.361831f,  0.221886f,
    0.256756f,  0.487949f, -0.491997f, -0.175118f,  0.312198f,  0.367885f, -0.167557f,
    -0.045960f, -0.298150f, -0.228114f, -0.047664f, -0.207583f, -0.013143f,  0.264493f,
    0.199440f,  0.005456f,  0.124157f,  0.004569f,  0.162268f, -0.198338f,  0.007463f,
    -0.237043f,  0.394168f, -0.210087f,  0.299644f,  0.285797f,  0.190296f,  0.089593f,
    0.081571f,  0.301595f,  0.177556f, -0.350254f, -0.232731f, -0.101003f,  0.116893f,
    -0.416437f,  0.171140f, -0.396041f, -0.086116f, -0.013289f,  0.408529f,  0.260644f,
    -0.022210f, -0.215142f, -0.357073f, -0.463492f, -0.179343f, -0.359699f,  0.316391f,
    0.310885f, -0.090510f,  0.473805f, -0.002584f,  0.415794f, -0.008395f,  0.249858f,
    0.013583f, -0.258847f,  0.325174f, -0.003273f, -0.405857f, -0.076817f, -0.164479f,
    -0.357477f, -0.102415f,  0.049292f,  0.258359f, -0.158694f,  0.436817f, -0.354592f,
    -0.148006f,  0.125933f, -0.486689f, -0.211349f,  0.493110f,  0.184482f,  0.133370f,
    0.400942f, -0.400333f, -0.067202f, -0.115661f, -0.465105f, -0.262685f,  0.105772f,
    -0.395917f, -0.065053f,  0.303445f, -0.036152f, -0.330302f,  0.032683f, -0.110539f,
    0.198967f, -0.024789f,  0.269719f, -0.205823f,  0.406338f,  0.355584f, -0.295831f,
    0.399549f,  0.386425f,  0.366014f, -0.017135f,  0.377646f, -0.232790f,  0.040019f,
    0.202177f, -0.168753f, -0.157273f, -0.046138f, -0.047929f, -0.210745f,  0.353153f,
    -0.376640f, -0.026796f, -0.004950f,  0.068274f, -0.214890f, -0.346858f, -0.393348f,
    0.254255f,  0.378672f, -0.141179f,  0.441179f,  0.318387f,  0.288674f, -0.072861f,
    0.364570f,  0.443555f, -0.056606f, -0.391193f, -0.323862f, -0.210166f,  0.344753f,
    0.242757f,  0.144503f, -0.308227f, -0.252671f, -0.194692f,  0.198307f,  0.194181f,
    0.062912f, -0.128311f, -0.403593f, -0.385395f, -0.228107f,  0.104548f,  0.335614f,
    -0.393806f,  0.131730f,  0.067598f,  0.190415f,  0.319428f,  0.321684f, -0.108906f,
    -0.087684f, -0.234456f, -0.283512f,  0.293405f, -0.006342f, -0.201099f,  0.181811f,
    0.409403f, -0.027925f,  0.331352f,  0.401876f, -0.223068f,  0.420577f,  0.430868f,
    0.133067f,  0.188348f,  0.140992f, -0.058337f, -0.396546f,  0.191592f,  0.214687f,
    -0.312874f,  0.301891f,  0.106664f, -0.273075f,  0.313712f,  0.204611f,  0.056615f,
    0.385591f,  0.428055f,  0.233227f, -0.239278f,  0.320404f,  0.035898f, -0.084970f,
    -0.469566f, -0.052909f, -0.034253f, -0.108252f, -0.109252f,  0.487602f,  0.148656f,
    -0.007842f, -0.368804f,  0.080570f,  0.415195f,  0.020544f,  0.497624f,  0.127317f,
    0.088978f, -0.481038f, -0.440031f, -0.217599f, -0.278717f,  0.416286f, -0.060418f,
    0.201565f,  0.082093f,  0.389230f, -0.274944f,  0.144942f,  0.148691f, -0.284037f,
    -0.263372f, -0.156621f, -0.396116f, -0.484027f,  0.269945f,  0.167752f, -0.047454f,
    0.232720f,  0.030215f,  0.295562f,  0.108894f, -0.451053f,  0.392758f,  0.398991f,
    0.409518f,  0.226927f, -0.353303f, -0.259390f, -0.178688f, -0.435896f, -0.488307f,
    -0.233465f,  0.382252f, -0.246508f,  0.495305f, -0.155280f,  0.020123f, -0.229213f,
    0.378748f, -0.325858f,  0.114431f, -0.112404f, -0.405144f, -0.242279f, -0.085358f,
    0.271713f, -0.426799f, -0.189904f,  0.009426f, -0.301641f,  0.368150f,  0.385982f,
    -0.097045f,  0.306338f,  0.416576f,  0.144063f, -0.267588f, -0.186373f, -0.031016f,
    -0.013204f, -0.266705f,  0.209924f,  0.242519f,  0.272478f,  0.093988f, -0.201069f,
    0.313909f, -0.479585f, -0.152789f, -0.471362f,  0.127782f, -0.386428f, -0.177249f,
    -0.140208f,  0.179386f, -0.260125f, -0.026595f,  0.345305f, -0.355333f, -0.049738f,
    -0.485060f, -0.431046f,  0.194672f, -0.301056f, -0.137607f, -0.109119f, -0.069387f,
    0.472408f, -0.238814f,  0.418734f, -0.188223f,  0.214956f, -0.095292f, -0.056450f,
    0.387198f, -0.220471f, -0.306446f,  0.003594f,  0.366042f, -0.163986f,  0.259140f,
    0.350273f, -0.381280f,  0.270894f, -0.029506f, -0.450882f,  0.154368f,  0.030959f,
    0.032538f,  0.244951f, -0.200431f, -0.028032f, -0.477031f,  0.321033f,  0.052873f,
    -0.354268f, -0.000992f,  0.182816f, -0.480002f,  0.124506f,  0.221945f,  0.171475f,
    -0.428321f,  0.151175f,  0.323862f,  0.462445f,  0.301484f, -0.197821f, -0.004398f,
    0.109634f,  0.401832f, -0.154985f, -0.233525f,  0.364810f,  0.395714f,  0.404407f,
    -0.175978f,  0.320018f,  0.447755f, -0.035258f, -0.123762f, -0.096993f,  0.185356f,
    0.128183f,  0.469784f,  0.493970f,  0.058432f, -0.381737f, -0.232915f, -0.053160f,
    0.490096f,  0.420947f, -0.235180f, -0.311299f, -0.328562f, -0.454336f,  0.158618f,
    0.263180f,  0.348053f, -0.022819f, -0.232983f,  0.182991f,  0.366202f, -0.011883f,
    -0.494369f,  0.096038f,  0.390521f,  0.057186f,  0.124518f, -0.040181f, -0.113659f,
    0.358916f,  0.202889f,  0.399522f, -0.242923f, -0.221408f, -0.458731f, -0.486381f,
    -0.464366f, -0.013204f,  0.048287f, -0.267594f, -0.391522f, -0.440544f,  0.324348f,
    -0.346588f, -0.021807f, -0.066833f,  0.375072f,  0.124740f, -0.313665f,  0.076396f,
    -0.388290f, -0.146959f,  0.380589f, -0.227424f, -0.477407f, -0.065028f,  0.041435f,
    -0.058003f,  0.028447f,  0.485770f, -0.477794f,  0.269640f, -0.394927f, -0.169688f,
    0.006659f, -0.197174f,  0.200289f, -0.027011f,  0.469787f,  0.085925f, -0.140796f,
    -0.456443f, -0.274196f, -0.287299f, -0.234987f,  0.475310f,  0.163120f,  0.006652f,
    0.203897f, -0.013639f,  0.066236f,  0.445421f,  0.265570f,  0.259288f, -0.208932f,
    -0.310169f,  0.029297f, -0.368044f, -0.458883f, -0.123004f, -0.416830f,  0.284108f,
    0.150577f, -0.390634f, -0.352764f, -0.180434f, -0.053911f, -0.310511f,  0.374222f,
    -0.130054f,  0.276055f, -0.311146f,  0.281561f, -0.221718f, -0.224391f,  0.426888f,
    0.311937f, -0.466621f, -0.497507f,  0.104275f, -0.045669f, -0.280096f,  0.125784f,
    0.368002f, -0.198424f,  0.205079f, -0.217110f, -0.128572f,  0.132659f,  0.308288f,
    -0.286665f, -0.227786f,  0.237722f,  0.081160f, -0.480925f,  0.127956f, -0.458987f,
    0.176979f, -0.155494f, -0.199045f, -0.197351f,  0.301941f,  0.384695f,  0.469953f,
    0.115080f, -0.062586f, -0.347005f, -0.178876f,  0.266734f, -0.499492f, -0.379859f,
    0.309633f, -0.324162f,  0.296751f, -0.307331f, -0.143776f,  0.245057f,  0.018349f,
    0.061414f, -0.016794f, -0.463726f,  0.487377f,  0.018612f, -0.333184f, -0.111265f,
    0.246472f, -0.271607f,  0.257065f, -0.081791f,  0.199416f,  0.219203f,  0.313951f,
    0.045195f,  0.117777f,  0.142695f, -0.044409f, -0.247002f, -0.396951f,  0.472230f,
    0.087578f, -0.491485f,  0.250130f, -0.328681f, -0.334702f,  0.167408f, -0.150761f,
    -0.410305f,  0.366485f,  0.099119f, -0.380594f,  0.099458f, -0.142221f, -0.285247f,
    -0.354565f,  0.188775f,  0.317144f, -0.038474f, -0.072028f,  0.324356f,  0.317817f,
    0.201429f,  0.117114f, -0.419478f,  0.335920f, -0.350475f,  0.026406f, -0.468175f,
    0.463253f, -0.219757f,  0.186507f, -0.296749f, -0.207589f,  0.280052f, -0.155094f,
    0.467984f, -0.000377f, -0.165475f,  0.126625f,  0.444137f, -0.058752f,  0.280218f,
    0.295738f,  0.451045f,  0.365294f,  0.060736f, -0.218303f, -0.009586f, -0.164458f,
    0.026340f, -0.480832f, -0.418592f, -0.408240f,  0.072377f,  0.184408f,  0.430672f,
    -0.302831f, -0.020495f, -0.337250f,  0.203091f, -0.471056f, -0.205735f, -0.054186f,
    -0.312918f,  0.477488f, -0.240903f,  0.107430f,  0.045473f, -0.133158f, -0.106212f,
    -0.154425f,  0.001002f,  0.276580f, -0.036107f, -0.316145f, -0.368435f,  0.022470f,
    -0.495456f, -0.491828f, -0.382751f, -0.120039f,  0.449745f, -0.041635f,  0.477489f,
    -0.244906f, -0.462196f, -0.085008f,  0.016440f, -0.081211f,  0.203512f,  0.110564f,
    0.327593f,  0.322865f, -0.051476f, -0.227280f,  0.030143f,  0.062883f, -0.085140f,
    0.272971f,  0.170592f,  0.100444f,  0.425184f,  0.435195f,  0.440200f,  0.215465f,
    -0.159338f,  0.458165f,  0.064336f, -0.160084f,  0.106497f,  0.158929f,  0.211398f,
    -0.105650f, -0.418814f,  0.359926f, -0.139670f,  0.176197f,  0.093105f, -0.038290f,
    0.335814f, -0.143630f, -0.057101f,  0.382321f, -0.236202f, -0.446628f, -0.281367f,
    0.249252f,  0.377481f, -0.449854f,  0.149638f,  0.224247f,  0.291107f,  0.479827f,
    -0.227976f, -0.323416f,  0.197620f,  0.166903f,  0.282060f,  0.226876f, -0.406426f,
    -0.092264f,  0.121888f,  0.418908f,  0.013553f, -0.100183f, -0.025302f,  0.477559f,
    0.305149f, -0.423589f,  0.483592f,  0.140877f, -0.101485f, -0.480519f,  0.080625f,
    0.356137f,  0.041204f,  0.359223f,  0.391158f,  0.473790f,  0.064895f, -0.473631f,
    0.225607f, -0.191776f,  0.426648f,  0.010238f, -0.211467f, -0.263074f, -0.209893f,
    -0.049209f, -0.083153f,  0.134934f,  0.063772f,  0.219409f,  0.038608f, -0.027730f,
    -0.357931f,  0.336586f,  0.145770f,  0.499636f,  0.163749f, -0.445871f, -0.436601f,
    0.101136f, -0.259574f, -0.433053f,  0.230028f, -0.330284f, -0.339572f, -0.309899f,
    -0.224926f,  0.156683f,  0.149975f, -0.030974f, -0.023238f, -0.265049f, -0.498988f,
    0.315992f,  0.435090f,  0.098106f,  0.144357f, -0.431419f,  0.117365f, -0.326013f,
    0.465477f,  0.233959f,  0.087435f, -0.329727f,  0.000946f,  0.456720f,  0.363367f,
    -0.323461f,  0.305035f,  0.472150f, -0.247935f,  0.136840f,  0.191940f, -0.022104f,
    0.363768f,  0.071338f,  0.209687f, -0.324585f, -0.364119f,  0.485385f,  0.322046f,
    -0.148410f,  0.306022f, -0.441570f, -0.384126f, -0.353030f,  0.221136f, -0.120139f,
    -0.070292f,  0.399723f, -0.103947f,  0.199386f,  0.147485f, -0.323606f, -0.275033f,
    -0.281322f,  0.316730f, -0.232359f, -0.022888f,  0.280048f,  0.046922f,  0.208323f,
    -0.411241f, -0.354030f, -0.099799f,  0.398594f,  0.102920f, -0.272130f, -0.202311f,
    0.481392f,  0.352366f,  0.259138f,  0.191012f,  0.049940f, -0.032515f,  0.239506f,
    -0.234092f, -0.001595f, -0.004273f,  0.057466f,  0.394836f,  0.323888f, -0.287881f,
    -0.345787f, -0.404568f,  0.076434f, -0.410774f,  0.384690f, -0.195688f,  0.026419f,
    -0.220381f,  0.394746f, -0.220338f,  0.269465f, -0.115832f, -0.267418f, -0.394739f,
    -0.334944f,  0.166218f, -0.010188f,  0.302936f,  0.156438f,  0.296036f, -0.206832f,
    0.455118f,  0.049540f, -0.366160f, -0.209200f,  0.495311f, -0.156060f, -0.414247f,
    0.073940f,  0.208371f,  0.268972f, -0.311636f,  0.000345f,  0.276796f, -0.454476f,
    0.427910f, -0.276567f,  0.461640f,  0.284843f, -0.096015f,  0.041467f, -0.219435f,
    -0.231432f, -0.029965f,  0.453785f,  0.170138f,  0.001439f,  0.479464f,  0.113375f,
    -0.060577f, -0.035207f,  0.433194f,  0.092429f,  0.447603f, -0.046590f, -0.251059f,
    -0.496334f, -0.004267f, -0.018026f, -0.218198f,  0.346797f, -0.196599f, -0.315122f,
    -0.261830f, -0.143461f,  0.052305f,  0.292117f,  0.499299f, -0.176055f,  0.493329f,
    0.485285f, -0.243562f,  0.132770f, -0.279857f, -0.234717f, -0.453635f,  0.211253f,
    0.364785f,  0.394226f,  0.445092f,  0.439585f, -0.361249f, -0.291544f, -0.350325f,
    -0.205131f, -0.437723f,  0.290868f, -0.334472f,  0.257182f,  0.145615f, -0.004713f,
    0.171692f,  0.169319f, -0.274104f,  0.443090f,  0.102637f, -0.156437f, -0.346249f,
    0.375250f, -0.054177f,  0.074717f, -0.136815f,  0.107330f,  0.484138f, -0.239554f,
    0.359641f,  0.469685f, -0.373726f, -0.212737f, -0.096042f, -0.357826f, -0.128119f,
    -0.469574f, -0.251356f, -0.462600f,  0.298248f,  0.384224f,  0.057985f,  0.127060f,
    -0.431888f,  0.409172f, -0.009068f, -0.176053f,  0.321652f, -0.493640f,  0.487034f,
    -0.337986f, -0.202119f,  0.136346f, -0.271791f,  0.196390f, -0.359716f, -0.051245f,
    0.475630f,  0.365197f,  0.478144f,  0.315053f, -0.060013f, -0.190682f,  0.078499f,
    -0.474728f,  0.239000f, -0.417942f,  0.064833f, -0.237993f, -0.452127f, -0.251940f,
    0.468657f,  0.172355f, -0.258002f, -0.026735f, -0.318987f, -0.230742f,  0.167342f,
    -0.048502f, -0.194839f,  0.184690f,  0.419428f, -0.041889f,  0.472484f, -0.276834f,
    -0.051336f,  0.229574f,  0.004734f, -0.191822f,  0.486036f,  0.455939f,  0.411524f,
    -0.062515f, -0.237853f, -0.140470f,  0.267572f,  0.155015f, -0.396480f, -0.009811f,
    -0.424798f, -0.125235f,  0.077583f,  0.070112f,  0.480332f, -0.448891f,  0.032287f,
    -0.002009f,  0.261554f,  0.153946f, -0.236256f, -0.295572f, -0.420557f, -0.022140f,
    0.037269f, -0.377195f,  0.175107f, -0.128135f, -0.308958f,  0.489817f,  0.302010f,
    0.228342f,  0.239965f,  0.358423f,  0.312629f, -0.197425f,  0.458881f, -0.362926f,
    0.291635f, -0.237852f, -0.187012f, -0.340284f,  0.110681f, -0.019302f, -0.210972f,
    -0.058476f,  0.097750f,  0.013705f, -0.101271f,  0.038842f, -0.121589f,  0.023738f,
    0.127238f,  0.164918f,  0.209619f,  0.085604f,  0.400369f,  0.225177f, -0.467752f,
    0.303099f, -0.222350f,  0.239810f, -0.100077f,  0.341502f,  0.341316f, -0.316910f,
    0.173525f, -0.265278f,  0.457909f, -0.242994f,  0.317927f,  0.402405f,  0.318231f,
    0.153708f,  0.105745f, -0.472374f, -0.492282f,  0.271892f, -0.031543f,  0.445666f,
    0.183193f, -0.084829f,  0.475121f, -0.297715f,  0.109495f,  0.196878f,  0.440515f,
    -0.492228f, -0.017891f,  0.140435f, -0.163828f, -0.429383f, -0.212977f,  0.434899f,
    0.008107f, -0.300001f,  0.349372f,  0.072501f, -0.406425f, -0.344444f,  0.136482f,
    0.452854f, -0.484084f, -0.139699f,  0.012838f, -0.265986f,  0.452150f, -0.279508f,
    0.213962f,  0.194061f, -0.216263f,  0.185272f, -0.201445f, -0.458485f, -0.281254f,
    -0.322443f,  0.254530f,  0.085254f, -0.383874f, -0.187210f, -0.458703f, -0.495827f,
    -0.457022f,  0.148571f,  0.430171f,  0.406339f,  0.387519f,  0.158983f, -0.395236f,
    -0.347338f, -0.041818f,  0.363631f,  0.167362f,  0.460071f,  0.088092f,  0.052363f,
    0.294465f, -0.034085f, -0.110409f, -0.100317f,  0.139822f,  0.304021f, -0.338051f,
    0.353542f,  0.306605f,  0.341812f,  0.133692f,  0.485060f,  0.427884f,  0.288628f,
    0.446738f, -0.199341f,  0.497934f,  0.092401f, -0.319156f, -0.274141f,  0.493238f,
    0.282836f, -0.467398f,  0.278664f, -0.315667f,  0.035125f, -0.347314f,  0.146150f,
    -0.443794f,  0.262770f, -0.101585f, -0.425118f, -0.119942f,  0.498544f, -0.443491f,
    0.376388f, -0.317520f, -0.110913f,  0.254512f, -0.046241f,  0.374864f,  0.464391f,
    -0.479315f, -0.326931f,  0.387212f, -0.194913f, -0.376301f, -0.439525f,  0.312876f,
    -0.372637f, -0.331593f,  0.207500f, -0.153431f, -0.349633f, -0.173900f, -0.253905f,
    -0.015100f,  0.369882f, -0.188582f, -0.277282f, -0.129650f,  0.203741f,  0.198422f,
    -0.103788f, -0.125029f, -0.478904f,  0.201063f,  0.224990f, -0.366004f, -0.355640f,
    0.074548f,  0.240514f, -0.387690f,  0.297756f,  0.160902f,  0.349908f, -0.205726f,
    -0.348615f, -0.218139f,  0.422490f,  0.371419f,  0.009139f,  0.043314f, -0.076967f,
    0.020174f, -0.049718f,  0.166527f,  0.316488f, -0.064057f, -0.050974f,  0.101912f,
    0.021136f,  0.159016f, -0.042253f, -0.049015f, -0.306410f, -0.404005f,  0.394814f,
    -0.447748f, -0.467515f,  0.227489f,  0.377471f, -0.451815f, -0.141711f,  0.284007f,
    -0.212858f,  0.305259f, -0.186757f,  0.168336f, -0.044623f,  0.309660f,  0.304702f,
    -0.129228f, -0.026983f, -0.399075f, -0.458042f, -0.154390f,  0.115685f, -0.431701f,
    -0.225940f,  0.341184f, -0.138794f,  0.044267f,  0.285214f,  0.064905f, -0.131896f,
    0.251730f, -0.165512f, -0.351707f, -0.039237f,  0.351197f, -0.395067f,  0.499710f,
    0.201604f,  0.288509f,  0.249567f,  0.404641f,  0.051857f,  0.448861f, -0.238572f,
    0.280977f,  0.161738f, -0.493133f, -0.046034f,  0.211449f, -0.327338f,  0.443170f,
    0.196204f, -0.335742f, -0.053897f,  0.234517f,  0.412408f,  0.349073f,  0.196855f,
    0.365676f,  0.014622f, -0.372787f, -0.353464f,  0.348110f, -0.497501f, -0.243758f,
    0.023376f, -0.457422f, -0.369061f,  0.470033f, -0.283200f,  0.092182f, -0.167526f,
    -0.289036f, -0.196601f, -0.109407f, -0.413141f,  0.492300f, -0.149031f, -0.410013f,
    -0.418345f,  0.392565f, -0.310950f,  0.437563f,  0.309621f, -0.397981f, -0.279574f,
    -0.397596f, -0.465580f, -0.447812f,  0.304202f, -0.109901f,  0.236772f,  0.276042f,
    -0.063677f, -0.243865f, -0.032246f, -0.151820f, -0.490209f,  0.126225f,  0.302170f,
    -0.364157f, -0.320457f,  0.158705f,  0.447957f,  0.013142f,  0.064364f,  0.077887f,
    0.251378f, -0.471450f, -0.328331f,  0.045319f,  0.393835f, -0.088969f, -0.034806f,
    -0.413625f, -0.365486f,  0.410400f, -0.451862f, -0.138590f,  0.471714f, -0.284466f,
    -0.403933f,  0.463102f, -0.389270f, -0.481777f,  0.238717f, -0.025242f, -0.498130f,
    -0.104942f, -0.195038f,  0.168869f, -0.109102f,  0.284335f, -0.339369f,  0.032347f,
    -0.423516f,  0.425010f, -0.311874f,  0.236630f,  0.243699f,  0.201140f, -0.113893f,
    -0.170332f, -0.484022f, -0.335334f,  0.166648f, -0.194039f, -0.004795f,  0.374023f,
    -0.041178f,  0.443957f, -0.376393f, -0.366246f,  0.407432f,  0.411847f, -0.136839f,
    -0.185454f, -0.297351f,  0.297917f, -0.062572f,  0.003002f, -0.237448f,  0.476047f,
    0.284578f,  0.120720f,  0.191318f, -0.233273f, -0.175714f, -0.026766f,  0.179304f,
    -0.213768f,  0.118868f, -0.432921f,  0.029058f, -0.081283f, -0.187787f,  0.359206f,
    -0.032205f, -0.383758f,  0.238621f, -0.215473f,  0.229952f, -0.011146f,  0.015620f,
    -0.382760f,  0.403801f,  0.040240f,  0.056299f,  0.148388f,  0.277709f,  0.224234f,
    0.371980f,  0.259778f, -0.108385f,  0.424164f,  0.477455f, -0.287167f, -0.102249f,
    -0.187954f,  0.179121f,  0.085377f,  0.315007f,  0.039857f,  0.119751f,  0.030813f,
    0.179936f, -0.296949f,  0.099092f, -0.080772f, -0.236092f,  0.240350f, -0.108079f,
    0.480886f, -0.047039f,  0.277359f, -0.122488f,  0.107159f,  0.040333f, -0.340766f,
    0.187962f, -0.214238f, -0.269580f, -0.035633f, -0.483402f, -0.164836f,  0.219046f,
    0.452710f,  0.019202f,  0.252153f,  0.123677f,  0.124987f, -0.464426f,  0.456876f,
    0.066862f, -0.310198f,  0.380557f, -0.112533f,  0.348193f, -0.268155f,  0.253907f,
    0.402970f,  0.309003f, -0.385585f,  0.027147f, -0.043875f,  0.337597f, -0.358096f,
    -0.259162f, -0.080626f, -0.428235f, -0.347709f, -0.376422f, -0.273247f,  0.023777f,
    -0.453974f,  0.188936f, -0.164770f,  0.327825f, -0.283365f, -0.079411f,  0.131222f,
    -0.458563f,  0.001263f, -0.010113f, -0.203082f,  0.323826f, -0.421964f,  0.212394f,
    -0.192508f,  0.472012f,  0.304198f, -0.282482f, -0.078936f, -0.220534f, -0.192473f,
    -0.167086f, -0.469549f, -0.245452f,  0.347470f, -0.443944f, -0.382718f,  0.113106f,
    0.075999f, -0.139736f,  0.348383f, -0.439920f,  0.016637f,  0.450845f,  0.410520f,
    0.071033f,  0.398882f, -0.483809f, -0.162521f,  0.251239f,  0.130821f,  0.404321f,
    -0.046769f, -0.084230f,  0.251894f, -0.029153f, -0.237273f, -0.469725f,  0.408128f,
    -0.108267f,  0.059179f, -0.236539f,  0.351839f,  0.393123f,  0.090779f,  0.016367f,
    0.445624f,  0.329143f, -0.486450f,  0.251121f,  0.295840f,  0.122920f, -0.261143f,
    -0.212959f,  0.243664f, -0.109503f, -0.381854f,  0.461656f,  0.183068f, -0.215888f,
    -0.336508f, -0.131288f,  0.375706f, -0.258948f, -0.084228f,  0.437856f, -0.195073f,
    0.005601f, -0.106146f,  0.267811f, -0.492769f, -0.068801f,  0.304557f, -0.323871f,
    -0.017168f,  0.172712f, -0.103323f, -0.103341f, -0.398791f, -0.222238f, -0.199235f,
    -0.293408f,  0.157124f,  0.292360f,  0.223239f, -0.332822f, -0.187407f, -0.450938f,
    -0.462216f,  0.238166f,  0.386332f, -0.377245f, -0.266400f,  0.100744f, -0.229416f,
    -0.334413f,  0.199330f,  0.375684f, -0.497088f,  0.192080f, -0.180729f,  0.033930f,
    -0.325021f,  0.429839f, -0.023529f,  0.100552f,  0.289741f, -0.289566f, -0.047291f,
    0.387562f,  0.391691f, -0.493054f,  0.310980f, -0.452638f,  0.191073f, -0.334523f,
    -0.419481f, -0.489517f, -0.477434f, -0.008104f,  0.141579f, -0.394115f,  0.252334f,
    -0.415386f, -0.153035f,  0.309600f,  0.245909f, -0.080270f,  0.105028f,  0.031232f,
    -0.304986f, -0.454868f, -0.114635f,  0.234234f, -0.423310f, -0.498185f,  0.160576f,
    -0.445487f, -0.223876f,  0.018668f,  0.447182f,  0.195502f, -0.420840f,  0.204323f,
    0.404177f,  0.452158f,  0.356061f,  0.047437f,  0.452089f, -0.329621f, -0.020331f,
    0.024276f,  0.417951f, -0.345873f, -0.095595f, -0.432899f, -0.362979f, -0.434683f,
    -0.426240f, -0.035943f,  0.360736f, -0.250433f, -0.489897f,  0.414732f, -0.141805f,
    -0.104287f, -0.200850f, -0.242979f,  0.147176f,  0.183031f, -0.169394f,  0.190262f,
    -0.242689f, -0.024763f, -0.145006f,  0.354865f,  0.485633f, -0.474800f, -0.185988f,
    -0.324099f,  0.441632f, -0.397046f, -0.212110f, -0.448342f,  0.249315f, -0.050870f,
    0.458868f, -0.039594f, -0.452661f, -0.313612f,  0.036329f,  0.389944f, -0.359613f,
    -0.053656f, -0.161767f, -0.236273f, -0.443426f, -0.154882f,  0.027882f, -0.328891f,
    -0.126610f, -0.123328f,  0.107758f, -0.287593f, -0.479224f, -0.197827f, -0.442830f,
    -0.024826f, -0.347817f,  0.161581f,  0.241956f,  0.477280f,  0.406406f, -0.210526f,
    -0.162286f,  0.084467f, -0.456298f, -0.197243f, -0.201502f, -0.247617f,  0.123890f,
    -0.231278f,  0.317060f, -0.398890f,  0.462205f,  0.436078f,  0.097275f,  0.027607f,
    -0.073429f,  0.000618f, -0.427912f, -0.149953f, -0.130770f,  0.315657f, -0.180848f,
    -0.012463f,  0.273697f,  0.382968f, -0.139763f, -0.132705f, -0.032595f,  0.463445f,
    0.178738f,  0.155029f,  0.439947f,  0.022184f,  0.192390f,  0.387421f,  0.120288f,
    -0.283013f, -0.493851f,  0.090471f,  0.123721f, -0.297116f,  0.114453f,  0.264700f,
    -0.034170f, -0.438789f,  0.284700f,  0.056306f,  0.057400f,  0.276739f, -0.262770f,
    -0.310795f,  0.207582f,  0.439731f,  0.434560f, -0.438728f,  0.155005f, -0.495586f,
    -0.062051f, -0.107938f, -0.134301f, -0.293072f, -0.093119f, -0.390041f,  0.046167f,
    -0.446617f,  0.071846f, -0.226614f, -0.151172f, -0.495813f,  0.458536f, -0.199354f,
    -0.059966f,  0.179622f, -0.021481f,  0.031895f,  0.068357f, -0.378053f, -0.185470f,
    -0.361963f, -0.361264f, -0.397416f, -0.454717f, -0.073025f, -0.041909f, -0.156170f,
    0.293310f, -0.442622f,  0.177231f,  0.220603f, -0.401459f, -0.238025f,  0.185279f,
    0.359893f,  0.369615f,  0.192590f,  0.004866f, -0.392213f,  0.434262f, -0.458242f,
    -0.457004f, -0.416842f, -0.419830f,  0.363403f, -0.156329f, -0.316329f, -0.130105f,
    0.028056f,  0.499278f,  0.106873f, -0.360566f,  0.105158f,  0.359419f, -0.446672f,
    0.302629f, -0.407074f, -0.355038f, -0.400480f, -0.374194f, -0.180230f, -0.436312f,
    0.278371f, -0.107323f, -0.146388f,  0.330066f,  0.150440f, -0.376947f,  0.287530f,
    0.428645f, -0.241832f, -0.344697f,  0.061381f,  0.107635f, -0.049025f,  0.257450f,
    -0.153228f, -0.458995f, -0.024164f, -0.058393f, -0.387604f,  0.214332f,  0.224363f,
    0.157988f, -0.477930f, -0.252420f,  0.095005f, -0.484378f, -0.149523f,  0.208651f,
    0.002219f,  0.485195f,  0.261538f, -0.347929f,  0.281025f,  0.194043f, -0.460436f,
    0.060491f, -0.313798f,  0.323524f, -0.270110f, -0.488772f, -0.335727f, -0.195000f,
    -0.002006f,  0.439909f,  0.330590f, -0.087083f,  0.296357f, -0.451761f, -0.436633f,
    0.043502f, -0.092811f, -0.311742f,  0.234763f,  0.407087f, -0.044857f, -0.047842f,
    -0.057431f, -0.346205f,  0.234119f, -0.028517f, -0.255796f,  0.089198f, -0.078987f,
    -0.135545f,  0.090352f,  0.252602f, -0.460093f,  0.413206f,  0.124416f, -0.249932f,
    -0.446273f,  0.467193f, -0.324965f,  0.022296f,  0.186212f, -0.415637f, -0.005763f,
    0.239654f,  0.082423f, -0.117889f, -0.341403f,  0.449323f, -0.403496f, -0.413540f,
    0.083354f,  0.039514f,  0.324675f, -0.034163f,  0.031236f,  0.260737f, -0.218847f,
    0.107152f,  0.013395f,  0.072088f,  0.224852f,  0.243707f, -0.033092f, -0.279500f,
    -0.206793f,  0.249693f,  0.392781f, -0.137919f, -0.427484f,  0.163101f, -0.205950f,
    0.487243f, -0.353969f, -0.358110f, -0.237399f, -0.404149f, -0.296008f, -0.432997f,
    0.125883f,  0.306451f,  0.494473f,  0.315569f, -0.165901f, -0.413333f,  0.338883f,
    -0.210620f, -0.398886f, -0.087385f, -0.442029f,  0.114153f,  0.017921f,  0.146838f,
    -0.041831f,  0.056291f, -0.051414f, -0.349360f,  0.347049f, -0.066209f,  0.461094f,
    -0.107878f,  0.291659f, -0.059960f, -0.491652f,  0.490858f,  0.243875f, -0.067400f,
    -0.320221f,  0.059520f, -0.450010f,  0.458460f, -0.083191f,  0.308297f,  0.383089f,
    -0.047078f,  0.404171f, -0.493557f,  0.009927f,  0.037372f,  0.395103f, -0.475640f,
    0.080858f, -0.206902f,  0.436469f, -0.322590f,  0.441681f, -0.038501f, -0.032527f,
    0.467891f, -0.231894f, -0.361882f,  0.163668f, -0.026131f, -0.346977f,  0.127569f,
    -0.019563f,  0.102632f,  0.498163f, -0.087395f, -0.135983f, -0.356625f,  0.117414f,
    -0.116890f,  0.493682f,  0.089354f, -0.380459f,  0.054941f,  0.099263f, -0.483730f,
    0.251959f,  0.485373f,  0.470088f, -0.496496f,  0.131333f,  0.227952f,  0.294411f,
    -0.338791f,  0.415902f,  0.247068f,  0.204978f, -0.087020f, -0.428268f, -0.220594f,
    0.072533f,  0.305241f,  0.111506f, -0.250928f,  0.103633f, -0.064301f,  0.029419f,
    0.344695f,  0.034231f,  0.169855f,  0.186535f, -0.405002f, -0.258694f, -0.157102f,
    0.013068f
};

/**
 * Immediately after the random number table,
 * some "poison" floating point numbers,
 * intended to cause noticeable difficulties if these are used.
 */
float	bn_rand_poison_[] = {
    9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f,
    9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f,
    9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f,
    9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f, 9e20f
};

void
bn_mathtab_constant(void)
{
    register int i;

    for ( i = (sizeof(bn_rand_halftab)/sizeof(bn_rand_halftab[0]))-1; i >= 0; i-- )
	bn_rand_halftab[i] = 0.0;
}

/** @} */
/*
 * Local Variables:
 * mode: C
 * tab-width: 8
 * indent-tabs-mode: t
 * c-file-style: "stroustrup"
 * End:
 * ex: shiftwidth=4 tabstop=8
 */
