/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.NetClient;

class TCPClient
extends NetClient {
    private Socket tcpSocket = new Socket();
    private BufferedOutputStream out;
    private BufferedInputStream in;

    TCPClient(String string, int n, int n2) throws IOException {
        this.tcpSocket.connect(new InetSocketAddress(string, n), n2);
        this.out = new BufferedOutputStream(this.tcpSocket.getOutputStream());
        this.in = new BufferedInputStream(this.tcpSocket.getInputStream());
        this.tcpSocket.setSoTimeout(n2);
    }

    public void send(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[4];
        TCPClient.intToNetworkByteOrder(byArray.length, byArray2, 0, 4);
        this.out.write(byArray2);
        this.out.write(byArray);
        this.out.flush();
    }

    public byte[] receive() throws IOException {
        byte[] byArray = new byte[4];
        int n = this.readFully(byArray, 4);
        if (n != 4) {
            if (Krb5.DEBUG) {
                System.out.println(">>>DEBUG: TCPClient could not read length field");
            }
            return null;
        }
        int n2 = TCPClient.networkByteOrderToInt(byArray, 0, 4);
        if (Krb5.DEBUG) {
            System.out.println(">>>DEBUG: TCPClient reading " + n2 + " bytes");
        }
        if (n2 <= 0) {
            if (Krb5.DEBUG) {
                System.out.println(">>>DEBUG: TCPClient zero or negative length field: " + n2);
            }
            return null;
        }
        byte[] byArray2 = new byte[n2];
        n = this.readFully(byArray2, n2);
        if (n != n2) {
            if (Krb5.DEBUG) {
                System.out.println(">>>DEBUG: TCPClient could not read complete packet (" + n2 + "/" + n + ")");
            }
            return null;
        }
        return byArray2;
    }

    public void close() throws IOException {
        this.tcpSocket.close();
    }

    private int readFully(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            int n3 = this.in.read(byArray, n2, n);
            if (n3 == -1) {
                return n2 == 0 ? -1 : n2;
            }
            n2 += n3;
            n -= n3;
        }
        return n2;
    }

    private static int networkByteOrderToInt(byte[] byArray, int n, int n2) {
        if (n2 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 8;
            n3 |= byArray[n + i] & 0xFF;
        }
        return n3;
    }

    private static void intToNetworkByteOrder(int n, byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = n3 - 1; i >= 0; --i) {
            byArray[n2 + i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
    }
}

