/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.alchemy.core.AlcAbstractToolBar;
import org.alchemy.core.AlcCanvas;
import org.alchemy.core.AlcColorSelector;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcMath;
import org.alchemy.core.AlcMenuBar;
import org.alchemy.core.AlcPalette;
import org.alchemy.core.AlcPlugins;
import org.alchemy.core.AlcPreferences;
import org.alchemy.core.AlcSession;
import org.alchemy.core.AlcShortcuts;
import org.alchemy.core.AlcSimpleToolBar;
import org.alchemy.core.AlcToolBar;
import org.alchemy.core.AlcWindow;

public class Alchemy
implements AlcConstants {
    public static int OS;
    public static boolean OS_IS_VISTA;
    public static String KEY_MODIFIER_STRING;
    public static String KEY_SHIFT_STRING;
    public static String KEY_ALT_STRING;
    static AlcWindow window;
    static AlcCanvas canvas;
    static AlcAbstractToolBar toolBar;
    static AlcPlugins plugins;
    static AlcPalette palette;
    static AlcMenuBar menuBar;
    static AlcPreferences preferences;
    static AlcShortcuts shortcuts;
    static AlcSession session;
    static ResourceBundle bundle;
    static ResourceBundle bundleEn;
    static final AlcMath math;
    static AlcColorSelector colorSelector;

    Alchemy() {
        if (OS == 2) {
            Object appIcon = LookAndFeel.makeIcon(this.getClass(), "/org/alchemy/data/alchemy-logo64.png");
            UIManager.put("OptionPane.errorIcon", appIcon);
            UIManager.put("OptionPane.informationIcon", appIcon);
            UIManager.put("OptionPane.questionIcon", appIcon);
            UIManager.put("OptionPane.warningIcon", appIcon);
        }
        try {
            bundleEn = ResourceBundle.getBundle("org/alchemy/core/AlcResourceBundle", new Locale("en"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            bundleEn = ResourceBundle.getBundle("org/alchemy/core/AlcResourceBundle");
        }
        try {
            bundle = LOCALE.getLanguage().equals("zh") && LOCALE.getCountry().equals("HK") ? ResourceBundle.getBundle("org/alchemy/core/AlcResourceBundle", new Locale("zh", "TW")) : ResourceBundle.getBundle("org/alchemy/core/AlcResourceBundle", LOCALE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            bundle = bundleEn;
        }
        preferences = new AlcPreferences();
        window = new AlcWindow();
        UIManager.put("FileChooser.cancelButtonText", bundle.getString("cancel"));
        UIManager.put("FileChooser.newFolderButtonText", bundle.getString("newFolder"));
        UIManager.put("FileChooser.openButtonText", bundle.getString("open"));
        UIManager.put("FileChooser.openDialogTitleText", bundle.getString("open"));
        UIManager.put("FileChooser.saveDialogTitleText", bundle.getString("save"));
        UIManager.put("OptionPane.yesButtonText", bundle.getString("yes"));
        UIManager.put("OptionPane.noButtonText", bundle.getString("no"));
        UIManager.put("OptionPane.okButtonText", bundle.getString("ok"));
        UIManager.put("OptionPane.cancelButtonText", bundle.getString("cancel"));
        shortcuts = new AlcShortcuts(window);
        colorSelector = new AlcColorSelector(bundle.getString("colorTitle"));
        plugins = new AlcPlugins();
        System.out.println("Number of Plugins: " + plugins.getNumberOfPlugins());
        canvas = new AlcCanvas();
        session = new AlcSession();
        palette = new AlcPalette(window);
        toolBar = Alchemy.preferences.simpleToolBar ? new AlcSimpleToolBar() : new AlcToolBar();
        menuBar = new AlcMenuBar();
        window.setupWindow();
        shortcuts.setupWindow();
        preferences.setupWindow();
        plugins.initialiseModules();
        if (Alchemy.preferences.simpleToolBar) {
            window.setFullscreen(true);
            Alchemy.menuBar.fullScreenItem.setSelected(true);
        }
        window.setVisible(true);
        System.out.println("Java Version: " + JAVA_VERSION_NAME);
        System.out.println("Platform: " + OS_NAME);
        System.out.println("OS Version: " + System.getProperty("os.version"));
        System.out.println("Architecture: " + System.getProperty("os.arch"));
        System.out.println("Language: " + LOCALE.getLanguage());
        System.out.println("Country: " + LOCALE.getCountry());
    }

    public static void main(String[] args) {
        try {
            if (OS == 2) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                String css = "<head><style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style></head>";
                UIManager.put("OptionPane.css", css);
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Alchemy();
    }

    static {
        OS_IS_VISTA = false;
        KEY_MODIFIER_STRING = "Ctrl";
        KEY_SHIFT_STRING = "Shift";
        KEY_ALT_STRING = "Alt";
        if (OS_NAME.indexOf("Mac") != -1) {
            OS = 2;
            KEY_MODIFIER_STRING = "?";
            KEY_SHIFT_STRING = "?";
            KEY_ALT_STRING = "?";
        } else if (OS_NAME.indexOf("Windows") != -1) {
            OS = 1;
            if (OS_NAME.indexOf("Vista") != -1) {
                OS_IS_VISTA = true;
            }
        } else {
            OS = OS_NAME.equals("Linux") ? 3 : 0;
        }
        math = new AlcMath();
    }
}

