/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import org.alchemy.core.AlcAbout;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcNative;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;
import org.alchemy.core.OSXAdapter;

class AlcWindow
extends JFrame
implements AlcConstants,
WindowListener,
ComponentListener,
KeyListener,
ClipboardOwner {
    private boolean fullscreen = false;
    private Rectangle oldBounds = null;
    private boolean windowDisposed = false;
    private boolean finishTransparentFullscreen = false;
    private GraphicsDevice finishDevice = null;
    private Rectangle finishBounds = null;
    private static Dimension windowSize = null;
    private static final Dimension minWindowSize = new Dimension(640, 400);

    AlcWindow() {
        super("OSXAdapter");
        this.registerForMacOSXEvents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AlcWindow.this.exitAlchemy();
            }
        });
        this.addComponentListener(this);
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.setTitle("Alchemy");
        this.setDefaultCloseOperation(0);
        GraphicsConfiguration grapConfig = this.getGraphicsConfiguration();
        Dimension currentWindowSize = grapConfig.getBounds().getSize();
        boolean windowSet = false;
        if (Alchemy.preferences.canvasSize != null) {
            Dimension savedWindowSize = new Dimension(Alchemy.preferences.canvasSize.width, Alchemy.preferences.canvasSize.height);
            if (savedWindowSize.width <= currentWindowSize.width && savedWindowSize.height <= currentWindowSize.height && savedWindowSize.width >= AlcWindow.minWindowSize.width && savedWindowSize.height >= AlcWindow.minWindowSize.width) {
                windowSize = savedWindowSize;
                windowSet = true;
            }
        }
        if (!windowSet) {
            windowSize = currentWindowSize.width < 1000 ? new Dimension(800, 500) : new Dimension(1024, 640);
        }
    }

    void setupWindow() {
        if (Alchemy.OS == 2) {
            this.setJMenuBar(Alchemy.menuBar);
        } else if (Alchemy.preferences.paletteAttached || Alchemy.preferences.simpleToolBar) {
            this.setJMenuBar(Alchemy.menuBar);
        } else {
            Alchemy.toolBar.add("North", Alchemy.menuBar);
            Alchemy.toolBar.calculateTotalHeight();
        }
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.add((Component)Alchemy.canvas, new Integer(1));
        layeredPane.add((Component)Alchemy.toolBar, new Integer(2));
        layeredPane.setPreferredSize(windowSize);
        this.setContentPane(layeredPane);
        this.pack();
        if (Alchemy.OS != 2) {
            this.setFrameIconImage();
        }
        if (Alchemy.preferences.canvasLocation != null) {
            boolean onscreen = this.checkOnscreen(Alchemy.preferences.canvasLocation);
            if (onscreen) {
                this.setLocation(Alchemy.preferences.canvasLocation);
            } else {
                this.setLocationRelativeTo(null);
            }
        } else {
            this.setLocationRelativeTo(null);
        }
        if (!Alchemy.preferences.simpleToolBar && Alchemy.preferences.paletteAttached) {
            this.setPalette(true);
        } else {
            this.requestFocus();
        }
    }

    Dimension getWindowSize() {
        return windowSize;
    }

    private void resizeWindow() {
        this.setSize(Math.max(AlcWindow.minWindowSize.width, this.getWidth()), Math.max(AlcWindow.minWindowSize.height, this.getHeight()));
        windowSize = this.getSize();
        Alchemy.toolBar.resizeToolBar(windowSize);
        Alchemy.canvas.resizeCanvas(windowSize);
    }

    void setFullscreen(boolean fullscreen) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsConfiguration grapConfig = this.getGraphicsConfiguration();
        Rectangle bounds = grapConfig.getBounds();
        int currentDevice = 0;
        if (this.fullscreen != fullscreen) {
            this.fullscreen = fullscreen;
            if (!fullscreen) {
                if (Alchemy.preferences.transparentFullscreen) {
                    Alchemy.canvas.setTransparentImage(null);
                    Alchemy.canvas.redraw();
                }
                this.setVisible(false);
                this.dispose();
                this.setUndecorated(false);
                this.setFocusable(true);
                this.setBounds(this.oldBounds);
                if (Alchemy.OS == 2 && bounds.x == 0 && bounds.y == 0) {
                    AlcNative.setMenubarVisible(true);
                }
                this.setVisible(true);
                this.toFront();
            } else {
                this.oldBounds = this.getBounds();
                try {
                    if (devices.length > 1) {
                        for (int i = 0; i < devices.length; ++i) {
                            Rectangle screenBounds = devices[i].getDefaultConfiguration().getBounds();
                            if (!screenBounds.equals(bounds)) continue;
                            currentDevice = i;
                        }
                    }
                    this.setVisible(false);
                    this.dispose();
                    if (Alchemy.OS == 2 && bounds.x == 0 && bounds.y == 0) {
                        AlcNative.setMenubarVisible(false);
                    }
                    if (Alchemy.preferences.transparentFullscreen) {
                        if (!this.windowDisposed) {
                            this.finishDevice = devices[currentDevice];
                            this.finishBounds = bounds;
                            this.finishTransparentFullscreen = true;
                            return;
                        }
                        this.captureTransparentScreen(devices[currentDevice], bounds);
                    }
                    this.setUndecorated(true);
                    this.setBounds(bounds);
                    this.setVisible(true);
                    if (Alchemy.preferences.paletteAttached) {
                        Alchemy.palette.toFront();
                    }
                    this.toFront();
                }
                catch (Exception e) {
                    System.err.println("Error Entering Fullscreen");
                    e.printStackTrace();
                }
            }
            this.repaint();
        }
    }

    boolean isFullscreen() {
        return this.fullscreen;
    }

    boolean isTransparent() {
        return Alchemy.preferences.transparentFullscreen;
    }

    void setTransparent(boolean transparent) {
        Alchemy.preferences.transparentFullscreen = transparent;
    }

    private void finishTransparentFullscreen() {
        this.captureTransparentScreen(this.finishDevice, this.finishBounds);
        this.setUndecorated(true);
        this.setBounds(this.finishBounds);
        this.setVisible(true);
        if (Alchemy.preferences.paletteAttached) {
            Alchemy.palette.toFront();
        }
        this.toFront();
        this.repaint();
        this.finishTransparentFullscreen = false;
    }

    private void captureTransparentScreen(GraphicsDevice device, Rectangle bounds) {
        try {
            Robot robot = null;
            robot = device != null ? new Robot(device) : new Robot();
            Rectangle newBounds = new Rectangle(0, 0, bounds.width, bounds.height);
            BufferedImage screenCapture = null;
            try {
                screenCapture = robot.createScreenCapture(newBounds);
            }
            catch (IllegalArgumentException ex) {
                screenCapture = robot.createScreenCapture(bounds);
                ex.printStackTrace();
            }
            Alchemy.canvas.setTransparentImage(screenCapture);
            Alchemy.canvas.updateCanvasImage(true);
            Alchemy.canvas.repaint();
        }
        catch (Exception e) {
            System.err.println("Error Entering Fullscreen");
            e.printStackTrace();
        }
    }

    private boolean checkOnscreen(Point location) {
        boolean onscreen = false;
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            Rectangle screenBounds = devices[i].getDefaultConfiguration().getBounds();
            if (!screenBounds.contains(location)) continue;
            onscreen = true;
        }
        return onscreen;
    }

    private void setFrameIconImage() {
        Insets insets = this.getInsets();
        int titleBarHeight = insets.top;
        if (titleBarHeight == 32) {
            Image titleIcon26 = AlcUtil.getImage("alchemy-logo26.png");
            if (titleIcon26 != null) {
                this.setIconImage(titleIcon26);
            }
        } else {
            Image titleIcon20 = AlcUtil.getImage("alchemy-logo20.png");
            if (titleIcon20 != null) {
                this.setIconImage(titleIcon20);
            }
        }
    }

    void setPalette(boolean seperate) {
        if (seperate) {
            if (!Alchemy.preferences.paletteAttached) {
                Alchemy.toolBar.detachToolBar();
            }
            if (Alchemy.preferences.paletteLocation != null) {
                boolean onscreen = this.checkOnscreen(Alchemy.preferences.paletteLocation);
                if (onscreen) {
                    Alchemy.palette.setLocation(Alchemy.preferences.paletteLocation);
                } else {
                    Alchemy.palette.setLocation(100, 100);
                }
            } else {
                Alchemy.palette.setLocation(100, 100);
            }
            Alchemy.toolBar.addPaletteContent();
            Alchemy.preferences.paletteAttached = true;
            if (Alchemy.OS != 2) {
                this.setJMenuBar(Alchemy.menuBar);
                Alchemy.toolBar.calculateTotalHeight();
            }
            Alchemy.toolBar.toggleDetachButton(false);
            Alchemy.palette.setVisible(true);
            Alchemy.palette.toFront();
            Alchemy.palette.requestFocus();
        } else if (Alchemy.palette != null) {
            Alchemy.preferences.paletteLocation = Alchemy.palette.getLocation();
            Alchemy.palette.setVisible(false);
            Alchemy.preferences.paletteAttached = false;
            Alchemy.canvas.setAutoToggleToolBar(true);
            Alchemy.toolBar.attachToolBar();
        }
    }

    boolean exitAlchemy() {
        if (Alchemy.canvas.shapes.size() > 0) {
            boolean result = AlcUtil.showConfirmDialogFromBundle("exitDialogTitle", "exitDialogMessage", "quitDialogTitle", "quitDialogMessage");
            if (result) {
                this.exit();
                return true;
            }
            return false;
        }
        this.exit();
        return true;
    }

    private void exit() {
        if (!this.isFullscreen()) {
            Alchemy.preferences.canvasLocation = this.getLocation();
            Rectangle visibleRect = Alchemy.canvas.getVisibleRect();
            if (Alchemy.preferences.simpleToolBar) {
                visibleRect.width += Alchemy.toolBar.toolBarWidth;
            }
            Alchemy.preferences.canvasSize = new Dimension(visibleRect.width, visibleRect.height);
        }
        if (!Alchemy.preferences.simpleToolBar && Alchemy.preferences.paletteAttached) {
            Alchemy.preferences.paletteLocation = Alchemy.palette.getLocation();
        }
        if (Alchemy.session.isRecording()) {
            Alchemy.session.setRecording(false);
        }
        Alchemy.preferences.writeChanges();
        this.dispose();
        System.exit(0);
    }

    private void registerForMacOSXEvents() {
        if (Alchemy.OS == 2) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("exitAlchemy", null));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("showAbout", null));
                OSXAdapter.setPreferencesHandler(this, this.getClass().getDeclaredMethod("showPreferences", null));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    void showAbout() {
        new AlcAbout((Window)Alchemy.window);
    }

    void showPreferences() {
        Alchemy.preferences.showWindow();
    }

    public void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 27 && this.isFullscreen()) {
            this.setFullscreen(false);
        }
        if (Alchemy.plugins.currentCreate >= 0) {
            Alchemy.plugins.creates[Alchemy.plugins.currentCreate].keyPressed(event);
        }
        if (Alchemy.plugins.hasCurrentAffects()) {
            for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                if (!Alchemy.plugins.currentAffects[i]) continue;
                Alchemy.plugins.affects[i].keyPressed(event);
            }
        }
    }

    public void keyTyped(KeyEvent event) {
        if (Alchemy.plugins.currentCreate >= 0) {
            Alchemy.plugins.creates[Alchemy.plugins.currentCreate].keyTyped(event);
        }
        if (Alchemy.plugins.hasCurrentAffects()) {
            for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                if (!Alchemy.plugins.currentAffects[i]) continue;
                Alchemy.plugins.affects[i].keyTyped(event);
            }
        }
    }

    public void keyReleased(KeyEvent event) {
        if (Alchemy.plugins.currentCreate >= 0) {
            Alchemy.plugins.creates[Alchemy.plugins.currentCreate].keyReleased(event);
        }
        if (Alchemy.plugins.hasCurrentAffects()) {
            for (int i = 0; i < Alchemy.plugins.currentAffects.length; ++i) {
                if (!Alchemy.plugins.currentAffects[i]) continue;
                Alchemy.plugins.affects[i].keyReleased(event);
            }
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.resizeWindow();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.windowDisposed = true;
        if (this.finishTransparentFullscreen) {
            this.finishTransparentFullscreen();
        }
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
        this.windowDisposed = false;
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

