/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcShortcutInterface;
import org.alchemy.core.AlcShortcuts;
import org.alchemy.core.AlcUtil;

class AlcToggleButton
extends JToggleButton
implements AlcShortcutInterface,
AlcConstants {
    private String toolTip;
    private boolean preferenceButton = false;
    private Color centreTop = new Color(233, 233, 233);
    private Color centreMiddle = new Color(187, 187, 187);
    private Color centreBottom = new Color(197, 197, 197);
    private Color innerMiddle = new Color(170, 170, 170);
    private Color outerMiddle = new Color(133, 133, 133);
    private Image backgroundImage;

    AlcToggleButton() {
    }

    AlcToggleButton(Action action) {
        this.setAction(action);
    }

    AlcToggleButton(URL iconUrl) {
        this.setup(null, null, iconUrl, false);
    }

    AlcToggleButton(String text, String toolTip, URL iconUrl) {
        this.setup(text, toolTip, iconUrl, false);
    }

    AlcToggleButton(String text, String toolTip, URL iconUrl, boolean preferenceButton) {
        this.setup(text, toolTip, iconUrl, preferenceButton);
    }

    void setup(String text, String toolTip, URL iconUrl) {
        this.setup(text, toolTip, iconUrl, false);
    }

    void setup(String text, String toolTip, URL iconUrl, boolean preferenceButton) {
        this.preferenceButton = preferenceButton;
        if (toolTip != null) {
            this.toolTip = toolTip;
        }
        if (iconUrl != null) {
            this.setIcon(AlcUtil.getImageIcon(iconUrl));
            URL rolloverIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-over");
            this.setRolloverIcon(AlcUtil.getImageIcon(rolloverIconUrl));
            if (!preferenceButton) {
                URL selectedIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-on");
                this.setSelectedIcon(AlcUtil.getImageIcon(selectedIconUrl));
            }
            URL rolloverSelectedIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-on-over");
            this.setRolloverSelectedIcon(AlcUtil.getImageIcon(rolloverSelectedIconUrl));
            URL pressedIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-down");
            this.setPressedIcon(AlcUtil.getImageIcon(pressedIconUrl));
        }
        this.setFont(FONT_MEDIUM);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        if (text != null) {
            this.setText(text);
        }
        this.setToolTipText(toolTip);
        this.setMargin(new Insets(0, 0, 0, 0));
        if (preferenceButton) {
            this.setBorder(new EmptyBorder(4, 8, 4, 8));
        } else {
            this.setBorderPainted(false);
        }
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
    }

    public void refreshShortcut(int key, int modifier) {
        this.setToolTipText(AlcShortcuts.getShortcutString(key, modifier, this.toolTip));
    }

    private Image createBackgroundImage() {
        int height = this.getHeight();
        int halfHeight = height / 2;
        int width = this.getWidth() - 3;
        BufferedImage image = new BufferedImage(width + 4, height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.centreTop, 0.0f, halfHeight, this.centreMiddle, true));
        g2.fillRect(2, 0, width, halfHeight);
        g2.setPaint(new GradientPaint(0.0f, halfHeight, this.centreMiddle, 0.0f, height, this.centreBottom, true));
        g2.fillRect(2, halfHeight, width, height);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.centreTop, 0.0f, halfHeight, this.outerMiddle, true));
        g2.fillRect(0, 0, 1, halfHeight);
        g2.setPaint(new GradientPaint(0.0f, halfHeight, this.outerMiddle, 0.0f, height, this.centreBottom, true));
        g2.fillRect(0, halfHeight, 1, height);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.centreTop, 0.0f, halfHeight, this.innerMiddle, true));
        g2.fillRect(1, 0, 1, halfHeight);
        g2.setPaint(new GradientPaint(0.0f, halfHeight, this.innerMiddle, 0.0f, height, this.centreBottom, true));
        g2.fillRect(1, halfHeight, 1, height);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.centreTop, 0.0f, halfHeight, this.innerMiddle, true));
        g2.fillRect(width, 0, 1, halfHeight);
        g2.setPaint(new GradientPaint(0.0f, halfHeight, this.innerMiddle, 0.0f, height, this.centreBottom, true));
        g2.fillRect(width, halfHeight, 1, height);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.centreTop, 0.0f, halfHeight, this.outerMiddle, true));
        g2.fillRect(width + 1, 0, 1, halfHeight);
        g2.setPaint(new GradientPaint(0.0f, halfHeight, this.outerMiddle, 0.0f, height, this.centreBottom, true));
        g2.fillRect(width + 1, halfHeight, 1, height);
        return image;
    }

    protected void paintComponent(Graphics g) {
        if (this.preferenceButton && this.isSelected()) {
            if (this.backgroundImage == null) {
                this.backgroundImage = this.createBackgroundImage();
            }
            g.drawImage(this.backgroundImage, 0, 0, null);
        }
        super.paintComponent(g);
    }
}

