/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Insets;
import java.net.URL;
import javax.swing.JButton;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcUtil;

public class AlcSubButton
extends JButton
implements AlcConstants {
    public AlcSubButton(String text) {
        this.setup(text);
    }

    public AlcSubButton(String text, URL iconUrl) {
        if (iconUrl != null) {
            this.setIcon(AlcUtil.getImageIcon(iconUrl));
            URL rolloverIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-over");
            this.setRolloverIcon(AlcUtil.getImageIcon(rolloverIconUrl));
            URL pressedIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-down");
            this.setPressedIcon(AlcUtil.getImageIcon(pressedIconUrl));
        }
        this.setup(text);
    }

    private void setup(String text) {
        this.setFont(FONT_SMALL);
        this.setText(text);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setIconTextGap(2);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
    }
}

