/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcNumberDialog;
import org.alchemy.core.AlcNumberDialogInterface;
import org.alchemy.core.AlcToolBar;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

public class AlcSpinnerCustom
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
AlcNumberDialogInterface,
AlcConstants {
    int value;
    int dragY;
    int dragValue;
    int min;
    int max;
    int step;
    boolean mouseDown;
    private boolean upPressed = false;
    private boolean downPressed = false;
    private boolean drag = false;
    private final int width;
    private final int height;
    private final int halfHeight;
    private final int textAreaWidth;
    private final int stringY;
    private final FontMetrics metrics;
    private final Font font;
    private final Image spinner;
    private final Image spinnerUp;
    private final Image spinnerDown;
    private Timer repeatTimer;
    private final int repeatInterval = 65;
    private final int repeatInitialDelay = 500;
    private Timer keyOffTimer;
    private final int keyOffDelay = 2000;
    private boolean textInput = false;
    private String text;
    protected transient ChangeEvent changeEvent;
    private AlcNumberDialog dialog;
    private String title;

    AlcSpinnerCustom(String title, boolean sub, int value, int min, int max, int step) {
        this.value = value;
        this.step = step;
        this.title = title;
        if (sub) {
            this.width = 38;
            this.height = 15;
            this.textAreaWidth = 24;
            this.stringY = 11;
            this.metrics = this.getFontMetrics(FONT_SMALLER);
            this.font = FONT_SMALLER;
            this.spinner = AlcUtil.getImage("sub-spinner.png");
            this.spinnerUp = AlcUtil.getImage("sub-spinner-up.png");
            this.spinnerDown = AlcUtil.getImage("sub-spinner-down.png");
        } else {
            this.width = 43;
            this.height = 24;
            this.textAreaWidth = 27;
            this.stringY = 16;
            this.metrics = this.getFontMetrics(FONT_MEDIUM);
            this.font = FONT_MEDIUM;
            this.spinner = AlcUtil.getImage("spinner.png");
            this.spinnerUp = AlcUtil.getImage("spinner-up.png");
            this.spinnerDown = AlcUtil.getImage("spinner-down.png");
        }
        this.halfHeight = this.height / 2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.dialog = new AlcNumberDialog(this);
        AbstractAction doNothing = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(49, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(50, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(51, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(52, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(53, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(54, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(55, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(56, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(57, 0), "doNothing");
        this.getInputMap().put(KeyStroke.getKeyStroke(48, 0), "doNothing");
        this.getActionMap().put("doNothing", doNothing);
        this.setup(min, max);
    }

    public void setup(int min, int max) {
        this.min = min;
        this.max = max;
        this.setValue(this.value);
    }

    public String getTitle() {
        return this.title;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        if (this.upPressed) {
            g2.drawImage(this.spinnerUp, 0, 0, null);
        } else if (this.downPressed) {
            g2.drawImage(this.spinnerDown, 0, 0, null);
        } else {
            g2.drawImage(this.spinner, 0, 0, null);
        }
        if (this.textInput || this.drag) {
            g2.setColor(AlcToolBar.COLOR_UI_BG);
            g2.fillRect(1, 1, this.textAreaWidth - 2, this.height - 2);
        }
        g2.setColor(Color.BLACK);
        String valueString = Integer.toString(this.value);
        int stringWidth = this.metrics.stringWidth(valueString);
        int stringX = this.textAreaWidth - stringWidth >> 1;
        g2.setFont(this.font);
        g2.drawString(valueString, stringX, this.stringY);
    }

    boolean getValueIsAdjusting() {
        return this.mouseDown;
    }

    int getValue() {
        return this.value;
    }

    void setValue(int newValue) {
        this.value = newValue > this.max ? this.max : (newValue < this.min ? this.min : newValue);
        this.fireStateChanged();
    }

    int getNextValue() {
        if (this.value + this.step > this.max) {
            return this.max;
        }
        return this.value + this.step;
    }

    void setNextValue() {
        if (this.value == this.max) {
            return;
        }
        if (this.value + this.step > this.max) {
            this.value = this.max;
            this.fireStateChanged();
        } else {
            this.value += this.step;
            this.fireStateChanged();
        }
    }

    int getPreviousValue() {
        if (this.value - this.step < this.min) {
            return this.min;
        }
        return this.value - this.step;
    }

    void setPreviousValue() {
        if (this.value == this.min) {
            return;
        }
        if (this.value - this.min < this.min) {
            this.value = this.min;
            this.fireStateChanged();
        } else {
            this.value -= this.step;
            this.fireStateChanged();
        }
    }

    private void repaintNumber() {
        this.repaint(0, 0, this.textAreaWidth, this.height);
    }

    void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    void fireStateChanged() {
        this.repaint();
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = changeListeners.length - 2; i >= 0; i -= 2) {
            if (changeListeners[i] != ChangeListener.class) continue;
            ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    private void startTimer(final boolean direction) {
        this.repeatTimer = new Timer(65, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (direction) {
                    AlcSpinnerCustom.this.setNextValue();
                    AlcSpinnerCustom.this.repaint();
                } else {
                    AlcSpinnerCustom.this.setPreviousValue();
                    AlcSpinnerCustom.this.repaint();
                }
            }
        });
        this.repeatTimer.setInitialDelay(500);
        this.repeatTimer.start();
    }

    private void stopTimer() {
        if (this.repeatTimer != null) {
            if (this.repeatTimer.isRunning()) {
                this.repeatTimer.stop();
            }
            this.repeatTimer = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
        boolean showDialog = false;
        if (Alchemy.OS == 2) {
            if (e.isMetaDown()) {
                showDialog = true;
            }
        } else if (e.isControlDown()) {
            showDialog = true;
        }
        if (showDialog) {
            if (!Alchemy.preferences.simpleToolBar) {
                this.dialog.show(this.min, this.max);
            }
        } else if (e.getX() < this.textAreaWidth) {
            this.requestFocusInWindow(true);
            this.textInput = true;
            this.text = new String();
            this.repaint();
            this.keyOffTimer = new Timer(2000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlcSpinnerCustom.this.textInput = false;
                    AlcSpinnerCustom.this.repaint();
                }
            });
            this.keyOffTimer.setRepeats(false);
            this.keyOffTimer.start();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getX() >= this.textAreaWidth && e.getY() <= this.halfHeight) {
            this.setNextValue();
            this.startTimer(true);
            this.upPressed = true;
            this.repaint();
        } else if (e.getX() >= this.textAreaWidth && e.getY() > this.halfHeight) {
            this.setPreviousValue();
            this.startTimer(false);
            this.downPressed = true;
            this.repaint();
        } else if (e.getX() < this.textAreaWidth) {
            // empty if block
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.upPressed || this.downPressed) {
            this.stopTimer();
            this.downPressed = false;
            this.upPressed = false;
            this.repaint();
        } else if (this.drag) {
            this.drag = false;
            this.repaintNumber();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.drag) {
            int change = (this.dragY - e.getY()) / 4;
            this.setValue(this.dragValue + change * this.step);
            this.repaintNumber();
        } else if (e.getX() < this.textAreaWidth) {
            this.drag = true;
            this.dragY = e.getY();
            this.dragValue = this.value;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (this.textInput) {
            char c;
            if (this.keyOffTimer != null) {
                this.keyOffTimer.restart();
            }
            if (Character.isDigit(c = e.getKeyChar())) {
                try {
                    String s = Character.toString(c);
                    String numberString = this.text + s;
                    int number = Integer.parseInt(numberString);
                    this.setValue(number);
                    this.text = Integer.toString(this.value);
                    this.repaintNumber();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int scrollAmount = e.getUnitsToScroll() * -1;
        if (scrollAmount != 1 && scrollAmount != -1) {
            scrollAmount /= 2;
        }
        this.setValue(this.value + scrollAmount * this.step);
        this.repaintNumber();
    }
}

