/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransparencyGroup;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.xmp.PdfSchema;
import com.lowagie.text.xml.xmp.XmpWriter;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import eu.medsea.util.MimeUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.Timer;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;

class AlcSession
implements ActionListener,
AlcConstants {
    private Timer timer;
    private boolean recordState;
    private File pdfWriteFile;
    private Timer indicatorTimer;
    private PDFFile pdfReadFile;
    PDFPage pdfReadPage;
    private int currentPdfReadPage = 1;
    private int maxPdfReadPage;

    AlcSession() {
    }

    void setRecording(boolean record) {
        if (record) {
            int interval = Alchemy.preferences.sessionRecordingInterval;
            if (this.timer == null) {
                this.timer = new Timer(interval, this);
                this.timer.start();
            } else {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
                this.timer.setDelay(Alchemy.preferences.sessionRecordingInterval);
                this.timer.start();
            }
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.recordState = record;
    }

    boolean isRecording() {
        return this.recordState;
    }

    void setTimerInterval(int interval) {
        System.out.println("Interval: " + interval);
        Alchemy.preferences.sessionRecordingInterval = interval;
        if (this.recordState) {
            if (this.timer != null) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                    this.timer = null;
                    if (interval > 0) {
                        this.timer = new Timer(interval, this);
                        this.timer.start();
                    }
                } else {
                    this.timer = null;
                    this.timer = new Timer(interval, this);
                    this.timer.start();
                }
            } else if (interval > 0) {
                this.timer = new Timer(interval, this);
                this.timer.start();
            }
        }
    }

    private void restartTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            System.out.println("Timer Restarted");
            this.timer.restart();
        }
    }

    void restartSession() {
        this.pdfWriteFile = null;
    }

    File getCurrentPdfPath() {
        return this.pdfWriteFile;
    }

    void manualSavePage() {
        this.savePage();
        this.restartTimer();
        this.progressPage();
    }

    void manualSaveClearPage() {
        this.saveClearPage();
        this.restartTimer();
    }

    boolean savePage() {
        if (this.pdfWriteFile == null || !this.pdfWriteFile.exists()) {
            String fileName = Alchemy.preferences.sessionFilePreName + AlcUtil.dateStamp(Alchemy.preferences.sessionFileDateFormat) + ".pdf";
            this.pdfWriteFile = new File(Alchemy.preferences.sessionPath, fileName);
            System.out.println("Current PDF file: " + this.pdfWriteFile.getPath());
            return this.saveSinglePdf(this.pdfWriteFile);
        }
        try {
            File temp = File.createTempFile("AlchemyPage", ".pdf");
            this.saveSinglePdf(temp);
            boolean jointUp = this.addPageToPdf(this.pdfWriteFile, temp);
            if (jointUp) {
                temp.delete();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    void saveClearPage() {
        this.savePage();
        Alchemy.canvas.clear();
        this.progressPage();
    }

    boolean saveSinglePdf(File file) {
        java.awt.Rectangle bounds = Alchemy.canvas.getVisibleRect();
        Document document = new Document(new Rectangle(bounds.width, bounds.height), 0.0f, 0.0f, 0.0f, 0.0f);
        System.out.println("Save Single Pdf Called: " + file.toString());
        boolean noError = true;
        try {
            PdfWriter singleWriter = PdfWriter.getInstance(document, new FileOutputStream(file));
            document.addTitle("Alchemy Session");
            document.addAuthor(USER_NAME);
            document.addCreator("Alchemy <http://al.chemy.org>");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XmpWriter xmp = new XmpWriter(os);
            PdfSchema pdf = new PdfSchema();
            pdf.setProperty("pdf:keywords", "Alchemy <http://al.chemy.org>");
            xmp.addRdfDescription(pdf);
            xmp.close();
            singleWriter.setXmpMetadata(os.toByteArray());
            PdfTransparencyGroup transGroup = new PdfTransparencyGroup();
            transGroup.put(PdfName.CS, PdfName.DEVICERGB);
            document.open();
            PdfContentByte cb = singleWriter.getDirectContent();
            PdfTemplate tp = cb.createTemplate(bounds.width, bounds.height);
            document.newPage();
            cb.getPdfWriter().setGroup(transGroup);
            cb.setDefaultColorspace(PdfName.CS, PdfName.DEVICERGB);
            Graphics2D g2pdf = tp.createGraphics(bounds.width, bounds.height);
            Alchemy.canvas.setGuide(false);
            Alchemy.canvas.vectorCanvas.paintComponent(g2pdf);
            Alchemy.canvas.setGuide(true);
            g2pdf.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException ex) {
            System.err.println(ex);
            noError = false;
        }
        catch (IOException ex) {
            System.err.println(ex);
            noError = false;
        }
        document.close();
        return noError;
    }

    boolean saveSVG(File file) {
        boolean noError = true;
        System.out.println("Save SVG Called: " + file.toString());
        java.awt.Rectangle bounds = Alchemy.canvas.getVisibleRect();
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        org.w3c.dom.Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault(document);
        ctx.setComment("Generated by Alchemy (http://al.chemy.org) with Batik SVG Generator");
        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, false);
        svgGenerator.setSVGCanvasSize(new Dimension(bounds.width, bounds.height));
        Alchemy.canvas.setGuide(false);
        Alchemy.canvas.vectorCanvas.paintComponent(svgGenerator);
        Alchemy.canvas.setGuide(true);
        svgGenerator.dispose();
        boolean useCSS = true;
        try {
            FileWriter out = new FileWriter(file);
            svgGenerator.stream(out, useCSS);
        }
        catch (IOException ex) {
            System.err.println(ex);
            noError = false;
        }
        return noError;
    }

    boolean addPageToPdf(File mainPdf, File tempPdf) {
        try {
            File dest = new File(DIR_TEMP, "Alchemy.pdf");
            FileOutputStream output = new FileOutputStream(dest);
            PdfReader reader = new PdfReader(mainPdf.getPath());
            PdfReader newPdf = new PdfReader(tempPdf.getPath());
            Rectangle currentSize = newPdf.getPageSizeWithRotation(1);
            Rectangle oldSize = reader.getPageSizeWithRotation(1);
            float pdfWidth = oldSize.getWidth();
            float pdfHeight = oldSize.getHeight();
            if (currentSize.getWidth() > pdfWidth) {
                pdfWidth = currentSize.getWidth();
            }
            if (currentSize.getHeight() > pdfHeight) {
                pdfHeight = currentSize.getHeight();
            }
            Document document = new Document(new Rectangle(pdfWidth, pdfHeight), 0.0f, 0.0f, 0.0f, 0.0f);
            PdfCopy copy = new PdfCopy(document, (OutputStream)output);
            document.addTitle("Alchemy Session");
            document.addAuthor(USER_NAME);
            document.addCreator("Alchemy <http://al.chemy.org>");
            copy.setXmpMetadata(reader.getMetadata());
            document.open();
            PdfContentByte cb = copy.getDirectContent();
            int i = 0;
            while (i < reader.getNumberOfPages()) {
                document.newPage();
                cb.setDefaultColorspace(PdfName.CS, PdfName.DEVICERGB);
                PdfImportedPage page = copy.getImportedPage(reader, ++i);
                copy.addPage(page);
            }
            document.newPage();
            PdfImportedPage lastPage = copy.getImportedPage(newPdf, 1);
            copy.addPage(lastPage);
            output.flush();
            document.close();
            ((OutputStream)output).close();
            if (dest.exists()) {
                File joinPdf;
                boolean success;
                String mainPdfPath = mainPdf.getPath();
                if (mainPdf.exists()) {
                    mainPdf.delete();
                }
                if (!(success = dest.renameTo(joinPdf = new File(mainPdfPath)))) {
                    System.err.println("Error moving Pdf");
                    return false;
                }
            } else {
                System.err.println("File does not exist?!: " + dest.getAbsolutePath());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean loadSessionFile(File file) {
        try {
            boolean result;
            PdfReader reader;
            String metaData;
            String mime = MimeUtil.getMimeType(file.getAbsoluteFile());
            if (!mime.equals("application/pdf")) {
                AlcUtil.showConfirmDialogFromBundle("notPDFDialogTitle", "notPDFDialogMessage");
                return false;
            }
            if (file.equals(this.pdfWriteFile)) {
                boolean result2 = AlcUtil.showConfirmDialogFromBundle("loadSessionPDFDialogTitle", "loadSessionPDFDialogMessage");
                if (result2) {
                    this.restartSession();
                } else {
                    return false;
                }
            }
            if (!((metaData = new String((reader = new PdfReader(file.getPath())).getMetadata())).contains("Alchemy") || file.getName().startsWith("Alchemy") || (result = AlcUtil.showConfirmDialogFromBundle("loadForeignPDFDialogTitle", "loadForeignPDFDialogMessage")))) {
                return false;
            }
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            this.pdfReadFile = new PDFFile(buf);
            this.currentPdfReadPage = 1;
            this.maxPdfReadPage = this.pdfReadFile.getNumPages();
            this.pdfReadPage = this.pdfReadFile.getPage(this.currentPdfReadPage);
            Alchemy.canvas.redraw(true);
            return true;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    void nextPage() {
        if (this.pdfReadFile != null) {
            if (this.currentPdfReadPage + 1 <= this.maxPdfReadPage) {
                ++this.currentPdfReadPage;
                this.pdfReadPage = this.pdfReadFile.getPage(this.currentPdfReadPage);
                Alchemy.canvas.redraw(true);
            } else {
                TOOLKIT.beep();
            }
        }
    }

    void previousPage() {
        if (this.pdfReadFile != null) {
            if (this.currentPdfReadPage - 1 >= 1) {
                --this.currentPdfReadPage;
                this.pdfReadPage = this.pdfReadFile.getPage(this.currentPdfReadPage);
                Alchemy.canvas.redraw(true);
            } else {
                TOOLKIT.beep();
            }
        }
    }

    void unloadSessionFile() {
        this.pdfReadFile = null;
        this.pdfReadPage = null;
        Alchemy.canvas.redraw(true);
    }

    void progressPage() {
        if (Alchemy.preferences.sessionLink && this.pdfReadFile != null) {
            if (this.currentPdfReadPage + 1 <= this.maxPdfReadPage) {
                ++this.currentPdfReadPage;
                this.pdfReadPage = this.pdfReadFile.getPage(this.currentPdfReadPage);
                Alchemy.canvas.redraw(true);
            } else {
                this.currentPdfReadPage = 0;
                this.pdfReadPage = this.pdfReadFile.getPage(this.currentPdfReadPage);
                Alchemy.canvas.redraw(true);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (Alchemy.canvas.canvasChanged() && this.savePage()) {
            Alchemy.canvas.setRecordIndicator(true);
            if (this.indicatorTimer == null) {
                this.indicatorTimer = new Timer(500, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Alchemy.canvas.setRecordIndicator(false);
                        Alchemy.canvas.redraw();
                        AlcSession.this.indicatorTimer.stop();
                        AlcSession.this.indicatorTimer = null;
                        Alchemy.canvas.resetCanvasChanged();
                    }
                });
                this.indicatorTimer.start();
            }
            Alchemy.canvas.redraw();
            if (Alchemy.preferences.sessionAutoClear) {
                Alchemy.canvas.clear();
            }
            this.progressPage();
            Alchemy.canvas.resetCanvasChanged();
        }
    }
}

