/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AlcResourceBundleChecker
extends JDialog {
    AlcResourceBundleChecker() {
        int i;
        LinkedHashMap<Object, Object> rootBundle = new LinkedHashMap();
        try {
            URI bundleURI = Alchemy.class.getResource("/org/alchemy/core/AlcResourceBundle.properties").toURI();
            rootBundle = AlcResourceBundleChecker.load(new FileInputStream(new File(bundleURI)));
        }
        catch (Exception ex) {
            System.err.println("Error loading the default resource bundle");
            ex.printStackTrace();
        }
        File[] bundleFiles = null;
        try {
            URI bundleURI = Alchemy.class.getResource("/org/alchemy/core").toURI();
            File bundleDir = new File(bundleURI);
            bundleFiles = bundleDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    System.out.println(name);
                    return name.startsWith("AlcResourceBundle_") && !name.contains("_en");
                }
            });
            for (i = 0; i < bundleFiles.length; ++i) {
                File file = bundleFiles[i];
                System.out.println(file.getAbsolutePath());
            }
            System.out.println("Total Files: " + bundleFiles.length);
        }
        catch (URISyntaxException ex) {
            System.err.println("Error scanning for bundles");
            ex.printStackTrace();
        }
        String text = new String();
        Set<Object> keySet = rootBundle.keySet();
        if (bundleFiles != null && bundleFiles.length > 0) {
            for (i = 0; i < bundleFiles.length; ++i) {
                try {
                    LinkedHashMap<Object, Object> bundle = new LinkedHashMap();
                    bundle = AlcResourceBundleChecker.load(new FileInputStream(bundleFiles[i]));
                    text = text + bundleFiles[i].getName() + "\n\n";
                    for (String string : keySet) {
                        if (bundle.containsKey(string) || string.startsWith("copyright") || string.startsWith("version")) continue;
                        text = text + string + " = " + (String)rootBundle.get(string) + "\n";
                    }
                    text = text + "\n---------------\n\n";
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("Error loading bundle");
                    ex.printStackTrace();
                }
            }
        }
        JPanel contentPanel = new JPanel(new BorderLayout());
        JTextArea textArea = new JTextArea(text, 5, 30);
        JScrollPane scrollPane = new JScrollPane(textArea);
        contentPanel.add((Component)scrollPane, "Center");
        this.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add(contentPanel);
        this.pack();
        Point point = AlcUtil.calculateCenter(this);
        this.setLocation(point.x, point.y);
        this.setVisible(true);
    }

    protected static LinkedHashMap<String, String> load(InputStream input) throws IOException {
        String[] lines;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String line : lines = AlcResourceBundleChecker.loadStrings(input)) {
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, equals).trim();
            String value = line.substring(equals + 1).trim();
            map.put(key, value);
        }
        return map;
    }

    public static String[] loadStrings(InputStream input) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String[] lines = new String[100];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

