/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcShortcutInterface;
import org.alchemy.core.Alchemy;

class AlcMenuItem
extends JMenuItem
implements AlcShortcutInterface,
AlcConstants {
    AlcMenuItem(Action action) {
        this.setAction(action);
    }

    AlcMenuItem(String title) {
        this.setup(title, -1);
    }

    AlcMenuItem(String title, int accelerator) {
        this.setup(title, accelerator);
    }

    void setup(String title) {
        this.setup(title, -1);
    }

    void setup(String title, int accelerator) {
        this.setText(title);
        if (accelerator > 0) {
            this.setAccelerator(KeyStroke.getKeyStroke(accelerator, KEY_MODIFIER));
        }
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.setOpaque(true);
        if (Alchemy.OS != 3) {
            this.setBackground(COLOR_UI_HIGHLIGHT);
        }
        this.setFont(FONT_MEDIUM);
    }

    public void refreshShortcut(int key, int modifier) {
        this.setAccelerator(KeyStroke.getKeyStroke(key, modifier));
    }
}

