/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcExportDialog
extends JDialog
implements AlcConstants {
    private JFormattedTextField widthField;
    private JFormattedTextField heightField;
    private JFormattedTextField percentField;
    private JCheckBox transparencyCheckBox;
    private int startWidth;
    private int startHeight;
    private static final Font font = new Font("sansserif", 0, 12);
    private String imageFormat = "PNG";
    private File file;

    AlcExportDialog() {
        super(Alchemy.window, Alchemy.bundle.getString("exportFileTitle"), true);
        Dimension size = new Dimension(250, 250);
        this.setPreferredSize(size);
        JPanel contentPanel = new JPanel(new MigLayout("fill, insets 15, gap 2"));
        this.addSeparator(contentPanel, Alchemy.bundle.getString("exportOptions"));
        Rectangle canvasSize = Alchemy.canvas.getVisibleRect();
        contentPanel.add((Component)this.getLabel("exportWidth"), "gap para");
        this.widthField = this.getNumberField(canvasSize.width);
        contentPanel.add((Component)this.widthField, "growx, wrap");
        contentPanel.add((Component)this.getLabel("exportHeight"), "gap para");
        this.heightField = this.getNumberField(canvasSize.height);
        contentPanel.add((Component)this.heightField, "growx, wrap");
        contentPanel.add((Component)this.getLabel("exportPercent"), "gap para");
        this.percentField = this.getNumberField(100);
        contentPanel.add((Component)this.percentField, "growx, wrap 10px");
        this.transparencyCheckBox = new JCheckBox(Alchemy.bundle.getString("exportTransparency"));
        this.transparencyCheckBox.setFont(font);
        contentPanel.add((Component)this.transparencyCheckBox, "gap para, span, wrap 10px");
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlcExportDialog.this.setVisible(false);
            }
        };
        AlcUtil.registerWindowCloseKeys(this.getRootPane(), closeAction);
        JButton okButton = new JButton(Alchemy.bundle.getString("ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int width = new Integer(AlcExportDialog.this.widthField.getText());
                    int height = new Integer(AlcExportDialog.this.heightField.getText());
                    float scale = new Float(AlcExportDialog.this.percentField.getText()).floatValue() / 100.0f;
                    boolean transparency = AlcExportDialog.this.transparencyCheckBox.isSelected();
                    Alchemy.canvas.setGuide(false);
                    BufferedImage bitmapImage = (BufferedImage)Alchemy.canvas.renderCanvas(true, transparency, scale, width, height);
                    Alchemy.canvas.setGuide(true);
                    Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(AlcExportDialog.this.imageFormat);
                    ImageWriter writer = iter.next();
                    ImageWriteParam iwp = writer.getDefaultWriteParam();
                    if (AlcExportDialog.this.imageFormat.equals("JPG")) {
                        iwp.setCompressionMode(2);
                        iwp.setCompressionQuality(1.0f);
                    }
                    FileImageOutputStream output = new FileImageOutputStream(AlcExportDialog.this.file);
                    writer.setOutput(output);
                    IIOImage image = new IIOImage(bitmapImage, null, null);
                    writer.write(null, image, iwp);
                    writer.dispose();
                }
                catch (Exception ex) {
                    AlcUtil.showConfirmDialogFromBundle("imageExportErrorDialogTitle", "imageExportErrorDialogMessage");
                    ex.printStackTrace();
                }
                AlcExportDialog.this.setVisible(false);
            }
        });
        contentPanel.add((Component)okButton, "skip 1, split, alignx right, tag ok");
        JButton cancelButton = new JButton(Alchemy.bundle.getString("cancel"));
        cancelButton.addActionListener(closeAction);
        contentPanel.add((Component)cancelButton, "tag cancel");
        this.getContentPane().add(contentPanel);
        this.pack();
    }

    void showWindow(File file, String imageFormat) {
        this.imageFormat = imageFormat;
        this.file = file;
        Rectangle canvasSize = Alchemy.canvas.getVisibleRect();
        this.startWidth = canvasSize.width;
        this.widthField.setValue(new Integer(this.startWidth));
        this.startHeight = canvasSize.height;
        this.heightField.setValue(new Integer(this.startHeight));
        this.percentField.setValue(new Integer(100));
        if (imageFormat.equals("PNG")) {
            this.transparencyCheckBox.setEnabled(true);
        } else {
            this.transparencyCheckBox.setSelected(false);
            this.transparencyCheckBox.setEnabled(false);
        }
        Point loc = AlcUtil.calculateCenter(this);
        this.setLocation(loc.x, loc.y);
        this.setVisible(true);
    }

    private void addSeparator(JPanel panel, String text) {
        JLabel l = new JLabel(text);
        l.setForeground(new Color(0, 0, 0));
        panel.add((Component)l, "gapbottom 1, span, split 2, aligny center");
        panel.add((Component)new JSeparator(), "gapleft rel, growx");
    }

    private JLabel getLabel(String text) {
        JLabel label = new JLabel(Alchemy.bundle.getString(text));
        label.setFont(font);
        return label;
    }

    private JFormattedTextField getNumberField(int value) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        DecimalFormat format = (DecimalFormat)numberFormat;
        format.applyPattern("#############");
        JFormattedTextField field = new JFormattedTextField(format);
        field.setValue(new Integer(value));
        field.setFont(font);
        field.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                try {
                    float width = new Float(AlcExportDialog.this.widthField.getText()).floatValue();
                    float height = new Float(AlcExportDialog.this.heightField.getText()).floatValue();
                    float percent = new Float(AlcExportDialog.this.percentField.getText()).floatValue();
                    JFormattedTextField source = (JFormattedTextField)evt.getSource();
                    if (source == AlcExportDialog.this.widthField) {
                        float change = width / (float)AlcExportDialog.this.startWidth;
                        AlcExportDialog.this.heightField.setValue(new Integer(Math.round((float)AlcExportDialog.this.startHeight * change)));
                        AlcExportDialog.this.percentField.setValue(new Integer(Math.round(change * 100.0f)));
                    } else if (source == AlcExportDialog.this.heightField) {
                        float change = height / (float)AlcExportDialog.this.startHeight;
                        AlcExportDialog.this.widthField.setValue(new Integer(Math.round((float)AlcExportDialog.this.startWidth * change)));
                        AlcExportDialog.this.percentField.setValue(new Integer(Math.round(change * 100.0f)));
                    } else if (source == AlcExportDialog.this.percentField) {
                        AlcExportDialog.this.widthField.setValue(new Integer(Math.round((float)AlcExportDialog.this.startWidth * (percent / 100.0f))));
                        AlcExportDialog.this.heightField.setValue(new Integer(Math.round((float)AlcExportDialog.this.startHeight * (percent / 100.0f))));
                    }
                }
                catch (NumberFormatException ex) {
                    System.err.println("Number Format Exception");
                }
            }
        });
        return field;
    }
}

