/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

public class AlcColorSelector
extends JDialog
implements DocumentListener,
AlcConstants {
    private int hue;
    private int saturation;
    private int brightness;
    private int red;
    private int green;
    private int blue;
    private ColorRange range;
    private ColorSlider slider;
    private JTextField hueField;
    private JTextField saturationField;
    private JTextField brightnessField;
    private JTextField redField;
    private JTextField greenField;
    private JTextField blueField;
    private JTextField hexField;
    private JPanel colorPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean updating;
    private int labelH;
    private ActionListener okListener;
    private ActionListener cancelListener;

    AlcColorSelector(String title) {
        super((Frame)Alchemy.window, title);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(COLOR_UI_HIGHLIGHT);
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.range = new ColorRange();
        Box rangeBox = new Box(1);
        rangeBox.setAlignmentY(0.0f);
        rangeBox.setBorder(BorderFactory.createBevelBorder(1));
        rangeBox.add(this.range);
        box.add(rangeBox);
        box.add(Box.createHorizontalStrut(10));
        this.slider = new ColorSlider();
        Box sliderBox = new Box(1);
        sliderBox.setAlignmentY(0.0f);
        sliderBox.setBorder(BorderFactory.createBevelBorder(1));
        sliderBox.add(this.slider);
        box.add(sliderBox);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.createColorFields());
        box.add(Box.createHorizontalStrut(10));
        this.getContentPane().add((Component)box, "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        AlcUtil.registerWindowCloseKeys(this.getRootPane(), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlcColorSelector.this.setVisible(false);
            }
        });
        this.hueField.getDocument().addDocumentListener(this);
        this.saturationField.getDocument().addDocumentListener(this);
        this.brightnessField.getDocument().addDocumentListener(this);
        this.redField.getDocument().addDocumentListener(this);
        this.greenField.getDocument().addDocumentListener(this);
        this.blueField.getDocument().addDocumentListener(this);
        this.hexField.getDocument().addDocumentListener(this);
        this.hexField.setText("FFFFFF");
    }

    public void show(ActionListener okListener, ActionListener cancelListener) {
        this.show(okListener, cancelListener, null);
    }

    public void show(ActionListener okListener, ActionListener cancelListener, Color initialColor) {
        if (this.okListener != null) {
            this.okButton.removeActionListener(this.okListener);
        }
        if (this.cancelListener != null) {
            this.cancelButton.removeActionListener(this.cancelListener);
        }
        this.okListener = okListener;
        this.cancelListener = cancelListener;
        this.okButton.addActionListener(okListener);
        this.cancelButton.addActionListener(cancelListener);
        if (initialColor != null) {
            this.setColor(initialColor);
        }
        this.range.init = true;
        Point p = AlcUtil.calculateCenter(this, true);
        this.setLocation(p);
        this.setVisible(true);
    }

    public Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public void setColor(Color color) {
        this.updateRGB2(color.getRGB());
        this.updateHSB();
        this.updateHex();
        this.range.repaint();
        this.slider.repaint();
        this.colorPanel.repaint();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Document doc = e.getDocument();
        if (doc == this.hueField.getDocument()) {
            this.hue = this.bounded(this.hue, this.hueField, 359);
            this.updateRGB();
            this.updateHex();
        } else if (doc == this.saturationField.getDocument()) {
            this.saturation = this.bounded(this.saturation, this.saturationField, 99);
            this.updateRGB();
            this.updateHex();
        } else if (doc == this.brightnessField.getDocument()) {
            this.brightness = this.bounded(this.brightness, this.brightnessField, 99);
            this.updateRGB();
            this.updateHex();
        } else if (doc == this.redField.getDocument()) {
            this.red = this.bounded(this.red, this.redField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (doc == this.greenField.getDocument()) {
            this.green = this.bounded(this.green, this.greenField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (doc == this.blueField.getDocument()) {
            this.blue = this.bounded(this.blue, this.blueField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (doc == this.hexField.getDocument()) {
            String str = this.hexField.getText();
            while (str.length() < 6) {
                str = str + "0";
            }
            if (str.length() > 6) {
                str = str.substring(0, 6);
            }
            this.updateRGB2(Integer.parseInt(str, 16));
            this.updateHSB();
        }
        this.range.repaint();
        this.slider.repaint();
        this.colorPanel.repaint();
        this.updating = false;
    }

    private void updateRGB() {
        int rgb = Color.HSBtoRGB((float)this.hue / 359.0f, (float)this.saturation / 99.0f, (float)this.brightness / 99.0f);
        this.updateRGB2(rgb);
    }

    private void updateRGB2(int rgb) {
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.redField.setText(String.valueOf(this.red));
        this.greenField.setText(String.valueOf(this.green));
        this.blueField.setText(String.valueOf(this.blue));
    }

    private void updateHSB() {
        float[] hsb = new float[3];
        Color.RGBtoHSB(this.red, this.green, this.blue, hsb);
        this.hue = (int)(hsb[0] * 359.0f);
        this.saturation = (int)(hsb[1] * 99.0f);
        this.brightness = (int)(hsb[2] * 99.0f);
        this.hueField.setText(String.valueOf(this.hue));
        this.saturationField.setText(String.valueOf(this.saturation));
        this.brightnessField.setText(String.valueOf(this.brightness));
    }

    private void updateHex() {
        this.hexField.setText(AlcUtil.hex(this.red, 2) + AlcUtil.hex(this.green, 2) + AlcUtil.hex(this.blue, 2));
    }

    private int bounded(int current, final JTextField field, final int max) {
        String text = field.getText();
        if (text.length() == 0) {
            return 0;
        }
        try {
            int value = Integer.parseInt(text);
            if (value > max) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        field.setText(String.valueOf(max));
                    }
                });
                return max;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return current;
        }
    }

    private Container createColorFields() {
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        this.colorPanel = new JPanel(){

            public void paintComponent(Graphics g) {
                g.setColor(new Color(AlcColorSelector.this.red, AlcColorSelector.this.green, AlcColorSelector.this.blue));
                Dimension size = this.getSize();
                g.fillRect(0, 0, size.width, size.height);
            }
        };
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(1));
        Dimension dim = new Dimension(60, 40);
        this.colorPanel.setMinimumSize(dim);
        box.add(this.colorPanel);
        box.add(Box.createVerticalStrut(15));
        Box row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("H:"));
        this.hueField = new NumberField(4, false);
        row.add(this.hueField);
        row.add(new JLabel(" \u00b0"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("S:"));
        this.saturationField = new NumberField(4, false);
        row.add(this.saturationField);
        row.add(new JLabel(" %"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("B:"));
        this.brightnessField = new NumberField(4, false);
        row.add(this.brightnessField);
        row.add(new JLabel(" %"));
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(10));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("R:"));
        this.redField = new NumberField(4, false);
        row.add(this.redField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("G:"));
        this.greenField = new NumberField(4, false);
        row.add(this.greenField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("B:"));
        this.blueField = new NumberField(4, false);
        row.add(this.blueField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalStrut(10));
        row = Box.createHorizontalBox();
        row.add(this.createFixedLabel("#"));
        this.hexField = new NumberField(5, true);
        row.add(this.hexField);
        row.add(Box.createHorizontalGlue());
        box.add(row);
        box.add(Box.createVerticalGlue());
        return box;
    }

    private JPanel createButtonPanel() {
        this.cancelButton = new JButton(Alchemy.bundle.getString("cancel"));
        this.cancelButton.setMnemonic(27);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcColorSelector.this.setVisible(false);
            }
        });
        this.okButton = new JButton(Alchemy.bundle.getString("ok"));
        this.okButton.setMnemonic(10);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcColorSelector.this.setVisible(false);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        if (Alchemy.OS == 2) {
            buttonPane.add(this.cancelButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(this.okButton);
        } else {
            buttonPane.add(this.okButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(this.cancelButton);
        }
        return buttonPane;
    }

    private JLabel createFixedLabel(String title) {
        JLabel label = new JLabel(title);
        if (this.labelH == 0) {
            this.labelH = label.getPreferredSize().height;
        }
        Dimension dim = new Dimension(20, this.labelH);
        label.setPreferredSize(dim);
        label.setMinimumSize(dim);
        label.setMaximumSize(dim);
        return label;
    }

    class NumberDocument
    extends PlainDocument {
        NumberField parentField;

        public NumberDocument(NumberField parentField) {
            this.parentField = parentField;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] chars = str.toCharArray();
            int charCount = 0;
            for (int i = 0; i < chars.length; ++i) {
                boolean ok = Character.isDigit(chars[i]);
                if (this.parentField.allowHex) {
                    if (chars[i] >= 'A' && chars[i] <= 'F') {
                        ok = true;
                    }
                    if (chars[i] >= 'a' && chars[i] <= 'f') {
                        ok = true;
                    }
                }
                if (!ok) continue;
                if (charCount != i) {
                    chars[charCount] = chars[i];
                }
                ++charCount;
            }
            super.insertString(offs, new String(chars, 0, charCount), a);
        }
    }

    class NumberField
    extends JTextField {
        public boolean allowHex;

        public NumberField(int cols, boolean allowHex) {
            super(cols);
            this.allowHex = allowHex;
        }

        protected Document createDefaultModel() {
            return new NumberDocument(this);
        }

        public Dimension getPreferredSize() {
            if (!this.allowHex) {
                return new Dimension(45, super.getPreferredSize().height);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    class ColorSlider
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        static final int WIDE = 20;
        static final int HIGH = 256;
        private int[] pixels = new int[5120];
        private BufferedImage colorArray = new BufferedImage(20, 256, 2);

        ColorSlider() {
            this.setPreferredSize(new Dimension(20, 256));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        protected void paintComponent(Graphics g) {
            int index = 0;
            int sel = 255 - (int)(255.0f * ((float)AlcColorSelector.this.hue / 359.0f));
            for (int j = 0; j < 256; ++j) {
                Color c = Color.getHSBColor((255.0f - (float)j) / 255.0f, 1.0f, 1.0f);
                if (j == sel) {
                    c = new Color(-16777216);
                }
                for (int i = 0; i < 20; ++i) {
                    this.pixels[index++] = c.getRGB();
                }
            }
            this.colorArray.setRGB(0, 0, 20, 256, this.pixels, 0, 20);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)this.colorArray, 0, 0, null);
        }

        void updateMouse(int mouseX, int mouseY) {
            if (mouseX >= 0 && mouseX < 256 && mouseY >= 0 && mouseY < 256) {
                int nhue = 359 - (int)(359.0f * ((float)mouseY / 255.0f));
                AlcColorSelector.this.hueField.setText(String.valueOf(nhue));
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(20, 256);
        }

        public Dimension getMinimumSize() {
            return new Dimension(20, 256);
        }

        public Dimension getMaximumSize() {
            return new Dimension(20, 256);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.updateMouse(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            this.updateMouse(e.getX(), e.getY());
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    class ColorRange
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        static final int WIDE = 256;
        static final int HIGH = 256;
        int lastX;
        int lastY;
        private int[] pixels = new int[65536];
        private BufferedImage colorArray = new BufferedImage(256, 256, 2);
        boolean init = true;

        ColorRange() {
            this.setPreferredSize(new Dimension(256, 256));
            this.setCursor(AlcConstants.CURSOR_CIRCLE);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        protected void paintComponent(Graphics g) {
            int index = 0;
            float fhue = (float)AlcColorSelector.this.hue / 359.0f;
            Color targetColor = new Color(AlcColorSelector.this.red, AlcColorSelector.this.green, AlcColorSelector.this.blue);
            for (int j = 0; j < 256; ++j) {
                for (int i = 0; i < 256; ++i) {
                    Color c = Color.getHSBColor(fhue, (float)i / 255.0f, (float)(255 - j) / 255.0f);
                    if (this.init && this.nearlyEquals(targetColor, c)) {
                        this.lastX = i;
                        this.lastY = j;
                        this.init = false;
                    }
                    this.pixels[index++] = c.getRGB();
                }
            }
            this.colorArray.setRGB(0, 0, 256, 256, this.pixels, 0, 256);
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)this.colorArray, 0, 0, null);
            g2.setColor(AlcColorSelector.this.brightness > 50 ? Color.BLACK : Color.WHITE);
            g2.drawRect(this.lastX - 4, this.lastY - 4, 8, 8);
        }

        private boolean nearlyEquals(Color c1, Color c2) {
            boolean result = false;
            boolean difference = true;
            if (c1.equals(c2)) {
                result = true;
            } else {
                int blue;
                int green;
                int red = Math.abs(c1.getRed() - c2.getRed());
                if (red + (green = Math.abs(c1.getGreen() - c2.getGreen())) + (blue = Math.abs(c1.getBlue() - c2.getBlue())) <= 1) {
                    result = true;
                }
            }
            return result;
        }

        void updateMouse(int mouseX, int mouseY) {
            if (mouseX >= 0 && mouseX < 256 && mouseY >= 0 && mouseY < 256) {
                int nsaturation = (int)(100.0f * ((float)mouseX / 255.0f));
                int nbrightness = 100 - (int)(100.0f * ((float)mouseY / 255.0f));
                AlcColorSelector.this.saturationField.setText(String.valueOf(nsaturation));
                AlcColorSelector.this.brightnessField.setText(String.valueOf(nbrightness));
                this.lastX = mouseX;
                this.lastY = mouseY;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(256, 256);
        }

        public Dimension getMinimumSize() {
            return new Dimension(256, 256);
        }

        public Dimension getMaximumSize() {
            return new Dimension(256, 256);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.updateMouse(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            this.updateMouse(e.getX(), e.getY());
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

