/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcPopupInterface;
import org.alchemy.core.AlcPopupMenu;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcColorButton
extends JComponent
implements MouseListener,
AlcPopupInterface,
AlcConstants {
    private AlcPopupMenu fgPopup;
    private AlcPopupMenu bgPopup;
    private JComponent colorPanel;
    private Image colorPanelImage;
    private final Image colorFg = AlcUtil.getImage("color-fg.png");
    private final Image colorBg = AlcUtil.getImage("color-bg.png");
    private final Image colorSwitch = AlcUtil.getImage("color-switch.png");
    private final Color highlightColor = new Color(0, 0, 0, 50);
    private final int FOREGROUND = 1;
    private final int BACKGROUND = 2;
    private final int SWITCH = 3;
    private int highlight = 0;
    private final int swatchSize = 17;

    AlcColorButton(String text, String toolTip) {
        this.setLayout(new BoxLayout(this, 3));
        this.colorPanel = new JComponent(){

            public void paintComponent(Graphics g) {
                g.drawImage(AlcColorButton.this.colorPanelImage, 0, 0, null);
            }
        };
        this.colorPanel.setPreferredSize(new Dimension(34, 24));
        this.colorPanel.setAlignmentX(0.5f);
        this.colorPanel.addMouseListener(this);
        this.add(this.colorPanel);
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.5f);
        label.setFont(FONT_MEDIUM);
        label.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                AlcColorButton.this.highlight = 1;
                AlcColorButton.this.refresh();
                if (((AlcColorButton)AlcColorButton.this).fgPopup.clickOk) {
                    ((AlcColorButton)AlcColorButton.this).fgPopup.clickOk = false;
                    AlcColorButton.this.fgPopup.show(e.getComponent(), -2, 21);
                }
            }
        });
        this.add(label);
        this.colorPanel.setToolTipText(toolTip);
        label.setToolTipText(toolTip);
        this.setToolTipText(toolTip);
        this.fgPopup = new AlcPopupMenu();
        this.fgPopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AlcColorButton.this.highlight = 0;
                AlcColorButton.this.refresh();
            }
        });
        this.bgPopup = new AlcPopupMenu();
        this.bgPopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AlcColorButton.this.highlight = 0;
                AlcColorButton.this.refresh();
            }
        });
    }

    void addFgItem(Component item) {
        this.fgPopup.add(item);
    }

    void addBgItem(Component item) {
        this.bgPopup.add(item);
    }

    void refresh() {
        this.colorPanelImage = this.getColorPanelImage();
        this.colorPanel.repaint();
    }

    void switchColors() {
        Alchemy.canvas.setBackgroundColorActive(!Alchemy.canvas.isBackgroundColorActive());
        this.refresh();
    }

    public boolean isPopupVisible() {
        return this.fgPopup.isVisible() || this.bgPopup.isVisible();
    }

    public boolean isInside() {
        if (!Alchemy.canvas.isBackgroundColorActive()) {
            return this.fgPopup.inside;
        }
        return this.bgPopup.inside;
    }

    public void hidePopup() {
        this.fgPopup.setVisible(false);
        this.bgPopup.setVisible(false);
        this.highlight = 0;
        this.refresh();
    }

    private int getArea(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x >= 24 && y <= 12) {
            return 3;
        }
        if (!Alchemy.canvas.isBackgroundColorActive() && x >= 7 && x < 17 && y >= 17 || !Alchemy.canvas.isBackgroundColorActive() && x >= 17 && x <= 23 && y >= 7) {
            return 2;
        }
        if (Alchemy.canvas.isBackgroundColorActive() && x >= 7 && x <= 23 && y >= 7) {
            return 2;
        }
        return 1;
    }

    private Image getColorPanelImage() {
        BufferedImage image = new BufferedImage(35, 24, 2);
        Graphics2D g = image.createGraphics();
        if (!Alchemy.canvas.isBackgroundColorActive()) {
            g.setColor(Alchemy.canvas.getForegroundColor());
            g.fillRect(2, 2, 13, 13);
            g.setColor(Alchemy.canvas.getBackgroundColor());
            g.fillRect(9, 17, 7, 5);
            g.fillRect(16, 9, 6, 13);
            g.drawImage(this.colorFg, 0, 0, null);
        } else {
            g.setColor(Alchemy.canvas.getForegroundColor());
            g.fillRect(2, 2, 13, 5);
            g.fillRect(2, 7, 6, 10);
            g.setColor(Alchemy.canvas.getBackgroundColor());
            g.fillRect(9, 9, 13, 13);
            g.drawImage(this.colorBg, 0, 0, null);
        }
        switch (this.highlight) {
            case 1: {
                g.setColor(this.highlightColor);
                if (!Alchemy.canvas.isBackgroundColorActive()) {
                    g.fillRect(0, 0, 17, 17);
                    break;
                }
                g.fillRect(0, 0, 17, 7);
                g.fillRect(0, 7, 7, 10);
                break;
            }
            case 2: {
                g.setColor(this.highlightColor);
                if (!Alchemy.canvas.isBackgroundColorActive()) {
                    g.fillRect(7, 17, 10, 7);
                    g.fillRect(17, 7, 7, 17);
                    break;
                }
                g.fillRect(7, 7, 17, 17);
                break;
            }
            case 3: {
                g.drawImage(this.colorSwitch, 24, 0, null);
            }
        }
        return image;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int area = this.getArea(e);
        switch (area) {
            case 3: {
                this.highlight = 3;
                Alchemy.canvas.setBackgroundColorActive(!Alchemy.canvas.isBackgroundColorActive());
                this.refresh();
                break;
            }
            case 1: {
                this.highlight = 1;
                this.refresh();
                if (this.fgPopup.clickOk) {
                    this.fgPopup.clickOk = false;
                    this.fgPopup.show(e.getComponent(), 0, 45);
                    break;
                }
                this.highlight = 0;
                this.refresh();
                break;
            }
            case 2: {
                this.highlight = 2;
                this.refresh();
                if (this.bgPopup.clickOk) {
                    this.bgPopup.clickOk = false;
                    this.bgPopup.show(e.getComponent(), 7, 45);
                    break;
                }
                this.highlight = 0;
                this.refresh();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.highlight == 3) {
            this.highlight = 0;
            this.refresh();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

