/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Insets;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JButton;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcShortcutInterface;
import org.alchemy.core.AlcShortcuts;
import org.alchemy.core.AlcUtil;

class AlcButton
extends JButton
implements AlcShortcutInterface,
AlcConstants {
    private String toolTip;

    AlcButton() {
    }

    AlcButton(Action action) {
        this.setAction(action);
    }

    AlcButton(URL iconUrl) {
        this.setup(null, null, iconUrl);
    }

    AlcButton(String text, String toolTip) {
        this.setup(text, toolTip, null);
    }

    AlcButton(String text, String toolTip, URL iconUrl) {
        this.setup(text, toolTip, iconUrl);
    }

    void setup(String text, String toolTip, URL iconUrl) {
        if (toolTip != null) {
            this.toolTip = toolTip;
        }
        if (iconUrl != null) {
            this.setIcon(AlcUtil.getImageIcon(iconUrl));
            URL rolloverIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-over");
            this.setRolloverIcon(AlcUtil.getImageIcon(rolloverIconUrl));
            URL pressedIconUrl = AlcUtil.appendStringToUrl(iconUrl, "-down");
            this.setPressedIcon(AlcUtil.getImageIcon(pressedIconUrl));
        }
        this.setFont(FONT_MEDIUM);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        if (text != null) {
            this.setText(text);
        }
        this.setToolTipText(toolTip);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
    }

    public void refreshShortcut(int key, int modifier) {
        this.setToolTipText(AlcShortcuts.getShortcutString(key, modifier, this.toolTip));
    }
}

