/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.xinput;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jpen.PLevel;
import jpen.provider.xinput.XiBus;
import jpen.provider.xinput.XinputProvider;

final class XiDevice {
    final int cellIndex;
    final XiBus xiBus;
    final int xiDeviceIndex;

    XiDevice(XiBus xiBus, int cellIndex, int xiDeviceIndex) {
        XinputProvider.loadLibrary();
        this.cellIndex = cellIndex;
        this.xiBus = xiBus;
        this.xiDeviceIndex = xiDeviceIndex;
    }

    public String getName() {
        return this.xiBus.getXiDeviceName(this.xiDeviceIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsListening() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            return XiDevice.getIsListening(this.cellIndex);
        }
    }

    private static native boolean getIsListening(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsListening(boolean isListening) {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            XiDevice.setIsListening(this.cellIndex, isListening);
        }
    }

    private static native void setIsListening(int var0, boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PLevel.Range getLevelRange(PLevel.Type levelType) {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            int typeIndex = XiDevice.getLevelTypeValueIndex(levelType);
            return new PLevel.Range(XiDevice.getLevelRangeMin(this.cellIndex, typeIndex), XiDevice.getLevelRangeMax(this.cellIndex, typeIndex));
        }
    }

    private static int getLevelTypeValueIndex(PLevel.Type levelType) {
        return levelType.ordinal();
    }

    private static native int getLevelRangeMin(int var0, int var1);

    private static native int getLevelRangeMax(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValue(PLevel.Type levelType) {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            return XiDevice.getValue(this.cellIndex, XiDevice.getLevelTypeValueIndex(levelType));
        }
    }

    private static native int getValue(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            if (this.cellIndex != -1) {
                XiDevice.destroy(this.cellIndex);
            }
        }
    }

    private static native int destroy(int var0);

    private static native String getError();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextEvent() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            return XiDevice.nextEvent(this.cellIndex);
        }
    }

    private static native boolean nextEvent(int var0);

    private static synchronized native void stopWaitingNextEvent(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitNextEvent() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            return XiDevice.waitNextEvent(this.cellIndex);
        }
    }

    private static native boolean waitNextEvent(int var0);

    public void stopWaitingNextEvent() {
        XiDevice.stopWaitingNextEvent(this.cellIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEventTime() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            return XiDevice.getLastEventTime(this.cellIndex);
        }
    }

    private static native long getLastEventTime(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventType getLastEventType() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            int lastEventTypeOrdinal = XiDevice.getLastEventType(this.cellIndex);
            if (lastEventTypeOrdinal < 0) {
                return null;
            }
            return EventType.VALUES.get(lastEventTypeOrdinal);
        }
    }

    private static native int getLastEventType(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastEventButton() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            return XiDevice.getLastEventButton(this.cellIndex);
        }
    }

    private static native int getLastEventButton(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLevelRanges() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            XiDevice.refreshLevelRanges(this.cellIndex);
        }
    }

    private static native void refreshLevelRanges(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        XiBus xiBus = this.xiBus;
        synchronized (xiBus) {
            StringBuffer sb = new StringBuffer();
            sb.append("{Device: name=");
            sb.append(this.getName());
            sb.append(", levelRanges=( ");
            for (PLevel.Type levelType : PLevel.Type.values()) {
                sb.append((Object)levelType);
                sb.append("=");
                sb.append(this.getLevelRange(levelType));
                sb.append(" ");
            }
            sb.append(") values=(");
            for (PLevel.Type levelType : PLevel.Type.values()) {
                sb.append((Object)levelType);
                sb.append("=");
                sb.append(this.getValue(levelType));
                sb.append(",");
            }
            sb.append(") , lastEventType=");
            sb.append((Object)this.getLastEventType());
            sb.append(", lastEventButton=");
            sb.append(this.getLastEventButton());
            sb.append("}");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EventType {
        BUTTON_PRESS,
        BUTTON_RELEASE,
        MOTION_NOTIFY;

        public static final List<EventType> VALUES;

        static {
            VALUES = Collections.unmodifiableList(Arrays.asList(EventType.values()));
        }
    }
}

