/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.osx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jpen.PButton;
import jpen.PKind;
import jpen.PLevel;
import jpen.PenDevice;
import jpen.provider.osx.CocoaDevice;
import jpen.provider.osx.CocoaProvider;

public class CocoaAccess {
    static final Logger L = Logger.getLogger(CocoaAccess.class.getName());
    protected static final float RADIANS_PER_DEGREE = (float)Math.PI / 180;
    protected static final float HALF_PI = 1.5707964f;
    protected static final float TILT_TO_RADIANS = 1.1170107f;
    private boolean active = false;
    private CocoaProvider cocoaProvider = null;
    public static final int WACOM_VENDOR_ID = 1386;
    public static final int WACOM_CAPABILITY_DEVICEIDMASK = 1;
    public static final int WACOM_CAPABILITY_ABSXMASK = 2;
    public static final int WACOM_CAPABILITY_ABSYMASK = 4;
    public static final int WACOM_CAPABILITY_VENDOR1MASK = 8;
    public static final int WACOM_CAPABILITY_VENDOR2MASK = 16;
    public static final int WACOM_CAPABILITY_VENDOR3MASK = 32;
    public static final int WACOM_CAPABILITY_BUTTONSMASK = 64;
    public static final int WACOM_CAPABILITY_TILTXMASK = 128;
    public static final int WACOM_CAPABILITY_TILTYMASK = 256;
    public static final int WACOM_CAPABILITY_TILTMASK = 384;
    public static final int WACOM_CAPABILITY_ABSZMASK = 512;
    public static final int WACOM_CAPABILITY_PRESSUREMASK = 1024;
    public static final int WACOM_CAPABILITY_TANGENTIALPRESSUREMASK = 2048;
    public static final int WACOM_CAPABILITY_ORIENTINFOMASK = 4096;
    public static final int WACOM_CAPABILITY_ROTATIONMASK = 8192;
    public static final int WACOM_POINTER_TYPE_MASK = 3846;
    public static final int WACOM_POINTER_TYPE_GENERAL_STYLUS = 2052;
    public static final int WACOM_POINTER_TYPE_AIRBRUSH = 2050;
    public static final int WACOM_POINTER_TYPE_GENERAL_MOUSE = 2306;
    public static final int WACOM_POINTER_TYPE_PRO_MOUSE = 6;
    public static final int WACOM_POINTER_TYPE_ROTATION_STYLUS = 4;
    public static final int WACOM_POINTER_TYPE_I_Standard_Stylus = 2082;
    public static final int WACOM_POINTER_TYPE_I_Inking_Stylus = 2066;
    public static final int WACOM_POINTER_TYPE_I_Stroke_Stylus = 2098;
    public static final int WACOM_POINTER_TYPE_I_Grip_Stylus = 2114;
    public static final int WACOM_POINTER_TYPE_I_Airbrush = 2322;
    public static final int WACOM_POINTER_TYPE_I_4D_Mouse = 148;
    public static final int WACOM_POINTER_TYPE_I_Lens_Cursor = 150;
    public static final int WACOM_POINTER_TYPE_I2_Standard_Grip_Stylus = 2130;
    public static final int WACOM_POINTER_TYPE_I2_Classic_Stylus = 2082;
    public static final int WACOM_POINTER_TYPE_I2_Inking_Stylus = 2066;
    public static final int WACOM_POINTER_TYPE_I2_Stroke_Stylus = 2098;
    public static final int WACOM_POINTER_TYPE_I2_Designer_Stylus = 2114;
    public static final int WACOM_POINTER_TYPE_I2_Airbrush = 2322;
    public static final int WACOM_POINTER_TYPE_I2_2D_Mouse = 7;
    public static final int WACOM_POINTER_TYPE_I2_4D_Mouse = 148;
    public static final int WACOM_POINTER_TYPE_I2_Lens_Cursor = 150;
    public static final int WACOM_POINTER_TYPE_I3_Standard_Grip_Stylus = 2083;
    public static final int WACOM_POINTER_TYPE_I3_Rotation_Stylus_Art_Pen = 2181;
    public static final int WACOM_POINTER_TYPE_I3_Inking_Stylus = 2049;
    public static final int WACOM_POINTER_TYPE_I3_Airbrush = 2323;
    public static final int WACOM_POINTER_TYPE_I3_2D_mouse = 23;
    public static final int WACOM_POINTER_TYPE_I3_Lens_Cursor = 151;
    public static final int WACOM_POINTER_TYPE_Graphire_Stylus = 34;
    public static final int WACOM_POINTER_TYPE_Graphire_Mouse = 662;
    protected static final int NS_MODIFIER_AlphaShiftKeyMask = 65536;
    protected static final int NS_MODIFIER_ShiftKeyMask = 131072;
    protected static final int NS_MODIFIER_ControlKeyMask = 262144;
    protected static final int NS_MODIFIER_AlternateKeyMask = 524288;
    protected static final int NS_MODIFIER_CommandKeyMask = 0x100000;
    protected static final int NS_MODIFIER_NumericPadKeyMask = 0x200000;
    protected static final int NS_MODIFIER_HelpKeyMask = 0x400000;
    protected static final int NS_MODIFIER_FunctionKeyMask = 0x800000;
    protected static final int NS_EVENT_TYPE_LeftMouseDown = 1;
    protected static final int NS_EVENT_TYPE_LeftMouseUp = 2;
    protected static final int NS_EVENT_TYPE_RightMouseDown = 3;
    protected static final int NS_EVENT_TYPE_RightMouseUp = 4;
    protected static final int NS_EVENT_TYPE_MouseMoved = 5;
    protected static final int NS_EVENT_TYPE_LeftMouseDragged = 6;
    protected static final int NS_EVENT_TYPE_RightMouseDragged = 7;
    protected static final int NS_EVENT_TYPE_MouseEntered = 8;
    protected static final int NS_EVENT_TYPE_MouseExited = 9;
    protected static final int NS_EVENT_TYPE_ScrollWheel = 22;
    protected static final int NS_EVENT_TYPE_TabletPoint = 23;
    protected static final int NS_EVENT_TYPE_TabletProximity = 24;
    protected static final int NS_EVENT_TYPE_OtherMouseDown = 25;
    protected static final int NS_EVENT_TYPE_OtherMouseUp = 26;
    protected static final int NS_EVENT_TYPE_OtherMouseDragged = 27;
    protected static final int NS_EVENT_TYPE_EventTypeGesture = 29;
    protected static final int NS_EVENT_TYPE_EventTypeMagnify = 30;
    protected static final int NS_EVENT_TYPE_EventTypeSwipe = 31;
    protected static final int NS_EVENT_TYPE_EventTypeRotate = 18;
    protected static final int NS_EVENT_TYPE_EventTypeBeginGesture = 19;
    protected static final int NS_EVENT_TYPE_EventTypeEndGesture = 20;
    protected static final int NSUnknownPointingDevice = 0;
    protected static final int NSPenPointingDevice = 1;
    protected static final int NSCursorPointingDevice = 2;
    protected static final int NSEraserPointingDevice = 3;
    protected static final int NSPenTipMask = 1;
    protected static final int NSPenLowerSideMask = 2;
    protected static final int NSPenUpperSideMask = 4;
    private CocoaDevice device = null;
    private Collection<PLevel> levels = new ArrayList<PLevel>(8);

    static native int getNativeBuild();

    public void start() {
        if (!this.active) {
            this.active = true;
            this.startup();
            this.setProximityEventsEnabled(true);
        }
    }

    public void stop() {
        if (this.active) {
            this.active = false;
            this.shutdown();
        }
    }

    public void finalize() {
        this.stop();
    }

    public void enable() {
        this.setTabletEventsEnabled(true);
    }

    public void disable() {
        this.setTabletEventsEnabled(false);
    }

    protected native void setTabletEventsEnabled(boolean var1);

    protected native void setProximityEventsEnabled(boolean var1);

    protected native void setScrollEventsEnabled(boolean var1);

    protected native void setGestureEventsEnabled(boolean var1);

    public void setProvider(CocoaProvider _cocoaProvider) {
        this.cocoaProvider = _cocoaProvider;
    }

    private native void startup();

    private native void shutdown();

    protected void postProximityEvent(double eventTimeSeconds, int cocoaModifierFlags, int capabilityMask, int deviceID, boolean enteringProximity, int pointingDeviceID, int pointingDeviceSerialNumber, int pointingDeviceType, int systemTabletID, int tabletID, long uniqueID, int vendorID, int vendorPointingDeviceType) {
        if (enteringProximity) {
            switch (pointingDeviceType) {
                case 1: {
                    this.device = this.cocoaProvider.getDevice(PKind.Type.STYLUS);
                    break;
                }
                case 2: {
                    this.device = this.cocoaProvider.getDevice(PKind.Type.CURSOR);
                    break;
                }
                case 3: {
                    this.device = this.cocoaProvider.getDevice(PKind.Type.ERASER);
                    break;
                }
                default: {
                    this.device = this.cocoaProvider.getDevice(PKind.Type.CURSOR);
                    break;
                }
            }
        } else {
            this.device = this.cocoaProvider.getDevice(PKind.Type.CURSOR);
        }
        if (vendorID == 1386) {
            // empty if block
        }
    }

    protected void postEvent(final int type, final double eventTimeSeconds, int cocoaModifierFlags, final float screenX, final float screenY, final boolean tabletEvent, int absoluteX, int absoluteY, int absoluteZ, int buttonMask, final float pressure, final float rotation, final float tiltX, final float tiltY, final float tangentialPressure) {
        this.invokeOnEventThread(new Runnable(){

            public void run() {
                if (CocoaAccess.this.device == null) {
                    CocoaAccess.this.device = CocoaAccess.this.cocoaProvider.getDevice(PKind.Type.CURSOR);
                }
                if (tabletEvent && CocoaAccess.this.device.getType() == PKind.Type.CURSOR) {
                    CocoaAccess.this.device = CocoaAccess.this.cocoaProvider.getDevice(PKind.Type.STYLUS);
                }
                if (!CocoaAccess.this.device.getEnabled()) {
                    return;
                }
                long deviceTime = (long)(eventTimeSeconds * 1000.0);
                switch (type) {
                    case 1: {
                        CocoaAccess.this.scheduleButtonEvent(deviceTime, PButton.Type.LEFT, true);
                        break;
                    }
                    case 2: {
                        CocoaAccess.this.scheduleButtonEvent(deviceTime, PButton.Type.LEFT, false);
                        break;
                    }
                    case 3: {
                        CocoaAccess.this.scheduleButtonEvent(deviceTime, PButton.Type.RIGHT, true);
                        break;
                    }
                    case 4: {
                        CocoaAccess.this.scheduleButtonEvent(deviceTime, PButton.Type.RIGHT, false);
                        break;
                    }
                    case 25: {
                        CocoaAccess.this.scheduleButtonEvent(deviceTime, PButton.Type.CENTER, true);
                        break;
                    }
                    case 26: {
                        CocoaAccess.this.scheduleButtonEvent(deviceTime, PButton.Type.CENTER, false);
                    }
                }
                CocoaAccess.this.levels.clear();
                CocoaAccess.this.levels.add(new PLevel(PLevel.Type.X, screenX));
                CocoaAccess.this.levels.add(new PLevel(PLevel.Type.Y, screenY));
                CocoaAccess.this.levels.add(new PLevel(PLevel.Type.TILT_X, tiltX * 1.1170107f));
                CocoaAccess.this.levels.add(new PLevel(PLevel.Type.TILT_Y, -tiltY * 1.1170107f));
                CocoaAccess.this.levels.add(new PLevel(PLevel.Type.PRESSURE, pressure));
                CocoaAccess.this.levels.add(new PLevel(PLevel.Type.SIDE_PRESSURE, tangentialPressure));
                CocoaAccess.this.levels.add(new PLevel(PLevel.Type.ROTATION, rotation * ((float)Math.PI / 180)));
                CocoaAccess.this.cocoaProvider.getPenManager().scheduleLevelEvent((PenDevice)CocoaAccess.this.device, deviceTime, CocoaAccess.this.levels, true);
            }
        });
    }

    protected void postScrollEvent(double eventTimeSeconds, int cocoaModifierFlags, float screenX, float screenY, boolean isDeviceDelta, float deltaX, float deltaY) {
    }

    protected void postMagnifyEvent(double eventTimeSeconds, int cocoaModifierFlags, float screenX, float screenY, float magnificationFactor) {
    }

    protected void postSwipeEvent(double eventTimeSeconds, int cocoaModifierFlags, float screenX, float screenY, float deltaX, float deltaY) {
    }

    protected void postRotateEvent(double eventTimeSeconds, int cocoaModifierFlags, float screenX, float screenY, float rotationDegrees) {
    }

    protected void invokeOnEventThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void scheduleButtonEvent(long deviceTime, PButton.Type type, boolean pressed) {
        this.cocoaProvider.getPenManager().scheduleButtonEvent(this.device, deviceTime, new PButton(type.ordinal(), pressed));
    }
}

