/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.PKind;
import jpen.PKindEvent;
import jpen.PLevel;
import jpen.PLevelEvent;
import jpen.PScroll;
import jpen.PScrollEvent;
import jpen.Pen;
import jpen.PenDevice;
import jpen.PenEvent;
import jpen.PenState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PenScheduler {
    static final Logger L = Logger.getLogger(PenScheduler.class.getName());
    private final Pen pen;
    private PenEvent lastScheduledEvent;
    public final PenState lastScheduledState = new PenState();
    private final PhantomEventFilter phantomLevelFilter = new PhantomEventFilter();
    private final List<PLevel> scheduledLevels = new ArrayList<PLevel>();
    private final Point clipLocationOnScreen = new Point();
    private final Point2D.Float scheduledLocation = new Point2D.Float();

    PenScheduler(Pen pen) {
        this.pen = pen;
        this.lastScheduledEvent = pen.getLastDispatchedEvent();
    }

    synchronized boolean scheduleLevelEvent(PenDevice device, long deviceTime, Collection<PLevel> levels, boolean levelsOnScreen) {
        if (device != this.getEmulationDevice() && this.phantomLevelFilter.filter(device)) {
            return false;
        }
        float scheduledPressure = -1.0f;
        float lastScheduledPressure = -1.0f;
        boolean scheduledMovement = false;
        this.scheduledLocation.x = this.lastScheduledState.levels.getValue(PLevel.Type.X);
        this.scheduledLocation.y = this.lastScheduledState.levels.getValue(PLevel.Type.Y);
        if (this.pen.penManager != null && levelsOnScreen) {
            this.pen.penManager.penOwner.getPenClip().evalLocationOnScreen(this.clipLocationOnScreen);
        }
        for (PLevel level : levels) {
            if (((Float)level.value).floatValue() == this.lastScheduledState.getLevelValue(level.typeNumber) || device != this.getEmulationDevice() && this.pen.levelEmulator != null && this.pen.levelEmulator.onActivePolicy(((PKind.Type)((Object)this.lastScheduledState.getKind().getType())).ordinal(), level.typeNumber) || this.pen.getLevelFilter().filterPenLevel(level)) continue;
            switch ((PLevel.Type)((Object)level.getType())) {
                case X: {
                    scheduledMovement = true;
                    if (levelsOnScreen) {
                        level.value = Float.valueOf(((Float)level.value).floatValue() - (float)this.clipLocationOnScreen.x);
                    }
                    this.scheduledLocation.x = ((Float)level.value).floatValue();
                    break;
                }
                case Y: {
                    scheduledMovement = true;
                    if (levelsOnScreen) {
                        level.value = Float.valueOf(((Float)level.value).floatValue() - (float)this.clipLocationOnScreen.y);
                    }
                    this.scheduledLocation.y = ((Float)level.value).floatValue();
                    break;
                }
                case PRESSURE: {
                    scheduledPressure = ((Float)level.value).floatValue();
                    lastScheduledPressure = this.lastScheduledState.levels.getValue(PLevel.Type.PRESSURE);
                    break;
                }
            }
            this.scheduledLevels.add(level);
        }
        if (this.scheduledLevels.isEmpty()) {
            return false;
        }
        if (scheduledMovement) {
            if (this.pen.penManager != null && !this.pen.penManager.penOwner.getPenClip().contains(this.scheduledLocation) && !this.pen.penManager.penOwner.isDraggingOut()) {
                return false;
            }
            if (device.getKindTypeNumber() != PKind.Type.IGNORE.ordinal() && device.getKindTypeNumber() != this.lastScheduledState.getKind().typeNumber) {
                PKind newKind = PKind.valueOf(device.getKindTypeNumber());
                if (L.isLoggable(Level.FINE)) {
                    L.fine("changing kind to:" + newKind);
                    L.fine("scheduledLevels: " + this.scheduledLevels);
                    L.fine("device: " + device);
                }
                this.lastScheduledState.setKind(newKind);
                this.schedule(new PKindEvent(device, deviceTime, newKind));
            }
        }
        this.lastScheduledState.levels.setValues(this.scheduledLevels);
        PLevelEvent levelEvent = new PLevelEvent(device, deviceTime, this.scheduledLevels.toArray(new PLevel[this.scheduledLevels.size()]));
        this.phantomLevelFilter.setLastEvent(levelEvent);
        this.scheduledLevels.clear();
        this.scheduleOnPressureButtonEvent(lastScheduledPressure, scheduledPressure);
        this.schedule(levelEvent);
        return true;
    }

    private void scheduleOnPressureButtonEvent(float lastScheduledPressure, float scheduledPressure) {
        if (lastScheduledPressure == 0.0f && scheduledPressure > 0.0f) {
            this.scheduleEmulatedButtonEvent(new PButton(PButton.Type.ON_PRESSURE.ordinal(), true));
        } else if (lastScheduledPressure > 0.0f && scheduledPressure == 0.0f) {
            this.scheduleEmulatedButtonEvent(new PButton(PButton.Type.ON_PRESSURE.ordinal(), false));
        }
    }

    synchronized void scheduleButtonReleasedEvents() {
        int i = PButton.Type.VALUES.size();
        while (--i >= 0) {
            this.scheduleEmulatedButtonEvent(new PButton(i, false));
        }
        for (Integer extButtonTypeNumber : this.lastScheduledState.extButtonTypeNumberToValue.keySet()) {
            this.scheduleEmulatedButtonEvent(new PButton((int)extButtonTypeNumber, false));
        }
    }

    private void scheduleEmulatedButtonEvent(PButton button) {
        this.scheduleButtonEvent(this.getEmulationDevice(), System.currentTimeMillis(), button);
    }

    private PenDevice getEmulationDevice() {
        return this.pen.penManager.emulationDevice;
    }

    synchronized void scheduleButtonEvent(PenDevice device, long deviceTime, PButton button) {
        if (this.lastScheduledState.setButtonValue(button.typeNumber, (Boolean)button.value)) {
            if (L.isLoggable(Level.FINE)) {
                L.fine("scheduling button event: " + button);
            }
            PButtonEvent buttonEvent = new PButtonEvent(device, deviceTime, button);
            this.schedule(buttonEvent);
            if (this.pen.levelEmulator != null) {
                this.pen.levelEmulator.scheduleEmulatedEvent(buttonEvent);
            }
        }
    }

    synchronized void scheduleScrollEvent(PenDevice device, long deviceTime, PScroll scroll) {
        this.schedule(new PScrollEvent(device, deviceTime, scroll));
    }

    private void schedule(PenEvent ev) {
        ev.time = System.currentTimeMillis();
        this.lastScheduledEvent.next = ev;
        this.lastScheduledEvent = ev;
        this.pen.processNewEvents();
    }

    private static class PhantomEventFilter {
        public static int THRESHOLD_PERIOD = 200;
        private PenDevice lastDevice;
        private PenEvent lastEvent;
        boolean filteredFirstInSecuence;
        private long time;
        private long firstInSecuenceTime;

        private PhantomEventFilter() {
        }

        boolean filter(PenDevice device) {
            if (!device.isDigitizer()) {
                this.time = System.currentTimeMillis();
                if (this.lastDevice != null && this.lastDevice != device && this.lastEvent != null && this.time - this.lastEvent.time <= (long)THRESHOLD_PERIOD) {
                    return true;
                }
                if (!this.filteredFirstInSecuence) {
                    L.fine("filtered first in sequence to prioritize digitized input in race");
                    this.filteredFirstInSecuence = true;
                    this.firstInSecuenceTime = System.currentTimeMillis();
                    return true;
                }
                if (this.time - this.firstInSecuenceTime <= (long)THRESHOLD_PERIOD) {
                    L.fine("filtering after the first for a period to allow digitized input to come and win in race");
                    return true;
                }
                L.fine("non digitized input going as event");
            } else {
                this.filteredFirstInSecuence = false;
            }
            this.lastDevice = device;
            return false;
        }

        void setLastEvent(PenEvent event) {
            this.lastEvent = event;
        }

        PenEvent getLastEvent() {
            return this.lastEvent;
        }
    }
}

