/* WhySynth default 'factory' patches
 *
 * The patches encoded herein have all been dedicated to the public
 * domain by their respective authors.  See the file
 * ../extra/COPYING-patches for more information.
 *
 * Note that while the patches themselves are in the public domain,
 * this particular encoding of them as WhySynth 'C' source code is
 * (for compatibility with the rest of the WhySynth source code)
 * copyrighted and licensed under the GNU General Public License.
 * You can find the copyright-unencumbered *content* of this file,
 * free from its copyrighted *form*, in the file
 * ../extra/current_default_patches.WhySynth.
 *
 * Copyright (C) 2008, 2010 Sean Bolton.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "whysynth_voice.h"

#define FRIENDLY_PATCH_COUNT  273

int y_friendly_patch_count = FRIENDLY_PATCH_COUNT;

y_patch_t y_friendly_patches[FRIENDLY_PATCH_COUNT] = {
    {
        "New String Thingy",
        "",
        { 8, 18, 0, 0, 0, 0, 0.414079, 0.5, 0, 0.234944, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 19.4917, 9, 0.0139509, 0.468405, 0 },
        { 6, 1, 19.4317, 11, 0.0186473, 0.464954, 0 },
        0, 0.147428, 0, 0.849625, 0.93656, 0.153421, 0.940932, 0.844492,
        0.538,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 0.244715, 0, 0, 0, 0 },
        128.177, 0,
        { 2, 3, 0.0738067, 0.875222, 2, 0.429704, 1, 3, 0.001, 1, 2, 3.54994, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "FM E.Piano 3",
        "",
        { 4, 56, 0, 0, 0, 0, 0.0519861, 0.617628, 18, 0.7428, 9, 0.0345608, 0.932864, 0 },
        { 4, 56, 0, -0.00517476, 0, 0, 0.0682776, 0.593337, 18, 0.776833, 11, 0.0372705, 0, 0.860843 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.810405, 0.080746, 0.716139, 1, 0, 0.5, 0, 0.5,
        0.650998,
        1, 0, 0, 0, 0.726627, 0.614681, 0.298288, 0.166667,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 2.99273, 0, 0, 0, 0 },
        146.537, 0,
        { 2, 1, 0.00161415, 1, 3, 0.1, 1, 2, 28.9352, 0, 3, 0.2, 0.0983891, 0, 0, 0, 0 },
        { 2, 3, 0.00127513, 1, 3, 1.14874, 0.381462, 3, 36.0975, 0, 3, 0.2, 0.218653, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Vox Liminal",
        "",
        { 8, 165, 0, 0, 0, 0, 0.541889, 0.5, 0, 0.128501, 0, 0, 1.06147, 1.0041 },
        { 8, 162, 0, 0, 0, 0, 0.577239, 0.602047, 0, 0.580746, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 5, 0, 4.29604, 10, 0.130744, 0.639143, 0 },
        { 5, 2, 3.60001, 12, 0.130744, 0.640278, 0 },
        0.690351, 0.100946, 0.609377, 0.901611, 0.401433, 1, 0.408376, 0,
        0.394656,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1.03594, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 0.170591, 0, 0, 0, 0 },
        136.296, 0,
        { 1, 0, 3.13761, 1, 3, 0.001, 1, 3, 0.001, 1, 4, 10.7132, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Glass Organ 2",
        "",
        { 8, 87, 0, -3.84027e-11, 0, 0, 0.166667, 0.505583, 4, 0, 0, 0, 1.00159, 0.996471 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 5, 0, 8.33333, 11, 0.0692964, 0.734944, 0 },
        { 5, 1, 8.33333, 9, -0.0671847, 0.677825, 0 },
        0.833383, 0.2, 0.792792, 0.8, 0.609377, 0.685905, 0.576881, 0.323236,
        0.333224,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 0.368403, 147, 0, 0, 0 },
        { 0.247489, 0, 0.1, 0, 0 },
        { 0.215443, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 3, 0.00464159, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.220639, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Brazzled",
        "",
        { 2, 148, 0, 0.00889638, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 21, 0, -0.0166605, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 8, 22, 0, 0, 7, 0.000823012, 0.385319, 0.5, 2, 0, 0, 0, 0.372768, 0.401433 },
        { 4, 39, 0, 0, 7, -0.00154537, 0.0859207, 0.5, 18, 0.833333, 0, 0, 0.372768, 0.267512 },
        { 6, 0, 3.19286, 18, 0.610992, 0.576133, 0 },
        { 6, 1, 2.32015, 18, 0.645165, 0.532393, 0 },
        0, 0.2, 0, 0.8, 1.06147, 0.359722, 1.0041, 0.657446,
        0.6559,
        3, 0, 0, 0, 0.363445, 0.725724, 0.0253436, 0.314484,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.000227217, 1, 3, 0.000999999, 1, 3, 0.000999999, 1, 3, 0.114011, 0.274276, 0, 0, 0, 0 },
        { 1, 3, 0.000860858, 1, 3, 0.1, 1, 0, 1.85185, 0, 3, 6.99957, 0.208555, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0999999, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Ice Chorus",
        "",
        { 8, 69, 0, 0, 0, 0, 0.551986, 0.5, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 19.4917, 9, 0.0139509, 0.468405, 0 },
        { 6, 1, 19.4317, 11, 0.0186473, 0.464954, 0 },
        0, 0.147428, 0, 0.849625, 0.93656, 0.153421, 0.940932, 0.844492,
        0.538,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 0.244715, 0, 0, 0, 0 },
        128.177, 0,
        { 2, 3, 0.0738067, 0.875222, 2, 0.429704, 1, 3, 0.001, 1, 2, 3.54994, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Bristol Mini 99",
        "an imitation of the Bristol Mini patch",
        { 2, 148, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.810405, 0.5 },
        { 1, 0, 0, -0.00813585, 0, 0, 0, 0, 0, 0, 0, 0, 0.842463, 0.5 },
        { 2, 148, -12, 0.0513497, 0, 0, 0, 0.493571, 0, 0, 0, 0, 1.31172, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 1.37619, 18, 0.62679, 0.182958, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.657115, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.0447214, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.000258908, 1, 3, 0.001, 1, 3, 0, 1, 2, 1.85185, 0, 0, 0, 0, 0 },
        { 1, 3, 5.21095e-05, 1, 3, 0.1, 1, 5, 2.70597, 0.153421, 3, 3.13305, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Tree's House",
        "",
        { 8, 154, 0, 0, 0, 0, 0.385319, 0.5, 0, 0.196778, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 3.3, 18, 0.154887, 0, 0 },
        { 6, 1, 3.3, 18, 0.158499, 0, 0 },
        0, 0, 0, 1, 0.916019, 0, 0.903455, 1,
        0.636999,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 1, 0.00761536, 1, 3, 0.001, 1, 3, 0.001, 1, 2, 4.61334, 0, 0, 0, 0, 0 },
        { 1, 3, 0, 1, 3, 0.1, 1, 1, 1.30023, 0, 3, 0.931069, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "amSynth Sweet Bass",
        "an imitation of the amSynth patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.716139, 0.5 },
        { 1, 2, -12, 0, 0, 0, 0, 0.582889, 0, 0, 0, 0, 0.33332, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 0.463044, 22, 0.444444, 0.895555, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.419732, 0.5, 0, 0.5,
        0.466332,
        1, 0, 0, 0, 0.677825, 0.322175, 0.0820976, 0.131621,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.17448, 147, 0, 18, 1 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0, 1, 3, 0.000999999, 1, 3, 0.000999999, 1, 3, 2.6414, 0, 0, 0, 0, 0 },
        { 1, 5, 0.798094, 1, 3, 0.1, 1, 3, 0, 1, 3, 2.40041, 0, 0, 0, 0, 0 },
        { 1, 3, 0, 1, 3, 0.1, 1, 1, 3.05897, 0, 3, 3.80765, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 8, 0.0746128, 19, 0.757756
    },
    {
        "Anakotological",
        "",
        { 9, 5, 0, 0, 7, 0.00802651, 0.317042, 0, 18, 0.40824, 0, 0, 0.5, 0 },
        { 1, 0, 6, 0.037451, 6, 0.745537, 1, 0, 18, 0.833333, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 1, 2.89671, 19, 0.306546, 0.679135, 0 },
        { 0, 1, 19.4317, 11, 0.0186473, 0.464954, 0 },
        0.794898, 0.666667, 0, 0.849625, 0.93656, 0.428, 0, 0.844492,
        0.656569,
        1, 0, 0, 0, 0.923867, 0.255417, 0.31569, 0.186015,
        0.984375, 2,
        { 0.418175, 0, 0, 0, 0 },
        { 3.74756, 0, 0.942466, 0, 0 },
        { 0.244715, 0, 0, 0, 0 },
        128.177, 0,
        { 2, 3, 0.000679816, 1, 2, 0, 1, 2, 6.25, 0, 2, 3.54994, 0, 0, 0, 0, 0 },
        { 1, 3, 8.73978e-11, 1, 3, 0.1, 1, 5, 2.09741, 0, 3, 0.2, 0.561849, 0, 0, 0, 0 },
        { 1, 3, 0, 1, 3, 0.1, 1, 3, 0.1, 0.333333, 3, 0.0359684, 0.356816, -0.609147, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Lush Bells",
        "",
        { 8, 81, 0, 0, 0, 0, 0.247413, 0.574907, 4, 0.320865, 0, 0, 1.06147, 1.0041 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.747904, 0.185905, 0.746606, 0.806944, 0, 1, 0, 0,
        0.803309,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.307589, 141, 0, 0, 0 },
        { 0.199477, 0, 0, 0, 0 },
        136.296, 0,
        { 1, 1, 0.000100269, 1, 3, 0.001, 1, 1, 4.18143, 0, 2, 4.88803, 0.320865, -0.196778, 0.407467, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Simulated Wood Grain",
        "",
        { 8, 21, -12, 0, 0, 0, 0.473611, 0.5, 2, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 2.32015, 18, 0.181595, 0.833333, 0 },
        { 6, 1, 2.09443, 18, 0.181595, 0.818201, 0 },
        0, 0, 0, 1, 0.5, 0.190149, 0.5, 0.78693,
        0.624959,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0, 1, 0, 0.496166, 0.118538, 3, 4.56835, 0, 3, 0.2, 0.409467, 0.28183, 0.239079, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Mighty Synchronoton",
        "",
        { 1, 2, 0, 0, 9, 0, 0, 0.0496018, 0, 0, 0, 0, 0.222222, 0.222222 },
        { 2, 121, 14, 0, 7, 0.528369, 1, 0.409467, 0, 0, 0, 0, 1.08029, 0.5 },
        { 2, 121, 17, 0, 7, 0.162751, 1, 0.154198, 0, 0, 0, 0, 0.5, 0.952611 },
        { 1, 0, -12, 0.001602, 11, 0.00291594, 0, 0, 0, 0, 0, 0, 0.697459, 0.674532 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.591942, 0, 0.604124, 1, 0, 0.5, 0, 0.5,
        0.5,
        1, 0, 0, 0, 0.455205, 0.60761, 0.291445, 0.274276,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.0631072, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 2, 3, 0.00569756, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Orange Blossom",
        "",
        { 9, 24, 12, 0, 0, 0, 0.188922, 0.5, 18, 0.647428, 0, 0, 0.5, 0 },
        { 9, 86, 12, -0.00551887, 0, 0, 0.138538, 0.5, 18, 0.642289, 0, 0, 0, 0.5 },
        { 8, 19, 0, 0.00301943, 0, 0, 0.157446, 0.492929, 0, 0.151535, 0, 0, 1.0041, 0.929338 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.5, 0.344492, 0.5, 0.687817, 0, 0.5, 0, 0.5,
        0.5,
        1, 0, 0, 0, 0.781347, 0.379736, 0.311459, 0.283958,
        0.984375, 2,
        { 0.156224, 0, 0, 0, 0 },
        { 0.941295, 141, 0, 6, 0.166029 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.18169, 0, 0, 0, 0, 0 },
        { 1, 3, 0.00520788, 1, 3, 0.1, 1, 1, 0.833139, 0, 3, 0.2, 0.423867, 0, 0.249556, 0, 0 },
        { 0, 3, 0.431249, 1, 3, 0.1, 1, 1, 3.89842, 0.363445, 3, 0.2, 0.423867, 0, 0.249556, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "...drone.....",
        "",
        { 8, 109, 0, 0, 0, 0, 0.644792, 0.503215, 0, 0, 0, 0, 0.5, 0.5 },
        { 8, 118, 7, 0, 0, 0, 0.644792, 0.503215, 0, 0.467607, 0, 0, 0.161007, 0.16988 },
        { 8, 120, 16, 0, 0, 0, 0.644792, 0.503215, 0, 0, 0, 0, 0.161007, 0.16566 },
        { 0, 64, 19, 0.0294311, 7, 0.0204808, 0.516718, 0.5, 0, 0.234944, 0, 0, 0.101902, 0.122426 },
        { 1, 0, 3.55456, 0, 0, 0.855589, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.5, 0.2, 0.47386, 0.8, 0.535909, 0.5, 0.5, 0.5,
        0.436278,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.80551, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 1, 0.433081, 1, 3, 0.001, 1, 3, 0.001, 1, 7, 10.7132, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Wist",
        "",
        { 8, 157, 0, -0.224394, 0, 0, 0.794476, 0.5, 0, 0.153421, 18, 1, 0.222222, 0.222222 },
        { 8, 37, 0, 0, 0, 0, 0.761889, 0.548128, 0, 0, 0, 0, 0.5, 0.51783 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 2, 0, 5.11963, 11, 0.0336794, 0.716269, 0.814095 },
        { 2, 1, 4.91945, 9, 0.0422791, 0.704833, 0.80094 },
        0.514736, 0.0859207, 0.5, 0.922083, 0.379714, 0.791445, 0.391618, 0.223167,
        0.557999,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.516822, 0, 0, 0, 0 },
        { 0.273688, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 3.42465, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 13.5689, 0, 0, 0, 0, 0 },
        { 1, 1, 3.51652, 1, 3, 0.1, 1, 3, 0, 1, 3, 12.194, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "String Thingy",
        "",
        { 2, 21, 0, -0.00623956, 9, 0.00316481, 0, 0, 0, 0, 0, 0, 1, 0 },
        { 2, 21, 0, 0, 11, 0.00316481, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 2, 21, 0, 0, 13, 0.00362681, 0, 0, 0, 0, 0, 0, 0.344492, 0.375222 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 2, 0, 4.91945, 2, 0.220795, 0.265056, 0 },
        { 2, 1, 5.38048, 2, 0.133895, 0.247413, 0 },
        0, 0, 0, 1, 0.984671, 0.319207, 0.95404, 0.680793,
        0.730666,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        { 0.307589, 0, 0.1, 0, 0 },
        120.296, 0,
        { 2, 1, 0.127513, 1, 3, 0.1, 1, 3, 0.1, 1, 0, 3.04009, 0.196778, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0250322, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Hydrangia",
        "",
        { 1, 2, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 1, 0 },
        { 2, 28, 0, 0.09599, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0 },
        { 1, 0, 0, -0.0480044, 0, 0, 0, 0.5, 0, 0, 0, 0, 0, 0.855951 },
        { 2, 102, -12, 0.172915, 0, 0, 0, 0.234944, 0, 0, 0, 0, 0, 0.802479 },
        { 3, 0, 0, 18, 0.454, 0.67515, 0.394035 },
        { 3, 1, 0, 18, 0.468, 0.708555, 0.166667 },
        0, 0.2, 0, 0.8, 0.643184, 0.387165, 0.666667, 0.612061,
        0.718653,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 3, 0.00187547, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.21037, 0.166667, 0, 0, 0, 0 },
        { 2, 3, 0.00127513, 1, 3, 0.576229, 0.355208, 3, 3.86107, 0.147428, 3, 0.749223, 0.507315, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Hydrogenous",
        "",
        { 1, 2, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 1, 0 },
        { 2, 22, 0, 0.0722797, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0 },
        { 1, 0, 0, -0.0480044, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.771484, 0.778032 },
        { 2, 53, -12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.772631, 0.7572 },
        { 3, 0, 0, 18, 0.454, 0.67515, 0.394035 },
        { 3, 1, 0, 18, 0.468, 0.708555, 0.166667 },
        0, 0.2, 0, 0.8, 0.643184, 0.366565, 0.666667, 0.666667,
        0.718653,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 3, 0.00187547, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.21037, 0.225724, 0, 0, 0, 0 },
        { 2, 3, 0.21037, 1, 3, 0.0533199, 1, 3, 0.716373, 0.345802, 3, 0.749223, 0.5, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "DragonPurr",
        "",
        { 3, 46, 0, -0.0527965, 0, 0, 0.610062, 1, 0, 4.6921e-05, 0, 0, 0.6296, 0 },
        { 2, 0, 0, 0.0527223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 2, 12, -24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.746103, 0.749556 },
        { 0, 2, 0, 0.0527223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 4, 0, 4.91945, 11, 0.0281141, 0.712092, 0.655508 },
        { 4, 1, 4.4375, 9, 0.0503323, 0.729361, 0.620264 },
        0.281583, 0.40824, 0.5, 0.649024, 0.831514, 0.319207, 0.888889, 0.666667,
        0.271445,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        { 0.19079, 0, 0.1, 0, 0 },
        60, 0,
        { 2, 3, 0.563986, 0.71307, 3, 0.99592, 1, 3, 0.1, 1, 3, 2.74719, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Soft Synth Strings",
        "",
        { 8, 18, 0, 0, 0, 0, 0.603972, 0.5, 0, 0.140278, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 6.09356, 3, -0.144256, 0, 0 },
        { 1, 1, 5.73403, 3, -0.133258, 0, 0 },
        0, 0, 0, 1, 0.851618, 0.166667, 0.859382, 0.81569,
        0.614999,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 1, 0.0989746, 1, 3, 0.001, 1, 3, 0.001, 1, 1, 2.04412, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "FM E.Piano 1",
        "",
        { 4, 71, 0, 8.32677e-05, 0, 0, 0.0481282, 0.608732, 18, 0.782334, 0, 0, 1.12633, 0 },
        { 4, 6, 0, 0.000387602, 0, 0, 0.059057, 0.685905, 19, 0.65254, 0, 0, 0.395513, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.729565, 0.491163, 0, 0.5, 0, 0.5, 0, 0.5,
        0.638523,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.48943, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 1, 0.00220639, 1, 3, 0.000999999, 1, 1, 50, 0, 0, 0.96949, 0.126817, 0, 0, 0, 0 },
        { 2, 3, 0.00247489, 1, 3, 0.576229, 0.234944, 1, 17.5782, 0, 3, 0.2, 0.363445, 0, 0, 0, 0 },
        { 1, 3, 0, 1, 3, 0.1, 1, 0, 3.6847, 0, 3, 2.40041, 0.469889, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "FM E.Piano 2",
        "",
        { 4, 0, 0, 0, 0, 0, 0.0720001, 0.438151, 18, 0.808482, 0, 0, 0.838326, 0.281583 },
        { 4, 3, 0, 0, 0, 0, 0.0437833, 0.59176, 19, 0.6296, 0, 0, 0.222222, 0.851618 },
        { 4, 4, 0, 0, 0, 0, 0.333333, 0.759322, 20, 0.453597, 0, 0, 0.254635, 0.274392 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.946185, 0.228516, 0.971, 0.8, 0, 0.5, 0, 0.5,
        0.389001,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 2, 3, 0.000289735, 1, 3, 1.60932, 0.918221, 3, 12.5991, 0, 1, 0.2, 0, 0, 0, 0, 0 },
        { 1, 3, 0.000289735, 1, 3, 0.000999999, 1, 1, 19.2413, 0, 1, 0.2, 0.396028, 0, 0.469889, 0, 0 },
        { 1, 3, 0.000289735, 1, 3, 0.000999999, 1, 1, 3.89842, 0, 1, 0.2, 0.486754, 0, 0.469889, 0, 0 },
        { 1, 3, 0.000289735, 1, 3, 0.000999999, 1, 0, 5.86081, 0, 1, 0.2, 0.486754, 0, 0.469889, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Early Semisolid Bass",
        "",
        { 4, 14, -12, 0, 0, 0, 0.0588, 0.5, 18, 0.850042, 0, 0, 0.5, 0.5 },
        { 4, 152, -12, 0, 0, 0, 0.0629861, 0.5, 18, 0.838666, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.951095, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.71585,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0, 1, 3, 0.000999999, 1, 2, 1.92203, 0, 2, 0.560596, 0.118538, 0, 0, 0, 0 },
        { 2, 0, 0, 1, 3, 0.114284, 0.785205, 3, 0.850711, 0, 3, 0.731561, 0.18968, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "SpaceBass",
        "",
        { 4, 132, -12, 0, 0, 0, 0.169044, 0.5, 18, 0.730524, 0, 0, 0.5, 0.5 },
        { 2, 108, -12, 0, 0, 0, 0, 0, 0, 0, 18, 0.444444, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 3.20609, 18, 0.166029, 0.423867, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1.019, 0.5, 0, 0.492685, 0.862166, 0.5, 0, 0.5,
        0.605778,
        1, 0, 0, 0, 0.931722, 0.196778, 0, 0.153421,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.00224961, 1, 3, 0.001, 1, 3, 0, 1, 2, 1.18524, 0.153421, 0, 0, 0, 0 },
        { 1, 3, 0, 1, 3, 0.1, 1, 1, 0.213904, 0.873904, 3, 0.2, 0.381462, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Waveshaper Bass",
        "",
        { 6, 112, -12, 0, 0, 0, 0.135071, 0.464954, 18, 1, 0, 0, 0.725753, 0.5 },
        { 2, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 1.03292 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.705374, 0.481324, 0.628774, 0.522852, 0, 0.5, 0, 0.5,
        0.542999,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.554607, 141, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 2, 3, 0.00197718, 1, 3, 0.00227883, 1, 3, 29.7041, 0, 2, 0.284457, 0.120264, 0, 0, 0, 0 },
        { 2, 3, 0.00120751, 1, 3, 0.280701, 0.480761, 3, 8.23774, 0.0060614, 3, 0.343757, 0.850976, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Waveshaper Clav",
        "",
        { 6, 39, 0, 0, 0, 0, 0, 0.10761, 18, 0.723167, 0, 0.333333, 0.5, 0.5 },
        { 6, 1, 0, 0.09599, 0, 0, 0, 0.303222, 18, 0.856816, 0, 0.352572, 0.375634, 0.69925 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 3, 0, 15.7047, 7, 0.0847, 0.41125, 0 },
        { 3, 0, 15.8521, 7, -0.0622782, 0.333333, 0 },
        0.222222, 0.833333, 0.222222, 0.179912, 0.666667, 0.166667, 0.666667, 0.833333,
        0.708096,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.48943, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 3, 0.00220639, 1, 3, 0.001, 1, 3, 0.0012572, 1, 3, 0.2, 0.104818, 0, 0, 0, 0 },
        { 2, 3, 0.00247489, 1, 3, 1.77309, 0.225724, 1, 10, 0, 3, 0.2, 0.631621, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "PADsynth Strings",
        "",
        { 8, 98, 0, 0, 0, 0, 0.409467, 0.5, 0, 0.69419, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.996868, 0, 0.977369, 1, 0, 0.5, 0, 0.5,
        0.515,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.189836, 1, 3, 0.001, 1, 3, 0.001, 1, 1, 1.85185, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "PADsynth Choir A",
        "",
        { 8, 165, 0, 0, 0, 0, 0.541889, 0.5, 0, 0.128501, 0, 0, 1.06147, 1.0041 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 5, 0, 4.29604, 10, 0.130744, 0.639143, 0 },
        { 5, 2, 3.60001, 12, 0.130744, 0.640278, 0 },
        0.690351, 0.185905, 0.609377, 0.806944, 0.207593, 1, 0.251317, 0,
        0.427001,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 0.199477, 0, 0, 0, 0 },
        136.296, 0,
        { 1, 1, 0.0525728, 1, 3, 0.001, 1, 3, 0.001, 1, 2, 2.54087, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "PADsynth Choir B",
        "",
        { 8, 121, 0, 0, 0, 0, 0.593875, 0.5, 0, 0.379736, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.996868, 0.255417, 0.977369, 0.734944, 0, 0.5, 0, 0.5,
        0.583999,
        2, 0, 0, 0, 0.042, 0.029, 0, 0.166667,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 2, 0.042417, 1, 3, 0.001, 1, 3, 0, 1, 2, 2.11327, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Simulated Wood Grain Bass",
        "",
        { 8, 21, -12, 0, 0, 0, 0.473611, 0.5, 3, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 1.92015, 18, 0.233431, 0.720498, 0 },
        { 0, 1, 50, 0, 0, 0, 0 },
        0, 0, 0, 1, 1.08029, 0.492144, 0.909961, 0.5,
        0.628584,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.00068532, 1, 3, 0.001, 1, 3, 0.001, 1, 1, 0.454766, 0.0894279, 0, 0, 0, 0 },
        { 2, 3, 0, 1, 0, 0.137503, 0.142519, 3, 4.56835, 0, 3, 0.2, 0.333333, 0.174063, 0.239079, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Malarky",
        "",
        { 8, 134, 0, 0, 0, 0, 0.368379, 0.5, 0, 0.641815, 18, 0, 0.52, 0.52 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0.444444, 0.627198, 0 },
        { 1, 3, 11, 0, 0, 0, 1, 0.0565004, 0, 0, 18, 0.444444, 0, 0.618271 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 5, 0, 2.32015, 18, 0.480614, 0.599855, 0 },
        { 5, 1, 1.78435, 18, 0.503625, 0.63831, 0 },
        0.810405, 0.185905, 0.742176, 0.806944, 0.802246, 0.166667, 0.864019, 0.805205,
        0.548,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 0.199477, 0, 0, 0, 0 },
        136.296, 0,
        { 1, 1, 0.0525728, 1, 3, 0.001, 1, 3, 0.001, 1, 2, 2.54087, 0, 0, 0, 0, 0 },
        { 1, 1, 2.2951e-07, 1, 3, 0.1, 1, 1, 0.270433, 0, 3, 0.2, 0.480761, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Wide Load",
        "",
        { 8, 17, 0, 0, 0, 0, 0.532393, 0.5, 4, 0, 0, 0, 0.382438, 0.397035 },
        { 2, 148, -12, 0, 7, 0.00078398, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 148, -12, 0, 7, -0.000899977, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.996868, 0, 0.977369, 1, 0, 0.5, 0, 0.5,
        0.548999,
        1, 0, 0, 0, 0.89083, 0.387939, 0.356816, 0.224555,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.368403, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.000512424, 1, 3, 0.001, 1, 3, 0.001, 1, 2, 1.36657, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Double Lush Bells",
        "",
        { 8, 81, 0, 0, 0, 0, 0.247413, 0.585921, 4, 0.211462, 0, 0, 1.06147, 1.0041 },
        { 8, 79, 0, 0, 0, 0, 0.247413, 0.585921, 4, 0.211462, 18, 1, 1.06147, 1.0041 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.690351, 0.185905, 0.609377, 0.806944, 0, 1, 0, 0,
        0.71931,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.307589, 141, 0, 0, 0 },
        { 0.199477, 0, 0, 0, 0 },
        136.296, 0,
        { 1, 1, 0.000100269, 1, 3, 0.001, 1, 1, 4.18143, 0, 2, 4.88803, 0.320865, -0.196778, 0.666667, 0, 0 },
        { 2, 1, 0.00583481, 0, 3, 0, 1, 1, 4.18143, 0, 2, 4.88803, 0.320865, -0.196778, 0.666667, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Helianthus",
        "",
        { 3, 118, 0, 0, 0, 0, 0.401611, 1, 3, 0.008, 10, 0.114681, 0.822591, 0 },
        { 3, 118, 0, 0, 0, 0, 0.409467, 1, 3, 0.002, 14, 0.141101, 0, 0.957756 },
        { 1, 3, 0, -0.031211, 0, 0, 0, 0.0983891, 13, 0.0156904, 0, 0, 0.66386, 0 },
        { 1, 3, 0, 0.0565004, 0, 0, 0, 0.0859207, 15, 0.019, 0, 0, 0, 0.674532 },
        { 2, 0, 5.76487, 18, 0.593884, 0.636555, 0 },
        { 2, 1, 4.64745, 18, 0.624676, 0.666667, 0 },
        0, 0, 0, 1, 0.511534, 0.333333, 0.515835, 0.714795,
        0.419254,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.190051, 0, 0.1, 0, 0 },
        { 0.861417, 0, 0.1, 0, 0 },
        69.3575, 0.917111,
        { 2, 3, 0.0014708, 1, 3, 0.001, 1, 3, 0.528654, 1, 0, 1.35137, 0.133435, 0, 0, 0, 0 },
        { 2, 3, 0.00187547, 1, 3, 0.001, 1, 1, 2.13686, 0, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Moose Invasion",
        "",
        { 2, 12, 0, -0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.971, 0 },
        { 2, 12, 0, 0.05, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.888889 },
        { 2, 23, 0, 0, 0, 0, 0, 0, 0, 0, 20, 1, 0.634712, 0.755664 },
        { 2, 24, 0, 0.08, 0, 0, 0, 0, 0, 0, 21, 1, 0.579246, 0.587287 },
        { 2, 0, 6.42503, 0, 0, 0, 0 },
        { 2, 1, 6.2389, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.888889, 0.145516, 0.888889, 0.850976,
        0.612061,
        1, 0, 0, 0, 0.333333, 0.484868, 0.298288, 0.265056,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.000999999, 1, 3, 0, 1, 6, 3.54994, 0, 0, 0, 0, 0 },
        { 1, 1, 0.441942, 1, 1, 0.1, 1, 1, 1.25, 0.84, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.507658, 1, 1, 0.1, 1, 1, 0.824692, 0.85, 1, 2.03063, 0, 0, 0, 0, 0 },
        { 1, 1, 0.507658, 1, 1, 0.1, 1, 1, 0.883883, 0.84, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0592077, 1, 1, 0.1, 1, 1, 1.89465, 0.46, 1, 2.17638, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "pseudo steel drums",
        "Contributed by Nigel Henry",
        { 2, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.769454, 0 },
        { 2, 80, 0, -0.283428, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 2, 80, 0, -0.107399, 0, 0, 0, 0, 0, 0, 0, 0, 0.372768, 0.365013 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 14.5722, 17, 0.199214, 0.812183, 0 },
        { 0, 0, 50, 19, 0, 0, 0 },
        0, 0.5, 0.759912, 0.5, 0.940932, 0.5, 0, 0.5,
        0.532,
        1, 0, 0, 0, 0.333333, 0.685905, 0.28693, 0.41125,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0, 1, 3, 0.001, 1, 3, 0, 1, 0, 4.02331, 0, 0, 0, 0, 0 },
        { 0, 3, 0.740741, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.349, 0, 0, 0, 0, 0 },
        { 0, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "more pseudo steel drums",
        "Contributed by Nigel Henry",
        { 2, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.769454, 0 },
        { 2, 80, 0, -0.283428, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 4, 80, 0, -0.107399, 0, 0, 0, 0, 0, 0, 0, 0, 0.372768, 0.365013 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 14.5722, 17, 0.199214, 0.812183, 0 },
        { 0, 0, 50, 19, 0, 0, 0 },
        0, 0.5, 0.759912, 0.5, 0.940932, 0.5, 0, 0.5,
        0.54,
        1, 0, 0, 0, 0.333333, 0.685905, 0.28693, 0.41125,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0, 1, 3, 0.001, 1, 3, 0, 1, 0, 4.02331, 0, 0, 0, 0, 0 },
        { 0, 3, 0.740741, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.349, 0, 0, 0, 0, 0 },
        { 0, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Spooky Bell",
        "",
        { 2, 32, -12, 0, 0, 0, 0, 0, 0, 0, 19, 0.203805, 0.5, 0.888889 },
        { 2, 36, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.866409, 0.833383 },
        { 2, 40, -12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.14932, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 12.86, 12, 0.111111, 0.656569, 0 },
        { 1, 1, 14.8133, 10, 0.083859, 0.69906, 0 },
        0, 0.2, 0, 0.8, 0.5, 0.274276, 0.5, 0.734944,
        0.492,
        1, 0, 0, 0, 0.676764, 0.541889, 0.131621, 0.274276,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 2.71442, 13, 2.27175, 0, 0 },
        180, 0,
        { 1, 3, 0.00257275, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.771268, 0, 0, 0, 0, 0 },
        { 1, 3, 0.000617682, 1, 3, 0.1, 1, 2, 8.73652, 0, 3, 6.58727, 0, 0, 0, 0, 0 },
        { 1, 3, 0.740741, 1, 3, 0.1, 1, 3, 4.20573, 0.93561, 3, 5.08479, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Sync Leslie",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.515835, 0.5 },
        { 1, 2, 11, 0, 6, 0.195846, 0.968789, 0.637246, 0, 0, 0, 0, 0.5, 0 },
        { 1, 2, 20, 0, 6, -0.213973, 0.968789, 0.693056, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 1, 3.03473, 5, 0.167826, 0.261633, 0 },
        { 0, 0, 3.26388, 5, -0.130744, 0.198262, 0 },
        0.976018, 0.422083, 0.940932, 0.645516, 0, 0.131621, 0, 0.906125,
        0.72098,
        1, 0, 0, 0, 0.516291, 0.431722, 0.60761, 0.319207,
        0.984375, 2,
        { 4.542, 0, 0, 0, 0 },
        { 1.03809, 0, 0, 0, 0 },
        { 0.341885, 0, 0, 0, 0 },
        89.2927, 0,
        { 1, 3, 0.00360733, 1, 3, 0.001, 1, 2, 0.231482, 0.946722, 3, 1.06077, 0.291445, 0, 0, 0, 0 },
        { 0, 3, 0.00447341, 1, 3, 0.1, 1, 2, 0.17747, 0, 3, 0.2, 0.479851, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Mighty Synchronoton Delayed",
        "",
        { 1, 2, 0, 0, 9, 0, 0, 0.0496018, 0, 0, 0, 0, 0.222222, 0.222222 },
        { 2, 121, 14, 0, 7, 0.528369, 1, 0.409467, 0, 0, 0, 0, 1.08029, 0.5 },
        { 2, 121, 17, 0, 7, 0.162751, 1, 0.154198, 0, 0, 0, 0, 0.5, 0.952611 },
        { 1, 0, -12, 0.001602, 11, 0.00291594, 0, 0, 0, 0, 0, 0, 0.697459, 0.674532 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.591942, 0, 0.604124, 1, 0, 0.5, 0, 0.5,
        0.446,
        2, 0, 0.7428, 0.771484, 0.134273, 0.259322, 0.320865, 0.322175,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.0631072, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 2, 3, 0.00569756, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "amSynth Derren 1",
        "an imitation of the amSynth patch",
        { 1, 2, 0, 0, 0, 0, 0, 0.655508, 0, 0, 8, 0.0951084, 0.414422, 0.5 },
        { 1, 2, -12, 0, 7, 0.121833, 1, 0.80094, 0, 0, 8, 0.0387217, 0.802479, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 3.0351, 22, 0.173981, 0.962933, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.5, 0.5, 0, 0.5,
        0.448722,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.597626, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.00439018, 1, 3, 0.000999999, 1, 4, 1.3291, 0.739459, 3, 0.104789, 0, 0, 0, 0, 0 },
        { 1, 3, 0, 1, 3, 0.1, 1, 2, 1.62921, 0, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 18, 0.776282, 7, 0.0151343
    },
    {
        "amSynth Sexy Boy",
        "an imitation of the amSynth patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.888889, 0.5 },
        { 1, 2, -12, 0, 0, 0, 0, 0.5565, 0, 0, 0, 0, 0.33332, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 2, 0, 0.0731735, 18, 0.244671, 0.890461, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.851618, 0.493571, 0, 0.503789,
        0.57661,
        1, 0, 0, 0, 0.356816, 0.151535, 0.639143, 0.0905332,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 2, 3, 0, 1, 3, 0.876543, 1, 6, 7.17259, 0, 3, 0.154065, 0.265056, 0, 0, 0, 0 },
        { 2, 3, 0, 1, 3, 0.191641, 1, 3, 7.17259, 0, 3, 1.32702, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "amSynth Flangey Bass 1",
        "an imitation of the amSynth patch",
        { 1, 2, 0, -0.0904532, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.419732, 0.5 },
        { 1, 2, 0, 0.0875367, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.604124, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 2, 0, 2.77301, 18, 0.263861, 0.855801, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.5, 0.5, 0, 0.5,
        0.422379,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.000317944, 1, 3, 0.001, 1, 3, 2.82219, 0.833333, 3, 0.138018, 0, 0, 0, 0, 0 },
        { 1, 2, 0.193462, 1, 3, 0.1, 1, 2, 0.522679, 0, 2, 3.7598, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "amSynth Lazy Moon Lead",
        "an imitation of the amSynth patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.11116, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 2.36096, 18, 0.196016, 0.804366, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 1.0936, 0.5, 0.5, 0.5,
        0.427611,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.00242286, 1, 3, 0.001, 1, 3, 0.001, 1, 5, 0.255083, 0, 0, 0, 0, 0 },
        { 1, 3, 0.000935304, 1, 3, 0.1, 1, 2, 0.436029, 0, 2, 0.300429, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "amSynth Encounter",
        "an imitation of the amSynth patch",
        { 4, 58, 0, 0, 7, 0.00386508, 0.0481282, 0.716269, 0, 0.728516, 7, 0.0269601, 0.888889, 0 },
        { 4, 14, 0, 0, 0, 0.00330853, 0.046403, 0.712092, 0, 0.741938, 7, 0.0160496, 0.822591, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 2, 0, 1.83029, 22, 0.548784, 0.166667, 0 },
        { 0, 1, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.866409, 0.5, 0, 0.491516,
        0.627185,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 5.44536, 12, 0, 18, 0.823001 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 9.826e-05, 1, 3, 0.001, 1, 4, 0.231482, 0.919833, 6, 1.2304, 0, 0, 0, 0, 0 },
        { 1, 4, 1.74466, 1, 3, 0.1, 1, 3, 4.11821, 0.285205, 3, 2.54087, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 18, 0.739716, 7, 0.197541
    },
    {
        "amSynth Artic",
        "an imitation of the amSynth patch",
        { 5, 24, 0, 0, 0, 0, 0.106056, 0.5, 0, 0.716651, 8, 0.0526065, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 2, 0, 0.51319, 22, 0.141101, 0.359722, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 1.12821, 0.5, 0.5, 0.5,
        0.826262,
        1, 0, 0, 0, 0.798288, 0.423867, 0.414079, 0.208555,
        0.984375, 2,
        { 1.02684, 0, 0, 0, 0 },
        { 1.94054, 13, 1.72427, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.0412923, 1, 3, 0.001, 1, 3, 3.08576, 0.940518, 2, 7.41817, 0, 0, 0, 0, 0 },
        { 1, 3, 0.552625, 1, 3, 0.1, 1, 3, 15.5712, 1, 1, 1.85163, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 18, 0.552471, 8, 0.0786876
    },
    {
        "Bristol Mini 0",
        "an imitation of the Bristol Mini patch",
        { 2, 148, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.18095, 0.5 },
        { 1, 0, 0, -0.0430675, 0, 0, 0, 0, 0, 0, 0, 0, 0.913414, 0.5 },
        { 1, 3, 0, 0.0513497, 0, 0, 0, 0.493571, 0, 0, 0, 0, 0.922449, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 1.37619, 18, 1, 0.182958, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.855951, 0.5, 0, 0.5,
        0.488127,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.805759, 0.832251, 2, 4.02331, 0, 0, 0, 0, 0 },
        { 1, 3, 5.21095e-05, 1, 3, 0.1, 1, 1, 5.69955, 0.218653, 3, 3.13305, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Bristol Explorer 0",
        "an imitation of the Bristol Explorer patch",
        { 1, 2, -12, -0.00671158, 0, 0, 0.173981, 0.382935, 0, 0, 0, 0, 0.639288, 0.5 },
        { 1, 2, 0, 0.00403808, 0, 0, 0, 0.389834, 0, 0, 0, 0, 1.26458, 0.5 },
        { 1, 3, -24, 0, 0, 0, 0, 0.389834, 0, 0, 0, 0, 0.932864, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 14.5722, 18, 0, 0.166667, 0 },
        { 1, 2, 6.50633, 22, 0.478315, 0.166667, 0 },
        0, 0.2, 0, 0.8, 0, 0.5, 0.484964, 0.5,
        0.529,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.22213, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.00275659, 1, 3, 0.001, 1, 2, 0.453425, 0.929079, 2, 1.78858, 0, 0, 0, 0, 0 },
        { 1, 3, 0.000608069, 1, 3, 0.1, 1, 3, 1.39396, 0, 3, 3.23882, 0.425093, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 18, 0.814872, 8, 0.622222
    },
    {
        "Circuit",
        "",
        { 8, 157, -36, 0, 0, 0, 0.356816, 0.414079, 0, 0, 0, 0, 1.03292, 0.971 },
        { 2, 72, 0, 0, 7, -0.233431, 0, 0, 0, 0, 10, 1, 1.05335, 0.5 },
        { 2, 72, -6, -0.223538, 7, 0.0432409, 0, 0, 0, 0, 12, 1, 0.70248, 0.749237 },
        { 2, 72, 10, 0.258574, 7, -0.271527, 0, 0, 0, 0, 14, 1, 0.5, 1.09986 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.5, 0, 0.5, 1, 0, 0.5, 0, 0.5,
        0.574999,
        1, 0, 0, 0, 0.798288, 0.344492, 0.10761, 0.363445,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.368403, 137, 0, 0, 0 },
        { 0.291058, 19, 0, 0, 0 },
        90, 1,
        { 1, 1, 0.0869095, 1, 3, 0.001, 1, 3, 0.001, 1, 1, 2.40041, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Headache",
        "",
        { 6, 105, 0, 0, 0, 0, 0.241574, 0.467607, 9, 0.295167, 0, 0, 0.833383, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0.420581, 0, 0.9848 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 3, 0, 8.33333, 11, 0.0712193, 0.645516, 0.182958 },
        { 5, 1, 17.8408, 15, -0.355902, 0.848465, 0 },
        0.780695, 0.422083, 0.130475, 0.59176, 0.922449, 0.680793, 0.888889, 0.58875,
        0.397001,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1.50544, 141, 0, 0, 0 },
        90, 0,
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 2, 3.23882, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "LFO Madness",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0, 0.5 },
        { 1, 2, 16, 0, 7, -0.310756, 0.940943, 0.493157, 9, 0.291445, 9, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 2, 0, 3.8405, 6, 1, 0.875222, 0 },
        { 2, 0, 2.9515, 6, 1, 0.885319, 0 },
        0, 0.2, 0, 0.8, 0.5, 0.234944, 0.5, 0.744583,
        0.319796,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 0.137754, 0, 0, 0, 0 },
        { 0.198367, 0, 0, 0, 0 },
        { 3.34863, 146, 0, 0, 0 },
        90, 0,
        { 2, 3, 0.064087, 1, 3, 0.1, 1, 3, 0.1, 1, 1, 2.40041, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Swarmed!",
        "",
        { 3, 41, 0, 0, 0, 0, 0.868379, 0.5, 17, 0.389834, 0, 0, 1, 0 },
        { 3, 41, 0, 0, 0, 0, 0.854481, 0.765056, 17, 0.436657, 0, 0, 0, 1 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 1, 50, 0, 0, 0, 0 },
        0.490402, 0.333333, 0.5, 0.666667, 0, 0.5, 0, 0.5,
        0.313001,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 64, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 3, 1.02412, 0.708555, 3, 1.73542, 1, 3, 0.0368403, 1, 2, 2.96216, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Wind Cliche",
        "",
        { 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0 },
        { 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.872665, 0.875222 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 4, 0, 4.93276, 11, 0.0424621, 0.833333, 0.624826 },
        { 4, 1, 5.23333, 9, 0.0407779, 0.788538, 0.627818 },
        0, 0, 0, 0, 0.5, 0.451872, 0.519464, 0.631621,
        0.287851,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.247489, 0, 0.1, 0, 0 },
        { 0.1, 9, 1.66086, 0, 0 },
        30, 0,
        { 2, 3, 3.47758, 0.708555, 3, 3.25473, 1, 3, 0.1, 1, 3, 3.47758, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Grave Fight",
        "cello-fm with amsynth filter (contributed by Idiomdrottning)",
        { 4, 98, 0, 0, 0, 0, 0.5, 0, 0, 0.507215, 6, -0.0387217, 0.5, 0.5 },
        { 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0465372, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 6, 0, 13.7138, 18, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 2, 0.5, 0, 0.5,
        0.576133,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 167, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.112463, 1, 3, 0.001, 1, 3, 0, 1, 3, 1.30717, 0, 0, 0, 0, 0 },
        { 1, 3, 2.65454, 1, 3, 0.1, 1, 3, 28.9352, 0.234944, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "off into space",
        "Contributed by Ken Restivo: \042man, this is fun\042",
        { 8, 157, -36, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1.46827, 1.46028 },
        { 8, 71, -12, 0, 0, -0.233431, 0.0761335, 0.685905, 0, 0, 0, 1, 1.05335, 0.5 },
        { 8, 40, -6, 0, 6, 0.00419728, 0.166667, 0.120264, 0, 0, 0, -0.00701863, 0.158313, 0.125444 },
        { 0, 72, 10, 0.258574, 7, -0.271527, 0, 0, 0, 0, 14, 1, 0.5, 1.09986 },
        { 3, 0, 33.3333, 7, 1, 0.312183, 1 },
        { 3, 1, 32.0139, 12, 1, 0.34746, 0 },
        0.744606, 0, 0.744606, 1, 0.192015, 0, 0.134496, 1,
        0.278851,
        0, 0, 0, 0, 0.798288, 0.344492, 0.10761, 0.363445,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.214166, 140, 0, 0, 0.306546 },
        { 2.11193, 166, 0, 0, 0.271527 },
        145.773, 0.760726,
        { 1, 1, 0.0869095, 1, 3, 0.001, 1, 3, 0.001, 1, 1, 2.40041, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "Faery Biker Gang",
        "",
        { 2, 44, -12, 0, 9, 0.522618, 0, 0.375222, 0, 0, 8, 0, 1.0041, 0 },
        { 2, 44, -13, 0, 11, 0.444444, 0, 0.375222, 0, 0, 8, 0, 0.5, 0.5 },
        { 2, 44, -12, 0, 15, 0.607881, 0, 0.375222, 0, 0, 8, 0, 0, 1.06147 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.557839, 0.147428, 0.557839, 0.854484, 0, 0, 0, 1,
        0.549999,
        1, 0, 0, 0, 0.849625, 0.414079, 0.187817, 0.300101,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 0.298629, 61, 0, 0, 0 },
        90, 1,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "============= Conversions from",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.658, 0 },
        { 1, 0, 12, 0.0239606, 0, 0, 0, 0, 0, 0, 0, 0, 0.742, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 11, 19, 0.62, 0.19, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.6296,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.18197, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00181426, 1, 3, 0.001, 1, 2, 0.137368, 0.950281, 0, 1.77955, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00181426, 1, 3, 0.1, 1, 0, 0.137368, 0.65, 0, 1.77955, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00137626, 1, 3, 0.1, 1, 0, 0.023872, 0.59, 0, 0.709668, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "========= Xsynth-DSSI patches:",
        "",
        { 1, 1, 0, -0.0239938, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 2, 0, 0.0240471, 0, 0, 0, 0.598389, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 3, 0, 0, 19, 0.5, 0.431722, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.663001,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.0539244, 2,
        { 1, 0, 0, 0, 0 },
        { 0.382727, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00617905, 1, 3, 0.001, 1, 2, 0.005815, 1, 0, 0.878256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00617905, 1, 3, 0.1, 1, 0, 0.005815, 1, 0, 0.878256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0028128, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.938391, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: strings",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.0527969, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0.0527218, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 11.4258, 18, 0.291444, 0.194795, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.396419, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 3.26843, 0, 0, 0, 0, 0 },
        { 1, 0, 0.522, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: strings",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.0603371, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0.0401298, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, -0.0374974, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 1, 0, 0, 0.0572314, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 2, 0, 11.4258, 18, 0.220795, 0.128501, 0 },
        { 2, 1, 11.4258, 18, 0.144626, 0.265056, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.201712, 0.71, 0.820088,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.522, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 2.349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.522, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Quick Strings",
        "Imported Xsynth-DSSI patch",
        { 1, 1, 0, -0.0359948, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 2, 0, 0, 0.0359716, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 3, 0, 8.33333, 19, 0.143184, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.533199, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0818036, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 2.349, 0.291445, 0, 0, 0, 0 },
        { 1, 0, 0.195799, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.349, 0.291445, 0, 0, 0, 0 },
        { 1, 0, 0.036306, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.878256, 0.401611, 0, 0, 8, 0.0350456 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Quick Strings",
        "Imported Xsynth-DSSI patch",
        { 1, 1, 0, -0.0659948, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 2, 0, 0, 0.0459716, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 1, 0, -0.0459948, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 2, 0, 0, 0.0659716, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 2, 0, 7.73333, 19, 0.137194, 0, 0 },
        { 2, 1, 7.23333, 19, 0.143184, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.10775, 0.71, 0.882372,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.533199, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.195799, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 2.349, 0.233156, 0, 0, 0, 0 },
        { 1, 0, 0.195799, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.349, 0.233156, 0, 0, 0, 0 },
        { 1, 0, 0.036306, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.878256, 0.321289, 0, 0, 8, 0.0350456 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: A-ha",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.658, 0 },
        { 1, 0, 12, 0.0239606, 0, 0, 0, 0, 0, 0, 0, 0, 0.742, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 11, 19, 0.62, 0.19, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.6296,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.18197, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00181426, 1, 3, 0.001, 1, 2, 0.137368, 0.950281, 0, 1.77955, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00181426, 1, 3, 0.1, 1, 0, 0.137368, 0.65, 0, 1.77955, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00137626, 1, 3, 0.1, 1, 0, 0.023872, 0.59, 0, 0.709668, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: A-ha VS",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.658, 0 },
        { 1, 3, 12, 0.0239606, 0, 0, 0, 0.0859207, 0, 0, 0, 0, 0.742, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 4.91945, 19, 0.458112, 0.19, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.682958,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.18197, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00181426, 1, 3, 0.001, 1, 2, 0.137368, 0.950281, 0, 1.83014, 0.234944, 0, 0, 0, 0 },
        { 1, 0, 0.00181426, 1, 3, 0.1, 1, 0, 0.137368, 0.65, 0, 1.83014, 0.234944, 0, 0, 0, 0 },
        { 1, 0, 0.00137626, 1, 3, 0.1, 1, 0, 0.023872, 0.59, 0, 0.709668, 0.774276, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Brass",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.0359948, 0, 0, 0, 0, 0, 0, 0, 0, 0.616, 0 },
        { 1, 0, 0, 0.0359716, 0, 0, 0, 0, 0, 0, 0, 0, 0.784, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 0, 19, 0.29, 0.45, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.530111,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.51189, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00125517, 1, 3, 0.001, 1, 2, 2.45647, 0.953779, 0, 1.22984, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00125517, 1, 3, 0.1, 1, 0, 2.45647, 0.67, 0, 1.22984, 0, 0, 0, 0, 0 },
        { 1, 0, 0.114474, 1, 3, 0.1, 1, 0, 0.314774, 0.73, 0, 3.40435, 0, 0, 0, 8, 0.05 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Brass",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.0659949, 0, 0, 0, 0, 0, 0, 0, 0, 0.616, 0 },
        { 1, 0, 0, 0.0459716, 0, 0, 0, 0, 0, 0, 0, 0, 0.784, 0 },
        { 1, 0, 0, -0.0459948, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.616 },
        { 1, 0, 0, 0.0659716, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.784 },
        { 2, 0, 0, 19, 0.239284, 0.469889, 0 },
        { 2, 1, 0, 19, 0.29, 0.45, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.166667, 0.71, 0.791445,
        0.530111,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.51189, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00125517, 1, 3, 0.001, 1, 0, 2.45647, 0.953779, 0, 1.22984, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00125517, 1, 3, 0.1, 1, 0, 2.45647, 0.67, 0, 1.22984, 0, 0, 0, 0, 0 },
        { 1, 0, 0.114474, 1, 3, 0.1, 1, 0, 0.314774, 0.73, 0, 3.40435, 0, 0, 0, 8, 0.05 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Xylophone",
        "Imported Xsynth-DSSI patch",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 2, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 19, 0.587299, 0.933, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.49,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00150904, 1, 3, 0.001, 1, 2, 0.455564, 0, 0, 0.854182, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00150904, 1, 3, 0.1, 1, 0, 0.455564, 0, 0, 0.854182, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00114472, 1, 3, 0.1, 1, 0, 4.47429, 0, 0, 10.213, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Shimmer Pad",
        "Imported Xsynth-DSSI patch",
        { 1, 3, 0, 0, 0, 0, 0, 0.0682776, 0, 0, 0, 0, 0.78268, 0 },
        { 1, 3, 0, 0.0119411, 0, 0, 0, 0.08875, 0, 0, 0, 0, 0.61732, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 3, 0, 4.91945, 19, 0.747412, 0.375222, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.84622,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.70426, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.295441, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 2.30255, 0.333333, 0, 0, 0, 0 },
        { 1, 0, 0.484583, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 1.43878, 0.333333, 0, 0, 0, 0 },
        { 1, 0, 0.195799, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 1.39029, 0.774276, 0, 0, 8, 0.193056 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Shimmer Pad",
        "Imported Xsynth-DSSI patch",
        { 1, 3, 0, -0.03, 0, 0, 0, 0.0727919, 0, 0, 10, -0.0653409, 0.78268, 0 },
        { 1, 3, 0, 0.0219411, 0, 0, 0, 0.08875, 0, 0, 12, -0.0548167, 0.61732, 0 },
        { 1, 3, 0, -0.01, 0, 0, 0, 0.0622776, 0, 0, 14, -0.0455452, 0, 0.78268 },
        { 1, 3, 0, 0.0419411, 0, 0, 0, 0.09675, 0, 0, 16, -0.0562055, 0, 0.61732 },
        { 3, 0, 4.91945, 19, 0.599898, 0.618435, 0 },
        { 3, 1, 4.76945, 19, 0.58757, 0.635071, 0.368379 },
        0, 0.5, 0, 0.5, 0.71, 0, 0.71, 1,
        0.84622,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.70426, 0, 0, 0, 0 },
        { 0.651774, 0, 5.31908, 0, 0 },
        90, 0.20673,
        { 1, 0, 0.231985, 1, 3, 0.000999999, 1, 0, 0.0012528, 1, 0, 1.43878, 0.266666, 0, 0, 0, 0 },
        { 1, 0, 0.484583, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 1.43878, 0.266666, 0, 0, 0, 0 },
        { 1, 0, 0.195799, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 1.39029, 0.624566, 0, 0, 8, 0.162751 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Sun Dog",
        "Imported Xsynth-DSSI patch",
        { 1, 1, 0, -0.0239938, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 2, 0, 0.0240471, 0, 0, 0, 0.598389, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 3, 0, 0, 19, 0.5, 0.431722, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.663001,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.0539244, 2,
        { 1, 0, 0, 0, 0 },
        { 0.382727, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00617905, 1, 3, 0.001, 1, 2, 0.005815, 1, 0, 0.878256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00617905, 1, 3, 0.1, 1, 0, 0.005815, 1, 0, 0.878256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0028128, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.938391, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Sun Dog",
        "Imported Xsynth-DSSI patch",
        { 1, 1, 0, -0.0539938, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 2, 0, 0.0340471, 0, 0, 0, 0.598389, 0, 0, 0, 0, 0.7, 0 },
        { 1, 1, 0, -0.0339938, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 1, 2, 0, 0.0540471, 0, 0, 0, 0.598389, 0, 0, 0, 0, 0, 0.7 },
        { 3, 0, 0, 19, 0.5, 0.431722, 0 },
        { 3, 1, 0, 19, 0.5, 0.431722, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.663001,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.0539244, 2,
        { 1, 0, 0, 0, 0 },
        { 0.382727, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00617905, 1, 3, 0.001, 1, 0, 0.005815, 1, 0, 0.878256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00617905, 1, 3, 0.1, 1, 0, 0.005815, 1, 0, 0.878256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0028128, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.938391, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Organ 2",
        "Imported Xsynth-DSSI patch",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.826, 0 },
        { 1, 2, 12, 0.0239606, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.574, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 6.5, 7, 0.00854879, 0.03, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.51,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 6.62217, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00218123, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.0178184, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00218123, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0178184, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00165462, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0148211, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Organ 2",
        "Imported Xsynth-DSSI patch",
        { 2, 0, 0, -0.03, 0, 0, 0, 0, 0, 0, 0, 0, 0.826, 0 },
        { 1, 2, 12, 0.0339606, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.574, 0 },
        { 2, 0, 0, -0.01, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.826 },
        { 1, 2, 12, 0.0539606, 0, 0, 0, 0.5, 0, 0, 0, 0, 0, 0.574 },
        { 2, 0, 6.5, 9, 0.0187692, 0.03, 0 },
        { 2, 1, 6.5, 11, 0.0304669, 0.03, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.136555, 0.71, 0.865727,
        0.51,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 6.62217, 0, 0, 0, 0 },
        { 6.49111, 0, 0, 0, 0 },
        140.046, 0,
        { 1, 0, 0.00218122, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 0.0178184, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00218122, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0178184, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00165462, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0148211, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: French Horn",
        "Imported Xsynth-DSSI patch",
        { 1, 2, 0, 0, 0, 0, 0, 0.21, 0, 0, 0, 0, 0.616, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.784, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 0, 19, 0.25, 0.6, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.7,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.98107, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00239164, 1, 3, 0.001, 1, 2, 5.50378, 0, 0, 1.65423, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00239164, 1, 3, 0.1, 1, 0, 2.45647, 0, 0, 1.65423, 0, 0, 0, 0, 0 },
        { 1, 0, 1.044, 1, 3, 0.1, 1, 0, 1.84177, 0, 0, 2.83012, 0, 0, 0, 8, 0.132723 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: plucked",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.0527969, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0.0527218, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 10.9326, 0, 0, 0.696777, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.509221,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00782198, 1, 3, 0.001, 1, 2, 0.632727, 0, 0, 1.09256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00782198, 1, 3, 0.1, 1, 0, 0.632727, 0, 0, 1.09256, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: bell",
        "Imported Xsynth-DSSI patch",
        { 1, 3, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 1, 3, 24, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 15.4926, 0, 0, 0.901609, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.505,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 2.45647, 0, 0, 1.65423, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 2.45647, 0, 0, 1.65423, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: bell VS",
        "Imported Xsynth-DSSI patch",
        { 1, 3, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 1, 3, 24, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 3.325, 19, 0.40161, 0.833333, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5155,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 2.45647, 0, 0, 1.65423, 0.314095, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 2.45647, 0, 0, 1.65423, 0.314095, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 23.49, 0.708555, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: sync_bass",
        "Imported Xsynth-DSSI patch",
        { 1, 2, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 12, 0.149708, 18, 0.275399, 1, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 1e-06, 18, 1, 0.691519, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 2.72348, 0, 0, 2.13545, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 2.72348, 0, 0, 2.13545, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: sync_sweep",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0, 19, 1, 1, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 50, 0, 0, 0.0501253, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.531011,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0421818, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0421818, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 4.01538, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: sync_sweep",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0, 19, 1, 1, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 1, 0, 1, 0.123646, 19, 1, 1, 0, 0, 0, 0, 0, 0, 0.7 },
        { 2, 0, 50, 0, 0.62941, 0.0501253, 0 },
        { 2, 1, 50, 0, 0.645165, 0.0501253, 0 },
        0, 0.271484, 0, 0.708555, 0.787097, 0.25, 0.738379, 0.75,
        0.531011,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0421818, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0421818, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 4.01538, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Gramma's Organ",
        "Imported Xsynth-DSSI patch",
        { 1, 3, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.798, 0 },
        { 1, 3, 12, 0, 7, 0.003, 0, 0.5, 0, 0, 0, 0, 0.602, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 15, 0, 0, 0.05, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.640712,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 7.58577, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00218123, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.0178184, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00218123, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0178184, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00165462, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0148211, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Long Portamento",
        "Imported Xsynth-DSSI patch",
        { 1, 3, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 8, 0.390994, 7, 0.714795, 1, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 10, 0, 0, 0.68, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.002509, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0060076, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.854182, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0060076, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.854182, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00198929, 1, 3, 0.1, 1, 0, 0.378489, 0, 0, 0.709668, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Owww!",
        "Imported Xsynth-DSSI patch",
        { 1, 3, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.715621, 0 },
        { 1, 0, 6, 0.0620319, 18, 0.295167, 1, 0, 0, 0, 0, 0, 0.684379, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 1e-06, 19, 1, 0.752586, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.36,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.247489, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.858082, 0.985942, 0, 1.35, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.858082, 0.885319, 0, 1.35, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 1.76451, 0, 0, 2.30294, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Tube Growl",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 2, 10, 0.361363, 19, 1, 1, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 1e-06, 18, 0.349624, 0.798286, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.3325,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0085658, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 4.05, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0085658, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 4.05, 0, 0, 0, 0, 0 },
        { 1, 0, 4.97143, 1, 3, 0.1, 1, 0, 5.69455, 0.631621, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Tube Growl",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.00671157, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 2, 13, 0.361363, 19, 1, 1, 0.5, 7, 0.143814, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0.0155939, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 1, 2, 11, 0.352893, 19, 1, 1, 0.319207, 8, 0.265056, 0, 0, 0, 0.7 },
        { 2, 0, 1e-06, 18, 0.349624, 0.754029, 0 },
        { 2, 1, 1e-06, 18, 0.349624, 0.798286, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.303222, 0.71, 0.701712,
        0.3325,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.172416, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0085658, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 4.05, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0085658, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 4.05, 0, 0, 0, 0, 0 },
        { 1, 0, 4.97143, 1, 3, 0.1, 1, 0, 5.69455, 0.631621, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: squelchy_bass",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0, 18, 0.154198, 1, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 1e-06, 18, 1, 0.833333, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.45,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 2.72348, 0, 0, 2.349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 2.72348, 0, 0, 2.349, 0, 0, 0, 8, 0.800101 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 2.32, 0, 0, 5.10652, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: reso_sweep",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.692574, 0 },
        { 1, 0, 12, 0.0835031, 0, 0, 0, 0, 0, 0, 0, 0, 0.707426, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 11.9333, 19, 1, 0.919253, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.2108,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0421818, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0421818, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0188414, 1, 3, 0.1, 1, 0, 5.44696, 0, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: reso_sweep",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.03, 0, 0, 0, 0, 0, 0, 0, 0, 0.692575, 0 },
        { 1, 0, 12, 0.0935031, 0, 0, 0, 0, 0, 0, 0, 0, 0.707426, 0 },
        { 1, 0, 0, -0.01, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.692575 },
        { 1, 0, 12, 0.113503, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.707426 },
        { 2, 0, 11.9948, 19, 1, 0.844403, 0 },
        { 2, 1, 11.9333, 19, 1, 0.919253, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.624778,
        0.2108,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0421818, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0421818, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 2.83012, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0188414, 1, 3, 0.1, 1, 0, 5.44696, 0, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: theremin",
        "Imported Xsynth-DSSI patch",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 2, 0, 24, 0, 7, 0.050261, 0, 0, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5146,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.009709, 2,
        { 1, 0, 0, 0, 0 },
        { 10, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 2.26957, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 23.49, 0, 0, 0, 0, 0 },
        { 1, 0, 2.26957, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 23.49, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Twub",
        "Imported Xsynth-DSSI patch",
        { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.715621, 0 },
        { 1, 2, 7, 0.43645, 7, 0.193056, 1, 0.255417, 0, 0, 0, 0, 0.684379, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 0.623417, 19, 0.140278, 0.752586, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.289927,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.247489, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 2.45647, 0, 0, 1.65423, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 2.45647, 0, 0, 1.65423, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0170449, 1, 3, 0.1, 1, 0, 0.00310053, 0.610166, 0, 1.305, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Wavey",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 2, 10, 0.361363, 19, 1, 1, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 10.6535, 18, 0.349624, 0.757198, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.339089,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.087247, 2,
        { 1, 0, 0, 0, 0 },
        { 0.256842, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0085658, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 5.8725, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0085658, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 5.8725, 0, 0, 0, 8, 0.76999 },
        { 1, 0, 4.97143, 1, 3, 0.1, 1, 0, 1.71616, 0.631621, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Wavey",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 2, 10, 0.361363, 19, 1, 1, 0.5, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7 },
        { 1, 2, 11, 0.361363, 19, 0.745537, 1, 0.5, 0, 0, 0, 0, 0, 0.7 },
        { 2, 0, 10.6535, 18, 0.299527, 0.772198, 0 },
        { 2, 1, 10.6535, 18, 0.424178, 0.727198, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.291445, 0.71, 0.723167,
        0.339089,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.087247, 2,
        { 1, 0, 0, 0, 0 },
        { 0.256842, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.0085658, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 5.8725, 0, 0, 0, 0, 0 },
        { 1, 0, 0.0085658, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 5.8725, 0, 0, 0, 8, 0.76999 },
        { 1, 0, 4.97143, 1, 3, 0.1, 1, 0, 1.71616, 0.631621, 0, 9.7875, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: heart_beat",
        "Imported Xsynth-DSSI patch",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 2, 0, 12, 0.149708, 7, 0.923867, 0, 0, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 0.539044, 0, 0, 0.852571, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.18,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.932825, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 10.213, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 10.213, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: voice",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 2, 8, 0.483617, 19, 0.225724, 0, 0.931722, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 15.3472, 0, 0, 0.679133, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.291445,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.329338, 1, 3, 0.001, 1, 2, 0.366316, 0.973377, 0, 0.741009, 0, 0, 0, 0, 0 },
        { 1, 0, 0.329338, 1, 3, 0.1, 1, 0, 0.366316, 0.794001, 0, 0.741009, 0, 0, 0, 0, 0 },
        { 1, 0, 0.442373, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 23.49, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: VS Bass 1",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, -0.0480042, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 1, 0, 0, 0.0456445, 0, 0, 0, 0, 0, 0, 0, 0, 0.7, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 5.38461, 19, 0.825128, 0.369231, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.586264,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00228972, 1, 3, 0.001, 1, 2, 0.27, 0.950487, 0, 0.00978872, 0.166255, 0, 0, 0, 0 },
        { 1, 0, 0.00228972, 1, 3, 0.1, 1, 0, 0.27, 0.651163, 0, 0.00978872, 0.166255, 0, 0, 0, 0 },
        { 1, 0, 0.00214546, 1, 3, 0.1, 1, 0, 0.436516, 0.226667, 0, 0.191599, 0.758072, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: VS Bass 2",
        "Imported Xsynth-DSSI patch",
        { 1, 3, -12, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.975489, 0 },
        { 1, 2, 8, -1.18668e-05, 0, 0, 1, 0.856816, 0, 0, 0, 0, 0.424511, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 3, 0, 8.33333, 19, 0.752588, 0.281347, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.80025,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.215443, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00316049, 1, 3, 0.001, 1, 2, 12.528, 0, 0, 0.494159, 0.276833, 0, 0, 0, 0 },
        { 1, 0, 0.00316049, 1, 3, 0.1, 1, 0, 12.528, 0, 0, 0.494159, 0.276833, 0, 0, 0, 0 },
        { 1, 0, 0.00300209, 1, 3, 0.1, 1, 0, 0.221451, 0, 0, 1.26682, 0.614681, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Klaxon",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 0, 24, 0, 7, -0.89239, 1, 0, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5082,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.97177, 141, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Klaxon",
        "Imported Xsynth-DSSI patch",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 0, 24, -0.347185, 7, -0.89239, 1, 0, 0, 0, 0, 0, 1.4, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 0, 24, 0.340163, 7, -0.9216, 1, 0, 0, 0, 0, 0, 0, 1.4 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 1, 50, 0, 0, 0.02, 0 },
        0.70248, 0, 0.700359, 1, 0, 0, 0, 1,
        0.5082,
        0, 0, 0, 0, 0.806944, 0.373275, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.97177, 141, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Hammond pedals",
        "Xsynth-DSSI patch contributed by Silvan",
        { 1, 2, 0, 0, 0, 0, 0, 0.49, 0, 0, 0, 0, 1.4, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 8.5, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.51,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 6.139, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00347919, 1, 3, 0.001, 1, 2, 12.528, 0.468492, 0, 0.00602215, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00347919, 1, 3, 0.1, 1, 0, 12.528, 0.01, 0, 0.00602215, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 12.528, 0.01, 0, 0.00252578, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: space race",
        "Xsynth-DSSI patch contributed by Silvan",
        { 1, 2, 12, 0, 0, 0, 0, 0.64, 0, 0, 0, 0, 0.336, 0 },
        { 1, 0, 24, 0, 19, 1, 1, 0, 0, 0, 0, 0, 1.064, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 15.5, 19, 0.33, 0.6, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.53,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.28144, 2,
        { 1, 0, 0, 0, 0 },
        { 2.575, 144, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00329827, 1, 3, 0.001, 1, 2, 0.00782609, 0.952043, 0, 0.00865544, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00329827, 1, 3, 0.1, 1, 0, 0.00782609, 0.66, 0, 0.00865544, 0, 0, 0, 0, 0 },
        { 1, 0, 0.00613829, 1, 3, 0.1, 1, 0, 2.84727, 0.28, 0, 0.00978424, 0, 0, 0, 8, 0.703096 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Night Sweats 2",
        "Xsynth-DSSI patch contributed by Silvan",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.162, 0 },
        { 1, 0, 0, 0, 19, 0.29, 0, 0, 0, 0, 0, 0, 0.238, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 3.5, 19, 0.99, 0.955499, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.302555,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 10, 141, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 2, 0, 0.180169, 1, 3, 3.32028, 1, 2, 0.00314687, 0, 0, 0.0135171, 0, 0, 0, 0, 0 },
        { 1, 0, 3.16364, 1, 3, 0.1, 1, 0, 0.00314687, 0, 0, 0.0135171, 0, 0, 0, 0, 0 },
        { 1, 0, 3.18244, 1, 3, 0.1, 1, 0, 0.0198542, 1, 0, 1.35, 0, 0, 0, 8, 0.306546 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Tweetie",
        "Xsynth-DSSI patch contributed by Silvan",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.162, 0 },
        { 1, 0, 0, 0, 19, 0.29, 0, 0, 0, 0, 0, 0, 0.238, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 3.5, 19, 0.77, 1, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.080246,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 10, 141, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.137368, 0, 0, 0.0135171, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.137368, 0, 0, 0.0135171, 0, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.00345048, 0.22, 0, 1.35, 0, 0, 0, 8, 0.08 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Vitreous Humor",
        "Xsynth-DSSI patch contributed by Silvan",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.98, 0 },
        { 2, 0, 24, 0, 18, 1, 1, 0, 0, 0, 0, 0, 0.42, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 27, 19, 0.38, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.535501,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.158489, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.274861, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 6.525, 0, 0, 0, 0, 0 },
        { 1, 0, 1.37368, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 6.525, 0, 0, 0, 8, 0.384031 },
        { 1, 0, 0.0315313, 1, 3, 0.1, 1, 0, 1.81565, 0.81, 0, 5.33864, 0, 0, 0, 8, 0.75 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Vibrothingie",
        "Xsynth-DSSI patch contributed by Silvan",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.28, 0 },
        { 2, 0, 0, 0, 7, 0.74, 1, 0, 0, 0, 0, 0, 1.12, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 33.5, 19, 0.48, 0.8, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.414116,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.002, 2,
        { 1, 0, 0, 0, 0 },
        { 0.630957, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 12.528, 0.950281, 0, 0.0257563, 0.5, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 12.528, 0.65, 0, 0.0257563, 1, 0, 0, 0, 0 },
        { 1, 0, 0.0181426, 1, 3, 0.1, 1, 0, 12.528, 0, 0, 1.95382, 0.66, 0, 0, 8, 0.36 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Vibrato Hammond",
        "Xsynth-DSSI patch contributed by Silvan",
        { 1, 3, 24, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.98, 0 },
        { 1, 2, 12, 0, 19, 1, 1, 0.5, 0, 0, 0, 0, 0.42, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 10, 18, 0.37, 0.01, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.615634,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 7.58578, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.00218123, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.0178184, 0.6, 0, 0, 0, 0 },
        { 1, 0, 0.00218123, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0178184, 0.6, 0, 0, 8, 0.6 },
        { 1, 0, 0.00165462, 1, 3, 0.1, 1, 0, 0.0012528, 1, 0, 0.0148211, 1, 0, 0, 8, 0.02 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Music Box",
        "Xsynth-DSSI patch contributed by Silvan",
        { 2, 0, 24, -0.03, 0, 0, 0, 0, 0, 0, 0, 0, 1.4, 0 },
        { 1, 2, 0, 0.01, 18, 0.69, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 2, 0, 24, -0.01, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.4 },
        { 1, 2, 0, 0.03, 18, 0.69, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 2, 0, 50, 18, 0.79, 0.934, 0 },
        { 2, 1, 50, 18, 0.79, 0.959, 0 },
        0, 0.5, 0, 0.5, 0.71, 0, 0.71, 1,
        0.541889,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.288403, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 0, 0.657479, 0.802086, 0, 5.38125, 0.76, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.657479, 0.18, 0, 5.38125, 0.76, 0, 0, 8, 0.02 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.0012528, 0, 0, 0.002349, 0.2, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X: Ploink Box",
        "Xsynth-DSSI patch contributed by Silvan",
        { 1, 3, 24, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.854, 0 },
        { 2, 0, 12, 0, 18, 1, 1, 0, 0, 0, 0, 0, 0.546, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 30, 18, 0.79, 0.9, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.504388,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 0.275423, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.287, 0.802086, 0, 5.38125, 0.5, 0, 0, 0, 0 },
        { 1, 0, 0.001044, 1, 3, 0.1, 1, 0, 0.287, 0.18, 0, 5.38125, 0.72, 0, 0, 0, 0 },
        { 1, 0, 0.0218123, 1, 3, 0.1, 1, 0, 1.2528, 0.67, 0, 0.408209, 0.4, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "X2: Polkenstein",
        "Xsynth-DSSI patch contributed by Silvan",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.176, 0 },
        { 2, 0, 12, 0, 18, 0.56, 1, 0, 0, 0, 0, 0, 0.224, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.176 },
        { 2, 0, 12, 0, 18, 0.56, 1, 0, 0, 0, 0, 0, 0, 0.224 },
        { 1, 0, 4.5, 19, 0.81, 0.53, 0 },
        { 1, 1, 4.5, 19, 0.81, 0.53, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.580002,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0, 0, 0 },
        { 6.60694, 141, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.114472, 1, 3, 0.001, 1, 0, 0.0261747, 0.955489, 0, 5.90042, 0.508, 0, 0, 0, 0 },
        { 1, 0, 0.114472, 1, 3, 0.1, 1, 0, 0.0261747, 0.68, 0, 5.90042, 0.508, 0, 0, 0, 0 },
        { 1, 0, 9.52138, 1, 3, 0.1, 1, 0, 0.498748, 1, 0, 23.49, 0.652, 0, 0, 8, 0.09 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "====== Rudimentary conversions",
        "",
        { 2, 19, -12, 0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 22, -12, -0.05, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 20, 1, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.544094, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.25, 0.94, 1, 0.179484, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.544094, 0, 0, 0, 0, 0 },
        { 1, 1, 0.625, 1, 1, 0.1, 1, 1, 20, 0.5, 1, 0.544094, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "====== from Kawai K4 patches:",
        "",
        { 2, 16, -12, -0.09, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 16, -12, 0.09, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 19, -12, 0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 2.14375, 20, 0.22, 0, 0 },
        { 1, 1, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.76777, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0837323, 1, 1, 0.625, 0.84, 1, 0.625, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0209331, 0, 1, 0.0837323, 1, 1, 0.669858, 0.87, 1, 0.625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.947323, 1, 1, 0.1, 1, 1, 4.66516, 0.49, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 1.89465, 1, 1, 0.1, 1, 1, 1.76777, 0.5, 1, 1.76777, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Lue",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 80, 19, 0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 116, -12, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 80, 19, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 116, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 0, 20, 0.78, 0.545455, 0 },
        { 1, 1, 0, 20, 0.78, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.24504, 142, 0.45, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.76777, 0.95, 1, 0.192366, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0634572, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.473661, 1, 1, 0.1, 1, 1, 0.769465, 0.65, 1, 1.25, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Monocultur",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 101, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, 0, 0.09, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 2.7436, 20, 0.32, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.8404, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 1.76777, 0.62, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0592077, 0, 0, 0, 0, 0 },
        { 1, 1, 0.253829, 1, 1, 0.1, 1, 1, 0.883883, 0.61, 1, 12.3114, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: BreezeGame",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 62, 0, -0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 99, 0, 0.01, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 10.8, 20, 0.46, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.947323, 0, 0, 0, 0, 0 },
        { 1, 1, 0.078125, 1, 1, 0.1, 1, 1, 1.33972, 0.32, 1, 0.947323, 0, 0, 0, 0, 0 },
        { 1, 1, 0.110485, 1, 1, 0.1, 1, 1, 1.33972, 0.49, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 4.66517, 1, 1, 0.1, 1, 1, 3.78929, 0.63, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: E.Piano S1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 61, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 60, 0, 0.01, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 28.5893, 20, -0.36, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.45176, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0209331, 1, 1, 0.1, 1, 1, 2.67943, 0.7, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0224355, 1, 1, 0.1, 1, 1, 0.583146, 0.7, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 5.35887, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 3.78929, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: FletchLead",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 19, -24, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 22, -12, 0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, -24, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 61, -24, 0.1, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 30.7063, 0, 0, 0, 0 },
        { 1, 1, 25.6, 21, 0.26, 0.636364, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.67492, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 5, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0390625, 1, 1, 0.1, 1, 1, 2.5, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0240458, 0, 1, 0.0390625, 1, 1, 5, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 8.12252, 1, 1, 0.1, 1, 1, 7.07107, 0, 1, 20, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: jaBBazyntx",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 23, -12, -0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, -12, 0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 23, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, -12, -0.11, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 1, 0, 23.7276, 19, 0.3, 0, 0 },
        { 1, 2, 23.7276, 19, 0.3, 0, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.10318, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.110485, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.110485, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.53893, 0.51, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: MICROwave",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 122, -24, 0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 4.55625, 0, 0, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.16228, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.441942, 0.8, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.441942, 0.4, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: OBIErezPAD",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, -0.07, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 21, -12, 0.07, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.35, 19, 0.4, 0.818182, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.16228, 142, 0.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.220971, 1, 1, 0.1, 1, 1, 7.07107, 0.5, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 5, 1, 1, 0.1, 1, 1, 7.07107, 0.55, 1, 10, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: van halen",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 19, -12, -0.09, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, -12, 0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 19, -12, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 11.3491, 20, 0.16, 0, 0 },
        { 1, 1, 15.0382, 21, 0.16, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.24579, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.358968, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0340059, 1, 1, 0.625, 0.84, 1, 0.358968, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0209331, 0, 1, 0.0340059, 1, 1, 0.669858, 0.87, 1, 0.358968, 0, 0, 0, 0, 0 },
        { 1, 1, 1.25, 1, 1, 0.1, 1, 1, 1.76777, 0.5, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 1.89465, 1, 1, 0.1, 1, 1, 1.76777, 0.5, 1, 1.76777, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Glaschords",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 102, -12, -0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 102, -12, 0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 31.8028, 19, 0.44, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.87747, 142, 1.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.220971, 1, 1, 0.1, 1, 1, 5, 0.57, 1, 0.625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 0.441942, 0.55, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Harmonics",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 6, 16, -0.11, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 42, -12, -0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 6, 16, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 42, -12, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 12.5023, 20, 0.32, 0, 0 },
        { 1, 1, 12.5023, 20, 0.32, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.8404, 142, 0.7, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.291573, 0.12, 1, 0.0552427, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0364466, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0897421, 1, 1, 0.1, 1, 1, 4.35275, 0.5, 1, 2.17638, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Polysynth",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 15, -12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 15, -12, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 30, 0, 0.04, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 30, 0, -0.01, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 1, 0, 0.6912, 20, 0.36, 0.363636, 0 },
        { 1, 2, 0.6912, 20, 0.36, 0.363636, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.595109, 142, 0.65, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.126914, 1, 1, 0.1, 1, 1, 4.66517, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.126914, 1, 1, 0.1, 1, 1, 1.89465, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.358968, 1, 1, 0.1, 1, 1, 6.15572, 0.57, 1, 1.53893, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Pyeipzz",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 96, -24, 0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 96, -24, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 5.19115, 20, 0.36, 0.636364, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.60015, 142, 1.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.947323, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.947323, 0, 0, 0, 0, 0 },
        { 1, 1, 1.01532, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.947323, 0, 0, 0, 0, 0 },
        { 1, 1, 0.118415, 1, 1, 0.1, 1, 1, 4.66517, 0.44, 1, 1.53893, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Reedy Synt",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 98, 0, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 24.652, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 0.55, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 16.245, 0.82, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Return",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 74, -12, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 101, -12, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 1, 0, 8.31875, 20, 0.7, 0.363636, 0 },
        { 1, 2, 8.31875, 20, 0.7, 0.363636, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.8404, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.044871, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 2.33258, 0.68, 1, 0.044871, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0634572, 1, 1, 0.1, 1, 1, 2.33258, 0.77, 1, 0.0390625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0837323, 1, 1, 0.1, 1, 1, 1.43587, 0.46, 1, 0.103087, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: TechnoTube",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 87, 19, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 98, -12, 0.01, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.9652, 20, 0.58, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.24504, 142, 0.45, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0224355, 1, 1, 0.1, 1, 1, 1.53893, 0, 1, 0.192366, 0, 0, 0, 0, 0 },
        { 1, 1, 0.145786, 1, 1, 0.1, 1, 1, 1.16629, 0, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.220971, 1, 1, 0.1, 1, 1, 0.769465, 0.5, 1, 1.25, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Thin Keys",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 92, 24, -0.01, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 105, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 31.8028, 20, -0.36, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 142, 0.75, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.220971, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0195312, 1, 1, 0.441942, 0.69, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 2.67943, 0.52, 1, 0.136024, 0, 0, 0, 0, 0 },
        { 1, 1, 1.64938, 1, 1, 0.1, 1, 1, 2.67943, 0.86, 1, 4.66517, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Vectory !",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 114, 19, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 118, -12, 0.05, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 114, 19, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 118, -12, -0.05, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 50, 20, 0.4, 0.454545, 0 },
        { 1, 1, 50, 21, 0.4, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.16228, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0224355, 1, 1, 0.1, 1, 1, 1.64938, 0.79, 1, 0.192366, 0, 0, 0, 0, 0 },
        { 1, 1, 0.126914, 1, 1, 0.1, 1, 1, 6.15572, 0, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.824692, 1, 1, 0.1, 1, 1, 4.35275, 0.5, 1, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 1.64938, 0.5, 1, 1.25, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Warm Synpi",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 110, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 115, -12, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 11.3491, 20, 0.12, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.11895, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 1.43587, 0.19, 1, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 1.43587, 0.19, 1, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 1.08819, 1, 1, 0.1, 1, 1, 8.12252, 0.65, 1, 0.291573, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Woodpecker",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 54, -12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 100, 0, 0, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 80, 0, 0.02, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 2, 76, 12, -0.12, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0.727273, 0 },
        { 1, 1, 13.7312, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.11895, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.236831, 1, 1, 0.1, 1, 1, 4.35275, 0.65, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 2.5, 0.44, 1, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0224355, 1, 1, 0.1, 1, 1, 0.473661, 0.03, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Zippoline",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 22, 0, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 29, 0, -0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 9.25965, 20, 0.16, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 2.87175, 0, 1, 0.272047, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0340059, 0, 1, 0.0240458, 1, 1, 2.33258, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.110485, 1, 1, 0.1, 1, 1, 1.33972, 0.53, 1, 0.291573, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Double Wha",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 19, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 26, 0, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 19, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 26, 0, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 1.79685, 20, 0.26, 0.909091, 0 },
        { 1, 1, 4.55625, 21, 0.26, 0.636364, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.8404, 147, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0364466, 0, 0, 0, 0, 0 },
        { 1, 1, 0.220971, 1, 1, 0.1, 1, 1, 2.33258, 0.68, 1, 0.0364466, 0, 0, 0, 0, 0 },
        { 1, 1, 0.220971, 1, 1, 0.1, 1, 1, 2.33258, 0.77, 1, 0.0364466, 0, 0, 0, 0, 0 },
        { 1, 1, 6.15572, 1, 1, 0.1, 1, 1, 1.33972, 0.88, 1, 0.625, 0, 0, 0, 0, 0 },
        { 1, 1, 1.43587, 1, 1, 0.1, 1, 1, 1.33972, 0.88, 1, 0.625, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Lurkerer",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 41, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 12, 0, 0, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 92, 0, 0, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 22.8266, 0, 0, 0, 0 },
        { 1, 1, 50, 0, 0, 0.818182, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 3.29877, 0, 0, 0, 0, 0 },
        { 1, 1, 0.291573, 1, 1, 0.1, 1, 1, 1.89465, 0.48, 1, 2.67943, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 2.87175, 0.56, 1, 3.29877, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Remember?",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 19, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 92, -12, 0.01, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 5.88245, 20, 0.04, 0.909091, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.595109, 142, 2.1, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 3.07786, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 0.583146, 0.17, 1, 3.07786, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 1.89465, 0.07, 1, 2.67943, 0, 0, 0, 0, 0 },
        { 1, 1, 0.441942, 1, 1, 0.1, 1, 1, 1.43587, 0.91, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Talkochord",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 113, 12, -0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 105, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 28.5893, 20, -0.26, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.468619, 142, 0.4, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.136024, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0257716, 1, 1, 0.441942, 0.83, 1, 0.136024, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0592077, 1, 1, 0.1, 1, 1, 1.16629, 0.3, 1, 0.0592077, 0, 0, 0, 0, 0 },
        { 1, 1, 2.67943, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Cla Bell",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 0, -24, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 81, 0, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 0, -12, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 81, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 15.7216, 20, 0.08, 0.909091, 0 },
        { 1, 1, 15.7216, 20, 0.08, 0.909091, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 2.17638, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.883883, 0, 1, 0.583146, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.883883, 0, 1, 2.17638, 0, 0, 0, 0, 0 },
        { 1, 1, 0.384733, 1, 1, 0.1, 1, 1, 0.717936, 0.6, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Euro*Dig",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 59, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 59, -12, 0.06, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 71, 0, 0, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 2, 71, 0, 0.03, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 1, 1, 13.1072, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 2.17638, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.769465, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 1.33972, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0195312, 1, 1, 2.5, 0, 1, 2.17638, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: FINE FINE",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 60, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 75, 0, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 17.8955, 20, -0.4, 0, 0 },
        { 1, 1, 17.8955, 21, -0.6, 0.454545, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 1, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.43587, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.33972, 0, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0240458, 0, 1, 0.0195312, 1, 1, 1.33972, 0, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 1, 1, 10, 1, 1, 0.1, 1, 1, 6.59754, 0.58, 1, 3.29877, 0, 0, 0, 0, 0 },
        { 1, 1, 10, 1, 1, 0.1, 1, 1, 16.245, 0.58, 1, 3.29877, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Spring Sky",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 75, 12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 63, 0, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 19.4509, 0, 0, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.595109, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 3.07786, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 0.583146, 0.17, 1, 3.07786, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 1.89465, 0.07, 1, 2.67943, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: AmbientHrp",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 66, 0, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 11.9164, 20, 0.12, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.595109, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 3.07786, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 0.583146, 0.17, 1, 3.07786, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 1.89465, 0.07, 1, 2.67943, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 1.01532, 0.32, 1, 0.291573, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: BitterStrg",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 60, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 115, 0, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 3.7044, 20, 0.3, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.595109, 142, 1.35, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 3.07786, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0296039, 0, 1, 0.0680118, 1, 1, 0.583146, 0.17, 1, 3.07786, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 1.89465, 0.07, 1, 2.67943, 0, 0, 0, 0, 0 },
        { 1, 1, 0.272047, 1, 1, 0.1, 1, 1, 1.53893, 0.52, 1, 1.89465, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: LylesStrng",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 19, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, 0, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 7.8732, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 2.87175, 0, 0, 0, 0, 0 },
        { 1, 1, 5, 1, 1, 0.1, 1, 1, 2.87175, 0.62, 1, 2.87175, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: OB Strings",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, 0, 0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 21.0938, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.888553, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.769465, 0, 0, 0, 0, 0 },
        { 1, 1, 2.33258, 1, 1, 0.1, 1, 1, 1.16629, 0.78, 1, 0.769465, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: EnglishHrn",
        "(Mis)Interpreted Kawai K4 patch",
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 47, 0, 0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.16875, 19, 0.48, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.18136, 142, 0.25, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.15625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0592077, 1, 1, 0.1, 1, 1, 15.1572, 0.35, 1, 0.15625, 0, 0, 0, 0, 0 },
        { 1, 1, 2.03063, 1, 1, 0.1, 1, 1, 3.29877, 0.66, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: emphasizer",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 26, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, -12, 0.13, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.35, 0, 0, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 5.39574, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.441942, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: UnderAtack",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 23, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, -12, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.35, 20, 0.1, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.01298, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0837323, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.883883, 0, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Soundtrack",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, -5, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 18, 7, -0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 18, 2, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 1.35, 20, 0.3, 0, 0 },
        { 1, 1, 1.35, 20, 0.3, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.81188, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 2.5, 0, 0, 0, 0, 0 },
        { 1, 1, 0.883883, 1, 1, 0.1, 1, 1, 0.625, 0.6, 1, 2.5, 0, 0, 0, 0, 0 },
        { 1, 1, 0.883883, 1, 1, 0.1, 1, 1, 0.625, 0.3, 1, 2.5, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 1.25, 0.8, 1, 10, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Sync Wail",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 73, 0, -0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 103, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 19, 0.5, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.078125, 1, 1, 0.1, 1, 1, 20, 0, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.15625, 1, 1, 0.1, 1, 1, 10, 0.55, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: VeryHiVocs",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 80, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 80, 0, -0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 10.8, 19, 0.2, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.10318, 142, 0.9, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.883883, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 0.717936, 0.4, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: CleanOrgn1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 87, -12, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 83, -12, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 19, -0.02, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.81188, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0418662, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.625, 1, 1, 0.1, 1, 1, 2.5, 0.55, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: IndoProOne",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 23, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 0, -12, 0.21, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 17.15, 20, 0.4, 0.818182, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.29164, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.89465, 0, 1, 1.01532, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.07786, 0, 1, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 0.441942, 0.45, 1, 2.67943, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Moog+ChDly",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 116, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 116, 12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 3.2, 19, 0.8, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.3123, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.15625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.078125, 1, 1, 0.1, 1, 1, 0.625, 0.83, 1, 0.15625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.110485, 1, 1, 0.1, 1, 1, 0.625, 0.5, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: PPG/VelRes",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, 0, -0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 122, 0, 0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.78125, 0, 0, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.220971, 0, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: RememberMe",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 27, -12, 0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 12, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 3.2, 19, 0.2, 0.818182, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 5.21863, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.15625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.15625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 0.0961832, 0.4, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: RichRhodes",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 63, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 63, -12, 0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 58, -12, 0.05, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 58, -12, -0.05, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 0.78125, 20, 0.4, 0, 0 },
        { 1, 1, 8.31875, 20, 0.4, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 2.87175, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.118415, 1, 1, 0.1, 1, 1, 2.87175, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.236831, 1, 1, 0.1, 1, 1, 4.06126, 0.6, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: CleanOrgn3",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 96, -12, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 88, -12, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 19, -0.02, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.81188, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0418662, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.625, 1, 1, 0.1, 1, 1, 2.5, 0.55, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Bob'sBass",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 0, -24, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, -12, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.4, 20, 0.24, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.10318, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.76777, 0.8, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.3125, 0.43, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: digitaSYNT",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 93, -24, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 88, 0, 0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 8.38568, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.25, 0, 1, 0.441942, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: elektrik 1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 77, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 77, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 25.6, 19, 0.18, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.59546, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 2.5, 0, 1, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 0.625, 0.25, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: PropaQ PaD",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, 0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, -12, 0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 18, -12, 0.04, 0, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 1, 0, 0.78125, 19, 0.6, 0.545455, 0 },
        { 1, 1, 6.25, 19, 0.6, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.835515, 147, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 3.78929, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 10, 0.5, 1, 10, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Vibraphon",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 75, 0, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 75, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 4.2592, 19, 0.18, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 2.17638, 0, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 2.5, 0.5, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Sierra",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 106, -12, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 106, 0, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 106, -24, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 12, 12, -0.04, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 6.25, 21, 0.06, 0.545455, 0 },
        { 1, 1, 17.15, 21, 0.06, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0.2, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.167465, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0480916, 0, 0, 0, 0, 0 },
        { 1, 1, 0.136024, 1, 1, 0.1, 1, 1, 0.103087, 0.88, 1, 0.0480916, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 0.717936, 0.17, 1, 0.167465, 0, 0, 0, 0, 0 },
        { 1, 1, 1.76777, 1, 1, 0.1, 1, 1, 3.53553, 0.5, 1, 1.33972, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Spinn Solo",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 75, 7, 0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 96, -12, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.35, 20, 0.72, 0.909091, 0 },
        { 1, 1, 0.2916, 21, 0.76, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.75788, 142, 0.7, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.441942, 0.63, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.412346, 1, 1, 0.1, 1, 1, 1.64938, 0.7, 1, 13.1951, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Seventy",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 109, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 77, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 37.6786, 19, 0.48, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.10318, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.64938, 0, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0634572, 1, 1, 0.1, 1, 1, 0.384733, 0.5, 1, 0.0195312, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: OhhBe Ex-A",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, -0.04, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, -12, 0.07, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 9.25965, 19, 0.1, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.18136, 142, 0.3, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.583146, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0317286, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.583146, 0, 0, 0, 0, 0 },
        { 1, 1, 2.5, 1, 1, 0.1, 1, 1, 1.53893, 0.5, 1, 0.544094, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: OldSutCase",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 61, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 8, -10, -0.1, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.21945, 20, 0.06, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 17.2214, 142, 0.05, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.253829, 0, 0, 0, 0, 0 },
        { 1, 1, 0.103087, 1, 1, 0.1, 1, 1, 8.12252, 0, 1, 0.253829, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0276214, 0, 1, 0.0296039, 1, 1, 0.947323, 0, 1, 0.253829, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0897421, 1, 1, 0.1, 1, 1, 20, 0.5, 1, 2.5, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Lead Me",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 111, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, 0, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 20, 1, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.10318, 142, 0.2, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0592077, 1, 1, 0.1, 1, 1, 0.358968, 0.74, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0592077, 1, 1, 0.1, 1, 1, 0.236831, 0.74, 1, 0.0480916, 0, 0, 0, 0, 0 },
        { 1, 1, 0.334929, 1, 1, 0.1, 1, 1, 1.64938, 0.66, 1, 0.669858, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Memory",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, -12, 0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 26, -12, -0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.98415, 20, 0.16, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 142, 0.85, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 0.625, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 2.33258, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.118415, 1, 1, 0.1, 1, 1, 4.66517, 0.55, 1, 8.70551, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Glass EP",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 108, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 72, 4, 0.34, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 2.7436, 20, 0.42, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.888553, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0634572, 1, 1, 0.1, 1, 1, 6.15572, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0240458, 1, 1, 0.1, 1, 1, 3.78929, 0, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 2.5, 0.56, 1, 2.67943, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Super KX",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, 0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 21, -12, -0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.46305, 20, 0.36, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.39004, 142, 1.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0390625, 1, 1, 0.1, 1, 1, 1.33972, 0.64, 1, 0.192366, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0728932, 1, 1, 0.1, 1, 1, 1.33972, 0.75, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.507658, 1, 1, 0.1, 1, 1, 1.76777, 0.65, 1, 0.272047, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: SquareLead",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 53, 0, 0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 12, 0, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.5324, 20, 0.02, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.60015, 142, 0.8, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0364466, 1, 1, 0.1, 1, 1, 0.358968, 0.78, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0364466, 1, 1, 0.1, 1, 1, 0.412346, 0.81, 1, 0.0480916, 0, 0, 0, 0, 0 },
        { 1, 1, 0.883883, 1, 1, 0.1, 1, 1, 1.76777, 0.5, 1, 1.01532, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Rock Organ",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 85, -12, -0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 85, -12, 0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 86, 0, 0, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 95, 0, 0, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 11.3491, 20, 0.3, 0, 0 },
        { 1, 1, 44.2368, 0, 0, 0.454545, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.118415, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0276214, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0897421, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.118415, 0, 0, 0, 0, 0 },
        { 1, 1, 0.145786, 1, 1, 0.1, 1, 1, 0.3125, 0.62, 1, 1.01532, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Warmth",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, -12, 0.05, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 6.25, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 2.33258, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 1.76777, 1, 1, 8.70551, 0, 1, 2.33258, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0240458, 0, 1, 1.43587, 1, 1, 8.70551, 0, 1, 2.17638, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Miniapolis",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, -12, 0.04, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 26, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.98415, 20, 0.16, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.29164, 142, 0.85, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 0.625, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 2.33258, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.384733, 1, 1, 0.1, 1, 1, 4.66517, 0.55, 1, 8.70551, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Reso Syn",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 19, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, 7, 0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, 7, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 19, 7, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 1, 0, 17.8955, 19, -0.6, 0.727273, 0 },
        { 1, 1, 17.8955, 20, -0.6, 0.454545, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 0.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.43587, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 6.59754, 0, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 1, 1, 10, 1, 1, 0.1, 1, 1, 6.59754, 0.58, 1, 3.29877, 0, 0, 0, 0, 0 },
        { 1, 1, 10, 1, 1, 0.1, 1, 1, 16.245, 0.58, 1, 3.29877, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Oboe",
        "(Mis)Interpreted Kawai K4 patch",
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 47, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 9.25965, 19, 0.12, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.18136, 142, 2.7, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.206173, 0, 0, 0, 0, 0 },
        { 1, 1, 0.206173, 1, 1, 0.1, 1, 1, 8.70551, 0.4, 1, 0.206173, 0, 0, 0, 0, 0 },
        { 1, 1, 0.669858, 1, 1, 0.1, 1, 1, 11.487, 0.71, 1, 0.769465, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Mini Bass",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 31, -12, 0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 26, -12, -0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.10985, 20, 0.42, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.11895, 142, 1.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0276214, 1, 1, 0.1, 1, 1, 0.625, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0728932, 1, 1, 0.1, 1, 1, 2.33258, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.179484, 1, 1, 0.1, 1, 1, 2.17638, 0.64, 1, 8.70551, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Melo Vox 1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 12, -12, -0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 12, -12, 0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 5.88245, 19, 0.08, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 2.85, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.824692, 1, 1, 0.1, 1, 1, 2.87175, 0.9, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 7.57858, 1, 1, 0.1, 1, 1, 20, 0.5, 1, 7.57858, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Melo Waves",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 71, 0, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 71, 0, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 7.8732, 19, 0.3, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.19604, 142, 2.85, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.824692, 1, 1, 0.1, 1, 1, 2.87175, 0.9, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 2.17638, 1, 1, 0.1, 1, 1, 20, 0.5, 1, 7.57858, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: MelSqrSwep",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, 0, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 53, 0, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 20, 0.58, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 2.95, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 1.01532, 1, 1, 0.1, 1, 1, 2.87175, 0.9, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.824692, 1, 1, 0.1, 1, 1, 2.87175, 0.9, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.384733, 1, 1, 0.1, 1, 1, 8.70551, 0.63, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Sqr Sweep1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, -12, -0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, -12, 0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 18.6624, 19, 0.28, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 17.2214, 142, 3.6, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0418662, 1, 1, 0.1, 1, 1, 2.87175, 0.9, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 10.7177, 1, 1, 0.1, 1, 1, 17.411, 0.44, 1, 7.57858, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: SqrMel Ld1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, 24, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, 0, 0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.2916, 19, 0.36, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.24504, 142, 1.15, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 2.87175, 0.9, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.473661, 1, 1, 0.1, 1, 1, 1.64938, 0.68, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: SqrMel Ld2",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, -12, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, -12, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 20, 0.32, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.09686, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0418662, 1, 1, 0.1, 1, 1, 5, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0418662, 1, 1, 0.1, 1, 1, 5, 0, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0364466, 1, 1, 0.1, 1, 1, 2.17638, 0.77, 1, 1.89465, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Slow Swell",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, -0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, -12, 0.06, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 2.3328, 20, 0.26, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.01298, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 5, 0, 0, 0, 0, 0 },
        { 1, 1, 1.76777, 1, 1, 0.1, 1, 1, 8.70551, 0.91, 1, 5, 0, 0, 0, 0, 0 },
        { 1, 1, 1.43587, 1, 1, 0.1, 1, 1, 8.70551, 0.91, 1, 5, 0, 0, 0, 0, 0 },
        { 1, 1, 20, 1, 1, 0.1, 1, 1, 16.245, 0.72, 1, 13.1951, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Eeeevil 1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 122, -24, 0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 122, -24, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 5.19115, 20, 0.36, 0.636364, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.60015, 142, 1.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.01532, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 1.01532, 0, 0, 0, 0, 0 },
        { 1, 1, 1.01532, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 1.01532, 0, 0, 0, 0, 0 },
        { 1, 1, 0.118415, 1, 1, 0.1, 1, 1, 4.66517, 0.44, 1, 8.70551, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Matheim",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 16, -12, -0.09, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 16, -12, 0.09, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 19, -12, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 1.6384, 20, 0.22, 0, 0 },
        { 1, 1, 9.25965, 21, 0.2, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.24579, 142, 0.1, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.01532, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.358968, 1, 1, 0.625, 0.84, 1, 1.01532, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0209331, 0, 1, 0.3125, 1, 1, 0.669858, 0.87, 1, 1.01532, 0, 0, 0, 0, 0 },
        { 1, 1, 0.145786, 1, 1, 0.1, 1, 1, 4.66517, 0.49, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.192366, 1, 1, 0.1, 1, 1, 1.76777, 0.5, 1, 1.76777, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Celest",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 80, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 8, 0, -0.25, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 76, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 0, 0, 0.03, 0, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0.909091, 0 },
        { 1, 1, 50, 0, 0, 0.727273, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 17.2214, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.824692, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 1.53893, 0, 1, 0.824692, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0257716, 1, 1, 0.1, 1, 1, 0.0897421, 0, 1, 0.118415, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0390625, 1, 1, 0.1, 1, 1, 0.118415, 0, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Xylophone",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 81, 2, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 12, 12, 0, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.79685, 20, 0.08, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 17.2214, 142, 0.2, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 0.126914, 0, 1, 0.192366, 0, 0, 0, 0, 0 },
        { 1, 1, 0.078125, 1, 1, 0.1, 1, 1, 0.717936, 0, 1, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0.5, 1, 2.5, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: WaterBells",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 76, 0, 0.43, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 75, -12, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.24565, 20, 0.36, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.835515, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 1.76777, 0, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.291573, 1, 1, 0.1, 1, 1, 11.487, 0.57, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Oh Bo! Mel",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 103, 12, -0.01, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 47, -12, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 7.8732, 20, 0.08, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 142, 0.2, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.103087, 1, 1, 0.1, 1, 1, 7.57858, 0.4, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.15625, 1, 1, 0.1, 1, 1, 8.70551, 0.4, 1, 0.0897421, 0, 0, 0, 0, 0 },
        { 1, 1, 0.625, 1, 1, 0.1, 1, 1, 14.1421, 0.5, 1, 0.824692, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Sunday 1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 40, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 71, -12, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 10.2689, 20, 0.2, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.167343, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.583146, 1, 1, 0.1, 1, 1, 0.769465, 0.75, 1, 0.824692, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Sunday  2",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 83, -12, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 92, -12, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 4.2592, 20, 0.52, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.167343, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.824692, 1, 1, 0.1, 1, 1, 0.824692, 0.75, 1, 0.824692, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Sunday  3",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 96, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 92, -12, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 3.7044, 20, 0.52, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.167343, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0296039, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.824692, 1, 1, 0.1, 1, 1, 0.824692, 0.75, 1, 0.824692, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Rezysyn",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 15, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.6912, 20, 0.36, 0.909091, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.595109, 142, 0.65, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.15625, 1, 1, 0.1, 1, 1, 4.66517, 0, 1, 1.08819, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0209331, 0, 1, 0.126914, 1, 1, 4.66517, 0, 1, 0.3125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0961832, 1, 1, 0.1, 1, 1, 20, 0.48, 1, 10, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Reso.Syn 0",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 22, 0, -0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 22, 7, 0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 19, -0.98, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 17.2214, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.43587, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 1, 1, 1.33972, 1, 1, 0.1, 1, 1, 10, 0, 1, 2.5, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: 4osc. Juno",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, 12, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 22, 0, 0.05, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 27, -12, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 12, -12, -0.1, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 1, 0, 0.10985, 20, 0.4, 0.363636, 0 },
        { 1, 2, 0.10985, 20, 0.4, 0.363636, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.15625, 1, 1, 0.1, 1, 1, 0.883883, 0, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.15625, 1, 1, 0.1, 1, 1, 5, 0, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 1, 1, 0.110485, 1, 1, 0.1, 1, 1, 0.717936, 0.6, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: MooG InvsN",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 12, 0, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 12, 0, 0.05, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 23, 0, 0, 7, 0, 0, 0, 0, 0, 20, 1, 0.5, 0 },
        { 2, 24, 0, 0.08, 0, 0, 0, 0, 0, 0, 21, 1, 0.5, 0 },
        { 1, 0, 0.78125, 0, 0, 0, 0 },
        { 1, 2, 0.78125, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 142, 1.2, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 2.17638, 0, 0, 0, 0, 0 },
        { 1, 1, 0.441942, 1, 1, 0.1, 1, 1, 1.25, 0.84, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.507658, 1, 1, 0.1, 1, 1, 0.824692, 0.85, 1, 2.03063, 0, 0, 0, 0, 0 },
        { 1, 1, 0.507658, 1, 1, 0.1, 1, 1, 0.883883, 0.84, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0592077, 1, 1, 0.1, 1, 1, 1.89465, 0.46, 1, 2.17638, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: MooG InvsN (edited)",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 12, 0, -0.05, 7, 0.0219108, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 12, 0, 0.05, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 23, 0, 0, 7, 0.0102835, 0, 0, 0, 0, 20, 1, 0.5, 0 },
        { 2, 24, 0, 0.08, 0, 0, 0, 0, 0, 0, 21, 1, 0.5, 0 },
        { 1, 0, 1.8179, 0, 0, 0, 0 },
        { 1, 2, 2.67051, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.89239,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.28974, 142, 1.2, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 2.17638, 0, 0, 0, 0, 0 },
        { 1, 1, 0.441942, 1, 1, 0.1, 1, 1, 1.25, 0.84, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.507658, 1, 1, 0.1, 1, 1, 0.824692, 0.85, 1, 2.03063, 0, 0, 0, 0, 0 },
        { 1, 1, 0.507658, 1, 1, 0.1, 1, 1, 0.883883, 0.84, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0592077, 1, 1, 0.1, 1, 1, 1.89465, 0.46, 1, 2.17638, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: ToyPiano16",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 91, 0, -0.09, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 2, 0, 0.11, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 10.8, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.16228, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0390625, 1, 1, 0.1, 1, 1, 1.25, 0, 1, 0.625, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: 7ender EP",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 56, -9, -0.2, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 42, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 72, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 42, -12, 0.04, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 36.45, 0, 0, 0, 0 },
        { 1, 1, 5.88245, 20, 0.12, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 0.45, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.3125, 0, 1, 0.0552427, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.145786, 1, 1, 0.1, 1, 1, 3.78929, 0.57, 1, 5.35887, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Apham EP",
        "(Mis)Interpreted Kawai K4 patch",
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 42, 0, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 40, 12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 42, 0, -0.03, 7, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 10.8, 0, 0, 0, 0 },
        { 1, 1, 7.8732, 21, 0.04, 0.454545, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 1.85, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.583146, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0418662, 1, 1, 0.1, 1, 1, 2.5, 0, 1, 0.334929, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0480916, 1, 1, 0.1, 1, 1, 2.03063, 0, 1, 0.334929, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.583146, 0, 0, 0, 0, 0 },
        { 1, 1, 0.384733, 1, 1, 0.1, 1, 1, 1.43587, 0.57, 1, 5.35887, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Traum",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, -12, 0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 54, 12, -0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.6912, 20, 0.16, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 8.13762, 141, 0.85, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 0.625, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 2.33258, 0.75, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.118415, 1, 1, 0.1, 1, 1, 4.66517, 0.55, 1, 8.70551, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: EP",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 56, -9, -0.2, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 42, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 32, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 47, -12, 0.04, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 36.45, 0, 0, 0, 0 },
        { 1, 1, 5.88245, 20, 0.12, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 0.45, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.3125, 0, 1, 0.0552427, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.145786, 1, 1, 0.1, 1, 1, 3.78929, 0.57, 1, 5.35887, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Blue*G*Org",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 2, 0, 0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 40, -12, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 40, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 12.5023, 0, 0, 0, 0 },
        { 1, 1, 28.5893, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.11895, 142, 3.1, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.110485, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0364466, 1, 1, 0.1, 1, 1, 0.272047, 0.38, 1, 0.0680118, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0240458, 1, 1, 0.1, 1, 1, 0.507658, 0.84, 1, 0.110485, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Mild",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 42, -12, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 15, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 40, -12, -0.02, 7, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 2, 99, -12, 0.02, 7, 0, 0, 0, 0, 0, 20, 1, 0, 0.5 },
        { 1, 0, 13.1072, 0, 0, 0.454545, 0 },
        { 1, 1, 15.0382, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.272047, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 1.43587, 0.94, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0634572, 1, 1, 0.1, 1, 1, 3.78929, 0, 1, 0.272047, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0897421, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Peak-A-Bos",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 122, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 8.7808, 20, 1, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.3125, 0, 1, 0.0195312, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 0.883883, 0.5, 1, 2.17638, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Harpsich60",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 69, 0, 0.01, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 68, 0, 0, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 21.0938, 20, -0.22, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.3123, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.358968, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0418662, 0, 1, 0.0195312, 1, 1, 2.5, 0, 1, 0.358968, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 2.87175, 0, 1, 0.136024, 0, 0, 0, 0, 0 },
        { 1, 1, 3.29877, 1, 1, 0.1, 1, 1, 15.1572, 0.15, 1, 2.87175, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Troubles",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 61, 0, -0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 60, 0, 0.02, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 28.5893, 20, -0.36, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.390488, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0209331, 1, 1, 0.1, 1, 1, 2.67943, 0, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0224355, 1, 1, 0.1, 1, 1, 0.583146, 0, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 5.35887, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 3.78929, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Contempo",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 63, 0, 0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 63, -12, -0.02, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 26, -12, 0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 26, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 3.7044, 20, 0.16, 0, 0 },
        { 1, 1, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0317286, 1, 1, 0.1, 1, 1, 2.67943, 0, 1, 0.272047, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0317286, 1, 1, 2.67943, 0, 1, 0.358968, 0, 0, 0, 0, 0 },
        { 1, 1, 0.253829, 1, 1, 0.1, 1, 1, 1.64938, 0.5, 1, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.272047, 1, 1, 0.1, 1, 1, 5, 0.72, 1, 0.669858, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: GurglGhost",
        "(Mis)Interpreted Kawai K4 patch",
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 23, -24, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 1, 0, 1.6384, 19, 0.72, 0.818182, 0 },
        { 1, 2, 1.6384, 19, 0.72, 0.818182, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 17.2214, 146, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0195312, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0195312, 0, 0, 0, 0, 0 },
        { 1, 1, 7.07107, 1, 1, 0.1, 1, 1, 1.89465, 0.49, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: ClavRhods",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 1, 24, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 101, 0, 0.01, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 9.7556, 20, 0.16, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.59546, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.291573, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.25, 0, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.291573, 0, 0, 0, 0, 0 },
        { 1, 1, 0.206173, 1, 1, 0.1, 1, 1, 1.25, 0.5, 1, 0.625, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: DX-7 Piano",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 58, -12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 63, -12, 0.09, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 15.7216, 20, -0.12, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.45176, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.334929, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0209331, 1, 1, 0.1, 1, 1, 2.67943, 0, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.883883, 0, 1, 0.334929, 0, 0, 0, 0, 0 },
        { 1, 1, 2.5, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 3.78929, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Every",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 63, 0, 0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 63, -12, -0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 26, -12, 0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 26, -12, -0.03, 0, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 1, 0, 3.7044, 20, 0.16, 0, 0 },
        { 1, 1, 0.16875, 21, 0.2, 0.363636, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 2.3, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.358968, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0317286, 1, 1, 0.1, 1, 1, 2.67943, 0, 1, 0.272047, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0317286, 1, 1, 2.67943, 0, 1, 0.358968, 0, 0, 0, 0, 0 },
        { 1, 1, 0.253829, 1, 1, 0.1, 1, 1, 1.64938, 0.5, 1, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.272047, 1, 1, 0.1, 1, 1, 5, 0.72, 1, 0.669858, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Iron E.P",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 56, -9, -0.2, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 42, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 36.45, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 1.85, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0634572, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.3125, 0, 1, 0.0552427, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 3.29877, 0, 1, 0.0634572, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: SemiRoads",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 58, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 56, -12, -0.09, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 14, -12, -0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 56, -12, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 0.16875, 20, 0.28, 0, 0 },
        { 1, 1, 2.3328, 21, 0.5, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.888553, 142, 2.3, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0364466, 1, 1, 0.1, 1, 1, 2.87175, 0, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0418662, 1, 1, 0.1, 1, 1, 2.17638, 0, 1, 0.220971, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0515433, 1, 1, 0.1, 1, 1, 7.07107, 0.8, 1, 2.87175, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 6.15572, 0.99, 1, 2.67943, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Glocklock+",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 91, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 75, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 20.2612, 0, 0, 0.909091, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.10318, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.64938, 0, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Wastmnstr+",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 96, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 96, -12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 22.8266, 0, 0, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.784201, 142, 2.25, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.625, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: HouseBass+",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 41, 0, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, 0, 0.09, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.35, 20, 0.3, 0.636364, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 142, 1.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0480916, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0276214, 1, 1, 0.0195312, 1, 1, 0.0418662, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0837323, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0480916, 0, 0, 0, 0, 0 },
        { 1, 1, 0.272047, 1, 1, 0.1, 1, 1, 2.33258, 0.53, 1, 0.272047, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Taurs4Pol+",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, 0, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, 0, 0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.16228, 142, 0.3, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.167465, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0897421, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.167465, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Frogbell",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 75, -12, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 77, -12, 0.02, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 75, -12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 77, -12, -0.02, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 1, 0, 1.79685, 19, 0.74, 0.545455, 0 },
        { 1, 2, 1.79685, 19, 0.74, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.3123, 142, 1.4, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.206173, 0.73, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 1.25, 1, 1, 0.1, 1, 1, 2.5, 0.6, 1, 3.07786, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Raspel",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 96, 0, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 7, 0, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 5.88245, 19, 0.16, 0, 0 },
        { 1, 1, 5.88245, 19, 0.16, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.45176, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0897421, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.89465, 0, 1, 0.0897421, 0, 0, 0, 0, 0 },
        { 1, 1, 0.110485, 1, 1, 0.1, 1, 1, 2.67943, 0.5, 1, 0.0837323, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Clarinet",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 46, 0, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 14.3748, 20, 0.08, 0.454545, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.943364, 142, 2.35, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.145786, 1, 1, 0.1, 1, 1, 2.33258, 0.55, 1, 0.0728932, 0, 0, 0, 0, 0 },
        { 1, 1, 0.126914, 1, 1, 0.1, 1, 1, 0.441942, 0.55, 1, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.824692, 1, 1, 0.1, 1, 1, 3.29877, 0.99, 1, 1.43587, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Glass Harp",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 102, 0, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 103, 0, 0.01, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 17.2214, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.179484, 1, 1, 0.1, 1, 1, 0.769465, 0, 1, 0.883883, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0209331, 0, 1, 0.669858, 1, 1, 0.0195312, 1, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: GlockGlock",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 91, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 75, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 20.2612, 0, 0, 0.909091, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.10318, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.64938, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.64938, 0, 1, 1.64938, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Islandbell",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 99, 12, 0.15, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 76, -12, -0.1, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 12.5023, 20, 0.42, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.18136, 142, 1.2, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.206173, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0480916, 1, 1, 0.1, 1, 1, 1.08819, 0, 1, 0.179484, 0, 0, 0, 0, 0 },
        { 1, 1, 0.044871, 1, 1, 0.1, 1, 1, 0.412346, 0, 1, 0.206173, 0, 0, 0, 0, 0 },
        { 1, 1, 0.220971, 1, 1, 0.1, 1, 1, 1.53893, 0.5, 1, 4.66517, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Drops",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 75, 12, 0.06, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 75, 12, 0.06, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 17.15, 20, 1, 0.636364, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 4.55315, 147, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.89465, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 20, 0.5, 1, 1.89465, 0, 0, 0, 0, 0 },
        { 2, 1, 0.15625, 0, 1, 0.0195312, 1, 1, 20, 0.9, 1, 0.947323, 0, 0, 0, 0, 0 },
        { 1, 1, 20, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: scritti",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 68, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 68, 0, 0.02, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 18.6624, 20, 0.4, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 3.16228, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0480916, 1, 1, 0.1, 1, 1, 0.3125, 0.8, 1, 0.441942, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0209331, 0, 1, 0.078125, 1, 1, 0.3125, 0.8, 1, 0.441942, 0, 0, 0, 0, 0 },
        { 1, 1, 0.220971, 1, 1, 0.1, 1, 1, 0.441942, 0.38, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: UnAnalogic",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 113, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 113, -12, -0.05, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 1.6384, 0, 0, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.92541, 142, 1, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 0.118415, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: dead PIANO",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 67, -12, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 112, -12, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 12.5023, 20, 0.12, 0.545455, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 7.42726, 142, 0.6, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0634572, 1, 1, 0.1, 1, 1, 1.43587, 0, 1, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0837323, 1, 1, 0.1, 1, 1, 1.43587, 0, 1, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 1.25, 0.5, 1, 5, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: digistical",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 102, 0, 0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 103, 0, -0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 10.8, 19, 0.12, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.59546, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.078125, 1, 1, 0.1, 1, 1, 1.43587, 0, 1, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.192366, 1, 1, 0.1, 1, 1, 0.3125, 0.42, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: modular 1",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, -12, -0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 112, 0, 0.01, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 3.2, 19, 0.48, 0.727273, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.59546, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 3.53553, 0, 0, 0, 0, 0 },
        { 1, 1, 0.15625, 1, 1, 0.1, 1, 1, 10, 0.4, 1, 3.53553, 0, 0, 0, 0, 0 },
        { 1, 1, 10, 1, 1, 0.1, 1, 1, 5, 0.55, 1, 20, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: obPAD+dxEP",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, -12, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, -12, -0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 58, 0, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 63, 0, -0.01, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 30.7063, 0, 0, 0, 0 },
        { 1, 1, 1.35, 20, 0.18, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.3123, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.89465, 0, 0, 0, 0, 0 },
        { 1, 1, 1.25, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 1.89465, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0364466, 1, 1, 0.1, 1, 1, 2.17638, 0.15, 1, 0.384733, 0, 0, 0, 0, 0 },
        { 1, 1, 0.3125, 1, 1, 0.1, 1, 1, 1.43587, 0.67, 1, 13.1951, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Candlemass",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 75, 12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 63, 0, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 27.5684, 20, -0.28, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.888553, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.25, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0276214, 0, 1, 0.0364466, 1, 1, 1.08819, 0.08, 1, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0240458, 1, 1, 0.1, 1, 1, 2.5, 0.03, 1, 1.25, 0, 0, 0, 0, 0 },
        { 1, 1, 0.947323, 1, 1, 0.1, 1, 1, 9.33033, 0.25, 1, 3.07786, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Eno's Mini",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 24, 0, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 24, 0, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.1372, 19, 0.42, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.734557, 142, 0.35, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 5.35887, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0276214, 0, 1, 2.67943, 1, 1, 1.89465, 0.76, 1, 5.35887, 0, 0, 0, 0, 0 },
        { 1, 1, 13.1951, 1, 1, 0.1, 1, 1, 8.12252, 0.59, 1, 10.7177, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: SyntexBass",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 122, -12, 0, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 111, -12, 0, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0.2916, 20, 0.78, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.38094, 142, 0.35, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.126914, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0897421, 1, 1, 0.1, 1, 1, 3.07786, 0.53, 1, 0.078125, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0390625, 1, 1, 0.1, 1, 1, 2.33258, 0, 1, 0.126914, 0, 0, 0, 0, 0 },
        { 1, 1, 0.272047, 1, 1, 0.1, 1, 1, 1.89465, 0.5, 1, 5.74349, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: OBX Brass",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 19, -12, 0.05, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 22, -12, -0.05, 0, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 20, 1, 0.363636, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.67782, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.544094, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 1.25, 0.94, 1, 0.179484, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.544094, 0, 0, 0, 0, 0 },
        { 1, 1, 0.625, 1, 1, 0.1, 1, 1, 20, 0.5, 1, 0.544094, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: OceanBrass",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 16, -12, -0.09, 0, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 16, -12, 0.09, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 19, -12, -0.03, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 2, 19, -12, 0.03, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 2.14375, 20, 0.22, 0, 0 },
        { 1, 1, 9.25965, 21, 0.2, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.24579, 142, 0.15, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.625, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0224355, 0, 1, 0.0837323, 1, 1, 0.625, 0.84, 1, 0.625, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0209331, 0, 1, 0.0837323, 1, 1, 0.669858, 0.87, 1, 0.625, 0, 0, 0, 0, 0 },
        { 1, 1, 0.947323, 1, 1, 0.1, 1, 1, 4.66517, 0.49, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 1, 1, 1.89465, 1, 1, 0.1, 1, 1, 1.76777, 0.5, 1, 1.76777, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Alassen",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 103, -24, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 117, -5, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 103, -24, 0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 117, -5, -0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 31.8028, 20, 0.32, 0.545455, 0 },
        { 1, 1, 31.8028, 20, 0.32, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.11895, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.16629, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0680118, 1, 1, 0.1, 1, 1, 1.64938, 0, 1, 1.16629, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0480916, 1, 1, 0.1, 1, 1, 0.717936, 0, 1, 1.08819, 0, 0, 0, 0, 0 },
        { 1, 1, 0.118415, 1, 1, 0.1, 1, 1, 1.01532, 0.5, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: AnalgClavi",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 29, 7, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 48, -12, -0.01, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 11.9164, 20, 0.24, 0, 0 },
        { 1, 1, 7.0304, 21, 0.22, 0.363636, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.49129, 142, 0.35, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0515433, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0240458, 0, 1, 0.0195312, 1, 1, 1.53893, 0, 1, 0.0390625, 0, 0, 0, 0, 0 },
        { 2, 1, 0.0257716, 0, 1, 0.0195312, 1, 1, 1.64938, 0, 1, 0.0515433, 0, 0, 0, 0, 0 },
        { 1, 1, 0.136024, 1, 1, 0.1, 1, 1, 1.16629, 0.53, 1, 3.29877, 0, 0, 0, 0, 0 },
        { 1, 1, 0.206173, 1, 1, 0.1, 1, 1, 1.64938, 0.51, 1, 5.35887, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Kaliohpann",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 103, -24, -0.04, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 103, -5, 0.04, 7, 0, 0, 0, 0, 0, 19, 1, 0.5, 0 },
        { 2, 103, -24, 0.04, 0, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 103, -5, -0.04, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0.5 },
        { 1, 0, 31.8028, 20, 0.32, 0.545455, 0 },
        { 1, 1, 31.8028, 20, 0.36, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.734557, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.253829, 0, 0, 0, 0, 0 },
        { 1, 1, 0.206173, 1, 1, 0.1, 1, 1, 2.33258, 0, 1, 0.253829, 0, 0, 0, 0, 0 },
        { 1, 1, 0.206173, 1, 1, 0.1, 1, 1, 1.08819, 0, 1, 0.236831, 0, 0, 0, 0, 0 },
        { 1, 1, 0.544094, 1, 1, 0.1, 1, 1, 1.33972, 0.5, 1, 1.76777, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: Pepe,Geh !",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 53, 19, 0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 53, 19, -0.03, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 23.7276, 19, 0.4, 0.545455, 0 },
        { 1, 1, 23.7276, 19, 0.4, 0.545455, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1.52481, 142, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 1.16629, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0390625, 1, 1, 0.1, 1, 1, 1.64938, 0.42, 1, 1.16629, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0552427, 1, 1, 0.1, 1, 1, 1.64938, 0.5, 1, 1.25, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "K4oid: K4-Init",
        "(Mis)Interpreted Kawai K4 patch",
        { 2, 18, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0.5, 0 },
        { 2, 18, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 2, 18, 0, 0, 7, 0, 0, 0, 0, 0, 18, 1, 0, 0.5 },
        { 1, 0, 50, 19, 0.4, 0, 0 },
        { 1, 1, 50, 19, 0.4, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.29164, 142, 0.5, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.0552427, 0, 0, 0, 0, 0 },
        { 1, 1, 0.0195312, 1, 1, 0.1, 1, 1, 0.0195312, 1, 1, 0.0552427, 0, 0, 0, 0, 0 },
        { 1, 1, 0.15625, 1, 1, 0.1, 1, 1, 3.53553, 0.5, 1, 0.625, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "================ Test patches:",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.5, 0.5, 0.5, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "sweep alias test (key=100)",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 13, -0.158873, 7, 0.863445, 0, 0.5, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.424805, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "sweep alias test 2 (key=108)",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 0, 0, 7, 0.57, 0, 0.5, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "sync alias test (key=108)",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 13, -0.158873, 7, 0.863445, 1, 0.5, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.424805, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "mod discontinuity test",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 13, -0.158873, 7, -0.8634, 0, 0.5, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 2.73719, 141, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "subsample alias test (key=94)",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 12, 0.124202, 7, 0.431722, 1, 0.5, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.136948, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "subsample alias 2 (key=60)",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 12, 0.0120278, 7, 0.166667, 1, 0.5, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5185,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.247489, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "subsample alias 3 (key=96)",
        "",
        { 1, 0, 0, 0.391136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 0, 0.108381, 7, 0.791445, 1, 0.0682776, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.051986, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.164142, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "clipsaw sync test",
        "",
        { 1, 0, 0, 0, 5, 0, 0, 1, 22, 1, 0, 0, 0, 0 },
        { 1, 5, 34, 0, 22, 0.718651, 1, 0.102393, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.517111, 0.506629, 0, 0.8, 0, 0.5, 0, 0.5,
        0.861998,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.554607, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 8, -0.984334, 0, 0
    },
    {
        "clipsaw sync test 2, key=72",
        "",
        { 1, 0, 0, 0, 5, 0, 0, 1, 22, 1, 0, 0, 0, 0 },
        { 1, 5, 28, 0, 22, 0.111111, 1, 0.181799, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.517111, 0.506629, 0, 0.8, 0, 0.5, 0, 0.5,
        0.872665,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.554607, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 8, -0.984334, 0, 0
    },
    {
        "startup thump test (key=108)",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 2, 7, -0.279991, 0, 0, 1, 0.06, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "tri sync thump test (key=77)",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 1, 3, 14, -0.320002, 7, 0.57, 1, 0.08, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.416869, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "pulse click! (key=106)",
        "",
        { 1, 2, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0, 0 },
        { 1, 2, 13, -0.158873, 7, 0.863445, 0, 0.21, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.424805, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "pulse click! (key=103)",
        "",
        { 1, 2, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0, 0 },
        { 1, 2, 13, -0.158873, 7, 0.863445, 0, 0.21, 0, 0, 0, 0, 1.4, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 50, 0, 0, 0.02, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0.5, 0, 0.5, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.424805, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.001044, 1, 3, 0.001, 1, 2, 0.0012528, 1, 0, 0.002349, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "osc amp mod test",
        "",
        { 2, 83, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0.0573404, 1, 0 },
        { 2, 95, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0.0739899, 0, 1 },
        { 2, 85, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0.081342, 0.69201, 0.318201 },
        { 2, 87, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0.061213, 0.319207, 0.728516 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        1, 0, 1, 1, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        { 1.97177, 0, 0.1, 0, 0 },
        77.14, 0.397608,
        { 2, 3, 0.0250322, 1, 3, 0.00168268, 1, 3, 0.0025336, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "amp mod test 2",
        "",
        { 2, 71, 0, 0, 0, 0, 0, 0, 0, 0, 9, 1, 1, 0 },
        { 2, 83, 0, 0, 0, 0, 0, 0, 0, 0, 11, 1, 0.989903, 0 },
        { 2, 92, 0, 0, 0, 0, 0, 0, 0, 0, 9, 1, 0, 1 },
        { 2, 95, 0, 0, 0, 0, 0, 0, 0, 0, 11, 1, 0, 1 },
        { 3, 0, 4.91945, 13, 0.0387217, 0.734944, 0 },
        { 3, 1, 4.52666, 15, 0.0526065, 0.749556, 0 },
        0, 0.2, 0, 0.8, 0.640278, 0.401611, 0.576133, 0.604818,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.0183131, 1, 3, 0.20162, 0.666667, 3, 8.05511, 0, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.0173542, 1, 3, 0.275845, 0.145516, 3, 3.80829, 0, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.001, 1, 3, 0.001, 1, 3, 3.56251, 0, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "new filter test",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0, 0.0147647, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 5, 0, 44.7018, 7, 1, 1, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 2, 0.5, 0.5, 0.5,
        1,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 0.135721, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "eg amp mod test",
        "",
        { 1, 0, 0, 0, 18, 1, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.5, 0.5, 0.5, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 3, 3, 0.004, 1, 3, 0.001, 1, 11, 2.54087, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 1, 3, 2.16405, 1, 3, 0.1, 1, 3, 2.86044, 0, 3, 3.6847, 0, 0, 0, 8, 1 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "wave comparer (LFO)",
        "",
        { 2, 18, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0.433205, 0.674532, 0.5 },
        { 2, 19, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0.461224, 0.674532, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.674532, 0.507856, 0, 0.8, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 147, 0, 0, 0 },
        180, 0,
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "========= Development patches:",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.2, 0, 0.8, 0.5, 0.5, 0.5, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "-Xsynth-DSSI single init voice",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.1, 1, 3, 0.001, 1, 2, 0.001, 1, 0, 0.2, 0, 0, 0, 0, 0 },
        { 1, 0, 0.1, 1, 3, 0.1, 1, 0, 0.1, 1, 0, 0.2, 0, 0, 0, 0, 0 },
        { 1, 0, 0.1, 1, 3, 0.1, 1, 0, 0.1, 1, 0, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "-Xsynth-DSSI dual init voice-",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 1, 1, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 0, 0.1, 1, 3, 0.001, 1, 0, 0.001, 1, 0, 0.2, 0, 0, 0, 0, 0 },
        { 1, 0, 0.1, 1, 3, 0.1, 1, 0, 0.1, 1, 0, 0.2, 0, 0, 0, 0, 0 },
        { 1, 0, 0.1, 1, 3, 0.1, 1, 0, 0.1, 1, 0, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "- K4oid single init voice -",
        "",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 1, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.2, 0, 0, 0, 0, 0 },
        { 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "- K4oid dual init voice -",
        "",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 1, 1, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.2, 0, 0, 0, 0, 0 },
        { 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "- K4oid twin init voice -",
        "",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 1, 1, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0.71, 0.25, 0.71, 0.75,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.2, 0, 0, 0, 0, 0 },
        { 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "- K4oid double init voice -",
        "",
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0 },
        { 1, 0, 50, 0, 0, 0, 0 },
        { 1, 2, 50, 0, 0, 0, 0 },
        0, 0.5, 0, 0.5, 0, 0.5, 1, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.002, 1, 3, 0.001, 1, 3, 0, 1, 11, 0.2, 0, 0, 0, 0, 0 },
        { 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        { 0, 1, 0.1, 1, 1, 0.1, 1, 1, 0.1, 1, 1, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "GSynth",
        "Starting point for Juno 106-like patches from Garett Shulman",
        { 2, 0, -12, 0, 1, 0, 0, 0, 0, 0, 18, 0, 0.5, 0 },
        { 1, 2, 0, 0, 0, 0, 0, 0.492026, 6, 0.149838, 18, 0, 0.5, 0 },
        { 1, 1, 0, 0, 0, 0.00362681, 0, 0, 0, 0, 18, 0, 0.5, 0 },
        { 0, 24, 0, 0, 0, -0.00030387, 0, 0, 0, 0, 0, 0, 0, 0 },
        { 2, 0, 50, 22, 1, 0, 0 },
        { 2, 1, 3.55629, 0, 0, 0, 0 },
        0, 0, 0, 0, 0.984671, 0.5, 1.02186, 0.5,
        0.35,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 0.101461, 0, 0, 0, 0 },
        { 0.05, 0, 0.1, 0, 0 },
        { 0.05, 0, 0.1, 0, 0 },
        120.296, 0,
        { 1, 3, 0.0119657, 1, 3, 0.1, 1, 3, 6.35257, 1, 3, 0.0159149, 0.196778, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.0250322, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        0, 5, 0, 17, 0
    },
    {
        " <dual agran base>",
        "",
        { 3, 90, 0, 0, 0, 0, 0.696781, 1, 1, 0.008, 0, 0, 0.702898, 0 },
        { 3, 90, 0, 0, 0, 0, 0.696781, 1, 1, 0.002, 0, 0, 0, 0.69201 },
        { 2, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.5, 0, 0.5, 1, 0, 0.5, 0, 0.5,
        0.306275,
        0, 0, 0, 0, 0, 0, 0, 0,
        1, 2,
        { 1, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        { 1, 0, 0.1, 0, 0 },
        90, 0,
        { 2, 3, 0.1, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 2, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        "  <PADsynth stereo base>",
        "",
        { 8, 12, 0, 0, 0, 0, 0.431722, 0.5, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },
        { 0, 0, 50, 0, 0, 0, 0 },
        { 0, 0, 50, 0, 0, 0, 0 },
        0.996868, 0, 0.977369, 1, 0, 0.5, 0, 0.5,
        0.5,
        0, 0, 0, 0, 0, 0, 0, 0,
        0.984375, 2,
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        { 1, 0, 0, 0, 0 },
        90, 0,
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },
        1, 0, 0, 0, 0
    },
    {
        " <init voice>",
        "",
        { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },   /* osc1 */
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },   /* osc2 */
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },   /* osc3 */
        { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.5, 0.5 },   /* osc4 */
        { 1, 0, 50.0, 0, 0.0, 0.0, 0.0 },                   /* vcf1 */
        { 0, 0, 50.0, 0, 0.0, 0.0, 0.0 },                   /* vcf2 */
        0.0, 0.2, 0.0, 0.8, 0.5, 0.5, 0.5, 0.5,             /* mix */
        0.5,                                                /* volume */
        0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,               /* effects */
        0.984375, 2,                                        /* glide / bend */
        { 1.0, 0, 0.0, 0, 0.0 },                            /* glfo */
        { 1.0, 0, 0.0, 0, 0.0 },                            /* vlfo */
        { 1.0, 0, 0.0, 0, 0.0 }, 90.0, 0.0,                 /* mlfo */
        { 1, 3, 0.004, 1, 3, 0.001, 1, 3, 0.001, 1, 3, 0.2, 0, 0, 0, 0, 0 }, /* ego */
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },       /* eg1 */
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },       /* eg2 */
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },       /* eg3 */
        { 0, 3, 0.1, 1, 3, 0.1, 1, 3, 0.1, 1, 3, 0.2, 0, 0, 0, 0, 0 },       /* eg4 */
        1.0, 0, 0.0, 0, 0.0                                 /* modmix */
    },
};

