/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.oss;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.impl.midiport.oss.MidiOutputPortImpl;

public class MidiSystem {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-oss-jni");
    private long instance = this.malloc();
    private boolean open = false;
    private List ports = new ArrayList();
    private MidiOutputPortImpl connection = null;

    public void finalize() {
        if (this.instance != 0L) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    public boolean isOpen() {
        return this.instance != 0L && this.open;
    }

    public void open(String string) {
        if (this.instance != 0L && !this.open) {
            this.open(this.instance, string);
            this.open = true;
        }
    }

    public void close() {
        if (this.instance != 0L && this.open) {
            this.close(this.instance);
            this.open = false;
        }
    }

    public List findPorts() {
        this.ports.clear();
        if (this.instance != 0L && this.open) {
            this.findPorts(this.instance);
        }
        return this.ports;
    }

    public void openPort(MidiOutputPortImpl midiOutputPortImpl) {
        if (this.instance != 0L && this.open) {
            this.openPort(this.instance, midiOutputPortImpl.getDevice());
            this.connection = midiOutputPortImpl;
        }
    }

    public void closePort() {
        if (this.instance != 0L && this.open) {
            this.closePort(this.instance);
            this.connection = null;
        }
    }

    public void noteOn(int n, int n2, int n3) {
        if (this.instance != 0L && this.open) {
            this.noteOn(this.instance, n, n2, n3);
        }
    }

    public void noteOff(int n, int n2, int n3) {
        if (this.instance != 0L && this.open) {
            this.noteOff(this.instance, n, n2, n3);
        }
    }

    public void controlChange(int n, int n2, int n3) {
        if (this.instance != 0L && this.open) {
            this.controlChange(this.instance, n, n2, n3);
        }
    }

    public void programChange(int n, int n2) {
        if (this.instance != 0L && this.open) {
            this.programChange(this.instance, n, n2);
        }
    }

    public void pitchBend(int n, int n2) {
        if (this.instance != 0L && this.open) {
            this.pitchBend(this.instance, n, n2);
        }
    }

    public MidiOutputPortImpl getConnection() {
        return this.connection;
    }

    protected void addPort(String string, int n) {
        this.ports.add(new MidiOutputPortImpl(this, string, n));
    }

    private native long malloc();

    private native void free(long var1);

    protected native void open(long var1, String var3);

    protected native void close(long var1);

    protected native void findPorts(long var1);

    protected native void openPort(long var1, int var3);

    protected native void closePort(long var1);

    protected native void noteOn(long var1, int var3, int var4, int var5);

    protected native void noteOff(long var1, int var3, int var4, int var5);

    protected native void controlChange(long var1, int var3, int var4, int var5);

    protected native void programChange(long var1, int var3, int var4);

    protected native void pitchBend(long var1, int var3, int var4);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

