/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.oss;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.plugins.TGPluginConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.player.impl.midiport.oss.MidiOutputPortProviderImpl;

public class MidiConfigUtils {
    public static final String DEVICE_KEY = "oss.device";
    public static final String DEVICE_DEFAULT = "/dev/sequencer";

    public static TGConfigManager getConfig() {
        TGPluginConfigManager tGPluginConfigManager = new TGPluginConfigManager("tuxguitar-oss");
        tGPluginConfigManager.init();
        return tGPluginConfigManager;
    }

    public static String getDevice() {
        return MidiConfigUtils.getDevice(MidiConfigUtils.getConfig());
    }

    public static String getDevice(TGConfigManager tGConfigManager) {
        return tGConfigManager.getStringConfigValue(DEVICE_KEY, DEVICE_DEFAULT);
    }

    public static void setupDialog(Shell shell, MidiOutputPortProviderImpl midiOutputPortProviderImpl) {
        MidiConfigUtils.setupDialog(shell, midiOutputPortProviderImpl, MidiConfigUtils.getConfig());
    }

    public static void setupDialog(Shell shell, final MidiOutputPortProviderImpl midiOutputPortProviderImpl, final TGConfigManager tGConfigManager) {
        final String string = MidiConfigUtils.getDevice(tGConfigManager);
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText("Configuration");
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText("Device Configuration");
        Label label = new Label((Composite)group, 16384);
        label.setText("Device:");
        final Text text = new Text((Composite)group, 2048);
        text.setLayoutData((Object)new GridData(250, -1));
        text.setText(string == null ? new String() : string);
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string5;
                String string2 = text.getText();
                String string3 = string == null ? new String() : string;
                String string4 = string5 = string2 == null ? new String() : string2;
                if (!string3.equals(string5)) {
                    if (string2 != null) {
                        tGConfigManager.setProperty(MidiConfigUtils.DEVICE_KEY, string2);
                    } else {
                        tGConfigManager.removeProperty(MidiConfigUtils.DEVICE_KEY);
                    }
                    tGConfigManager.save();
                    midiOutputPortProviderImpl.updateDevice(string2);
                }
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }
}

