/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.BooleanRef;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.DoubleRef;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.IntegerRef;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.type.StringRef;

public class MidiSynth {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-fluidsynth-jni");
    private long instance = this.malloc();
    private MidiOutputPortImpl loadedPort = null;

    public boolean isInitialized() {
        return this.instance != 0L;
    }

    public void finalize() {
        if (this.isInitialized()) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    public boolean isConnected(MidiOutputPortImpl midiOutputPortImpl) {
        return midiOutputPortImpl != null && this.loadedPort != null && this.loadedPort.equals(midiOutputPortImpl);
    }

    public void connect(MidiOutputPortImpl midiOutputPortImpl) {
        if (this.isInitialized()) {
            this.disconnect(this.loadedPort);
            this.open(this.instance);
            this.loadFont(this.instance, midiOutputPortImpl.getSoundFont());
            this.loadedPort = midiOutputPortImpl;
        }
    }

    public void disconnect(MidiOutputPortImpl midiOutputPortImpl) {
        if (this.isInitialized() && this.isConnected(midiOutputPortImpl)) {
            this.unloadFont(this.instance);
            this.close(this.instance);
            this.loadedPort = null;
        }
    }

    public void reconnect() {
        MidiOutputPortImpl midiOutputPortImpl = this.loadedPort;
        if (this.isConnected(midiOutputPortImpl)) {
            this.disconnect(midiOutputPortImpl);
            this.connect(midiOutputPortImpl);
        }
    }

    public void sendSystemReset() {
        if (this.isInitialized()) {
            this.systemReset(this.instance);
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        if (this.isInitialized()) {
            this.noteOn(this.instance, n, n2, n3);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        if (this.isInitialized()) {
            this.noteOff(this.instance, n, n2, n3);
        }
    }

    public void sendControlChange(int n, int n2, int n3) {
        if (this.isInitialized()) {
            this.controlChange(this.instance, n, n2, n3);
        }
    }

    public void sendProgramChange(int n, int n2) {
        if (this.isInitialized()) {
            this.programChange(this.instance, n, n2);
        }
    }

    public void sendPitchBend(int n, int n2) {
        if (this.isInitialized()) {
            this.pitchBend(this.instance, n, n2);
        }
    }

    public void setDoubleProperty(String string, double d) {
        if (this.isInitialized()) {
            this.setDoubleProperty(this.instance, string, d);
        }
    }

    public void setIntegerProperty(String string, int n) {
        if (this.isInitialized()) {
            this.setIntegerProperty(this.instance, string, n);
        }
    }

    public void setStringProperty(String string, String string2) {
        if (this.isInitialized()) {
            this.setStringProperty(this.instance, string, string2);
        }
    }

    public double getDoubleProperty(String string) {
        DoubleRef doubleRef = new DoubleRef();
        if (this.isInitialized()) {
            this.getDoubleProperty(this.instance, string, doubleRef);
        }
        return doubleRef.getValue();
    }

    public int getIntegerProperty(String string) {
        IntegerRef integerRef = new IntegerRef();
        if (this.isInitialized()) {
            this.getIntegerProperty(this.instance, string, integerRef);
        }
        return integerRef.getValue();
    }

    public String getStringProperty(String string) {
        StringRef stringRef = new StringRef();
        if (this.isInitialized()) {
            this.getStringProperty(this.instance, string, stringRef);
        }
        return stringRef.getValue();
    }

    public double getDoublePropertyDefault(String string) {
        DoubleRef doubleRef = new DoubleRef();
        if (this.isInitialized()) {
            this.getDoublePropertyDefault(this.instance, string, doubleRef);
        }
        return doubleRef.getValue();
    }

    public int getIntegerPropertyDefault(String string) {
        IntegerRef integerRef = new IntegerRef();
        if (this.isInitialized()) {
            this.getIntegerPropertyDefault(this.instance, string, integerRef);
        }
        return integerRef.getValue();
    }

    public String getStringPropertyDefault(String string) {
        StringRef stringRef = new StringRef();
        if (this.isInitialized()) {
            this.getStringPropertyDefault(this.instance, string, stringRef);
        }
        return stringRef.getValue();
    }

    public List getPropertyOptions(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.isInitialized()) {
            this.getPropertyOptions(this.instance, string, arrayList);
        }
        return arrayList;
    }

    public int[] getIntegerPropertyRange(String string) {
        IntegerRef integerRef = new IntegerRef();
        IntegerRef integerRef2 = new IntegerRef();
        if (this.isInitialized()) {
            this.getIntegerPropertyRange(this.instance, string, integerRef, integerRef2);
        }
        return new int[]{integerRef.getValue(), integerRef2.getValue()};
    }

    public double[] getDoublePropertyRange(String string) {
        DoubleRef doubleRef = new DoubleRef();
        DoubleRef doubleRef2 = new DoubleRef();
        if (this.isInitialized()) {
            this.getDoublePropertyRange(this.instance, string, doubleRef, doubleRef2);
        }
        return new double[]{doubleRef.getValue(), doubleRef2.getValue()};
    }

    public boolean isRealtimeProperty(String string) {
        BooleanRef booleanRef = new BooleanRef();
        if (this.isInitialized()) {
            this.isRealtimeProperty(this.instance, string, booleanRef);
        }
        return booleanRef.getValue();
    }

    private native long malloc();

    private native void free(long var1);

    private native void open(long var1);

    private native void close(long var1);

    private native void loadFont(long var1, String var3);

    private native void unloadFont(long var1);

    private native void systemReset(long var1);

    private native void noteOn(long var1, int var3, int var4, int var5);

    private native void noteOff(long var1, int var3, int var4, int var5);

    private native void controlChange(long var1, int var3, int var4, int var5);

    private native void programChange(long var1, int var3, int var4);

    private native void pitchBend(long var1, int var3, int var4);

    private native void setDoubleProperty(long var1, String var3, double var4);

    private native void setIntegerProperty(long var1, String var3, int var4);

    private native void setStringProperty(long var1, String var3, String var4);

    private native void getDoubleProperty(long var1, String var3, DoubleRef var4);

    private native void getIntegerProperty(long var1, String var3, IntegerRef var4);

    private native void getStringProperty(long var1, String var3, StringRef var4);

    private native void getDoublePropertyDefault(long var1, String var3, DoubleRef var4);

    private native void getIntegerPropertyDefault(long var1, String var3, IntegerRef var4);

    private native void getStringPropertyDefault(long var1, String var3, StringRef var4);

    private native void getDoublePropertyRange(long var1, String var3, DoubleRef var4, DoubleRef var5);

    private native void getIntegerPropertyRange(long var1, String var3, IntegerRef var4, IntegerRef var5);

    private native void getPropertyOptions(long var1, String var3, List var4);

    private native void isRealtimeProperty(long var1, String var3, BooleanRef var4);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

