/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortProviderImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiSettings;

public class MidiOutputPortSettings
extends MidiSettings {
    private static final int TABLE_WIDTH = 350;
    private static final int TABLE_HEIGHT = 200;

    public MidiOutputPortSettings(MidiOutputPortProviderImpl midiOutputPortProviderImpl) {
        super(midiOutputPortProviderImpl);
    }

    public void configure(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setText(TuxGuitar.getProperty((String)"fluidsynth.settings"));
        shell2.setLayout((Layout)new GridLayout());
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        TabFolder tabFolder = new TabFolder((Composite)shell2, 128);
        tabFolder.setLayout((Layout)new FormLayout());
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)this.getGridLayout(2));
        composite.setLayoutData((Object)new FormData());
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.soundfonts"));
        tabItem.setControl((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        final Table table = new Table(composite2, 68356);
        table.setLayoutData((Object)this.getTableData());
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(350);
        tableColumn.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.soundfonts.list"));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)this.getButtonData(4, 128, true, false));
        button.setText(TuxGuitar.getProperty((String)"add"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiOutputPortSettings.this.addMidiPort(table);
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setText(TuxGuitar.getProperty((String)"remove"));
        button2.setLayoutData((Object)this.getButtonData(4, 128, true, false));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiOutputPortSettings.this.removeMidiPort(table);
            }
        });
        this.addMidiPorts(table);
        Composite composite4 = new Composite((Composite)tabFolder, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new FormData());
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio"));
        tabItem2.setControl((Control)composite4);
        final List list = this.getAudioDriverOptions();
        Label label = new Label(composite4, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.driver"));
        final Combo combo = new Combo(composite4, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioDriverCombo(list, combo);
        final List list2 = this.getAudioSampleFormatOptions();
        Label label2 = new Label(composite4, 0);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label2.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.sample-format"));
        final Combo combo2 = new Combo(composite4, 12);
        combo2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioSampleFormatCombo(list2, combo2);
        final List list3 = this.getAudioPeriodSizeOptions();
        Label label3 = new Label(composite4, 0);
        label3.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label3.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.period-size"));
        final Combo combo3 = new Combo(composite4, 12);
        combo3.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioPeriodSizeCombo(list3, combo3);
        final List list4 = this.getAudioPeriodCountOptions();
        Label label4 = new Label(composite4, 0);
        label4.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label4.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.periods"));
        final Combo combo4 = new Combo(composite4, 12);
        combo4.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillAudioPeriodCountCombo(list4, combo4);
        Composite composite5 = new Composite((Composite)tabFolder, 0);
        composite5.setLayout((Layout)new GridLayout(2, false));
        composite5.setLayoutData((Object)new FormData());
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth"));
        tabItem3.setControl((Control)composite5);
        Label label5 = new Label(composite5, 0);
        label5.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label5.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.gain"));
        final Scale scale = new Scale(composite5, 256);
        scale.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillSynthGainScale(scale);
        final List list5 = this.getSynthSampleRateOptions();
        Label label6 = new Label(composite5, 0);
        label6.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label6.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.sample-rate"));
        final Combo combo5 = new Combo(composite5, 12);
        combo5.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillSynthSampleRateCombo(list5, combo5);
        Label label7 = new Label(composite5, 0);
        label7.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label7.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.polyphony"));
        final Spinner spinner = new Spinner(composite5, 2048);
        spinner.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fillSynthPolyphonySpinner(spinner);
        final Button button3 = new Button(composite5, 32);
        button3.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        button3.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.reverb.active"));
        this.fillSynthReverbActiveCheckbox(button3);
        final Button button4 = new Button(composite5, 32);
        button4.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        button4.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.chorus.active"));
        this.fillSynthChorusActiveCheckbox(button4);
        Composite composite6 = new Composite((Composite)shell2, 0);
        composite6.setLayout((Layout)new GridLayout(2, false));
        composite6.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button5 = new Button(composite6, 8);
        button5.setText(TuxGuitar.getProperty((String)"ok"));
        button5.setLayoutData((Object)this.getButtonData(4, 4, true, true));
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MidiOutputPortSettings.this.updateSoundfontsSelection(table);
                MidiOutputPortSettings.this.updateAudioDriverSelection(list, combo.getSelectionIndex());
                MidiOutputPortSettings.this.updateAudioSampleFormatSelection(list2, combo2.getSelectionIndex());
                MidiOutputPortSettings.this.updateAudioPeriodSizeSelection(list3, combo3.getSelectionIndex());
                MidiOutputPortSettings.this.updateAudioPeriodCountSelection(list4, combo4.getSelectionIndex());
                MidiOutputPortSettings.this.updateSynthSampleRateSelection(list5, combo5.getSelectionIndex());
                MidiOutputPortSettings.this.updateSynthGainSelection(scale.getSelection());
                MidiOutputPortSettings.this.updateSynthPolyphonySelection(spinner.getSelection());
                MidiOutputPortSettings.this.updateSynthReverbActiveSelection(button3.getSelection());
                MidiOutputPortSettings.this.updateSynthChorusActiveSelection(button4.getSelection());
                new Thread(new Runnable(){

                    public void run() {
                        MidiOutputPortSettings.this.update();
                    }
                }).start();
                shell2.dispose();
            }
        });
        Button button6 = new Button(composite6, 8);
        button6.setText(TuxGuitar.getProperty((String)"cancel"));
        button6.setLayoutData((Object)this.getButtonData(4, 4, true, true));
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button5);
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }

    protected GridLayout getGridLayout(int n) {
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    protected GridData getTableData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 200;
        return gridData;
    }

    protected GridData getButtonData(int n, int n2, boolean bl, boolean bl2) {
        GridData gridData = new GridData(n, n2, bl, bl2);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void addMidiPorts(Table table) {
        Iterator iterator = this.getSoundfonts().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addMidiPort(table, string);
        }
    }

    protected void addMidiPort(Table table) {
        FileDialog fileDialog = new FileDialog(table.getShell());
        String string = fileDialog.open();
        if (string != null && string.length() > 0) {
            this.addMidiPort(table, string);
        }
    }

    protected void addMidiPort(Table table, String string) {
        TableItem tableItem = new TableItem(table, 0);
        tableItem.setText(string);
        tableItem.setData((Object)string);
    }

    protected void removeMidiPort(Table table) {
        int n = table.getSelectionIndex();
        if (n >= 0 && n < table.getItemCount()) {
            table.remove(n);
        }
    }

    protected List getAudioDriverOptions() {
        return this.getSynth().getPropertyOptions("audio.driver");
    }

    protected List getAudioSampleFormatOptions() {
        return this.getSynth().getPropertyOptions("audio.sample-format");
    }

    protected List getAudioPeriodSizeOptions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = this.getSynth().getIntegerPropertyRange("audio.period-size");
        if (nArray.length == 2 && nArray[0] < nArray[1]) {
            for (int i = nArray[0]; i <= nArray[1]; i *= 2) {
                arrayList.add(new Integer(i));
            }
        }
        return arrayList;
    }

    protected List getAudioPeriodCountOptions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = this.getSynth().getIntegerPropertyRange("audio.periods");
        if (nArray.length == 2 && nArray[0] < nArray[1]) {
            for (int i = nArray[0]; i <= nArray[1]; i *= 2) {
                arrayList.add(new Integer(i));
            }
        }
        return arrayList;
    }

    protected List getSynthSampleRateOptions() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = this.getSynth().getDoublePropertyRange("synth.sample-rate");
        double[] dArray2 = new double[]{22050.0, 44100.0, 48000.0, 88200.0, 96000.0};
        if (dArray.length == 2 && dArray[0] < dArray[1]) {
            for (int i = 0; i < dArray2.length; ++i) {
                if (!(dArray2[i] >= dArray[0]) || !(dArray2[i] <= dArray[1])) continue;
                arrayList.add(new Double(dArray2[i]));
            }
        }
        return arrayList;
    }

    protected void fillAudioDriverCombo(List list, Combo combo) {
        int n = 0;
        String string = this.getStringValue("audio.driver");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            combo.add(string2);
            if (string == null || !string.equals(string2)) continue;
            n = i;
        }
        combo.select(n);
    }

    protected void fillAudioSampleFormatCombo(List list, Combo combo) {
        int n = 0;
        String string = this.getStringValue("audio.sample-format");
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            combo.add(string2);
            if (string == null || !string.equals(string2)) continue;
            n = i;
        }
        combo.select(n);
    }

    protected void fillAudioPeriodSizeCombo(List list, Combo combo) {
        int n = 0;
        int n2 = this.getIntegerValue("audio.period-size");
        for (int i = 0; i < list.size(); ++i) {
            int n3 = (Integer)list.get(i);
            combo.add(Integer.toString(n3));
            if (n2 != n3) continue;
            n = i;
        }
        combo.select(n);
    }

    protected void fillAudioPeriodCountCombo(List list, Combo combo) {
        int n = 0;
        int n2 = this.getIntegerValue("audio.periods");
        for (int i = 0; i < list.size(); ++i) {
            int n3 = (Integer)list.get(i);
            combo.add(Integer.toString(n3));
            if (n2 != n3) continue;
            n = i;
        }
        combo.select(n);
    }

    protected void fillSynthGainScale(Scale scale) {
        double[] dArray = this.getSynth().getDoublePropertyRange("synth.gain");
        if (dArray.length == 2) {
            int n;
            int n2 = (int)Math.round(this.getDoubleValue("synth.gain") * 10.0);
            int n3 = (int)Math.round(dArray[0] * 10.0);
            if (n3 < (n = (int)Math.round(dArray[1] * 10.0))) {
                scale.setMinimum(n3);
                scale.setMaximum(n);
                scale.setIncrement(1);
                scale.setPageIncrement(10);
                if (n2 >= n3 && n2 <= n) {
                    scale.setSelection(n2);
                }
            }
        }
    }

    protected void fillSynthSampleRateCombo(List list, Combo combo) {
        int n = 0;
        double d = this.getDoubleValue("synth.sample-rate");
        for (int i = 0; i < list.size(); ++i) {
            double d2 = (Double)list.get(i);
            combo.add(Double.toString(d2));
            if (d != d2) continue;
            n = i;
        }
        combo.select(n);
    }

    protected void fillSynthPolyphonySpinner(Spinner spinner) {
        int n = this.getIntegerValue("synth.polyphony");
        int[] nArray = this.getSynth().getIntegerPropertyRange("synth.polyphony");
        if (nArray.length == 2 && nArray[0] < nArray[1]) {
            spinner.setMinimum(nArray[0]);
            spinner.setMaximum(nArray[1]);
            spinner.setIncrement(1);
            spinner.setPageIncrement(1);
            if (n >= nArray[0] && n <= nArray[1]) {
                spinner.setSelection(n);
            }
        }
    }

    protected void fillSynthReverbActiveCheckbox(Button button) {
        button.setSelection(this.getBooleanValue("synth.reverb.active"));
    }

    protected void fillSynthChorusActiveCheckbox(Button button) {
        button.setSelection(this.getBooleanValue("synth.chorus.active"));
    }

    protected void updateAudioDriverSelection(List list, int n) {
        if (n >= 0 && n < list.size()) {
            this.setStringValue("audio.driver", (String)list.get(n));
        }
    }

    protected void updateAudioSampleFormatSelection(List list, int n) {
        if (n >= 0 && n < list.size()) {
            this.setStringValue("audio.sample-format", (String)list.get(n));
        }
    }

    protected void updateAudioPeriodSizeSelection(List list, int n) {
        if (n >= 0 && n < list.size()) {
            this.setIntegerValue("audio.period-size", (Integer)list.get(n));
        }
    }

    protected void updateAudioPeriodCountSelection(List list, int n) {
        if (n >= 0 && n < list.size()) {
            this.setIntegerValue("audio.periods", (Integer)list.get(n));
        }
    }

    protected void updateSynthGainSelection(int n) {
        int n2;
        int n3;
        double d = (double)n / 10.0;
        double[] dArray = this.getSynth().getDoublePropertyRange("synth.gain");
        if (dArray.length == 2 && (n3 = (int)Math.round(dArray[0])) < (n2 = (int)Math.round(dArray[1])) && d >= (double)n3 && d <= (double)n2) {
            this.setDoubleValue("synth.gain", d);
        }
    }

    protected void updateSynthSampleRateSelection(List list, int n) {
        if (n >= 0 && n < list.size()) {
            this.setDoubleValue("synth.sample-rate", (Double)list.get(n));
        }
    }

    protected void updateSynthPolyphonySelection(int n) {
        int[] nArray = this.getSynth().getIntegerPropertyRange("synth.polyphony");
        if (nArray.length == 2 && nArray[0] < nArray[1] && n >= nArray[0] && n <= nArray[1] && n >= nArray[0] && n <= nArray[1]) {
            this.setIntegerValue("synth.polyphony", n);
        }
    }

    protected void updateSynthReverbActiveSelection(boolean bl) {
        this.setBooleanValue("synth.reverb.active", bl);
    }

    protected void updateSynthChorusActiveSelection(boolean bl) {
        this.setBooleanValue("synth.chorus.active", bl);
    }

    protected void updateSoundfontsSelection(Table table) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = table.getItemCount();
        for (int i = 0; i < n; ++i) {
            TableItem tableItem = table.getItem(i);
            if (!(tableItem.getData() instanceof String)) continue;
            arrayList.add(tableItem.getData());
        }
        this.setSoundfonts(arrayList);
    }

    protected void update() {
        this.save();
        this.apply();
    }
}

