/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.io.File;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiReceiver;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiReceiverImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiSynth;

public class MidiOutputPortImpl
implements MidiOutputPort {
    private String key;
    private String name;
    private MidiSynth synth;
    private MidiReceiverImpl receiver;
    private String soundFont;

    public MidiOutputPortImpl(MidiSynth midiSynth, File file) {
        this.key = this.getUniqueKey(file);
        this.name = this.getUniqueName(file);
        this.soundFont = file.getAbsolutePath();
        this.receiver = new MidiReceiverImpl(midiSynth);
        this.synth = midiSynth;
    }

    public void open() {
        if (!this.synth.isConnected(this)) {
            this.synth.connect(this);
        }
    }

    public void close() {
        if (this.synth.isConnected(this)) {
            this.synth.disconnect(this);
        }
    }

    public MidiReceiver getReceiver() {
        this.open();
        return this.receiver;
    }

    public void check() {
    }

    public String getSoundFont() {
        return this.soundFont;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueKey(File file) {
        return "tuxguitar-fluidsynth_" + file.getAbsolutePath();
    }

    private String getUniqueName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return "TG Fluidsynth [" + string + "]";
    }
}

