/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb;

import java.util.Iterator;
import org.herac.tuxguitar.io.ptb.PTSongSynchronizerUtil;
import org.herac.tuxguitar.io.ptb.base.PTBar;
import org.herac.tuxguitar.io.ptb.base.PTBeat;
import org.herac.tuxguitar.io.ptb.base.PTComponent;
import org.herac.tuxguitar.io.ptb.base.PTGuitarIn;
import org.herac.tuxguitar.io.ptb.base.PTNote;
import org.herac.tuxguitar.io.ptb.base.PTPosition;
import org.herac.tuxguitar.io.ptb.base.PTSection;
import org.herac.tuxguitar.io.ptb.base.PTSong;
import org.herac.tuxguitar.io.ptb.base.PTSongInfo;
import org.herac.tuxguitar.io.ptb.base.PTTempo;
import org.herac.tuxguitar.io.ptb.base.PTTrack;
import org.herac.tuxguitar.io.ptb.base.PTTrackInfo;
import org.herac.tuxguitar.io.ptb.helper.TrackHelper;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;

public class PTSongParser {
    private TGSongManager manager;
    private TrackHelper helper;

    public PTSongParser(TGFactory tGFactory) {
        this.manager = new TGSongManager(tGFactory);
        this.helper = new TrackHelper();
    }

    public TGSong parseSong(PTSong pTSong) {
        PTSong pTSong2 = new PTSong();
        PTSongSynchronizerUtil.synchronizeTracks(pTSong, pTSong2);
        this.manager.setSong(this.manager.getFactory().newSong());
        this.parseTrack(pTSong2.getTrack1());
        this.parseTrack(pTSong2.getTrack2());
        this.parseProperties(pTSong2.getInfo());
        this.manager.orderBeats();
        return this.manager.getSong();
    }

    private void parseProperties(PTSongInfo pTSongInfo) {
        String string;
        if (pTSongInfo.getName() != null) {
            this.manager.getSong().setName(pTSongInfo.getName());
        }
        if (pTSongInfo.getAlbum() != null) {
            this.manager.getSong().setAlbum(pTSongInfo.getAlbum());
        }
        if (pTSongInfo.getAuthor() != null) {
            this.manager.getSong().setAuthor(pTSongInfo.getAuthor());
        }
        if (pTSongInfo.getCopyright() != null) {
            this.manager.getSong().setCopyright(pTSongInfo.getCopyright());
        }
        if (pTSongInfo.getArrenger() != null) {
            this.manager.getSong().setWriter(pTSongInfo.getArrenger());
        }
        if (pTSongInfo.getGuitarTranscriber() != null || pTSongInfo.getBassTranscriber() != null) {
            string = new String();
            if (pTSongInfo.getGuitarTranscriber() != null) {
                string = string + pTSongInfo.getGuitarTranscriber();
            }
            if (pTSongInfo.getBassTranscriber() != null) {
                if (string.length() > 0) {
                    string = string + " - ";
                }
                string = string + pTSongInfo.getBassTranscriber();
            }
            this.manager.getSong().setTranscriber(string);
        }
        if (pTSongInfo.getGuitarInstructions() != null || pTSongInfo.getBassInstructions() != null) {
            string = new String();
            if (pTSongInfo.getGuitarInstructions() != null) {
                string = string + pTSongInfo.getGuitarInstructions();
            }
            if (pTSongInfo.getBassInstructions() != null) {
                string = string + pTSongInfo.getBassInstructions();
            }
            this.manager.getSong().setComments(string);
        }
    }

    private void parseTrack(PTTrack pTTrack) {
        this.helper.reset(pTTrack.getDefaultInfo());
        long l = 960L;
        for (int i = 0; i < pTTrack.getSections().size(); ++i) {
            PTSection pTSection = (PTSection)pTTrack.getSections().get(i);
            pTSection.sort();
            this.helper.getStartHelper().init(pTSection.getNumber(), pTSection.getStaffs());
            this.helper.getStartHelper().initVoices(l);
            for (int j = 0; j < pTSection.getPositions().size(); ++j) {
                PTPosition pTPosition = (PTPosition)pTSection.getPositions().get(j);
                this.parsePosition(pTTrack, pTPosition);
            }
            l = this.helper.getStartHelper().getMaxStart();
        }
    }

    private void parsePosition(PTTrack pTTrack, PTPosition pTPosition) {
        for (int i = 0; i < pTPosition.getComponents().size(); ++i) {
            PTComponent pTComponent = (PTComponent)pTPosition.getComponents().get(i);
            if (pTComponent instanceof PTBar) {
                this.parseBar((PTBar)pTComponent);
                continue;
            }
            if (pTComponent instanceof PTGuitarIn) {
                this.parseGuitarIn(pTTrack, (PTGuitarIn)pTComponent);
                continue;
            }
            if (pTComponent instanceof PTTempo) {
                this.parseTempo((PTTempo)pTComponent);
                continue;
            }
            if (!(pTComponent instanceof PTBeat)) continue;
            this.parseBeat((PTBeat)pTComponent);
        }
    }

    private void parseBar(PTBar pTBar) {
        this.helper.getStartHelper().initVoices(this.helper.getStartHelper().getMaxStart());
        if (pTBar.getNumerator() > 0 && pTBar.getDenominator() > 0) {
            this.helper.getStartHelper().setBarStart(this.helper.getStartHelper().getMaxStart());
            this.helper.getStartHelper().setBarLength((long)((float)pTBar.getNumerator() * (960.0f * (4.0f / (float)pTBar.getDenominator()))));
        }
    }

    private void parseGuitarIn(PTTrack pTTrack, PTGuitarIn pTGuitarIn) {
        PTTrackInfo pTTrackInfo = pTTrack.getInfo(pTGuitarIn.getTrackInfo());
        if (pTTrackInfo != null) {
            while (this.helper.getInfoHelper().countStaffTracks() > pTGuitarIn.getStaff()) {
                this.helper.getInfoHelper().removeStaffTrack(this.helper.getInfoHelper().countStaffTracks() - 1);
            }
            Iterator iterator = this.manager.getSong().getTracks();
            while (iterator.hasNext()) {
                TGTrack tGTrack = (TGTrack)iterator.next();
                if (!this.hasSameInfo(tGTrack, pTTrackInfo)) continue;
                boolean bl = false;
                for (int i = 0; i < this.helper.getInfoHelper().countStaffTracks(); ++i) {
                    TGTrack tGTrack2 = this.helper.getInfoHelper().getStaffTrack(i);
                    if (tGTrack2 == null || tGTrack2.getNumber() != tGTrack.getNumber()) continue;
                    bl = true;
                }
                if (bl) continue;
                this.helper.getInfoHelper().addStaffTrack(tGTrack);
                return;
            }
            this.createTrack(pTTrackInfo);
        }
    }

    private void parseTempo(PTTempo pTTempo) {
        TGMeasure tGMeasure = this.getMeasure(1, this.helper.getStartHelper().getMaxStart());
        tGMeasure.getTempo().setValue(pTTempo.getTempo());
        tGMeasure.getHeader().setTripletFeel(pTTempo.getTripletFeel());
    }

    private void parseBeat(PTBeat pTBeat) {
        if (pTBeat.isGrace()) {
            return;
        }
        if (pTBeat.getMultiBarRest() > 1) {
            long l = this.helper.getStartHelper().getBarStart();
            long l2 = (long)pTBeat.getMultiBarRest() * this.helper.getStartHelper().getBarLength();
            this.helper.getStartHelper().setVoiceStart(pTBeat.getStaff(), pTBeat.getVoice(), l + l2);
            return;
        }
        long l = this.helper.getStartHelper().getVoiceStart(pTBeat.getStaff(), pTBeat.getVoice());
        TGMeasure tGMeasure = this.getMeasure(this.getStaffTrack(pTBeat.getStaff()), l);
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        TGVoice tGVoice = tGBeat.getVoice(pTBeat.getVoice());
        tGVoice.setEmpty(false);
        tGVoice.getDuration().setValue(pTBeat.getDuration());
        tGVoice.getDuration().setDotted(pTBeat.isDotted());
        tGVoice.getDuration().setDoubleDotted(pTBeat.isDoubleDotted());
        tGVoice.getDuration().getDivision().setTimes(pTBeat.getTimes());
        tGVoice.getDuration().getDivision().setEnters(pTBeat.getEnters());
        Iterator iterator = pTBeat.getNotes().iterator();
        while (iterator.hasNext()) {
            PTNote pTNote = (PTNote)iterator.next();
            if (pTNote.getString() > tGMeasure.getTrack().stringCount() || pTNote.getValue() < 0) continue;
            TGNote tGNote = this.manager.getFactory().newNote();
            tGNote.setString(pTNote.getString());
            tGNote.setValue(pTNote.getValue());
            tGNote.setTiedNote(pTNote.isTied());
            tGNote.getEffect().setVibrato(pTBeat.isVibrato());
            tGNote.getEffect().setDeadNote(pTNote.isDead());
            tGNote.getEffect().setHammer(pTNote.isHammer());
            tGNote.getEffect().setSlide(pTNote.isSlide());
            tGNote.getEffect().setBend(this.makeBend(pTNote.getBend()));
            tGVoice.addNote(tGNote);
        }
        if (pTBeat.isArpeggioUp()) {
            tGBeat.getStroke().setDirection(-1);
            tGBeat.getStroke().setValue(16);
        } else if (pTBeat.isArpeggioDown()) {
            tGBeat.getStroke().setDirection(1);
            tGBeat.getStroke().setValue(16);
        }
        this.helper.getStartHelper().checkBeat(tGVoice.isRestVoice());
        long l3 = tGVoice.getDuration().getTime();
        if (tGVoice.isRestVoice() && tGBeat.getStart() == this.helper.getStartHelper().getBarStart() && l3 > this.helper.getStartHelper().getBarLength()) {
            l3 = this.helper.getStartHelper().getBarLength();
        }
        this.helper.getStartHelper().setVoiceStart(pTBeat.getStaff(), pTBeat.getVoice(), tGBeat.getStart() + l3);
    }

    private TGEffectBend makeBend(int n) {
        if (n >= 1 && n <= 8) {
            TGEffectBend tGEffectBend = this.manager.getFactory().newEffectBend();
            if (n == 1) {
                tGEffectBend.addPoint(0, 0);
                tGEffectBend.addPoint(6, 4);
                tGEffectBend.addPoint(12, 4);
            } else if (n == 2) {
                tGEffectBend.addPoint(0, 0);
                tGEffectBend.addPoint(3, 4);
                tGEffectBend.addPoint(6, 4);
                tGEffectBend.addPoint(9, 0);
                tGEffectBend.addPoint(12, 0);
            } else if (n == 3) {
                tGEffectBend.addPoint(0, 0);
                tGEffectBend.addPoint(6, 4);
                tGEffectBend.addPoint(12, 4);
            } else if (n == 4) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(12, 4);
            } else if (n == 5) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(4, 4);
                tGEffectBend.addPoint(8, 0);
                tGEffectBend.addPoint(12, 0);
            } else if (n == 6) {
                tGEffectBend.addPoint(0, 8);
                tGEffectBend.addPoint(12, 8);
            } else if (n == 7) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(4, 4);
                tGEffectBend.addPoint(8, 0);
                tGEffectBend.addPoint(12, 0);
            } else if (n == 8) {
                tGEffectBend.addPoint(0, 4);
                tGEffectBend.addPoint(4, 4);
                tGEffectBend.addPoint(8, 0);
                tGEffectBend.addPoint(12, 0);
            }
            return tGEffectBend;
        }
        return null;
    }

    private TGMeasure getMeasure(int n, long l) {
        return this.getMeasure(this.getTrack(n), l);
    }

    private TGMeasure getMeasure(TGTrack tGTrack, long l) {
        TGMeasure tGMeasure = null;
        while ((tGMeasure = this.manager.getTrackManager().getMeasureAt(tGTrack, l)) == null) {
            this.manager.addNewMeasureBeforeEnd();
        }
        return tGMeasure;
    }

    private TGTrack getTrack(int n) {
        TGTrack tGTrack = null;
        while ((tGTrack = this.manager.getTrack(n)) == null) {
            tGTrack = this.createTrack();
        }
        return tGTrack;
    }

    public TGTrack getStaffTrack(int n) {
        TGTrack tGTrack = this.helper.getInfoHelper().getStaffTrack(n);
        return tGTrack != null ? tGTrack : this.createTrack();
    }

    private TGTrack createTrack() {
        return this.createTrack(this.helper.getInfoHelper().getDefaultInfo());
    }

    private TGTrack createTrack(PTTrackInfo pTTrackInfo) {
        TGTrack tGTrack = this.manager.createTrack();
        this.helper.getInfoHelper().addStaffTrack(tGTrack);
        this.setTrackInfo(tGTrack, pTTrackInfo);
        return tGTrack;
    }

    private void setTrackInfo(TGTrack tGTrack, PTTrackInfo pTTrackInfo) {
        tGTrack.setName(pTTrackInfo.getName());
        tGTrack.getChannel().setInstrument((short)pTTrackInfo.getInstrument());
        tGTrack.getChannel().setVolume((short)pTTrackInfo.getVolume());
        tGTrack.getChannel().setBalance((short)pTTrackInfo.getBalance());
        tGTrack.getStrings().clear();
        for (int i = 0; i < pTTrackInfo.getStrings().length; ++i) {
            TGString tGString = this.manager.getFactory().newString();
            tGString.setNumber(i + 1);
            tGString.setValue(pTTrackInfo.getStrings()[i]);
            tGTrack.getStrings().add(tGString);
        }
    }

    private boolean hasSameInfo(TGTrack tGTrack, PTTrackInfo pTTrackInfo) {
        if (!pTTrackInfo.getName().equals(tGTrack.getName())) {
            return false;
        }
        if (pTTrackInfo.getInstrument() != tGTrack.getChannel().getInstrument()) {
            return false;
        }
        if (pTTrackInfo.getVolume() != tGTrack.getChannel().getVolume()) {
            return false;
        }
        if (pTTrackInfo.getBalance() != tGTrack.getChannel().getBalance()) {
            return false;
        }
        if (pTTrackInfo.getStrings().length != tGTrack.stringCount()) {
            return false;
        }
        for (int i = 0; i < pTTrackInfo.getStrings().length; ++i) {
            if (pTTrackInfo.getStrings()[i] == tGTrack.getString(i + 1).getValue()) continue;
            return false;
        }
        return true;
    }

    private TGBeat getBeat(TGMeasure tGMeasure, long l) {
        int n = tGMeasure.countBeats();
        for (int i = 0; i < n; ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            if (tGBeat.getStart() != l) continue;
            return tGBeat;
        }
        TGBeat tGBeat = this.manager.getFactory().newBeat();
        tGBeat.setStart(l);
        tGMeasure.addBeat(tGBeat);
        return tGBeat;
    }
}

